package fr.ifremer.isisfish.ui.simulator;

/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.ui.SimulationUI;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableCellEditor;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableCellRenderer;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableModel;
import fr.ifremer.isisfish.ui.models.rule.RuleListModel;
import fr.ifremer.isisfish.ui.models.rule.RuleParametersFactorTableCellEditor;
import fr.ifremer.isisfish.ui.models.rule.RuleParametersFactorTableCellRenderer;
import fr.ifremer.isisfish.ui.util.ErrorHelper;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class RuleChooser extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ACTIVE = "active";
    public static final String PROPERTY_RULES_LIST = "rulesList";
    public static final String PROPERTY_SHOW_FACTOR_COLUMN = "showFactorColumn";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_AVAILABLE_RULE_LIST_ENABLED = "availableRuleList.enabled";
    public static final String BINDING_SELECTED_RULE_PARAMETER_TABLE_MODEL_SHOW_FACTOR_COLUMN = "selectedRuleParameterTableModel.showFactorColumn";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JSCROLL_PANE1_ENABLED = "$JScrollPane1.enabled";
    private static final String BINDING_$JSCROLL_PANE2_ENABLED = "$JScrollPane2.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Wz28bRRSemDqp2yaNExFSKG1KIn5IaB1ahIRS0dBUIY3cH4p7qGoOjL2TeKLZmWVmNlkuiD+hf0J77wWJGyfEgXMPvVT9F6qKA1fEe7OO19ustwsmh3Hy5r1vvu/NvM958pJUjSaX9mkcezqSlgfM2/76/v07nX3WtTeY6WoeWqVJ8jNRIZU2Oe0P4saS5XYTyxv98saGCkIlmRyqXmuSU8b+IJjpMWYteT9b0TWm0Rpsr8VhpI9QB6TyUB/9+ary0P/pcYWQOAR28yBl6U1VqZITTVLhviVzcNIBbQgq94CG5nIP+E5jbENQY27TgH1PfiRTTTIZUg1glnxQXrLDcPVxaMnUyj3aEWzVkk93tcd3NQsYfBpudrnpeRH3DA8iQQHB24mguqeUYToMHcSkJTUNUdPkBljMIEcvslx4GEiTJmnX8gNmSd1loDLvulKCUZkmzZqeOtyETKU3lIgCifF6uj/Vo9IXTFty5d9Q3UqqUpyTK9tN2mECNM8hndgzh9BjL4liUm049y6VObkueizXIXyGf5/L7k2vbLe6WgmBdQD2TgYs3cpW1SGJC7wf1JP0uJ6lDDFMvjiomaG+j9nmemStkpbMZwqSaAE5x/5SNmHBMAHTxxJgPPOW8pmwZHXERQS4bTx8Gt4RdVeS3kL9GCZurODycfokAFodOPUp8Y+y5Ga78Iz0kOScnIzCyzkKLw6zuUs1jJhl2o1GX+q1YqldFQRKei03bQMAkyKkyt8dfdbrr8wFsexKCFbyXsZKwKS81KRSF5lok6qbSUsW28d9DQ9NHG3xNUdDQLf798L8s19f/LJ5ZGMLcPbbualDLgz2EmoVwnhyPPps4mHoBY1bNFxrk1oi21n0+Rxirf42kIPz6qmVbFHTA4jq1PPffl/47ulbpLJJTglF/cQrbpKa7WnoghJ+HF5bd4zOHJ6EdRa5gXEwiX0EZ5256lNLlzpc+tDfr2LowvmcLgyodGp//DXf+nn9qBMTwOzcyPS0G9UHZJJLwSVzlt5361wLPx0aFvkqdeU8n57Az8Ww/4bW3XojT+oJy2IwibmryelL1ML3RyeyDLRi0ZYTgb9tl8TE8CYu3+QjXCiFcBuXO/8VwZIzXSbEDpM+00wXsFkeW8+bESypuqEfE2Q6mQeuJPrD/6NpRIc/HPuOyiEU9fWTUgjfFiB4pRCKOlkOYX9shKK7WB37LsohFHG4PDaHcghF7+HzEiOS+x/hCLwvxn4dX5ZgVNPqcIvxvZ4taA4C/QNP5OvhyQwAAA==";
    private static final Log log = LogFactory.getLog(RuleChooser.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean active;
    protected JButton addRulesButton;
    protected JList availableRuleList;
    protected JButton clearRulesButton;
    protected RuleChooserHandler handler;
    protected JButton removeRuleButton;
    protected List<Rule> rulesList;
    protected JTable selectedRuleParameterTable;
    protected ScriptParametersTableModel selectedRuleParameterTableModel;
    protected JList selectedRulesList;
    protected RuleListModel selectedRulesListModel;
    protected Boolean showFactorColumn;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private RuleChooser $Table0 = this;
    private JLabel $JLabel0;
    private JPanel $JPanel0;
    private JLabel $JLabel1;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JScrollPane $JScrollPane2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            // Manage rule list change
            addPropertyChangeListener(PROPERTY_RULES_LIST, new PropertyChangeListener() {
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getNewValue() == null) {
                        selectedRulesListModel.setRules(new ArrayList<Rule>());
                    } else {
                        List<Rule> rules = (List<Rule>)evt.getNewValue();
                        selectedRulesListModel.setRules(rules);
                    }
                }
            });
    
            // fix colums size for buttons
            if (isShowFactorColumn()) {
                SwingUtil.fixTableColumnWidth(selectedRuleParameterTable, 2, 30);
            }
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public RuleChooser() {
        $initialize();
    }

    public RuleChooser(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addRulesButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addSelectedRules(this);
    }

    public void doActionPerformed__on__clearRulesButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.clearAllRules(this);
    }

    public void doActionPerformed__on__removeRuleButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeSelectedRules(this);
    }

    public void doValueChanged__on__availableRuleList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        addRulesButton.setEnabled(availableRuleList.getSelectedIndex() != -1);
    }

    public void doValueChanged__on__selectedRulesList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        removeRuleButton.setEnabled(selectedRulesList.getSelectedIndex() != -1);clearRulesButton.setEnabled(selectedRulesList.getSelectedIndex() != -1);handler.displayRuleParameters(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getActive() {
        return active;
    }

    public JButton getAddRulesButton() {
        return addRulesButton;
    }

    public JList getAvailableRuleList() {
        return availableRuleList;
    }

    public JButton getClearRulesButton() {
        return clearRulesButton;
    }

    public RuleChooserHandler getHandler() {
        return handler;
    }

    public JButton getRemoveRuleButton() {
        return removeRuleButton;
    }

    public List<Rule> getRulesList() {
        return rulesList;
    }

    public JTable getSelectedRuleParameterTable() {
        return selectedRuleParameterTable;
    }

    public ScriptParametersTableModel getSelectedRuleParameterTableModel() {
        return selectedRuleParameterTableModel;
    }

    public JList getSelectedRulesList() {
        return selectedRulesList;
    }

    public RuleListModel getSelectedRulesListModel() {
        return selectedRulesListModel;
    }

    public Boolean getShowFactorColumn() {
        return showFactorColumn;
    }

    public Boolean isActive() {
        return active !=null && active;
    }

    public Boolean isShowFactorColumn() {
        return showFactorColumn !=null && showFactorColumn;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setActive(Boolean active) {
        Boolean oldValue = this.active;
        this.active = active;
        firePropertyChange(PROPERTY_ACTIVE, oldValue, active);
    }

    public void setRulesList(List<Rule> rulesList) {
        List<Rule> oldValue = this.rulesList;
        this.rulesList = rulesList;
        firePropertyChange(PROPERTY_RULES_LIST, oldValue, rulesList);
    }

    public void setShowFactorColumn(Boolean showFactorColumn) {
        Boolean oldValue = this.showFactorColumn;
        this.showFactorColumn = showFactorColumn;
        firePropertyChange(PROPERTY_SHOW_FACTOR_COLUMN, oldValue, showFactorColumn);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createActive() {
        $objectMap.put("active", active = true);
    }

    protected void createAddRulesButton() {
        $objectMap.put("addRulesButton", addRulesButton = new JButton());
        
        addRulesButton.setName("addRulesButton");
        addRulesButton.setEnabled(false);
        addRulesButton.setText(_("isisfish.common.add"));
        addRulesButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addRulesButton"));
    }

    protected void createAvailableRuleList() {
        $objectMap.put("availableRuleList", availableRuleList = new JList());
        
        availableRuleList.setName("availableRuleList");
        availableRuleList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__availableRuleList"));
    }

    protected void createClearRulesButton() {
        $objectMap.put("clearRulesButton", clearRulesButton = new JButton());
        
        clearRulesButton.setName("clearRulesButton");
        clearRulesButton.setEnabled(false);
        clearRulesButton.setText(_("isisfish.common.clear"));
        clearRulesButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__clearRulesButton"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new RuleChooserHandler());
    }

    protected void createRemoveRuleButton() {
        $objectMap.put("removeRuleButton", removeRuleButton = new JButton());
        
        removeRuleButton.setName("removeRuleButton");
        removeRuleButton.setEnabled(false);
        removeRuleButton.setText(_("isisfish.common.remove"));
        removeRuleButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeRuleButton"));
    }

    protected void createRulesList() {
        $objectMap.put("rulesList", rulesList = new java.util.ArrayList<fr.ifremer.isisfish.rule.Rule>());
    }

    protected void createSelectedRuleParameterTable() {
        $objectMap.put("selectedRuleParameterTable", selectedRuleParameterTable = new JTable());
        
        selectedRuleParameterTable.setName("selectedRuleParameterTable");
        selectedRuleParameterTable.setRowHeight(24);
    }

    protected void createSelectedRuleParameterTableModel() {
        $objectMap.put("selectedRuleParameterTableModel", selectedRuleParameterTableModel = new ScriptParametersTableModel());
    }

    protected void createSelectedRulesList() {
        $objectMap.put("selectedRulesList", selectedRulesList = new JList());
        
        selectedRulesList.setName("selectedRulesList");
        selectedRulesList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectedRulesList"));
    }

    protected void createSelectedRulesListModel() {
        $objectMap.put("selectedRulesListModel", selectedRulesListModel = new RuleListModel());
    }

    protected void createShowFactorColumn() {
        $objectMap.put("showFactorColumn", showFactorColumn = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 1, 3, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(addRulesButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane1, new GridBagConstraints(2, 1, 1, 3, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(removeRuleButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(clearRulesButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane2, new GridBagConstraints(0, 4, 3, 1, 2.0, 2.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(availableRuleList);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(selectedRulesList);
        // inline complete setup of $JScrollPane2
        $JScrollPane2.getViewport().add(selectedRuleParameterTable);
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        availableRuleList.setCellRenderer(new fr.ifremer.isisfish.ui.models.rule.RuleNamesListRenderer());
        availableRuleList.setModel(new fr.ifremer.isisfish.ui.models.common.StringListModel(fr.ifremer.isisfish.datastore.RuleStorage.getRuleNames()));
        availableRuleList.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        selectedRulesList.setCellRenderer(new fr.ifremer.isisfish.ui.models.rule.RuleListCellRenderer());
        selectedRulesList.setModel(selectedRulesListModel);
        selectedRulesList.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        selectedRuleParameterTable.setModel(selectedRuleParameterTableModel);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createRulesList();
        createActive();
        createShowFactorColumn();
        createHandler();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("isisfish.params.rules.availables"));
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("isisfish.params.rules.selected"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createAvailableRuleList();
        createAddRulesButton();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createSelectedRulesListModel();
        createSelectedRulesList();
        createRemoveRuleButton();
        createClearRulesButton();
        // inline creation of $JScrollPane2
        $objectMap.put("$JScrollPane2", $JScrollPane2 = new JScrollPane());
        
        $JScrollPane2.setName("$JScrollPane2");
        createSelectedRuleParameterTableModel();
        createSelectedRuleParameterTable();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_AVAILABLE_RULE_LIST_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                availableRuleList.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JSCROLL_PANE1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JScrollPane1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JSCROLL_PANE2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JScrollPane2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTED_RULE_PARAMETER_TABLE_MODEL_SHOW_FACTOR_COLUMN, true ,"showFactorColumn") {
        
            @Override
            public void processDataBinding() {
                selectedRuleParameterTableModel.setShowFactorColumn(isShowFactorColumn());
            }
        });
    }

}