/*
 * #%L
 * IsisFish
 * 
 * $Id: VesselTypeComboModel.java 3279 2011-04-21 12:53:31Z chatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/isis-fish/tags/isis-fish-4.2.0.1/src/main/java/fr/ifremer/isisfish/ui/input/model/VesselTypeComboModel.java $
 * %%
 * Copyright (C) 2011 Ifremer, CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.input.model;

import java.util.List;

import javax.swing.DefaultComboBoxModel;

import fr.ifremer.isisfish.entities.VesselType;

/**
 * Model pour la liste des {@link VesselType}.
 * 
 * Pas de selection par defaut.
 *
 * @author chatellier
 * @version $Revision: 3279 $
 * 
 * Last update : $Date: 2011-04-21 14:53:31 +0200 (Thu, 21 Apr 2011) $
 * By : $Author: chatellier $
 */
public class VesselTypeComboModel extends DefaultComboBoxModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6171850179969290032L;

    /** VesselType list */
    protected List<VesselType> vesselTypeList;

    /**
     * Constructor with ports list.
     * 
     * @param vesselTypeList ports list
     */
    public VesselTypeComboModel(List<VesselType> vesselTypeList) {
        this.vesselTypeList = vesselTypeList;
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Object getElementAt(int index) {
        return vesselTypeList.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (vesselTypeList != null) {
            size = vesselTypeList.size();
        }
        return size;
    }
}
