/*
 * #%L
 * IsisFish
 * 
 * $Id: SpeciesComboModel.java 3276 2011-04-20 15:36:48Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.input.model;

import java.util.List;

import javax.swing.DefaultComboBoxModel;

import fr.ifremer.isisfish.entities.Species;

/**
 * Model pour la liste des {@link Species}.
 * 
 * Pas de selection par defaut.
 *
 * @author chatellier
 * @version $Revision: 3276 $
 * 
 * Last update : $Date: 2011-04-20 17:36:48 +0200 (Wed, 20 Apr 2011) $
 * By : $Author: chatellier $
 */
public class SpeciesComboModel extends DefaultComboBoxModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6171850179969290032L;

    /** Species list */
    protected List<Species> speciesList;

    /**
     * Constructor with species list.
     * 
     * @param speciesList species list
     */
    public SpeciesComboModel(List<Species> speciesList) {
        this.speciesList = speciesList;
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Object getElementAt(int index) {
        return speciesList.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (speciesList != null) {
            size = speciesList.size();
        }
        return size;
    }
}
