/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.util.ArgTypes;
import fr.ifremer.isisfish.util.Args;
import fr.ifremer.isisfish.util.CompileHelper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.FileUtil;

public class EvaluatorHelper {
    private static Log log = LogFactory.getLog(EvaluatorHelper.class);

    protected static String normalizeClassName(String name) {
        StringBuffer result = new StringBuffer(name);
        for (int i = 0; i < result.length(); ++i) {
            char c = result.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            result.setCharAt(i, '_');
        }
        return result.toString();
    }

    public static int check(Class javaInterface, String script, PrintWriter out) {
        try {
            File src = File.createTempFile("check", "equation");
            src.deleteOnExit();
            String packageName = null;
            String className = EvaluatorHelper.normalizeClassName(src.getName());
            src = new File(src.getParentFile(), className + ".java");
            src.deleteOnExit();
            Method[] methods = javaInterface.getDeclaredMethods();
            Method interfaceMethod = methods[0];
            String content = EvaluatorHelper.generateContent(packageName, className, interfaceMethod, script);
            FileUtils.writeStringToFile((File)src, (String)content, (String)"utf-8");
            int compileResult = CompileHelper.compile(src.getParentFile(), src, src.getParentFile(), out);
            File dest = new File(src.getParentFile(), className + ".class");
            dest.deleteOnExit();
            return compileResult;
        }
        catch (Exception eee) {
            log.warn((Object)"Can't check equation", (Throwable)eee);
            return -10000;
        }
    }

    public static Object evaluate(String packageName, String className, Class javaInterface, String script, Map<String, Object> args) {
        className = EvaluatorHelper.normalizeClassName(className);
        Object result = null;
        Class<?> clazz = null;
        Method[] methods = javaInterface.getDeclaredMethods();
        Method interfaceMethod = methods[0];
        String classname = packageName + "." + className;
        File fileRootSrc = IsisFish.config.getCompileDirectory();
        File fileCheckSum = new File(fileRootSrc, packageName + File.separator + className + ".hashCode");
        File fileSrc = new File(fileRootSrc, packageName + File.separator + className + ".java");
        File fileDest = new File(fileRootSrc, packageName + File.separator + className + ".class");
        boolean checkSumEquals = false;
        if (fileSrc.exists() && fileCheckSum.exists()) {
            String oldCheckSum = "";
            try {
                oldCheckSum = FileUtil.readAsString((File)fileCheckSum);
            }
            catch (IOException eee) {
                log.info((Object)("Can't read old checkSum:  " + fileCheckSum), (Throwable)eee);
            }
            String newCheckSum = Integer.toString(script.hashCode());
            checkSumEquals = newCheckSum.equals(oldCheckSum);
        }
        if (!checkSumEquals) {
            String content = EvaluatorHelper.generateContent(packageName, className, interfaceMethod, script);
            try {
                FileUtil.writeString((File)fileSrc, (String)content, (String)"utf-8");
            }
            catch (IOException zzz) {
                throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.save.script.compilation", (Object[])new Object[]{fileSrc}), zzz);
            }
            try {
                FileUtil.writeString((File)fileCheckSum, (String)Integer.toString(script.hashCode()));
            }
            catch (IOException zzz) {
                throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.save.checkSum.compilation", (Object[])new Object[]{fileSrc}), zzz);
            }
        }
        if (FileUtil.isNewer((File)fileSrc, (File)fileDest)) {
            try {
                ArrayList<File> classpath = new ArrayList<File>();
                classpath.add(fileRootSrc.getAbsoluteFile());
                classpath.add(IsisFish.config.getDatabaseDirectory().getAbsoluteFile());
                int compileResult = CompileHelper.compile(classpath, Collections.singletonList(fileSrc), fileRootSrc, null);
                if (compileResult != 0) {
                    throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.compile.script", (Object[])new Object[]{compileResult, fileSrc}));
                }
            }
            catch (Exception zzz) {
                throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.compile.script", (Object[])new Object[]{fileSrc}), zzz);
            }
        }
        try {
            ClassLoader cl = IsisFish.config.getScriptClassLoader();
            clazz = cl.loadClass(classname);
        }
        catch (Exception zzz) {
            throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.load.class", (Object[])new Object[]{classname}), zzz);
        }
        result = EvaluatorHelper.invoke(clazz, interfaceMethod, args);
        return result;
    }

    protected static String generateContent(String packageName, String className, Method interfaceMethod, String script) {
        String[] stringTypes;
        String content = "";
        if (packageName != null && !"".equals(packageName)) {
            content = content + "package " + packageName + ";";
        }
        content = content + "import fr.ifremer.isisfish.entities.*;";
        content = content + "import org.nuiton.math.matrix.*;";
        content = content + "import fr.ifremer.isisfish.types.*;";
        content = content + "import org.apache.commons.logging.Log;";
        content = content + "import org.apache.commons.logging.LogFactory;";
        content = content + "import java.util.*;";
        content = content + "public class " + className + " implements " + interfaceMethod.getDeclaringClass().getName() + " {";
        content = content + "private static Log log = LogFactory.getLog(" + className + ".class);";
        content = content + "public " + interfaceMethod.getReturnType().getName() + " " + interfaceMethod.getName() + "(";
        Args args = interfaceMethod.getAnnotation(Args.class);
        String[] names = args.value();
        ArgTypes argTypes = interfaceMethod.getAnnotation(ArgTypes.class);
        if (argTypes != null) {
            stringTypes = argTypes.value();
        } else {
            stringTypes = new String[names.length];
            Class<?>[] types = interfaceMethod.getParameterTypes();
            for (int i = 0; i < types.length; ++i) {
                stringTypes[i] = types[i].getName();
            }
        }
        for (int i = 0; i < names.length; ++i) {
            content = content + stringTypes[i] + " " + names[i];
            if (i + 1 >= names.length) continue;
            content = content + ", ";
        }
        content = content + ") throws Exception {";
        content = content + script;
        content = content + "\n}\n}\n";
        return content;
    }

    protected static Object invoke(Class clazz, Method interfaceMethod, Map<String, Object> args) {
        try {
            Method method = clazz.getDeclaredMethod(interfaceMethod.getName(), interfaceMethod.getParameterTypes());
            ArrayList<Object> params = new ArrayList<Object>();
            for (String name : interfaceMethod.getAnnotation(Args.class).value()) {
                Object arg = args.get(name);
                params.add(arg);
            }
            Object eq = clazz.newInstance();
            Object result = method.invoke(eq, params.toArray());
            return result;
        }
        catch (Exception eee) {
            throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.invoke.method", (Object[])new Object[]{interfaceMethod, clazz.getName()}), eee);
        }
    }
}

