/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTextField;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Resource;

public class FilterableComboBox
extends JPanel
implements ListDataListener {
    private static Log log = LogFactory.getLog(FilterableComboBox.class);
    private static final long serialVersionUID = -6669320998140538372L;
    protected JComboBox dataBox;
    protected JTextField filterField;
    protected JButton resetButton;
    protected FilterComboBoxModel filterModel;
    protected List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    protected boolean filtering = false;

    public FilterableComboBox() {
        this.buildLayout();
    }

    public FilterableComboBox(ComboBoxModel model) {
        this();
        this.setModel(model);
    }

    private void buildLayout() {
        this.dataBox = new JComboBox();
        this.dataBox.addActionListener(new ComboBoxActionListener());
        this.filterField = new JXTextField(I18n._((String)"isisfish.common.filter", (Object[])new Object[0]));
        this.filterField.setPreferredSize(new Dimension(200, 0));
        this.resetButton = new JButton(Resource.getIcon((String)"/icons/cancel.png"));
        this.resetButton.addActionListener(new FilterActionListener());
        this.resetButton.setEnabled(false);
        this.filterField.getDocument().addDocumentListener(new FilterDocumentListener());
        this.setLayout(new BorderLayout());
        this.add((Component)this.dataBox, "Center");
        JPanel filterPanel = new JPanel(new BorderLayout());
        filterPanel.add((Component)this.filterField, "Center");
        filterPanel.add((Component)this.resetButton, "East");
        this.add((Component)filterPanel, "East");
    }

    public void setModel(ComboBoxModel model) {
        model.addListDataListener(this);
        this.dataBox.setModel(new FilterComboBoxModel(model));
    }

    public ComboBoxModel getModel() {
        return ((FilterComboBoxModel)this.dataBox.getModel()).getModel();
    }

    public Object getSelectedItem() {
        return this.dataBox.getSelectedItem();
    }

    public void setSelectedItem(Object object) {
        this.dataBox.setSelectedItem(object);
    }

    public boolean addActionListener(ActionListener e) {
        return this.actionListeners.add(e);
    }

    public boolean removeActionListener(ActionListener o) {
        return this.actionListeners.remove(o);
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        if (!this.filtering) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"intervalAdded : fireDataChanged");
            }
            ((FilterComboBoxModel)this.dataBox.getModel()).fireDataChanged();
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        if (!this.filtering) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"intervalRemoved : fireDataChanged");
            }
            ((FilterComboBoxModel)this.dataBox.getModel()).fireDataChanged();
        }
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        if (!this.filtering) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"contentsChanged : fireDataChanged");
            }
            ((FilterComboBoxModel)this.dataBox.getModel()).fireDataChanged();
        }
    }

    class ComboBoxActionListener
    implements ActionListener {
        ComboBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!FilterableComboBox.this.filtering) {
                for (ActionListener a : FilterableComboBox.this.actionListeners) {
                    a.actionPerformed(e);
                }
            }
        }
    }

    class FilterActionListener
    implements ActionListener {
        FilterActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterableComboBox.this.filterField.setText("");
        }
    }

    class FilterDocumentListener
    implements DocumentListener {
        FilterDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateFilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateFilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateFilter();
        }

        protected void updateFilter() {
            ((FilterComboBoxModel)FilterableComboBox.this.dataBox.getModel()).fireDataChanged();
            FilterableComboBox.this.resetButton.setEnabled(!FilterableComboBox.this.filterField.getText().isEmpty());
        }
    }

    class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private static final long serialVersionUID = 6256289874593024153L;
        protected ComboBoxModel model;
        protected List<Integer> realIndexes = new ArrayList<Integer>();
        protected Object selectedItem;

        public FilterComboBoxModel(ComboBoxModel model) {
            this.model = model;
            this.fireDataChanged();
        }

        public ComboBoxModel getModel() {
            return this.model;
        }

        @Override
        public int getSize() {
            int size = this.realIndexes.size();
            return size;
        }

        @Override
        public Object getElementAt(int index) {
            int realIndex = this.realIndexes.get(index);
            Object element = this.model.getElementAt(realIndex);
            return element;
        }

        public void fireDataChanged() {
            FilterableComboBox.this.filtering = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Refreshing real indexes list");
            }
            this.realIndexes.clear();
            for (int i = 0; i < this.model.getSize(); ++i) {
                Object element = this.model.getElementAt(i);
                if (!element.toString().contains(FilterableComboBox.this.filterField.getText())) continue;
                this.realIndexes.add(i);
            }
            this.fireIntervalRemoved(this, 0, this.model.getSize());
            this.fireIntervalAdded(this, 0, this.realIndexes.size());
            FilterableComboBox.this.filtering = false;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selectedItem = anItem;
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }
    }
}

