/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.util;

import fr.ifremer.isisfish.IsisConfig;
import fr.ifremer.isisfish.IsisFish;
import java.awt.Component;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorReporter;
import org.nuiton.i18n.I18n;

public class ErrorHelper
implements ErrorReporter {
    public static void showErrorDialog(Component parent, String message, Throwable cause) {
        JXErrorPane pane = new JXErrorPane();
        ErrorInfo info = new ErrorInfo(I18n._((String)"isisfish.error.errorpane.title", (Object[])new Object[0]), I18n._((String)"isisfish.error.errorpane.htmlmessage", (Object[])new Object[]{message}), null, null, cause, null, null);
        pane.setErrorInfo(info);
        if (cause != null) {
            pane.setErrorReporter((ErrorReporter)new ErrorHelper());
        }
        JXErrorPane.showDialog((Component)parent, (JXErrorPane)pane);
    }

    public static void showErrorDialog(String message) {
        ErrorHelper.showErrorDialog(message, null);
    }

    public static void showErrorDialog(String message, Throwable cause) {
        ErrorHelper.showErrorDialog(null, message, cause);
    }

    public void reportError(ErrorInfo errorInfo) throws NullPointerException {
        MultiPartEmail email = new MultiPartEmail();
        try {
            String emailTo = "support@codelutin.com";
            email.setHostName("smtp");
            email.addTo(emailTo, "Support");
            email.setFrom("no-reply@isis-fish.org", "Isis-Fish");
            email.setSubject("Project error notification : Isis-Fish");
            email.addReplyTo("no-reply@isis-fish.org");
            String message = this.formatMessage("Project", "Isis-Fish " + IsisConfig.getVersion());
            message = message + this.formatMessage("Date", new Date().toString());
            message = message + this.formatMessage("Title", errorInfo.getTitle());
            message = message + this.formatMessage("Description", errorInfo.getBasicErrorMessage().replaceAll("<[^>]+>", ""));
            message = message + this.formatMessage("Configuration", null);
            ArrayList<String> propertiesNames = new ArrayList<String>(IsisFish.config.getOptions().stringPropertyNames());
            Collections.sort(propertiesNames);
            for (String propertyName : propertiesNames) {
                if (propertyName.contains("pass")) continue;
                message = message + "\t" + propertyName + " : " + IsisFish.config.getOptions().getProperty(propertyName) + "\n";
            }
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            errorInfo.getErrorException().printStackTrace(writer);
            message = message + this.formatMessage("Exception", out.toString());
            email.setContent((Object)message, "text/plain; charset=ISO-8859-9");
            email.send();
            JOptionPane.showMessageDialog(null, "A report message has been sent to " + emailTo);
        }
        catch (EmailException e) {
            e.printStackTrace();
        }
    }

    protected String formatMessage(String category, String content) {
        String formatted = category + " :\n";
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            formatted = formatted + "\t" + content + "\n";
        }
        return formatted;
    }
}

