/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.script.model;

import fr.ifremer.isisfish.ui.script.ScriptUI;
import fr.ifremer.isisfish.ui.script.model.ScriptTranferable;
import fr.ifremer.isisfish.ui.script.model.ScriptTree;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScriptTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 5433321973795969278L;
    private static Log log = LogFactory.getLog(ScriptTransferHandler.class);
    protected ScriptUI scriptUI;

    public ScriptTransferHandler(ScriptUI scriptUI) {
        this.scriptUI = scriptUI;
    }

    @Override
    public boolean canImport(JComponent cp, DataFlavor[] df) {
        for (DataFlavor dataFlavor : df) {
            if (!dataFlavor.equals(ScriptTranferable.myData)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent component, Transferable transferable) {
        boolean confirmImport = false;
        confirmImport = true;
        return confirmImport;
    }

    @Override
    protected Transferable createTransferable(JComponent cp) {
        ScriptTranferable transferable = null;
        ScriptTree scriptTree = (ScriptTree)cp;
        List<File> selectedFiles = scriptTree.getSelectedFiles();
        if (CollectionUtils.isNotEmpty(selectedFiles)) {
            LinkedList<File> files = new LinkedList<File>(selectedFiles);
            transferable = new ScriptTranferable(files);
        }
        return transferable;
    }

    @Override
    protected void exportDone(JComponent cp, Transferable transferable, int type) {
        block7: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Transfert done");
            }
            if (type == 2) {
                try {
                    ScriptTree factorTree = (ScriptTree)cp;
                    File directory = factorTree.getSelectedDirectory();
                    if (directory != null) {
                        Object myObject = transferable.getTransferData(ScriptTranferable.myData);
                        List movedFiles = (List)myObject;
                        this.scriptUI.getScriptAction().moveFiles(directory, movedFiles);
                    }
                }
                catch (IOException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Exception while transfering task", (Throwable)e);
                    }
                }
                catch (UnsupportedFlavorException e) {
                    if (!log.isErrorEnabled()) break block7;
                    log.error((Object)"Exception while transfering task", (Throwable)e);
                }
            }
        }
    }

    @Override
    public int getSourceActions(JComponent component) {
        return 2;
    }
}

