/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.models.export;

import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.ui.util.TooltipHelper;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import org.nuiton.i18n.I18n;

public class ExportNameListRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -4070846632975105788L;
    protected Map<String, Export> exportCache = new HashMap<String, Export>();

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel c = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        String exportName = (String)value;
        c.setText(exportName);
        try {
            Export export = this.exportCache.get(exportName);
            if (export == null) {
                ExportStorage storage = ExportStorage.getExport(exportName, new CodeSourceStorage.Location[0]);
                export = storage.getNewExportInstance();
                this.exportCache.put(exportName, export);
            }
            c.setToolTipText(export.getDescription());
        }
        catch (Exception e) {
            String errorTooltip = TooltipHelper.getErrorTooltip(I18n._((String)"isisfish.error.compile.fileerror", (Object[])new Object[]{exportName}));
            c.setToolTipText(errorTooltip);
        }
        return c;
    }
}

