/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.tree;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.FisheryRegionImpl;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.Port;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.TripType;
import fr.ifremer.isisfish.entities.VesselType;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.ui.input.tree.FisheryDataProvider;
import fr.ifremer.isisfish.ui.input.tree.FisheryTreeNode;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;

public class FisheryTreeRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -9045080128695551208L;
    protected FisheryDataProvider provider;

    public FisheryTreeRenderer(FisheryDataProvider provider) {
        this.provider = provider;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = null;
        if (value instanceof FisheryTreeNode) {
            FisheryTreeNode node = (FisheryTreeNode)((Object)value);
            if (!node.isStaticNode() || node.isStringNode()) {
                stringValue = I18n._((String)node.getId(), (Object[])new Object[0]);
            } else {
                FisheryRegion fisheryRegion = this.provider.getFisheryRegion();
                TopiaContext topiaContext = ((FisheryRegionImpl)fisheryRegion).getTopiaContext();
                try {
                    TopiaEntity entity = topiaContext.findByTopiaId(node.getId());
                    if (entity != null) {
                        if (FisheryRegion.class.isAssignableFrom(entity.getClass())) {
                            stringValue = ((FisheryRegion)entity).getName();
                        } else if (Cell.class.isAssignableFrom(entity.getClass())) {
                            stringValue = ((Cell)entity).getName();
                        } else if (Gear.class.isAssignableFrom(entity.getClass())) {
                            stringValue = ((Gear)entity).getName();
                        } else if (Metier.class.isAssignableFrom(entity.getClass())) {
                            stringValue = ((Metier)entity).getName();
                        } else if (Population.class.isAssignableFrom(entity.getClass())) {
                            stringValue = ((Population)entity).getName();
                        } else if (Port.class.isAssignableFrom(entity.getClass())) {
                            stringValue = ((Port)entity).getName();
                        } else if (SetOfVessels.class.isAssignableFrom(entity.getClass())) {
                            stringValue = ((SetOfVessels)entity).getName();
                        } else if (Species.class.isAssignableFrom(entity.getClass())) {
                            stringValue = ((Species)entity).getName();
                        } else if (Strategy.class.isAssignableFrom(entity.getClass())) {
                            stringValue = ((Strategy)entity).getName();
                        } else if (TripType.class.isAssignableFrom(entity.getClass())) {
                            stringValue = ((TripType)entity).getName();
                        } else if (VesselType.class.isAssignableFrom(entity.getClass())) {
                            stringValue = ((VesselType)entity).getName();
                        } else if (Zone.class.isAssignableFrom(entity.getClass())) {
                            stringValue = ((Zone)entity).getName();
                        }
                    }
                }
                catch (TopiaException eee) {
                    throw new IsisFishRuntimeException("Can't get entity for id " + node.getId(), eee);
                }
            }
        }
        return super.getTreeCellRendererComponent(tree, stringValue, sel, expanded, leaf, row, hasFocus);
    }
}

