/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.sensitivity;

import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.DiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationDiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.MatrixContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.visitor.FactorVisitor;
import java.io.Serializable;

public class Factor
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1643804268013964453L;
    protected String name;
    protected String comment;
    protected Object identifier;
    protected Domain domain;
    protected Object nominalValue;
    protected Object value;
    protected String path;
    protected int cardinality;

    public Factor(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getDisplayedValue() {
        if (this.domain instanceof MatrixContinuousDomain) {
            return this.identifier;
        }
        if (this.domain instanceof EquationDiscreteDomain || this.domain instanceof EquationContinuousDomain) {
            return "\"" + this.getValue() + "\"";
        }
        return this.getValue();
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setValueForIdentifier(Object valueIdentifier) {
        this.identifier = valueIdentifier;
        this.value = this.domain.getValueForIdentifier(valueIdentifier);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Object getNominalValue() {
        return this.nominalValue;
    }

    public void setNominalValue(Object nominalValue) {
        this.nominalValue = nominalValue;
    }

    public int getCardinality() {
        if (this.domain instanceof DiscreteDomain) {
            return ((DiscreteDomain)this.domain).getValues().size();
        }
        return this.cardinality;
    }

    public void setCardinality(int cardinality) {
        this.cardinality = cardinality;
    }

    public void accept(FactorVisitor visitor) {
        visitor.start(this);
        visitor.visit(this, this.domain);
        visitor.end(this);
    }

    public Object clone() {
        Factor f;
        try {
            f = (Factor)super.clone();
            if (this.domain != null) {
                f.domain = this.domain.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error on clone()", e);
        }
        return f;
    }

    public String toString() {
        return "Factor : " + this.name + "(" + this.comment + ")";
    }
}

