/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.launcher;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.datastore.ScriptStorage;
import fr.ifremer.isisfish.datastore.SensitivityExportStorage;
import fr.ifremer.isisfish.datastore.SimulationPlanStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.datastore.SimulatorStorage;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.mexico.MexicoHelper;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.rule.RuleHelper;
import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.SimulationException;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.SimulationPlan;
import fr.ifremer.isisfish.simulator.SimulationPlanContext;
import fr.ifremer.isisfish.simulator.launcher.SimulationExecutor;
import fr.ifremer.isisfish.simulator.launcher.SimulationItem;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationMonitor;
import fr.ifremer.isisfish.simulator.launcher.SimulationQueue;
import fr.ifremer.isisfish.simulator.launcher.SimulationServiceListener;
import fr.ifremer.isisfish.simulator.launcher.SimulatorLauncher;
import fr.ifremer.isisfish.simulator.sensitivity.DesignPlan;
import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import fr.ifremer.isisfish.simulator.sensitivity.Scenario;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityAnalysis;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityScenarios;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityUtils;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationDiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.RuleDiscreteDomain;
import fr.ifremer.isisfish.util.CompileHelper;
import fr.ifremer.isisfish.util.ConverterUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.FileUtil;
import org.nuiton.util.ListenerSet;
import org.nuiton.util.ObjectUtil;
import org.nuiton.util.ZipUtil;

public class SimulationService {
    public static final String SIMULATION_LAUNCHER = "simulation.launcher";
    public static final int MAX_PLAN_SIMULATION = 20000;
    private static Log log = LogFactory.getLog(SimulationService.class);
    protected static SimulationService instance = new SimulationService();
    protected PropertyChangeSupport propertyListeners = new PropertyChangeSupport(this);
    protected ListenerSet<SimulationServiceListener> listeners = new ListenerSet();
    protected boolean autoLaunch = true;
    protected ExecutorService subSimulationComputationExecutor = Executors.newSingleThreadExecutor();
    protected Map<SimulatorLauncher, SimulationExecutor> executors = new LinkedHashMap<SimulatorLauncher, SimulationExecutor>();
    protected Map<SimulatorLauncher, MutableInt> launcherError = new HashMap<SimulatorLauncher, MutableInt>();
    protected SimulationQueue queue = new SimulationQueue();
    protected Set<String> idJobs = new HashSet<String>();
    protected Set<SimulationJob> jobs = new TreeSet<SimulationJob>();
    protected Set<SimulationJob> jobDones = new TreeSet<SimulationJob>();

    public static SimulationService getService() {
        return instance;
    }

    protected SimulationService() {
        Properties prop = IsisFish.config.getOptionStartsWith(SIMULATION_LAUNCHER);
        ArrayList<String> simulationKeys = new ArrayList<String>(prop.stringPropertyNames());
        Collections.sort(simulationKeys);
        for (String key : simulationKeys) {
            String value = prop.getProperty(key);
            try {
                SimulatorLauncher sl = (SimulatorLauncher)ObjectUtil.newInstance((String)value);
                this.addSimulationLauncher(sl);
            }
            catch (Exception eee) {
                log.warn((Object)I18n._((String)"Can't instantiate %s", (Object[])new Object[]{value}), (Throwable)eee);
            }
        }
        if (IsisFish.config.isLaunchUI()) {
            SimulationMonitor.getInstance().reloadConfig(this);
        }
    }

    public void addSimulationLauncher(SimulatorLauncher sl) {
        SimulationQueue executorQueue = new SimulationQueue(this.queue);
        SimulationExecutor se = new SimulationExecutor(this, sl, executorQueue);
        this.executors.put(sl, se);
        this.launcherError.put(sl, new MutableInt(0));
    }

    public List<SimulatorLauncher> getSimulationLaunchers() {
        ArrayList<SimulatorLauncher> result = new ArrayList<SimulatorLauncher>(this.executors.keySet());
        return result;
    }

    public Collection<SimulationExecutor> getSimulationExecutors() {
        return this.executors.values();
    }

    public synchronized Set<SimulationJob> getJobs() {
        return this.jobs;
    }

    public synchronized Set<SimulationJob> getJobDones() {
        return this.jobDones;
    }

    protected Set<SimulatorLauncher> getSimulatorLaunchers() {
        return this.executors.keySet();
    }

    public void addSimulationServiceListener(SimulationServiceListener l) {
        this.listeners.add((Object)l);
    }

    public void removeSimulationServiceListener(SimulationServiceListener l) {
        this.listeners.remove((Object)l);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyListeners.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyListeners.removePropertyChangeListener(propertyName, listener);
    }

    protected synchronized void fireStartEvent(SimulationJob job) {
        if (this.jobs.add(job)) {
            this.idJobs.add(job.getItem().getControl().getId());
            for (SimulationServiceListener l : this.listeners) {
                l.simulationStart(this, job);
            }
        }
    }

    protected synchronized void fireStopEvent(SimulationJob job) {
        this.jobs.remove(job);
        this.idJobs.remove(job.getItem().getControl().getId());
        this.jobDones.add(job);
        for (SimulationServiceListener l : this.listeners) {
            l.simulationStop(this, job);
        }
    }

    public void clearJobDone() {
        this.jobDones.clear();
        for (SimulationServiceListener l : this.listeners) {
            l.clearJobDone(this);
        }
    }

    public boolean isAutoLaunch() {
        return this.autoLaunch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoLaunch(boolean autoLaunch) {
        SimulationService simulationService = this;
        synchronized (simulationService) {
            boolean oldValue = this.autoLaunch;
            this.autoLaunch = autoLaunch;
            if (this.autoLaunch) {
                this.notifyAll();
            }
            this.propertyListeners.firePropertyChange("autoLaunch", oldValue, autoLaunch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitAutoLaunch() {
        SimulationService simulationService = this;
        synchronized (simulationService) {
            while (!this.isAutoLaunch()) {
                try {
                    log.info((Object)"autoLaunch is false waiting queue start");
                    this.wait();
                }
                catch (InterruptedException eee) {
                    log.warn((Object)"Error during wait autoLaunch flag", (Throwable)eee);
                }
            }
        }
    }

    public void submit(String id, SimulationParameter param, SimulatorLauncher launcher, int priority) {
        SimulationParameter localParameters = param.deepCopy();
        SimulationControl control = new SimulationControl(id);
        SimulationItem item = new SimulationItem(control, localParameters);
        SimulationJob job = new SimulationJob(this, item, priority);
        job.setLauncher(launcher);
        this.fireStartEvent(job);
        PrepareSimulationJob task = null;
        if (localParameters.getUseSimulationPlan()) {
            task = new PrepareSimulationJob(this, job);
        }
        File zip = this.prepareSimulationZipFile(control, localParameters, null, null, true);
        item.setSimulationZip(zip);
        if (localParameters.getUseSimulationPlan() && localParameters.isIndependentPlan()) {
            this.subSimulationComputationExecutor.execute(task);
        } else {
            this.submit(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(String id, SimulationParameter param, SimulatorLauncher launcher, int priority, SensitivityAnalysis sensitivityAnalysis, DesignPlan designPlan) {
        SimulationParameter localParameters = param.deepCopy();
        try {
            File masterExportDirectory = new File(SimulationStorage.getSensitivityResultsDirectory(), id);
            if (!masterExportDirectory.isDirectory()) {
                masterExportDirectory.mkdirs();
            }
            String xmlDesignPlan = MexicoHelper.getDesignPlanAsXML(designPlan);
            RegionStorage regionStorage = RegionStorage.getRegion(param.getRegionName());
            TopiaContext context = null;
            try {
                context = regionStorage.getStorage().beginTransaction();
                this.fillDesignPlanNominalValue(context, designPlan);
            }
            finally {
                if (context != null) {
                    context.closeContext();
                }
            }
            SensitivityScenarios sensitivityScenarios = sensitivityAnalysis.compute(designPlan, masterExportDirectory);
            localParameters.setSensitivityAnalysis(sensitivityAnalysis);
            localParameters.setNumberOfSensitivitySimulation(sensitivityScenarios.getScenarios().size());
            SimulationControl controlJustForZip = new SimulationControl(id);
            File zip = this.prepareSimulationZipFile(controlJustForZip, localParameters, xmlDesignPlan, sensitivityScenarios, true);
            int simulationIndex = 0;
            for (Scenario scenario : sensitivityScenarios.getScenarios()) {
                SimulationParameter subParam = localParameters.copy();
                String preScriptContent = this.generatePreScript(scenario);
                subParam.setUsePreScript(true);
                subParam.setPreScript(preScriptContent);
                String subsimulationId = id + "_" + simulationIndex;
                SimulationControl realSimulationControl = new SimulationControl(subsimulationId);
                SimulationItem item = new SimulationItem(realSimulationControl, subParam);
                item.setSimulationZip(zip);
                item.setStandaloneSimulation(false);
                item.setStandaloneSimulationZip(false);
                item.setSimulationNumber(simulationIndex);
                item.setLastSimulation(simulationIndex == sensitivityScenarios.getScenarios().size() - 1);
                SimulationJob job = new SimulationJob(this, item, priority);
                job.setLauncher(launcher);
                this.fireStartEvent(job);
                if (subParam.getUseSimulationPlan() && subParam.isIndependentPlan()) {
                    PrepareSimulationJob task = new PrepareSimulationJob(this, job);
                    this.subSimulationComputationExecutor.execute(task);
                } else {
                    this.submit(job);
                }
                ++simulationIndex;
            }
        }
        catch (Exception e) {
            throw new IsisFishRuntimeException("Can't get scenarios from calculator", e);
        }
    }

    protected void fillDesignPlanNominalValue(TopiaContext context, DesignPlan designPlan) {
        for (Factor factor : designPlan.getFactors()) {
            String path = factor.getPath();
            if (StringUtils.contains((CharSequence)path, (CharSequence)"#")) {
                String topiaId = path.substring(0, path.lastIndexOf("#"));
                String propertyName = path.substring(path.lastIndexOf("#") + 1);
                try {
                    TopiaEntity entity = context.findByTopiaId(topiaId);
                    String result = BeanUtils.getProperty((Object)entity, (String)propertyName);
                    factor.setNominalValue(result);
                }
                catch (Exception ex) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"An error occurred while trying to get nominal value", (Throwable)ex);
                    }
                }
            } else {
                factor.setNominalValue("NaN");
            }
            String name = SensitivityUtils.espaceFactorName(factor.getName());
            factor.setName(name);
        }
    }

    protected String generatePreScript(Scenario scenario) {
        ConvertUtilsBean beanUtils = ConverterUtil.getConverter(null);
        StringBuffer buffer = new StringBuffer();
        buffer.append("import org.apache.commons.beanutils.BeanUtils;\n");
        buffer.append("import org.apache.commons.beanutils.ConvertUtilsBean;\n");
        buffer.append("import fr.ifremer.isisfish.util.ConverterUtil;\n");
        buffer.append("import fr.ifremer.isisfish.simulator.SimulationParameter;\n");
        buffer.append("ConvertUtilsBean beanUtils = ConverterUtil.getConverter(db);\n");
        buffer.append("SimulationParameter params = context.getSimulationStorage().getParameter();\n");
        this.generatePreScript(beanUtils, buffer, new Counter(), scenario.getFactors());
        String scriptContent = buffer.toString();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Simulation prescript content = " + scriptContent));
        }
        return scriptContent;
    }

    protected void generatePreScript(ConvertUtilsBean beanUtils, StringBuffer buffer, Counter counter, Collection<Factor> factors) {
        for (Factor factor : factors) {
            if (factor instanceof FactorGroup) {
                buffer.append("/* factor group : ").append(factor.getName()).append(" */\n");
                FactorGroup factorGroup = (FactorGroup)factor;
                this.generatePreScript(beanUtils, buffer, counter, factorGroup.getFactors());
            } else {
                int factorIndex = counter.getCounter();
                buffer.append("/* factor : ").append(factor.getName()).append(" */\n");
                if (factor.getPath().matches("parameters.population\\.\\w+\\.number")) {
                    String paramName = StringUtils.removeStart((String)factor.getPath(), (String)"parameters.");
                    MatrixND matrix = (MatrixND)factor.getValue();
                    String stringValue = String.valueOf(matrix.toList());
                    buffer.append("params.setProperty(\"").append(paramName).append("\",\"").append((Object)stringValue).append("\");\n");
                } else if (factor.getPath().equals("parameters.rules")) {
                    List rules = (List)factor.getValue();
                    ArrayList<String> rulesNames = new ArrayList<String>();
                    int ruleIndex = 0;
                    for (Rule rule : rules) {
                        rulesNames.add(rule.getClass().getSimpleName());
                        Properties rulesProps = RuleHelper.getRuleAsProperties(ruleIndex++, null, rule);
                        for (String rulesProp : rulesProps.stringPropertyNames()) {
                            String value = rulesProps.getProperty(rulesProp);
                            buffer.append("params.setProperty(\"").append(rulesProp).append("\",\"").append(value).append("\");\n");
                        }
                    }
                    buffer.append("params.setProperty(\"rules\",\"").append(StringUtils.join(rulesNames, (String)",")).append("\");\n");
                } else if (factor.getPath().startsWith("parameters.rule.")) {
                    Pattern pattern = Pattern.compile("^parameters\\.(rule\\.\\d+\\.parameter\\.\\w+)\\..+$");
                    Matcher matcher = pattern.matcher(factor.getPath());
                    String paramName = null;
                    paramName = matcher.matches() ? matcher.group(1) : StringUtils.removeStart((String)factor.getPath(), (String)"parameters.");
                    String stringValue = ConvertUtils.convert((Object)factor.getValue());
                    buffer.append("params.setProperty(\"").append(paramName).append("\",\"").append(stringValue).append("\");\n");
                } else if (factor.getDomain() instanceof EquationContinuousDomain) {
                    buffer.append("context.setComputeValue(\"").append(factor.getName());
                    buffer.append("\",").append(factor.getValue()).append(");\n");
                } else {
                    String stringValue;
                    Object value = factor.getValue();
                    String escValue = stringValue = beanUtils.convert(value);
                    if (factor.getDomain() instanceof EquationDiscreteDomain) {
                        escValue = StringUtils.replace((String)escValue, (String)"\n", (String)"");
                        escValue = StringUtils.replace((String)escValue, (String)"\r", (String)"");
                        escValue = StringUtils.replace((String)escValue, (String)"\"", (String)"\\\"");
                    }
                    String path = factor.getPath();
                    String topiaId = path.substring(0, path.lastIndexOf(35));
                    String property = path.substring(path.lastIndexOf(35) + 1);
                    buffer.append(value.getClass().getName()).append(" value");
                    buffer.append(factorIndex).append(" = beanUtils.convert(\"");
                    buffer.append(escValue).append("\", ").append(value.getClass().getName());
                    buffer.append(".class);\n");
                    buffer.append("TopiaEntity entity").append(factorIndex);
                    buffer.append(" = db.findByTopiaId(\"").append(topiaId);
                    buffer.append("\");\n");
                    if (factor.getDomain() instanceof EquationDiscreteDomain) {
                        buffer.append("BeanUtils.setProperty(entity").append(factorIndex);
                        buffer.append(", \"").append(property).append("Content\", ");
                        buffer.append("value").append(factorIndex).append(");\n");
                    } else {
                        buffer.append("BeanUtils.setProperty(entity").append(factorIndex);
                        buffer.append(", \"").append(property).append("\", ");
                        buffer.append("value").append(factorIndex).append(");\n");
                    }
                }
            }
            counter.inc();
        }
    }

    protected void submit(SimulationJob job) {
        SimulatorLauncher launcher = job.getLauncher();
        if (launcher != null) {
            for (SimulatorLauncher l : this.executors.keySet()) {
                if (launcher != l) continue;
                SimulationExecutor executor = this.executors.get(l);
                executor.execute(job);
                return;
            }
        }
        log.info((Object)I18n._((String)"Add to default queue", (Object[])new Object[0]));
        this.queue.add(job);
    }

    protected void resubmit(SimulationJob job) {
        this.submit(job);
    }

    protected void submitSubJob(SimulationJob job) {
        this.submit(job);
    }

    public void submitForCheckOnly(SimulationJob job) {
        job.setOnlyCheckControl(true);
        this.fireStartEvent(job);
        this.submit(job);
    }

    public void restart(SimulationJob job) {
        job.getItem().setStandaloneSimulation(true);
        job.setOnlyCheckControl(false);
        job.getItem().getControl().reset();
        this.fireStartEvent(job);
        this.submit(job);
    }

    protected boolean cancel(SimulationJob job) {
        boolean result = this.queue.remove(job);
        return result;
    }

    public boolean exists(String id) {
        boolean result = this.idJobs.contains(id);
        return result;
    }

    protected void reportError(SimulatorLauncher launcher, SimulationJob job) {
        MutableInt i = this.launcherError.get(launcher);
        i.setValue(i.intValue() + 1);
        if (i.intValue() >= 50) {
            log.error((Object)I18n._((String)"Launcher %s will be stopped because there are too many error (%s)", (Object[])new Object[]{launcher, i.intValue()}));
            SimulationExecutor e = this.executors.get(launcher);
            e.pause();
        }
        this.resubmit(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File prepareSimulationZipFile(SimulationControl control, SimulationParameter param, String xmlDesignPlan, SensitivityScenarios sensitivityScenarios, boolean compile) throws SimulationException {
        try {
            String name;
            File tmpDirectory = FileUtil.createTempDirectory((String)"isisfish-simulation-", (String)"-preparation");
            File regionXML = new File(tmpDirectory, "data-backup.sql.gz");
            Properties prop = param.toProperties();
            File f = new File(tmpDirectory, "parameters.properties");
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(f);
                prop.store(out, "Parameters");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
            control.setText(I18n._((String)"isisfish.message.backup.database.progress", (Object[])new Object[0]));
            RegionStorage region = RegionStorage.getRegion(param.getRegionName());
            TopiaContext tc = region.getStorage().beginTransaction();
            tc.backup(regionXML, true);
            tc.closeContext();
            control.setText(I18n._((String)"isisfish.message.backup.database.finished", (Object[])new Object[0]));
            List<Rule> rules = param.getRules();
            if (sensitivityScenarios != null) {
                for (Scenario sensitivityScenario : sensitivityScenarios.getScenarios()) {
                    List<Factor> factors = sensitivityScenario.getFactors();
                    for (Factor factor : factors) {
                        Domain domain = factor.getDomain();
                        if (!(domain instanceof RuleDiscreteDomain)) continue;
                        rules.addAll((List)factor.getValue());
                    }
                }
            }
            for (Rule rule : rules) {
                String name2 = RuleStorage.getName(rule);
                File ruleFile = new File(RuleStorage.getRuleDirectory(), name2 + ".java");
                if (!ruleFile.isFile()) {
                    ruleFile = new File(RuleStorage.getCommunityRuleDirectory(), name2 + ".java");
                }
                FileUtil.copy((File)ruleFile, (File)new File(tmpDirectory, "rules" + File.separator + name2 + ".java"));
            }
            for (String name3 : param.getExtraRules()) {
                File ruleFile = new File(RuleStorage.getRuleDirectory(), name3 + ".java");
                if (!ruleFile.isFile()) {
                    ruleFile = new File(RuleStorage.getCommunityRuleDirectory(), name3 + ".java");
                }
                FileUtil.copy((File)ruleFile, (File)new File(tmpDirectory, "rules" + File.separator + name3 + ".java"));
            }
            List<SimulationPlan> plans = param.getSimulationPlans();
            for (SimulationPlan plan : plans) {
                name = SimulationPlanStorage.getName(plan);
                File planFile = new File(SimulationPlanStorage.getSimulationPlanDirectory(), name + ".java");
                if (!planFile.isFile()) {
                    planFile = new File(SimulationPlanStorage.getCommunitySimulationPlanDirectory(), name + ".java");
                }
                FileUtil.copy((File)planFile, (File)new File(tmpDirectory, "simulationplans" + File.separator + name + ".java"));
            }
            for (String name2 : param.getExportNames()) {
                name2 = name2.endsWith(".java") ? name2 : name2 + ".java";
                File exportFile = new File(ExportStorage.getExportDirectory(), name2);
                if (!exportFile.isFile()) {
                    exportFile = new File(ExportStorage.getCommunityExportDirectory(), name2);
                }
                FileUtil.copy((File)exportFile, (File)new File(tmpDirectory, "exports" + File.separator + name2));
            }
            for (SensitivityExport sensitivity : param.getSensitivityExport()) {
                name = SensitivityExportStorage.getName(sensitivity);
                name = name.endsWith(".java") ? name : name + ".java";
                File sensitivityFile = new File(SensitivityExportStorage.getSensitivityExportDirectory(), name);
                if (!sensitivityFile.isFile()) {
                    sensitivityFile = new File(SensitivityExportStorage.getCommunitySensitivityExportDirectory(), name);
                }
                FileUtil.copy((File)sensitivityFile, (File)new File(tmpDirectory, "sensitivityexports" + File.separator + name));
            }
            FileUtil.copyRecursively((File)ScriptStorage.getCommunityScriptDirectory(), (File)tmpDirectory, (String[])new String[]{".*\\.java$"});
            FileUtil.copyRecursively((File)ScriptStorage.getScriptDirectory(), (File)tmpDirectory, (String[])new String[]{".*\\.java$"});
            File simulatorFile = new File(SimulatorStorage.getSimulatorDirectory(), param.getSimulatorName());
            if (!simulatorFile.isFile()) {
                simulatorFile = new File(SimulatorStorage.getCommunitySimulatorDirectory(), param.getSimulatorName());
            }
            FileUtil.copy((File)simulatorFile, (File)new File(tmpDirectory, "simulators" + File.separator + param.getSimulatorName()));
            if (compile) {
                this.compileAllFile(control, tmpDirectory);
            }
            if (!StringUtils.isEmpty((CharSequence)xmlDesignPlan)) {
                File simulationDesignPlanFile = SimulationStorage.getMexicoDesignPlan(tmpDirectory);
                FileUtil.writeString((File)simulationDesignPlanFile, (String)xmlDesignPlan, (String)"utf-8");
            }
            File result = new File(tmpDirectory.getPath() + ".zip");
            result.deleteOnExit();
            ZipUtil.compress((File)result, (File)tmpDirectory, null);
            if (!FileUtil.deleteRecursively((File)tmpDirectory)) {
                log.warn((Object)I18n._((String)"isisfish.error.remove.directory", (Object[])new Object[]{tmpDirectory}));
            }
            return result;
        }
        catch (IOException eee) {
            throw new SimulationException(I18n._((String)"isisfish.error.prepare.information.simulation", (Object[])new Object[0]), eee);
        }
        catch (TopiaException eee) {
            throw new SimulationException(I18n._((String)"isisfish.error.prepare.information.simulation", (Object[])new Object[0]), eee);
        }
    }

    protected void compileAllFile(SimulationControl control, File directory) {
        String[] modules;
        control.setText(I18n._((String)"isisfish.simulation.message.scriptscompilation", (Object[])new Object[0]));
        long currentTime = System.nanoTime();
        ArrayList<File> fileToCompile = new ArrayList<File>();
        for (String module : modules = new String[]{"exports", "rules", "sensitivityexports", "sensitivityanalysis", "scripts", "simulationplans", "simulators"}) {
            List tmp = FileUtil.find((File)new File(directory, module), (String)".*\\.java$", (boolean)true);
            fileToCompile.addAll(tmp);
        }
        CompileHelper.compile(directory, fileToCompile, directory, null);
        long time = System.nanoTime() - currentTime;
        control.setText(I18n._((String)"isisfish.message.compilation.time", (Object[])new Object[]{DurationFormatUtils.formatDuration((long)(time / 1000000L), (String)"s'.'S")}));
    }

    public static class PrepareSimulationJob
    implements Runnable,
    Iterator<SimulationJob>,
    SimulationJob.PostAction {
        protected SimulationService simulationService;
        protected SimulationPlanContext planContext;
        protected SimulationJob job;
        protected SimulationJob nextJob;
        protected boolean doNext = true;
        protected String id;
        protected SimulationControl control;
        protected SimulationParameter param;
        protected int done = 0;
        protected List<SimulationPlan> simulationPlan;

        public PrepareSimulationJob(SimulationService simulationService, SimulationJob job) {
            this.simulationService = simulationService;
            this.job = job;
            this.id = job.getItem().getControl().getId();
            this.control = job.getItem().getControl();
            this.param = job.getItem().getParameter();
            this.simulationPlan = this.param.getSimulationPlans();
            this.planContext = new SimulationPlanContext(this.control.getId(), this.param);
            try {
                for (SimulationPlan plan : this.simulationPlan) {
                    plan.init(this.planContext);
                }
            }
            catch (Exception eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)I18n._((String)"isisfish.error.evaluate.preplan.script", (Object[])new Object[0]), (Throwable)eee);
                }
                throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.evaluate.preplan.script", (Object[])new Object[0]), eee);
            }
        }

        @Override
        public void run() {
            SimulationJob subJobN = null;
            if (this.hasNext()) {
                subJobN = this.next();
            }
            while (subJobN != null) {
                try {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Simulation generated: " + subJobN.getId()));
                    }
                    SimulationItem itemN = subJobN.getItem();
                    itemN.setStandaloneSimulation(false);
                    itemN.setSimulationNumber(this.planContext.getNumber() - 1);
                    SimulationJob subJobNp1 = this.next();
                    if (subJobNp1 == null) {
                        itemN.setLastSimulation(true);
                    }
                    this.simulationService.submitSubJob(subJobN);
                    subJobN = subJobNp1;
                }
                catch (Exception eee) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)I18n._((String)"Can't add simulation: %s", (Object[])new Object[]{this.job.getItem().getControl().getId()}), (Throwable)eee);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            try {
                boolean result;
                boolean bl = result = !this.control.isStopSimulationRequest() && this.doNext;
                if (result) {
                    PrepareSimulationJob prepareSimulationJob = this;
                    synchronized (prepareSimulationJob) {
                        if (this.nextJob == null) {
                            int planNumber = this.planContext.getNumber();
                            if (planNumber > 20000) {
                                log.error((Object)I18n._((String)"Analyse plan error, too many simulation for %s : %s", (Object[])new Object[]{this.id, planNumber}));
                                this.doNext = false;
                                result = false;
                            } else {
                                String simId = this.id + "_" + planNumber;
                                this.param.setSimulationPlanNumber(planNumber);
                                File tmpDirectory = FileUtil.createTempDirectory((String)"isisfish-simulation-", (String)"-preparation");
                                SimulationStorage sim = SimulationStorage.importAndRenameZip(tmpDirectory, this.job.getItem().getSimulationZip(), simId);
                                sim.getParameter().setSimulationPlanNumber(planNumber);
                                for (SimulationPlan plan : this.simulationPlan) {
                                    if (result = result && plan.beforeSimulation(this.planContext, sim)) continue;
                                    this.nextJob = null;
                                    break;
                                }
                                this.doNext = result;
                                if (result) {
                                    File zip = sim.createZip();
                                    SimulationControl childControl = new SimulationControl(simId);
                                    SimulationParameter childParam = this.param.copy();
                                    SimulationItem item = new SimulationItem(childControl, childParam);
                                    item.setSimulationZip(zip);
                                    this.nextJob = new SimulationJob(this.simulationService, this.job, item, this.job.getPriority());
                                    this.nextJob.setLauncher(this.job.getLauncher());
                                    if (this.param.isIndependentPlan()) {
                                        this.nextJob.addPostAction(this);
                                    }
                                }
                                sim.closeStorage();
                                if (!FileUtil.deleteRecursively((File)tmpDirectory)) {
                                    log.warn((Object)I18n._((String)"isisfish.error.remove.directory", (Object[])new Object[]{tmpDirectory}));
                                }
                            }
                            this.planContext.incNumber();
                        }
                    }
                }
                return result;
            }
            catch (Exception eee) {
                throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.evalute.plan.script", (Object[])new Object[0]), eee);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SimulationJob next() {
            this.hasNext();
            SimulationJob result = null;
            PrepareSimulationJob prepareSimulationJob = this;
            synchronized (prepareSimulationJob) {
                result = this.nextJob;
                this.nextJob = null;
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public void finished(SimulationJob job, SimulationStorage sim) {
            for (SimulationPlan plan : this.simulationPlan) {
                try {
                    boolean result = plan.afterSimulation(this.planContext, sim);
                    this.doNext = this.doNext && result;
                }
                catch (Exception eee) {
                    log.error((Object)I18n._((String)"Stop simulation plan, because can't call afterSimulation correctly on plan %s", (Object[])new Object[]{plan.getClass().getName()}), (Throwable)eee);
                    this.doNext = false;
                }
            }
            ++this.done;
            if (!this.hasNext() && this.done + 1 == this.planContext.getNumber()) {
                this.simulationService.fireStopEvent(this.job);
            }
        }

        @Override
        public void exception(SimulationJob job, Throwable eee) {
            this.doNext = false;
            this.simulationService.fireStopEvent(this.job);
        }
    }

    public static class Counter {
        protected int counter = 0;

        public void inc() {
            ++this.counter;
        }

        public int getCounter() {
            return this.counter;
        }
    }
}

