/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.datastore.DataStorage;
import fr.ifremer.isisfish.datastore.StorageChangeEvent;
import fr.ifremer.isisfish.datastore.StorageException;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.FisheryRegionDAO;
import fr.ifremer.isisfish.entities.Result;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.vcs.VCSException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.util.FileUtil;
import org.nuiton.util.ZipUtil;

public class RegionStorage
extends DataStorage {
    public static final String REGION_PATH = "regions";
    public static final String MAP_DIRECTORY = "maps";
    private static Log log = LogFactory.getLog(RegionStorage.class);
    protected static Map<String, RegionStorage> regions = new ReferenceMap();
    protected File commentForNextCommitFile = new File(this.getDirectory(), "commentForNextCommit.txt");

    protected RegionStorage(File directory, String name) {
        super(directory, name);
    }

    public static File getRegionDirectory() {
        File result = RegionStorage.getContextDatabaseDirectory();
        result = new File(result, REGION_PATH);
        result.mkdirs();
        return result;
    }

    public static File getRegionDirectory(String name) {
        File result = RegionStorage.getRegionDirectory();
        result = new File(result, name);
        return result;
    }

    public String getCommentForNextCommit() throws IOException {
        this.commentForNextCommitFile.createNewFile();
        String result = FileUtil.readAsString((File)this.commentForNextCommitFile);
        return result;
    }

    public void setCommentForNextCommit(String commentForNextCommit) throws IOException {
        this.commentForNextCommitFile.createNewFile();
        FileUtil.writeString((File)this.commentForNextCommitFile, (String)commentForNextCommit);
    }

    public void clearCommentForNextCommit() {
        String date = DateFormatUtils.ISO_DATETIME_FORMAT.format(new Date());
        File dest = new File(this.commentForNextCommitFile, date);
        this.commentForNextCommitFile.renameTo(dest);
    }

    @Override
    protected boolean isVersionnableFile(File file) {
        boolean result = super.isVersionnableFile(file);
        if (result) {
            result = !file.getAbsolutePath().startsWith(this.commentForNextCommitFile.getAbsolutePath());
        }
        return result;
    }

    public void addCommentForNextCommit(String commentToAdd) throws IOException {
        String comment = this.getCommentForNextCommit();
        comment = comment + MessageFormat.format("{0,date,long}: " + commentToAdd + "\n", new Date());
        this.setCommentForNextCommit(comment);
    }

    @Override
    public void rename(String toName) throws StorageException {
        try {
            regions.remove(this.getName());
            super.rename(toName);
            TopiaContext tx = this.getStorage().beginTransaction();
            FisheryRegion region = RegionStorage.getFisheryRegion(tx);
            region.setName(toName);
            tx.commitTransaction();
            tx.closeContext();
            regions.put(toName, this);
            RegionStorage.fireDataChanged(new StorageChangeEvent(this));
        }
        catch (TopiaException eee) {
            throw new StorageException(I18n._((String)"isisfish.error.rename.region", (Object[])new Object[]{toName}), eee);
        }
    }

    public File getMapRepository() {
        File result = new File(this.getDirectory(), MAP_DIRECTORY);
        return result;
    }

    public static RegionStorage checkout(String name) throws VCSException, TopiaException {
        RegionStorage.checkout(IsisFish.config.getDatabaseDirectory(), REGION_PATH + File.separator + name);
        RegionStorage region = RegionStorage.getRegion(name);
        if (region != null) {
            File file = region.getDataBackupFile();
            if (file.exists()) {
                TopiaContext tx = region.getStorage().beginTransaction();
                tx.restore(file);
                tx.commitTransaction();
                tx.closeContext();
            }
            RegionStorage.fireDataChanged(new StorageChangeEvent(region));
        }
        return region;
    }

    public static RegionStorage getRegion(String name) {
        RegionStorage result = regions.get(name);
        if (result == null) {
            File directory = null;
            directory = SimulationContext.get().getScriptDirectory() != null ? RegionStorage.getContextDatabaseDirectory() : RegionStorage.getRegionDirectory(name);
            if (log.isInfoEnabled()) {
                log.info((Object)("Try to open region " + name + "(" + directory + ")"));
            }
            if (directory.exists()) {
                result = new RegionStorage(directory, name);
                regions.put(name, result);
            }
        }
        return result;
    }

    public static boolean exists(String name) {
        boolean result = false;
        result = result || RegionStorage.getRegionNames().contains(name);
        result = result || RegionStorage.getRemoteRegionNames().contains(name);
        return result;
    }

    public static RegionStorage create(String name) throws StorageException {
        if (RegionStorage.exists(name)) {
            throw new StorageException("Can't create region this region name exists: " + name);
        }
        File directory = RegionStorage.getRegionDirectory(name);
        RegionStorage result = new RegionStorage(directory, name);
        try {
            TopiaContext context = result.getStorage().beginTransaction();
            context.createSchema();
            FisheryRegionDAO regionDAO = IsisFishDAOHelper.getFisheryRegionDAO(context);
            regionDAO.create(new Object[]{"name", name});
            context.commitTransaction();
            context.closeContext();
        }
        catch (TopiaException eee) {
            throw new StorageException("Can't create new Region", eee);
        }
        regions.put(name, result);
        RegionStorage.fireDataChanged(new StorageChangeEvent(result));
        return result;
    }

    @Override
    public void delete(boolean cvsDelete) throws StorageException {
        super.delete(cvsDelete);
        RegionStorage.fireDataChanged(new StorageChangeEvent(this));
        regions.remove(this.getName());
    }

    public static List<String> getRegionNames() {
        File dir = RegionStorage.getRegionDirectory();
        List<String> result = RegionStorage.getStorageNames(dir);
        return result;
    }

    public static List<RegionStorage> getRegions() {
        ArrayList<RegionStorage> result = new ArrayList<RegionStorage>();
        for (String name : RegionStorage.getRegionNames()) {
            RegionStorage region = RegionStorage.getRegion(name);
            result.add(region);
        }
        return result;
    }

    public static List<String> getNewRegionNames() {
        List<String> result = RegionStorage.getRegionNames();
        result.removeAll(RegionStorage.getRemoteRegionNames());
        return result;
    }

    public static List<String> getRemoteRegionNames() {
        File dir = RegionStorage.getRegionDirectory();
        List<String> result = RegionStorage.getRemoteStorageNames(dir);
        return result;
    }

    public static List<String> getNewRemoteRegionNames() {
        List<String> result = RegionStorage.getRemoteRegionNames();
        result.removeAll(RegionStorage.getRegionNames());
        return result;
    }

    public static FisheryRegion getFisheryRegion(TopiaContext context) throws StorageException {
        FisheryRegion result;
        try {
            FisheryRegionDAO regionDAO = IsisFishDAOHelper.getFisheryRegionDAO(context);
            List regions = regionDAO.findAll();
            if (regions.size() != 1) {
                throw new StorageException("Invalide region database number of region must be 1 not " + regions.size());
            }
            result = (FisheryRegion)regions.get(0);
        }
        catch (TopiaException eee) {
            throw new StorageException("Can't find FisheryRegion in this Region", eee);
        }
        return result;
    }

    public static RegionStorage importZip(File file) throws IOException, StorageException {
        RegionStorage result = RegionStorage.importAndRenameZip(file, null);
        return result;
    }

    public static RegionStorage importAndRenameZip(File file, String newName) throws IOException, StorageException {
        try {
            String lastEntry;
            String name;
            RegionStorage result;
            String renameFrom = null;
            String renameTo = null;
            if (newName != null) {
                renameFrom = "^.*?/(.*)$";
                renameTo = newName + "/$1";
            }
            if ((result = RegionStorage.getRegion(name = (lastEntry = ZipUtil.uncompressAndRename((File)file, (File)RegionStorage.getRegionDirectory(), (String)renameFrom, renameTo)).substring(0, lastEntry.indexOf("/")))) != null) {
                File data = result.getDataBackupFile();
                if (data.exists()) {
                    TopiaContext tx = result.getStorage().beginTransaction();
                    tx.restore(data);
                    if (newName != null) {
                        FisheryRegion region = RegionStorage.getFisheryRegion(tx);
                        region.setName(newName);
                    }
                    tx.execute("DELETE " + Result.class.getName(), new Object[0]);
                    tx.commitTransaction();
                    tx.closeContext();
                }
                result.closeStorage();
            }
            RegionStorage.fireDataChanged(new StorageChangeEvent(result));
            return result;
        }
        catch (TopiaException eee) {
            throw new StorageException(I18n._((String)"isisfish.error.import.file", (Object[])new Object[]{file}), eee);
        }
    }
}

