/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.aspect;

import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.Trace;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.aspectwerkz.annotation.After;
import org.codehaus.aspectwerkz.annotation.AfterThrowing;
import org.codehaus.aspectwerkz.annotation.Aspect;
import org.codehaus.aspectwerkz.annotation.Before;
import org.codehaus.aspectwerkz.annotation.Expression;
import org.codehaus.aspectwerkz.definition.Pointcut;
import org.codehaus.aspectwerkz.joinpoint.JoinPoint;
import org.codehaus.aspectwerkz.joinpoint.MethodSignature;

@Aspect(value="perJVM")
public class TraceAspect {
    private static Log log = LogFactory.getLog(TraceAspect.class);
    @Expression(value="execution(* scripts..*(..)) || execution(* simulators..*(..)) || execution(* rules..*(..))  || execution(* simulationplans..*(..))  || execution(* formules..*(..))")
    Pointcut executeMethod;

    protected Trace getTrace() {
        SimulationContext context = SimulationContext.get();
        Trace result = context.getTrace();
        return result;
    }

    @Before(value="executeMethod")
    public void traceBeforeExecute(JoinPoint jp) {
        this.getTrace().traceBefore();
    }

    @AfterThrowing(type="java.lang.Exception", pointcut="executeMethod")
    public void traceAfterThrowingExecute(JoinPoint jp) {
        this.traceAfterExecute(jp);
    }

    @After(value="executeMethod")
    public void traceAfterExecute(JoinPoint jp) {
        Method method = ((MethodSignature)jp.getSignature()).getMethod();
        this.getTrace().traceAfterCall(method);
    }
}

