package fr.ifremer.isisfish.ui.simulator.filter;

/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.simulator.SimulationMeta;
import fr.ifremer.isisfish.ui.widget.filter.FilterDialogUI;
import fr.ifremer.isisfish.ui.widget.filter.FilterPanelUI;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.SimpleDateFormat;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import static org.nuiton.i18n.I18n._;

public class SimulationFilterPanelUI extends FilterPanelUI {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWTW8TRxieGJyQr4bwET5Kq1CMhJBYQ/iSGkqAUItEhrh1EAELibF3HE8y3t3OzMLCoeIn8BPoteqlUm+cqh567qGXqn+hQj30inhn197NlmEYsT6s43nf55nneWf8OD/9g8qCo+NbOIocHnqS9omzen1jY629RTryJhEdTgPpc5S8Rkqo1EKTbrouJDrRqit4dQCvLvv9wPeItwO9WEcTQj5lRPQIkRJ9lkd0hKg20/JiFIR8yJqK0rG+/Pd16YX7/IcSQlEA6o6ClfkPoTInu+uoRF2J9sFOj3GVYW8TZHDqbYLeabW2zLAQd3CffIe+R2N1NBpgDmQSfWFvOeaI8VEg0UylRpkkvIE9wu6unJVoqcsd2uWkT+BdUNGloueE1BG0HzIMTE43RjjNZIH6Xo4iCGL2UYnGKuu4zQhwHs4NQTwBS05cU53jKWBPZbWO24QBYp+yGw1ak1XVNJX2fiLS7dVAJJrLIdZJJGuUMDePGu5wTn2ezdemU4fDCR/Qgxc04AlONgdSDMjzGmR6eQGugY5Wbt3wI5jIIc0MVUm/04V0p+NpbSYbWVNiDtdm3uebzhYI2JZ+kHBGzurGTSxJg3a2Cc8TDMkvasinM/KvvXjqp/INiZF48Cf0mi+ltGfS2pQX9tuEr3XvE8zT8Zx5B3tZgz2QSWrAl+lOzKThSJQtaJTNhoI0cyQSHczds+Ue6WwPTuFyNmnArcGJ9ukzPDzXxXzLFLQ0OGnGR/+eOpySpELSjqZeZn4Hs50Fjj7NXRFIMSdLsSxmRlqozENYhu9l693g+xZKSeQd/l/kKcK4+mZu/5+v/v6lNsy5Cux9UNu6I6YhfwLuB4RLqraeSUIulJRVb+NgsYXGBWGQ8XGGH9MIaw7KIA72m1VwR8GdW1j0gKI89tevv809+mMXKtXQBPOxW8OqfwWNyx6HKfjMjYKla7GiqSd74LlXaYNLxNQVqvkcYuWKiyWeb1PPhfO9GsEYjmnGkGppj//+3/7mz9eGoxgBaUfe256No/wAjVKPUY/EoT/Ic23ITwaChK6f5bYuyUfU+95gEL4r8fO2zutuCckI+Xol2X0eS/iFaYeSgFcF+iY2of5qWnNOSt9n6zRQoauaNj6WSi2vqUdDzzBnxXDPoMGO4WFhBpOLo4Vd2DGYXNgxmFx8XtiFHYPJhR2DycXJwi7sGEwu7BhMLk4XdmHHYHJhx2BycbawCzsGk4sPM8D/tR2fhX1PGGgWCg/jQuFh2DGYhmHH8KOB4VJhF18WdmHHYNLwVWENdgwmDUuFNdgxmDRcL6zBjsGkYbmwBsXwFtm090JoEAAA";
    private static final Log log = LogFactory.getLog(SimulationFilterPanelUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTextField description;
    protected JCheckBox local;
    protected JTextField numberOfYear;
    protected JTextField regionName;
    protected JXDatePicker simulationEnd;
    protected JTextField simulationName;
    protected JTextField simulationPlanNumber;
    protected JXDatePicker simulationStart;
    protected JTextField simulatorName;
    protected JCheckBox useOptimization;
    protected JCheckBox usePreScript;
    protected JCheckBox useSimulationPlan;
    protected JCheckBox useStatistic;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SimulationFilterPanelUI $FilterPanelUI0 = this;
    private Table $Table0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private HBox $HBox0;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private HBox $HBox1;
    private JLabel $JLabel6;
    private JLabel $JLabel7;
    private HBox $HBox2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
    
        /**
         * push param's ui value to model
         *
         * @throws Exception
         */
        public synchronized void uiToModel() {
             extractTextFieldParam(SimulationMeta.simulationName.name());
             extractTextFieldParam(SimulationMeta.simulatorName.name());
             extractTextFieldParam(SimulationMeta.regionName.name());
             extractTextFieldParam(SimulationMeta.description.name());
    
             extractTextFieldParam(SimulationMeta.numberOfYear.name());
             extractTextFieldParam(SimulationMeta.simulationPlanNumber.name());
    
             extractCheckBoxParam(SimulationMeta.useSimulationPlan.name());
             extractCheckBoxParam(SimulationMeta.useOptimization.name());
             extractCheckBoxParam(SimulationMeta.usePreScript.name());
             extractCheckBoxParam(SimulationMeta.useStatistic.name());
             extractCheckBoxParam(SimulationMeta.local.name());
    
             extractDateInterval(SimulationMeta.simulationInterval.name(),
                                 SimulationMeta.simulationStart.name(),
                                 SimulationMeta.simulationEnd.name());
         }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SimulationFilterPanelUI(FilterDialogUI dialog) {
        super(dialog);
            $initialize();
    }

    public SimulationFilterPanelUI() {
        $initialize();
    }

    public SimulationFilterPanelUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public SimulationFilterPanelUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SimulationFilterPanelUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SimulationFilterPanelUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SimulationFilterPanelUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SimulationFilterPanelUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SimulationFilterPanelUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__local(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCheck();
    }

    public void doActionPerformed__on__useOptimization(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCheck();
    }

    public void doActionPerformed__on__usePreScript(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCheck();
    }

    public void doActionPerformed__on__useSimulationPlan(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCheck();
    }

    public void doActionPerformed__on__useStatistic(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCheck();
    }

    public void doFocusLost__on__simulationEnd(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCheck();
    }

    public void doFocusLost__on__simulationStart(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCheck();
    }

    public void doKeyReleased__on__description(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCheck();
    }

    public void doKeyReleased__on__numberOfYear(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCheck();
    }

    public void doKeyReleased__on__regionName(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCheck();
    }

    public void doKeyReleased__on__simulationName(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCheck();
    }

    public void doKeyReleased__on__simulationPlanNumber(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCheck();
    }

    public void doKeyReleased__on__simulatorName(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCheck();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTextField getDescription() {
        return description;
    }

    public JCheckBox getLocal() {
        return local;
    }

    public JTextField getNumberOfYear() {
        return numberOfYear;
    }

    public JTextField getRegionName() {
        return regionName;
    }

    public JXDatePicker getSimulationEnd() {
        return simulationEnd;
    }

    public JTextField getSimulationName() {
        return simulationName;
    }

    public JTextField getSimulationPlanNumber() {
        return simulationPlanNumber;
    }

    public JXDatePicker getSimulationStart() {
        return simulationStart;
    }

    public JTextField getSimulatorName() {
        return simulatorName;
    }

    public JCheckBox getUseOptimization() {
        return useOptimization;
    }

    public JCheckBox getUsePreScript() {
        return usePreScript;
    }

    public JCheckBox getUseSimulationPlan() {
        return useSimulationPlan;
    }

    public JCheckBox getUseStatistic() {
        return useStatistic;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected HBox get$HBox0() {
        return $HBox0;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected HBox get$HBox1() {
        return $HBox1;
    }

    protected JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected HBox get$HBox2() {
        return $HBox2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createDescription() {
        $objectMap.put("description", description = new JTextField());
        
        description.setName("description");
        description.setColumns(15);
        description.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__description"));
    }

    protected void createLocal() {
        $objectMap.put("local", local = new JCheckBox());
        
        local.setName("local");
        local.setText(_("isisfish.filter.simulation.local"));
        local.setToolTipText(_("isisfish.filter.simulation.tooltip.local"));
        local.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__local"));
    }

    protected void createNumberOfYear() {
        $objectMap.put("numberOfYear", numberOfYear = new JTextField());
        
        numberOfYear.setName("numberOfYear");
        numberOfYear.setColumns(15);
        numberOfYear.setColumns(5);
        numberOfYear.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__numberOfYear"));
    }

    protected void createRegionName() {
        $objectMap.put("regionName", regionName = new JTextField());
        
        regionName.setName("regionName");
        regionName.setColumns(15);
        regionName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__regionName"));
    }

    protected void createSimulationEnd() {
        $objectMap.put("simulationEnd", simulationEnd = new JXDatePicker());
        
        simulationEnd.setName("simulationEnd");
        simulationEnd.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__simulationEnd"));
    }

    protected void createSimulationName() {
        $objectMap.put("simulationName", simulationName = new JTextField());
        
        simulationName.setName("simulationName");
        simulationName.setColumns(15);
        simulationName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__simulationName"));
    }

    protected void createSimulationPlanNumber() {
        $objectMap.put("simulationPlanNumber", simulationPlanNumber = new JTextField());
        
        simulationPlanNumber.setName("simulationPlanNumber");
        simulationPlanNumber.setColumns(15);
        simulationPlanNumber.setColumns(5);
        simulationPlanNumber.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__simulationPlanNumber"));
    }

    protected void createSimulationStart() {
        $objectMap.put("simulationStart", simulationStart = new JXDatePicker());
        
        simulationStart.setName("simulationStart");
        simulationStart.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__simulationStart"));
    }

    protected void createSimulatorName() {
        $objectMap.put("simulatorName", simulatorName = new JTextField());
        
        simulatorName.setName("simulatorName");
        simulatorName.setColumns(15);
        simulatorName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__simulatorName"));
    }

    protected void createUseOptimization() {
        $objectMap.put("useOptimization", useOptimization = new JCheckBox());
        
        useOptimization.setName("useOptimization");
        useOptimization.setText(_("isisfish.filter.simulation.useOptimization"));
        useOptimization.setToolTipText(_("isisfish.filter.simulation.tooltip.useOptimization"));
        useOptimization.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__useOptimization"));
    }

    protected void createUsePreScript() {
        $objectMap.put("usePreScript", usePreScript = new JCheckBox());
        
        usePreScript.setName("usePreScript");
        usePreScript.setText(_("isisfish.filter.simulation.usePreScript"));
        usePreScript.setToolTipText(_("isisfish.filter.simulation.tooltip.usePreScript"));
        usePreScript.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__usePreScript"));
    }

    protected void createUseSimulationPlan() {
        $objectMap.put("useSimulationPlan", useSimulationPlan = new JCheckBox());
        
        useSimulationPlan.setName("useSimulationPlan");
        useSimulationPlan.setText(_("isisfish.filter.simulation.useSimulationPlan"));
        useSimulationPlan.setToolTipText(_("isisfish.filter.simulation.tooltip.useSimulationPlan"));
        useSimulationPlan.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__useSimulationPlan"));
    }

    protected void createUseStatistic() {
        $objectMap.put("useStatistic", useStatistic = new JCheckBox());
        
        useStatistic.setName("useStatistic");
        useStatistic.setText(_("isisfish.filter.simulation.useStatistic"));
        useStatistic.setToolTipText(_("isisfish.filter.simulation.tooltip.useStatistic"));
        useStatistic.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__useStatistic"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $FilterPanelUI0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(simulationName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(simulatorName, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(regionName, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(description, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($HBox0, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($HBox1, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($HBox2, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $HBox0
        $HBox0.add($JLabel4);
        $HBox0.add(simulationStart);
        $HBox0.add($JLabel5);
        $HBox0.add(simulationEnd);
        // inline complete setup of $HBox1
        $HBox1.add($JLabel6);
        $HBox1.add(numberOfYear);
        $HBox1.add($JLabel7);
        $HBox1.add(simulationPlanNumber);
        // inline complete setup of $HBox2
        $HBox2.add(useSimulationPlan);
        $HBox2.add(useOptimization);
        $HBox2.add(usePreScript);
        $HBox2.add(useStatistic);
        $HBox2.add(local);
        
        // apply 8 property setters
        $JLabel0.setLabelFor(simulationName);
        $JLabel1.setLabelFor(simulatorName);
        $JLabel2.setLabelFor(regionName);
        $JLabel3.setLabelFor(description);
        $JLabel4.setLabelFor(simulationStart);
        $JLabel5.setLabelFor(simulationEnd);
        $JLabel6.setLabelFor(numberOfYear);
        $JLabel7.setLabelFor(simulationPlanNumber);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$FilterPanelUI0", $FilterPanelUI0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("isisfish.filter.simulation.simulationName"));
        $JLabel0.setToolTipText(_("isisfish.filter.simulation.tooltip.simulationName"));
        createSimulationName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("isisfish.filter.simulation.simulatorName"));
        $JLabel1.setToolTipText(_("isisfish.filter.simulation.tooltip.simulatorName"));
        createSimulatorName();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.filter.simulation.regionName"));
        $JLabel2.setToolTipText(_("isisfish.filter.simulation.tooltip.regionName"));
        createRegionName();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.filter.simulation.description"));
        $JLabel3.setToolTipText(_("isisfish.filter.simulation.tooltip.description"));
        createDescription();
        // inline creation of $HBox0
        $objectMap.put("$HBox0", $HBox0 = new HBox());
        
        $HBox0.setName("$HBox0");
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("isisfish.filter.simulation.simulationStart"));
        $JLabel4.setToolTipText(_("isisfish.filter.simulation.tooltip.simulationStart"));
        createSimulationStart();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("isisfish.filter.simulation.simulationEnd"));
        $JLabel5.setToolTipText(_("isisfish.filter.simulation.tooltip.simulationEnd"));
        createSimulationEnd();
        // inline creation of $HBox1
        $objectMap.put("$HBox1", $HBox1 = new HBox());
        
        $HBox1.setName("$HBox1");
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new JLabel());
        
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("isisfish.filter.simulation.numberOfYear"));
        $JLabel6.setToolTipText(_("isisfish.filter.simulation.tooltip.numberOfYear"));
        createNumberOfYear();
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new JLabel());
        
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("isisfish.filter.simulation.simulationPlanNumber"));
        $JLabel7.setToolTipText(_("isisfish.filter.simulation.tooltip.simulationPlanNumber"));
        createSimulationPlanNumber();
        // inline creation of $HBox2
        $objectMap.put("$HBox2", $HBox2 = new HBox());
        
        $HBox2.setName("$HBox2");
        createUseSimulationPlan();
        createUseOptimization();
        createUsePreScript();
        createUseStatistic();
        createLocal();
        // inline creation of $FilterPanelUI0
        setName("$FilterPanelUI0");
        
        $completeSetup();
    }

}