package fr.ifremer.isisfish.ui.result;

/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.entities.FisheryRegion;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import static org.nuiton.i18n.I18n._;

public class ResultSimulationFrame extends JInternalFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_FISHERY_REGION = "fisheryRegion";
    public static final String PROPERTY_SIMULATION_STORAGE = "simulationStorage";
    public static final String PROPERTY_TOPIA_CONTEXT = "topiaContext";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1UQU8TQRSeVkppC4IgBCMaxB6MJlMTEo2BIIJpoClqKDHEXpx2p+2Q3Zl1ZlYWD8af4E/QuxcTb56MB88evBj/gjEevBrfbNvdFlbogR52mvfe971v3pv33v1EKSXRlT3i+1h6XDOH4tK93d2HtT1a1/epqkvmaiFR+5dIomQV5azQrjS6Wi0beKEDL6wLxxWc8h70UhlllT6wqWpRqjW61I+oK1WohO4l3/VklzUUFcf65vev5Gvr1dskQr4L6nJwlfmTUNFNhsooySyNJiHTc1KwCW+CDMl4E/SOGdu6TZR6QBz6DL1E6TIadokEMo0WBr9ywBHgfVejiXxpk2sqObGLEohvarTYkJg1JHUonIqpBlMt7DEsqfJsjbeDo8IczyaaCR7AXDegHNYo3SLcsqnU6MYgPBvt6Ah/ToXMFZBNmlSjQhyTRTRREEFx5TAiYhszoVQebNMmuDW6HscEdWKaUYWLvcERyagWLiPrgKe+eSxCNjH3mBYcBx680+OPYNl8aYtyb41IKOp50z4fq33oJu7ae2Kp7wqpjR1KcCTWRM1GJc7vkJptWjXb97jagMBnIjMhYCRfKpMatQEx2ccdWE3Q5TB2vN0eBU+oJtaEr9F0H6Rr70dNOwQeqv+Y0X0qTSUI4+YN9Kd7RHiYTqKLfeJh5nA0c9FQJKooJT0ww22rR8d0G1ztAZ09NKCGMPD+nZn69vHHh2J3KtOQezo2tGepwLS4UrhwB2ZSj7dH0tPMLmwRd6mKMorasJGCjTMXI6zScYM4yBe0FBs43iCqBRSp9PdPn2eefj2DkkWUtQWxisTEb6KMbkEPWsK2fPfuaqBodH8EvhNGG3SzbgtlmgzlXWbchkrPEw3lr3marvhQirmYUoR6apkvf6Yq71e75UiAvAv/DY9KknqChtvZgjXV2UCxaynnKupZIto0cbsnYc6s25mBQvBdjLtvjtUFZw3Wfde3/GAebgfazb87g1M5xGcOe3EKVBno0akQDZmtcQzH3Ikcxlw+hmFhABXDNjkQHmy3s8tmsc7XGLdgZlfiGa8B4z+u+50mqwcAAA==";
    private static final Log log = LogFactory.getLog(ResultSimulationFrame.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JMenu exportMenu;
    protected FisheryRegion fisheryRegion;
    protected ResultHandler handler;
    protected JPanel matrixViewerContainer;
    protected JComboBox resultsComboBox;
    protected SimulationStorage simulationStorage;
    protected TopiaContext topiaContext;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ResultSimulationFrame $JInternalFrame0 = this;
    private JMenuBar $JMenuBar0;
    private Table $Table0;
    private JLabel $JLabel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
        protected void finalize() throws Throwable {
            super.finalize();
            if (topiaContext != null) {
                topiaContext.closeContext();
            }
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ResultSimulationFrame(String param0, boolean param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ResultSimulationFrame(JAXXContext parentContext, String param1, boolean param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ResultSimulationFrame(String param0, boolean param1, boolean param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ResultSimulationFrame(JAXXContext parentContext, String param1, boolean param2, boolean param3, boolean param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ResultSimulationFrame(String param0, boolean param1, boolean param2, boolean param3, boolean param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public ResultSimulationFrame(JAXXContext parentContext, String param1, boolean param2, boolean param3, boolean param4, boolean param5) {
        super(param1 ,param2 ,param3 ,param4 ,param5);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ResultSimulationFrame() {
        $initialize();
    }

    public ResultSimulationFrame(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ResultSimulationFrame(String param0) {
        super(param0);
        $initialize();
    }

    public ResultSimulationFrame(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ResultSimulationFrame(String param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ResultSimulationFrame(JAXXContext parentContext, String param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JMenu getExportMenu() {
        return exportMenu;
    }

    public FisheryRegion getFisheryRegion() {
        return fisheryRegion;
    }

    public ResultHandler getHandler() {
        return handler;
    }

    public JPanel getMatrixViewerContainer() {
        return matrixViewerContainer;
    }

    public JComboBox getResultsComboBox() {
        return resultsComboBox;
    }

    public SimulationStorage getSimulationStorage() {
        return simulationStorage;
    }

    public TopiaContext getTopiaContext() {
        return topiaContext;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setFisheryRegion(FisheryRegion fisheryRegion) {
        FisheryRegion oldValue = this.fisheryRegion;
        this.fisheryRegion = fisheryRegion;
        firePropertyChange(PROPERTY_FISHERY_REGION, oldValue, fisheryRegion);
    }

    public void setSimulationStorage(SimulationStorage simulationStorage) {
        SimulationStorage oldValue = this.simulationStorage;
        this.simulationStorage = simulationStorage;
        firePropertyChange(PROPERTY_SIMULATION_STORAGE, oldValue, simulationStorage);
    }

    public void setTopiaContext(TopiaContext topiaContext) {
        TopiaContext oldValue = this.topiaContext;
        this.topiaContext = topiaContext;
        firePropertyChange(PROPERTY_TOPIA_CONTEXT, oldValue, topiaContext);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JMenuBar get$JMenuBar0() {
        return $JMenuBar0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createExportMenu() {
        $objectMap.put("exportMenu", exportMenu = new JMenu());
        
        exportMenu.setName("exportMenu");
        exportMenu.setText(_("isisfish.result.export"));
    }

    protected void createFisheryRegion() {
        $objectMap.put("fisheryRegion", fisheryRegion = null);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new ResultHandler());
    }

    protected void createMatrixViewerContainer() {
        $objectMap.put("matrixViewerContainer", matrixViewerContainer = new JPanel());
        
        matrixViewerContainer.setName("matrixViewerContainer");
        matrixViewerContainer.setLayout(new BorderLayout());
    }

    protected void createResultsComboBox() {
        $objectMap.put("resultsComboBox", resultsComboBox = new JComboBox());
        
        resultsComboBox.setName("resultsComboBox");
    }

    protected void createSimulationStorage() {
        $objectMap.put("simulationStorage", simulationStorage = null);
    }

    protected void createTopiaContext() {
        $objectMap.put("topiaContext", topiaContext = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JInternalFrame0
        add($Table0);
        $JInternalFrame0.setJMenuBar($JMenuBar0);
        // inline complete setup of $JMenuBar0
        $JMenuBar0.add(exportMenu);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(resultsComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(matrixViewerContainer, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JInternalFrame0", $JInternalFrame0);
        createHandler();
        createSimulationStorage();
        createFisheryRegion();
        createTopiaContext();
        // inline creation of $JMenuBar0
        $objectMap.put("$JMenuBar0", $JMenuBar0 = new JMenuBar());
        
        $JMenuBar0.setName("$JMenuBar0");
        createExportMenu();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("isisfish.result.selectResult"));
        createResultsComboBox();
        createMatrixViewerContainer();
        // inline creation of $JInternalFrame0
        setName("$JInternalFrame0");
        setVisible(true);
        setClosable(true);
        setDefaultCloseOperation(2);
        setClosable(true);
        setIconifiable(true);
        setMaximizable(true);
        setResizable(true);
        
        $JInternalFrame0.pack();
        $completeSetup();
    }

}