/*
 * #%L
 * IsisFish
 * 
 * $Id: SimulationMeta.java 3445 2011-07-15 13:12:45Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.ui.widget.filter.DateInterval;
import fr.ifremer.isisfish.ui.widget.filter.FilterAcceptor;
import fr.ifremer.isisfish.ui.widget.filter.FilterParamModel;
import fr.ifremer.isisfish.ui.widget.filter.ValueGetter;

import static org.nuiton.i18n.I18n._;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * This enum represents all properties on which we can perform search.
 * <p/>
 * Each constant is also used as acceptor for the property it represents (using {@link FilterAcceptor#accept(Object, Object)}
 * and permit to access SimulationProperties values with methods
 * {@link #getValue(SimulationProperties)}
 * and {@link #getDateValue(SimulationProperties)}
 */
public enum SimulationMeta implements ValueGetter<SimulationProperties, Object> {
    // text
    isisFishVersion(String.class),
    description(String.class),
    simulationName(String.class),
    simulatorName(String.class),
    simulationPlanName(String.class),
    regionName(String.class),
    otherInfo(String.class),

    // int
    numberOfYear(Integer.class),
    simulationPlanNumber(Integer.class),

    // date interval
    simulationInterval(DateInterval.class) {
        @Override
        public DateInterval getValue(SimulationProperties sim) {
            return new DateInterval(simulationStart.getDateValue(sim), simulationEnd.getDateValue(sim));
        }
    },

    // date
    simulationStart(Long.class),
    simulationEnd(Long.class),
    exportTime(Long.class),

    // boolean
    useOptimization(Boolean.class),
    useSimulationPlan(Boolean.class),
    useStatistic(Boolean.class),
    usePreScript(Boolean.class),
    onlyExport(Boolean.class),
    local(Boolean.class);

    // others
    //statistic(klazz),
    //optimizationUsage(klazz),
    //exception(klazz);

    private static final Log log = LogFactory.getLog(SimulationMeta.class);

    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    private final Class<?> klazz;

    SimulationMeta(Class<?> klazz) {
        this.klazz = klazz;
    }

    @SuppressWarnings({"unchecked"})
    public FilterParamModel<SimulationProperties, ?> createParamModel() {
        return new FilterParamModel<SimulationProperties, Object>(name(), (Class<Object>) getKlazz(), this);
    }

    public Class<?> getKlazz() {
        return klazz;
    }

    public Object getValue(SimulationProperties sim) {
        return sim.getData().getProperty(name());
    }

    public long getDateValue(SimulationProperties sim) {
        String d = (String) getValue(sim);
        Date result = null;
        if (d != null) {
            try {
                result = dateFormat.parse(d);
            } catch (ParseException eee) {
                if (log.isWarnEnabled()) {
                    log.warn(_("isisfish.error.parse.date", d), eee);
                }
            }
        }
        return result == null ? -1 : result.getTime();
    }
}
