/*
 * #%L
 * $Id: PopulationMaturityOgiveEquation.java 3507 2011-10-28 13:47:33Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/isis-fish/tags/isis-fish-4.2.0.0/src/main/java/fr/ifremer/isisfish/equation/PopulationMaturityOgiveEquation.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.equation;

import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.Args;

/**
 * Population's maturity ogive equation.
 * 
 * @author chatellier
 * @version $Revision: 3507 $
 * 
 * Last update : $Date: 2011-10-28 15:47:33 +0200 (Fri, 28 Oct 2011) $
 * By : $Author: echatellier $
 */
public interface PopulationMaturityOgiveEquation {

    /**
     * Compute maturity ogive.
     * 
     * @param context simulation context
     * @param group le groupe dont on souhaite avoir l'ogive de maturité
     * @return l'ogive de maturite
     * @throws Exception 
     */
    @Args({"context", "group"})
    public double compute(SimulationContext context, PopulationGroup group) throws Exception;
}
