/*
 * #%L
 * $Id: StepComponent.java 3507 2011-10-28 13:47:33Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/isis-fish/tags/isis-fish-4.1.0.3/src/main/java/fr/ifremer/isisfish/ui/widget/editor/StepComponent.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.widget.editor;

import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JComboBox;
import javax.swing.JPanel;

/**
 * Component used to edit TimeStep.
 * 
 * @author chatellier
 * @version $Revision: 3507 $
 * 
 * Last update : $Date: 2011-10-28 15:47:33 +0200 (Fri, 28 Oct 2011) $
 * By : $Author: echatellier $
 */
public class StepComponent extends JPanel {

    private static final long serialVersionUID = -6694461572642939712L;

    protected JComboBox mounth;

    protected JComboBox year;

    public StepComponent(int mounth, int year) {
        super(new GridLayout(0, 2));

        this.mounth = MonthComponent.createMounthCombo(mounth);
        this.year = createYearCombo(200, year);

        this.add(this.mounth);
        this.add(this.year);
    }

    public JComboBox getYearCombo() {
        return year;
    }

    public JComboBox getMounthCombo() {
        return mounth;
    }

    public int getSelectedMounth() {
        return mounth.getSelectedIndex();
    }

    public int getSelectedYear() {
        return year.getSelectedIndex();
    }

    public void setSelectedValue(int year, int mounth) {
        this.mounth.setSelectedIndex(mounth);
        this.year.setSelectedIndex(year);
    }

    public int getSelectedValue() {
        int selectedYear = getSelectedYear();
        int selectedMounth = getSelectedMounth();
        return selectedMounth + selectedYear * 12;
    }

    public static JComboBox createYearCombo(int nb, int selectedYear) {
        List<Integer> listI = new ArrayList<Integer>();
        for (int i = 0; i < nb; i++) {
            listI.add(i);
        }
        JComboBox year = new JComboBox(listI.toArray());
        listI.clear();
        year.setSelectedIndex(selectedYear);
        return year;
    }
}
