package fr.ifremer.isisfish.ui.widget.editor;
/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableCellEditor;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableCellRenderer;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class ScriptParameterDialog extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_OK_ACTION = "okAction";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TPW8TQRBdm9iJE0IggZCIRAQIBRKcoSVRvhWFyIEIU0S4Ye3b2Bv2bpfdOXw0iJ/AT4CeBomOClFQU9Ag/gJCFLSI2TvnnAuXxC7urJl5b97MvXn3kxSMJlf2aBg6OvCBe8zZXN7ZeVDfYw1YY6ahuQKpSfzL5Um+RobcJG6AXKtVLLzcgZdXpaekz/wD6LkKGTTwQjDTYgyATKcRDWPK1SQ9F6pA77MmorJY3/z+lX/tvnqbJyRUqG4AR5k5CdWdpK9C8twFMoqdntOyoH4TZWjuN1HvsI2tCmrMfeqxZ+Ql6a+QoqIayYBc7X3kiCPChwpIaXZzjVMhm7eB3N3VDt/VzGP4NtzsctNyAu60udtk4DCXI49TjQi3qUYZwHSMViqiLAIZkE+XG8ClD+SclezYMZwVKQWjfresf/YRrQuGXSdSCzJtHNeJcraylACGZzexsxRim/oWdtGSh536AylbPpKgzpu02i3pMgFk8YhJPZs2TkN6nvQPT2oiVRGDOrJBVIOfMKUuGWc0weHeVwIA6eMoY6niOJweI6m+YwPTnaQml1K7Q9s6Xdt2fZWrkYIOMIzLrv3v9IeYij0+ccjjljDK/h0f+/bxx4f1fWMXsfeFzNIDd4mGU1oqpoHb1iOxqwPgorxF1VyNlAwTeNTR0U5lCKt20igO+8VusnBng5oWUhT6v3/6PP7k6ymSXyeDQlJ3ndr6e6QELY1bkMIN1eJSpOh0ewCfZ602IAX80BR9MDrPfcF9NkMB76weAFsIcQ9TGXtIxNRLX/6MVd8v7e8ih9omjyzv7qPwmBTjbtGZdy4486yHlGGBK7uXmnW7OfseVB0rXo+eNzKHBQ6x/W6GgX3dilTbf+XeSbz4cs7MuxToTJ37Lrp1IZtwsgfCkpbtDcabLThGWS9EfcDC4zimTuSw4dVjGC4jwz8F0a9DmQYAAA==";
    private static final Log log = LogFactory.getLog(ScriptParameterDialog.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean okAction;
    protected ScriptParametersTableModel scriptParameterModel;
    protected JTable scriptParameterTable;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ScriptParameterDialog $JDialog0 = this;
    private Table $Table0;
    private JScrollPane $JScrollPane0;
    private JButton $JButton0;
    private JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    /**
         * Test if isis configuration allow auto configuration, and display
         * configuration frame (with only table model).
         * 
         * @param parent parent component
         * @param script script to configure
         * @return configured script, or {@code null} if user cancel configuration
         */
        public static Object displayConfigurationFrame(JAXXContext context, Object script) {
    
            Object result = script;
    
            if (!IsisFish.config.isScriptAutoconfig()) {
                if (log.isDebugEnabled()) {
                    log.debug("Script auto configuration turned off");
                }
            } else {
                // display modal frame
                ScriptParameterDialog dialog = new ScriptParameterDialog(context);
                dialog.setLocationRelativeTo((Component)context); // screen center
                dialog.getScriptParameterModel().setScript(script);
    
                // param list can be empty
                if (dialog.getScriptParameterModel().getRowCount() > 0) {
                    dialog.getScriptParameterTable().getColumnModel().getColumn(0).setCellRenderer(new ScriptParametersTableCellRenderer(script));
                    ScriptParametersTableCellEditor cellEditor = new ScriptParametersTableCellEditor(script);
                    cellEditor.setRegionStorage(context.getContextValue(RegionStorage.class));
                    dialog.getScriptParameterTable().getColumnModel().getColumn(1).setCellEditor(cellEditor);
                    dialog.setVisible(true); // blocking
                    if (!dialog.getOkAction()) {
                        result = null;
                    }
                }
            }
            return result;
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ScriptParameterDialog(Window param0) {
        super(param0);
        $initialize();
    }

    public ScriptParameterDialog(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ScriptParameterDialog(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ScriptParameterDialog(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ScriptParameterDialog(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ScriptParameterDialog(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ScriptParameterDialog(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ScriptParameterDialog(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ScriptParameterDialog(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ScriptParameterDialog(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ScriptParameterDialog(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ScriptParameterDialog(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ScriptParameterDialog(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ScriptParameterDialog(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ScriptParameterDialog(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ScriptParameterDialog(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ScriptParameterDialog(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ScriptParameterDialog(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ScriptParameterDialog(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ScriptParameterDialog(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ScriptParameterDialog(Frame param0) {
        super(param0);
        $initialize();
    }

    public ScriptParameterDialog(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ScriptParameterDialog() {
        $initialize();
    }

    public ScriptParameterDialog(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ScriptParameterDialog(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ScriptParameterDialog(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ScriptParameterDialog(Dialog param0) {
        super(param0);
        $initialize();
    }

    public ScriptParameterDialog(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ScriptParameterDialog(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ScriptParameterDialog(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ScriptParameterDialog(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ScriptParameterDialog(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        okAction = true; dispose();
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        okAction = false; dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getOkAction() {
        return okAction;
    }

    public ScriptParametersTableModel getScriptParameterModel() {
        return scriptParameterModel;
    }

    public JTable getScriptParameterTable() {
        return scriptParameterTable;
    }

    public Boolean isOkAction() {
        return okAction !=null && okAction;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setOkAction(Boolean okAction) {
        Boolean oldValue = this.okAction;
        this.okAction = okAction;
        firePropertyChange(PROPERTY_OK_ACTION, oldValue, okAction);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createOkAction() {
        $objectMap.put("okAction", okAction = false);
    }

    protected void createScriptParameterModel() {
        $objectMap.put("scriptParameterModel", scriptParameterModel = new ScriptParametersTableModel());
    }

    protected void createScriptParameterTable() {
        $objectMap.put("scriptParameterTable", scriptParameterTable = new JTable());
        
        scriptParameterTable.setName("scriptParameterTable");
        scriptParameterTable.setRowHeight(24);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 0, 2, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(scriptParameterTable);
        
        // apply 1 property setters
        scriptParameterTable.setModel(scriptParameterModel);
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JDialog0", $JDialog0);
        createOkAction();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createScriptParameterModel();
        createScriptParameterTable();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("isisfish.common.ok"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("isisfish.common.cancel"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JDialog0
        setName("$JDialog0");
        setModal(true);
        setTitle(_("isisfish.simulation.script.autoconfigtitle"));
        
        $completeSetup();
    }

}