/*
 * #%L
 * IsisFish
 * 
 * $Id: EquationDomainListModel.java 3331 2011-05-16 14:53:00Z chatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/isis-fish/tags/isis-fish-4.1.0.3/src/main/java/fr/ifremer/isisfish/ui/sensitivity/equation/EquationDomainListModel.java $
 * %%
 * Copyright (C) 2011 Ifremer, CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.sensitivity.equation;

import java.util.List;

import javax.swing.DefaultListModel;

import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationContinuousDomain;

/**
 * Model pour la liste des {@link EquationContinuousDomain}.
 * 
 * Pas de selection par defaut.
 *
 * @author chatellier
 * @version $Revision: 3331 $
 * 
 * Last update : $Date: 2011-05-16 16:53:00 +0200 (Mon, 16 May 2011) $
 * By : $Author: chatellier $
 */
public class EquationDomainListModel extends DefaultListModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 2281927104735245489L;

    /** EquationContinuousDomain list */
    protected List<EquationContinuousDomain> domains;

    /**
     * Constructor with domains list.
     * 
     * @param domains domains list
     */
    public EquationDomainListModel(List<EquationContinuousDomain> domains) {
        this.domains = domains;
    }

    /**
     * Change data list and fire data change event.
     * 
     * @param domains new data list
     */
    public void setDomains(List<EquationContinuousDomain> domains) {
        this.domains = domains;
        fireContentsChanged(this, 0, domains.size());
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Object getElementAt(int index) {
        return domains.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (domains != null) {
            size = domains.size();
        }
        return size;
    }
}
