package fr.ifremer.isisfish.ui.sensitivity;
/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class DefaultContinuousPanelUI extends ContinuousPanelContainerUI {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_PERCENTAGE_TYPE_FACTOR = "percentageTypeFactor";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COEFFICIENT_FIELD_ENABLED = "coefficientField.enabled";
    public static final String BINDING_CONTINUE_MAX_ENABLED = "continueMax.enabled";
    public static final String BINDING_CONTINUE_MIN_ENABLED = "continueMin.enabled";
    public static final String BINDING_REFERENCE_VALUE_FIELD_ENABLED = "referenceValueField.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";
    private static final String BINDING_$JRADIO_BUTTON0_SELECTED = "$JRadioButton0.selected";
    private static final String BINDING_$JRADIO_BUTTON1_SELECTED = "$JRadioButton1.selected";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUS2/TQBDehr5b+qZQ2orSFlGEcNpy4BCgTyIapYBoiyoiJDb2pNnKtc3uunUviJ/AT4A7FyRunBAHzhy4IP4CQhy4Imbt1IlLaiySw9qZme+bb8Y78+Y7aRGcXNylnqdx15JsD7Tc0vb2/eIu6HIVhM6ZI21Ogl9TiqQKpMsI7UKSqUJewdMVeHrF3nNsC6wadCZPOoU8NEGUAaQk41GELkR6I3RnPMflR6yhqHqsr37+SL00XrxOEeI5qK4fS5n4F6paSXOepJghyQBm2qdpk1o7KIMzawf1nla2FZMKcY/uwTPynLTlSatDOZJJMpm8ZJ/Dx3uOJGPTKzZiLNd2xQNqgan+UmYB31qblSRT4horcdgDfAomSkyUNZdpAizBJNtn8lBbhRJ1TXmMZ2vNcfw0rZIMOcB1VEN3YPPQgSzVUZAk/aokTZWpLdu2CdSqQtp0pPNLG1BRniYOsA9azueuCZvepEUTUOm5SJ+DaN+nIntDQM907iE1mL3sSmlbAa6GvsanAAMn4OaU9Ww0orvMDJXPV6hs/VF/RaoPHVLH+dDVPp3L0yKYs8er9a0qaCyMHeRQAvzoOjyipgtZBiZemeEIbBM86Tui0KM0voSJqK9Pt6FUYjrDnofQqWhMpYL5mArmQ+qZ0NelBzcD1pkVss78Bb0eC6VeLZST0cjnxoHVqgNbnaimAmnhLprxOxf+nvGH6Aqm+9yx6VaEvvf38OCX99/eZY9GehBzn6kbWrORcNQcbuOll0yl7g3m2ZXMTK9TJ1MgHQJM0IN1NVZH2EbFjeIwXzAnCq7dpaKMFC1tXz98HH76+RRJZUmnaVMjmKk10iHLHLtgm4bnLCz6iroP2vHsU9qw20FmwDvTc9Ogkk4UmWXgrbntYRvG6rQh1FLs+PRrcOPt4lErmlDayInh1Xa0PCatzDJxp/j7rbK66u6zLkeAa9jVFVVvaTWp57BTWQI3/DNTr9ZmiXOAI3UzyD5BJS7ToisBa1WgBb8I9baUkFOZb6njBIaRRAx31JH9XwZJWk16aLsyRsdoEpaizQ3gMSzjCVjawFI7wYihudBwU5IxPInRMNkww6WGq0jGEKfhciKG7RiGKw1ruNpwH5IxxGm41jBDuuEqkjHEaZhDhj/Arp1D8AoAAA==";
    private static final Log log = LogFactory.getLog(DefaultContinuousPanelUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTextField coefficientField;
    protected JTextField continueMax;
    protected JTextField continueMin;
    protected JPanel hidablePanel;
    protected Boolean percentageTypeFactor;
    protected JTextField referenceValueField;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private DefaultContinuousPanelUI $ContinuousPanelContainerUI0 = this;
    private Table $Table0;
    private JRadioButton $JRadioButton0;
    private JRadioButton $JRadioButton1;
    private Table $Table1;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private Table $Table2;
    private JLabel $JLabel2;
    private JLabel $JLabel3;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init(String min, String max, String referenceValue, String coefficient) {
        continueMin.setText(min);
        continueMax.setText(max);
        referenceValueField.setText(referenceValue);
        coefficientField.setText(coefficient);
    }
    
    public void initExisting(String min, String max, String referenceValue, String coefficient) {
        init(min, max, referenceValue, coefficient);
        setPercentageTypeFactor(StringUtils.isNotBlank(coefficient));
    }
    
    @Override
    public boolean isFactorValid() {
        boolean valid = false;
        
        try {
            if (continueSelected) {
                if (percentageTypeFactor) {
                    Double coefficient = Double.parseDouble(coefficientField.getText().trim());
                    Double referenceValue = Double.parseDouble(referenceValueField.getText().trim());
                    valid = coefficient != null && referenceValue != null;
                }
                else {
                    Double minValue = Double.parseDouble(continueMin.getText().trim());
                    Double maxValue = Double.parseDouble(continueMax.getText().trim());
                    valid = minValue != null && maxValue != null;
                }
            }
            else {
                valid = true;
            }
        }
        catch (NumberFormatException eee) {
            if (log.isWarnEnabled()) {
                log.warn("Double parse error", eee);
            }
        }
        
        return valid;
    }
    
    protected void $afterCompleteSetup() {
        addPropertyChangeListener(PROPERTY_PERCENTAGE_TYPE_FACTOR, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ((Boolean)evt.getNewValue()) {
                    ((CardLayout) hidablePanel.getLayout()).show(hidablePanel, "percentageType");
                } else {
                    ((CardLayout) hidablePanel.getLayout()).show(hidablePanel, "minMaxType");
                }
            }
        });
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DefaultContinuousPanelUI() {
        $initialize();
    }

    public DefaultContinuousPanelUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public DefaultContinuousPanelUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public DefaultContinuousPanelUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DefaultContinuousPanelUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DefaultContinuousPanelUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DefaultContinuousPanelUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DefaultContinuousPanelUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JRadioButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setPercentageTypeFactor(true);
    }

    public void doActionPerformed__on__$JRadioButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setPercentageTypeFactor(false);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTextField getCoefficientField() {
        return coefficientField;
    }

    public JTextField getContinueMax() {
        return continueMax;
    }

    public JTextField getContinueMin() {
        return continueMin;
    }

    public JPanel getHidablePanel() {
        return hidablePanel;
    }

    public Boolean getPercentageTypeFactor() {
        return percentageTypeFactor;
    }

    public JTextField getReferenceValueField() {
        return referenceValueField;
    }

    public Boolean isPercentageTypeFactor() {
        return percentageTypeFactor !=null && percentageTypeFactor;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setPercentageTypeFactor(Boolean percentageTypeFactor) {
        Boolean oldValue = this.percentageTypeFactor;
        this.percentageTypeFactor = percentageTypeFactor;
        firePropertyChange(PROPERTY_PERCENTAGE_TYPE_FACTOR, oldValue, percentageTypeFactor);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JRadioButton get$JRadioButton0() {
        return $JRadioButton0;
    }

    protected JRadioButton get$JRadioButton1() {
        return $JRadioButton1;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToContent() {
        if (!allComponentsCreated) {
            return;
        }
        content.add($Table0, BorderLayout.CENTER);
    }

    protected void addChildrenToHidablePanel() {
        if (!allComponentsCreated) {
            return;
        }
        hidablePanel.add($Table1, "percentageType");
        hidablePanel.add($Table2, "minMaxType");
    }

    protected void createCoefficientField() {
        $objectMap.put("coefficientField", coefficientField = new JTextField());
        
        coefficientField.setName("coefficientField");
        coefficientField.setColumns(15);
    }

    @Override
    protected void createContent() {
        super.createContent();
        content.setName("content");
    }

    protected void createContinueMax() {
        $objectMap.put("continueMax", continueMax = new JTextField());
        
        continueMax.setName("continueMax");
        continueMax.setColumns(15);
    }

    protected void createContinueMin() {
        $objectMap.put("continueMin", continueMin = new JTextField());
        
        continueMin.setName("continueMin");
        continueMin.setColumns(15);
    }

    protected void createHidablePanel() {
        $objectMap.put("hidablePanel", hidablePanel = new JPanel());
        
        hidablePanel.setName("hidablePanel");
        hidablePanel.setLayout(new CardLayout());
    }

    protected void createPercentageTypeFactor() {
        $objectMap.put("percentageTypeFactor", percentageTypeFactor = true);
    }

    protected void createReferenceValueField() {
        $objectMap.put("referenceValueField", referenceValueField = new JTextField());
        
        referenceValueField.setName("referenceValueField");
        referenceValueField.setColumns(15);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToContent();
        // inline complete setup of $Table0
        $Table0.add($JRadioButton0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JRadioButton1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(hidablePanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToHidablePanel();
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(referenceValueField, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(coefficientField, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table2
        $Table2.add($JLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(continueMin, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(continueMax, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 10 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        $Table1.setBorder(BorderFactory.createTitledBorder(""));
        $Table2.setBorder(BorderFactory.createTitledBorder(""));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$ContinuousPanelContainerUI0", $ContinuousPanelContainerUI0);
        createPercentageTypeFactor();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JRadioButton0
        $objectMap.put("$JRadioButton0", $JRadioButton0 = new JRadioButton());
        
        $JRadioButton0.setName("$JRadioButton0");
        $JRadioButton0.setText(_("isisfish.sensitivity.continuouspercentagetype"));
        $JRadioButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JRadioButton0"));
        // inline creation of $JRadioButton1
        $objectMap.put("$JRadioButton1", $JRadioButton1 = new JRadioButton());
        
        $JRadioButton1.setName("$JRadioButton1");
        $JRadioButton1.setText(_("isisfish.sensitivity.continuousminmaxtype"));
        $JRadioButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JRadioButton1"));
        createHidablePanel();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("isisfish.sensitivity.referencevalue"));
        createReferenceValueField();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("isisfish.sensitivity.coefficient"));
        createCoefficientField();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.sensitivity.firstValue"));
        createContinueMin();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.sensitivity.lastValue"));
        createContinueMax();
        // inline creation of $ContinuousPanelContainerUI0
        setName("$ContinuousPanelContainerUI0");
        
        // registers 10 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 10 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JRADIO_BUTTON0_SELECTED, true ,"percentageTypeFactor") {
        
            @Override
            public void processDataBinding() {
                $JRadioButton0.setSelected(isPercentageTypeFactor());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JRADIO_BUTTON1_SELECTED, true ,"percentageTypeFactor") {
        
            @Override
            public void processDataBinding() {
                $JRadioButton1.setSelected(!isPercentageTypeFactor());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"percentageTypeFactor") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isPercentageTypeFactor());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REFERENCE_VALUE_FIELD_ENABLED, true ,"percentageTypeFactor") {
        
            @Override
            public void processDataBinding() {
                referenceValueField.setEnabled(isPercentageTypeFactor());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"percentageTypeFactor") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isPercentageTypeFactor());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COEFFICIENT_FIELD_ENABLED, true ,"percentageTypeFactor") {
        
            @Override
            public void processDataBinding() {
                coefficientField.setEnabled(isPercentageTypeFactor());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"percentageTypeFactor") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(!isPercentageTypeFactor());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CONTINUE_MIN_ENABLED, true ,"percentageTypeFactor") {
        
            @Override
            public void processDataBinding() {
                continueMin.setEnabled(!isPercentageTypeFactor());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL3_ENABLED, true ,"percentageTypeFactor") {
        
            @Override
            public void processDataBinding() {
                $JLabel3.setEnabled(!isPercentageTypeFactor());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CONTINUE_MAX_ENABLED, true ,"percentageTypeFactor") {
        
            @Override
            public void processDataBinding() {
                continueMax.setEnabled(!isPercentageTypeFactor());
            }
        });
    }

}