/*
 * #%L
 * IsisFish
 * 
 * $Id: TopiaEntityListModel.java 3671 2012-04-03 13:31:36Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/isis-fish/tags/isis-fish-4.1.0.3/src/main/java/fr/ifremer/isisfish/ui/input/model/TopiaEntityListModel.java $
 * %%
 * Copyright (C) 2009 - 2011 Ifremer, CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.input.model;

import java.util.List;

import javax.swing.DefaultListModel;

import org.nuiton.topia.persistence.TopiaEntity;

/**
 * Model pour la liste des {@link TopiaEntity}.
 * 
 * Pas de selection par defaut.
 *
 * @author chatellier
 * @version $Revision: 3671 $
 * 
 * Last update : $Date: 2012-04-03 15:31:36 +0200 (Tue, 03 Apr 2012) $
 * By : $Author: echatellier $
 */
public class TopiaEntityListModel extends DefaultListModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6171850179969290032L;

    /** Zones list */
    protected List<? extends TopiaEntity> entities;

    public TopiaEntityListModel() {
        
    }

    /**
     * Constructor with entities list.
     * 
     * @param entities entities list
     */
    public TopiaEntityListModel(List<? extends TopiaEntity> entities) {
        this();
        this.entities = entities;
    }

    /**
     * Update model entities list.
     * 
     * @param entities entities
     */
    public void setEntities(List<? extends TopiaEntity> entities) {
        this.entities = entities;
        fireContentsChanged(this, 0, entities == null ? 0 : entities.size() - 1);
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Object getElementAt(int index) {
        return entities.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (entities != null) {
            size = entities.size();
        }
        return size;
    }

    /**
     * Return elements in model.
     * 
     * @return elements in model
     */
    public List<? extends TopiaEntity> getElements() {
        return entities;
    }
}
