package fr.ifremer.isisfish.ui.input;
/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.SetOfVessels;
import java.awt.LayoutManager;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class SetOfVesselsUI extends InputContentUI<fr.ifremer.isisfish.entities.SetOfVessels> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EFFORT_DESCRIPTION_UI_ACTIVE = "effortDescriptionUI.active";
    public static final String BINDING_EFFORT_DESCRIPTION_UI_BEAN = "effortDescriptionUI.bean";
    public static final String BINDING_EFFORT_DESCRIPTION_UI_SENSITIVITY = "effortDescriptionUI.sensitivity";
    public static final String BINDING_EFFORT_PARAMETERS_UI_ACTIVE = "effortParametersUI.active";
    public static final String BINDING_EFFORT_PARAMETERS_UI_BEAN = "effortParametersUI.bean";
    public static final String BINDING_EFFORT_PARAMETERS_UI_SENSITIVITY = "effortParametersUI.sensitivity";
    public static final String BINDING_SET_OF_VESSELS_BASICS_UI_ACTIVE = "setOfVesselsBasicsUI.active";
    public static final String BINDING_SET_OF_VESSELS_BASICS_UI_BEAN = "setOfVesselsBasicsUI.bean";
    public static final String BINDING_SET_OF_VESSELS_BASICS_UI_SENSITIVITY = "setOfVesselsBasicsUI.sensitivity";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWUz08TQRTHXystFlQQFEExQeWiJlsgHoz4A0WJJVWIFUPsxWl3lg7Zzo4zs7BcjH+Cf4LevZh482Q8ePbgxfgvGOPBq/HNtt12Za017WGnmfe+n3nvzbz3+htklIQz2yQILOlzzerUWr25ublW2aZVfZuqqmRCexIav1Qa0mUYtqN9peFcuWjk+aY8v+zVhccp71AvFmFI6T2XqhqlWsPpuKKqVL4UmRcD4csWNQoqifryx/f0C/v5qzRAIDC6IUxl5l+qdiYDRUgzW8MYnrRD8i7hWxiGZHwL4z1s9pZdotR9UqdP4RkMFiEriESYhrO9pxwyQn0gNIzOFrjw9bLHNbpvFOY0XHSkxRxJ6xRXxZTDVM3ymcWMo1Wies15RJWirtooCBGishoGKpRwDeeTxEhmmlEVE3dKPXsP0zYZBpbaxYSt1XXCqdv2GVEd0oekouFEzB23KtQ2IiMYiXTHOnW3iGJVjFrDfM85tjSGNxZhx6njeDIqL/O4oc51pd7ZL4lDxxrQdSLxhjWVYaRX/o/ZKY7Tc7NYowJ3PLzik7FH2Shh0yr2C+bNxkyCYaFlkHAqRsQGstoN1H7hqTJkpI/bGibL+3vuAZoa3Tb5R7cZYGj9NTH++d3XtyutFsvh2ccTXTsmBD59IT1BpXmE+JYa/eVr5ubvEbFYRgp1cbyE42M6IbBS04zB4XlHjdwycusuUTVEZAa/vP8w8eTTAUivwJDrEXuFGP8C5HRNYhU81w7EjaUwokO7B/E7amLTkEU/toM1OnLVJprMVBi38TauB1iE6YQiRJFUch9/jpfeLLUKkcLApv7q3i5G5jFkGXcZp+G0aQ6SxOkyLBT1ba89MJJGSMqsE6L5Oi6EXysp03BAGOt84JtlIQza/LvUM2NYUa5wlOwwvdcXymzPdSFM9US43DfhWt+EbllM951Fb4RuWRjCb1nAOGfWBwAA";
    private static final Log log = LogFactory.getLog(SetOfVesselsUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected SetOfVessels bean;
    protected EffortDescriptionUI effortDescriptionUI;
    protected EffortDescriptionParametersUI effortParametersUI;
    protected SetOfVesselsBasicsUI setOfVesselsBasicsUI;
    protected JTabbedPane setOfVesselsTab;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SetOfVesselsUI $InputContentUI0 = this;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;
    private TabInfo $TabInfo2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
        setButtonTitle(_("isisfish.input.continueStrategies"));
        setNextPath(n_("isisfish.input.tree.strategies"));
    
        // install change listener
        // (depends on sensitivity can't be done on constructor)
        installChangeListener(setOfVesselsTab);
    }
    
    /*public void refresh() {
        getSaveVerifier().addCurrentPanel(setOfVesselsBasicsUI, effortDescriptionUI, effortParametersUI);
    }*/
    
    @Override
    public void setLayer(boolean active) {
        super.setLayer(active);
        setOfVesselsBasicsUI.setLayer(active);
        effortDescriptionUI.setLayer(active);
        effortParametersUI.setLayer(active);
    }
    
    @Override
    public void resetChangeModel() {
        setOfVesselsBasicsUI.resetChangeModel();
        effortDescriptionUI.resetChangeModel();
        effortParametersUI.resetChangeModel();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SetOfVesselsUI() {
        $initialize();
    }

    public SetOfVesselsUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public SetOfVesselsUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SetOfVesselsUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SetOfVesselsUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SetOfVesselsUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SetOfVesselsUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SetOfVesselsUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public SetOfVessels getBean() {
        return bean;
    }

    public EffortDescriptionUI getEffortDescriptionUI() {
        return effortDescriptionUI;
    }

    public EffortDescriptionParametersUI getEffortParametersUI() {
        return effortParametersUI;
    }

    public SetOfVesselsBasicsUI getSetOfVesselsBasicsUI() {
        return setOfVesselsBasicsUI;
    }

    public JTabbedPane getSetOfVesselsTab() {
        return setOfVesselsTab;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(SetOfVessels bean) {
        SetOfVessels oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(setOfVesselsTab);
    }

    protected void addChildrenToSetOfVesselsTab() {
        if (!allComponentsCreated) {
            return;
        }
        setOfVesselsTab.add(setOfVesselsBasicsUI);
        setOfVesselsTab.add(effortDescriptionUI);
        setOfVesselsTab.add(effortParametersUI);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener(setOfVesselsTab, 0));
        setOfVesselsTab.setTitleAt(0, _("isisfish.setOfVessels.title"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener(setOfVesselsTab, 1));
        setOfVesselsTab.setTitleAt(1, _("isisfish.effortDescription.title"));
        $TabInfo2.addPropertyChangeListener(new TabInfoPropertyChangeListener(setOfVesselsTab, 2));
        setOfVesselsTab.setTitleAt(2, _("isisfish.effortDescription.parametersTitle"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createEffortDescriptionUI() {
        $objectMap.put("effortDescriptionUI", effortDescriptionUI = new EffortDescriptionUI(this));
        
        effortDescriptionUI.setName("effortDescriptionUI");
    }

    protected void createEffortParametersUI() {
        $objectMap.put("effortParametersUI", effortParametersUI = new EffortDescriptionParametersUI(this));
        
        effortParametersUI.setName("effortParametersUI");
    }

    protected void createSetOfVesselsBasicsUI() {
        $objectMap.put("setOfVesselsBasicsUI", setOfVesselsBasicsUI = new SetOfVesselsBasicsUI(this));
        
        setOfVesselsBasicsUI.setName("setOfVesselsBasicsUI");
    }

    protected void createSetOfVesselsTab() {
        $objectMap.put("setOfVesselsTab", setOfVesselsTab = new JTabbedPane());
        
        setOfVesselsTab.setName("setOfVesselsTab");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        addChildrenToSetOfVesselsTab();
        
        // apply 9 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createSetOfVesselsTab();
        createSetOfVesselsBasicsUI();
        createEffortDescriptionUI();
        createEffortParametersUI();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(_("isisfish.setOfVessels.title"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(_("isisfish.effortDescription.title"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new TabInfo());
        
        $TabInfo2.setTitle(_("isisfish.effortDescription.parametersTitle"));
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 9 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 9 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SET_OF_VESSELS_BASICS_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                setOfVesselsBasicsUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SET_OF_VESSELS_BASICS_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                setOfVesselsBasicsUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SET_OF_VESSELS_BASICS_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                setOfVesselsBasicsUI.setSensitivity(isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EFFORT_DESCRIPTION_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                effortDescriptionUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EFFORT_DESCRIPTION_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                effortDescriptionUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EFFORT_DESCRIPTION_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                effortDescriptionUI.setSensitivity(isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EFFORT_PARAMETERS_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                effortParametersUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EFFORT_PARAMETERS_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                effortParametersUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EFFORT_PARAMETERS_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                effortParametersUI.setSensitivity(isSensitivity());
            }
        });
    }

}