package fr.ifremer.isisfish.ui.input;
/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.Selectivity;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.ui.input.model.GearPopulationSelectivityModel;
import fr.ifremer.isisfish.ui.input.model.PopulationComboModel;
import fr.ifremer.isisfish.ui.widget.editor.EquationTableEditor;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class SelectivityUI extends InputContentUI<Gear> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_POPULATION = "population";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_SELECTIVITY_BUTTON_ENABLED = "addSelectivityButton.enabled";
    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CHANGE_MODEL_CHANGED = "changeModel.changed";
    public static final String BINDING_CHANGE_MODEL_VALID = "changeModel.valid";
    public static final String BINDING_FIELD_SELECTIVITY_POPULATION_ENABLED = "fieldSelectivityPopulation.enabled";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_SELECTIVITY_EQUATION_ACTIVE = "selectivityEquation.active";
    public static final String BINDING_SELECTIVITY_EQUATION_BEAN = "selectivityEquation.bean";
    public static final String BINDING_SELECTIVITY_TABLE_ENABLED = "selectivityTable.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz28TRxSemNjBSSkhCUkoP5SAJRBB63BBiCCaYhpiy5SoJijgC2PvOB403pnMzDobDqh/Qv+Ecu+lUm89VT303EMvVf+Fquqh16pvdu39kZhlhXPYdea975vvfW/m7fd/obySaPU19jxLuo6mPWLVvtjbe9p6Tdr6EVFtSYXmEgV/EzmUa6IZO1xXGl1r1g28PICXK7wnuEOcGHqjjqaVPmJEdQnRGl1OItpKlRtheMMTrhyyhqJGsX73z9+5b+1v3uUQ8gSom4NSVj6EiiqZrKMctTWag536uMywsw8yJHX2Qe8Zs1ZhWKmvcI8coLdoqo4KAksg0+hq9pJ9Dh/vCY1mS1VHuLrCHQ3pu9V1jW52pEU7kvQIvBVVHaq6lkstahKtBmHQCNqn+mi3KoTPVNBoskWwo9HqKCwQU02Jsh4TLCPItODCZVhT2BtdTwXuhJkRvNjHjNoYStNoLWFyGLDUIZhnNczz+XAxYphpd8Fi8oTbhGl0I7XsSpQaL5rbR9Av0xpvsFltBzvxnKnSM9xiBHxdTogMsv2YyVw+Drht/r1sHhfD0OlSrY5bhK0f39NfNUlXwtzPOpQwO9atnZjb5xNoOC0t/pB7SYJ5FWG/PHAHyHKqS/5ZeuqQYf5uNcm5gO24pIeu1oZ0PiEnWE0Cz5RqjbbkjBl3ofylBCIKJVGzsRJ8U4/7Ftp/K5JYqlOlByK543ccNrwSx53MiPq9BN7wPjlRpQmvJeVNKtwn4XrU5kIbO+2gn8OIRBcTpwcmlBVNqGiETDRRXrqwDMeteXKofQ2hYJwtHxtnhtCP/rc4//tPf/64NZxhC7D3+ZGpsREMs0VILog0t1Wjs8EAczVl5SdYbDRRMeiEP58vjRDWGIRBHOx3zsAtA7e2seoCRX7qj59/WXz12ymU20LTjGN7C5v8KirqrgQXOLM98fmmr+iTw9PwnDXa4DoFlxzG6qf34f7jlRZ1bGjiAw9cuDTChVBKq/jrv/ONHzaHTkyAsgvvTY/cyL9EBeow6hB/ng9G9cj5PSMUcW0ejeRRQ3rCvBfF4Iht+s9Ho0rN+4PPhB97rnlt+6rNr1pmkinimEuRRrOagWZSEw++S3P3AydWsIYPWcvV5MHHcprlRoqqUgZVBWzuJElhuZ6lNvOtG5Mj32b4zZsxSc52uOzBTaxgTfa5PDKJLz6Wzizvjc2Q1qGbY2vIxpCmYT2DrUXJD7cJ3e/qFCkfJgqlvIfhzth2ZGNIs+Pu2BqyMaRpuDe2BsPwPwTcvf46DAAA";
    private static final Log log = LogFactory.getLog(SelectivityUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addSelectivityButton;
    protected Gear bean;
    protected JButton cancel;
    protected ChangeModel changeModel;
    protected JComboBox fieldSelectivityPopulation;
    protected Population population;
    protected JButton removeSelectivityButton;
    protected JButton save;
    protected InputOneEquationUI selectivityEquation;
    protected JTable selectivityTable;
    @Validator( validatorId = "validator")
    protected SwingValidator<Gear> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SelectivityUI $InputContentUI0 = this;
    private Table $Table0;
    private Table $Table1;
    private JLabel $JLabel0;
    private JScrollPane $JScrollPane0;
    private ListSelectionModel $ListSelectionModel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
        addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    setPopulation(null);
                    selectivityTable.setModel(new GearPopulationSelectivityModel());
                }
                if (evt.getNewValue() != null) {
                    refresh();
                }
            }
        });
    }
    
    @Override
    public void resetChangeModel() {
        changeModel.setStayChanged(false);
    }
    
    public void refresh() {
    
        Gear gear = (Gear)getSaveVerifier().getEntity(Gear.class);
    
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        //setBean(null);
        //setBean(gear);
    
        if (getBean() != null) {
            setSelectivityTableModel();
            fieldSelectivityPopulation.setModel(getSelectivityPopulationModel());
        }
    }
    
    protected void setSelectivityTableModel() {
        
        java.util.List<Selectivity> selectivitiesList = new ArrayList<Selectivity>();
        
        // set model even if no selectivity
        // to clear data
        if (getBean().getPopulationSelectivity() != null) {
            // move collection to list
            // and add all entity to verifier
            for (Selectivity oneSelectivity : getBean().getPopulationSelectivity()) {
                getSaveVerifier().addCurrentEntity(oneSelectivity);
                selectivitiesList.add(oneSelectivity);
    
                // hack to enable save button :(
                oneSelectivity.addPropertyChangeListener(new PropertyChangeListener() {
                    public void propertyChange(PropertyChangeEvent evt) {
                        changeModel.setStayChanged(true);
                    }
                });
            }
        }
    
        // set table model
        GearPopulationSelectivityModel model = new GearPopulationSelectivityModel(selectivitiesList);
        selectivityTable.setModel(model);
        selectivityTable.setDefaultRenderer(Equation.class, model);
        selectivityTable.setDefaultEditor(Equation.class, new EquationTableEditor());
    }
    
    protected void addSelectivity() {
        getAction().addSelectivity(getPopulation(), selectivityEquation.getEditor().getText(), getBean());
        setSelectivityTableModel();
    }
    
    protected void removeSelectivity() {
        GearPopulationSelectivityModel model = (GearPopulationSelectivityModel)selectivityTable.getModel();
        Selectivity selectedSelectivity = model.getSelectivities().get(selectivityTable.getSelectedRow());
        getAction().removeSelectivity(getBean(), selectedSelectivity);
        getSaveVerifier().removeCurrentEntity(selectedSelectivity.getTopiaId());
        setSelectivityTableModel();
        removeSelectivityButton.setEnabled(false);
    }
    
    protected DefaultComboBoxModel getSelectivityPopulationModel() {
        java.util.List<Species> species = getFisheryRegion().getSpecies();
        java.util.List<Population> populations = new ArrayList<Population>();
        if (species != null) {
            for (Species s : species) {
                if (s.getPopulation() != null) {
                    populations.addAll(s.getPopulation());
                }
            }
        }
        PopulationComboModel selectivityPopulationModel = new PopulationComboModel(populations);
        return selectivityPopulationModel;
    }
    
    protected void selectivityChanged() {
        setPopulation((Population)fieldSelectivityPopulation.getSelectedItem());
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectivityUI() {
        $initialize();
    }

    public SelectivityUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public SelectivityUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SelectivityUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectivityUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SelectivityUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectivityUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectivityUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addSelectivityButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        addSelectivity();
    }

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__removeSelectivityButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        removeSelectivity();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);changeModel.setStayChanged(false);
    }

    public void doItemStateChanged__on__fieldSelectivityPopulation(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        selectivityChanged();
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        removeSelectivityButton.setEnabled(isActive() && selectivityTable.getSelectedRow() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddSelectivityButton() {
        return addSelectivityButton;
    }

    public Gear getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public ChangeModel getChangeModel() {
        return changeModel;
    }

    public JComboBox getFieldSelectivityPopulation() {
        return fieldSelectivityPopulation;
    }

    public Population getPopulation() {
        return population;
    }

    public JButton getRemoveSelectivityButton() {
        return removeSelectivityButton;
    }

    public JButton getSave() {
        return save;
    }

    public InputOneEquationUI getSelectivityEquation() {
        return selectivityEquation;
    }

    public JTable getSelectivityTable() {
        return selectivityTable;
    }

    public SwingValidator<Gear> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Gear bean) {
        Gear oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setPopulation(Population population) {
        Population oldValue = this.population;
        this.population = population;
        firePropertyChange(PROPERTY_POPULATION, oldValue, population);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createAddSelectivityButton() {
        $objectMap.put("addSelectivityButton", addSelectivityButton = new JButton());
        
        addSelectivityButton.setName("addSelectivityButton");
        addSelectivityButton.setText(_("isisfish.common.add"));
        addSelectivityButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addSelectivityButton"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(_("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createChangeModel() {
        $objectMap.put("changeModel", changeModel = new ChangeModel());
    }

    protected void createFieldSelectivityPopulation() {
        $objectMap.put("fieldSelectivityPopulation", fieldSelectivityPopulation = new JComboBox());
        
        fieldSelectivityPopulation.setName("fieldSelectivityPopulation");
        fieldSelectivityPopulation.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldSelectivityPopulation"));
    }

    protected void createPopulation() {
        $objectMap.put("population", population = null);
    }

    protected void createRemoveSelectivityButton() {
        $objectMap.put("removeSelectivityButton", removeSelectivityButton = new JButton());
        
        removeSelectivityButton.setName("removeSelectivityButton");
        removeSelectivityButton.setEnabled(false);
        removeSelectivityButton.setText(_("isisfish.common.remove"));
        removeSelectivityButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeSelectivityButton"));
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(_("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createSelectivityEquation() {
        $objectMap.put("selectivityEquation", selectivityEquation = new InputOneEquationUI(this));
        
        selectivityEquation.setName("selectivityEquation");
        selectivityEquation.setFormuleCategory("Selectivity");
        selectivityEquation.setText(_("isisfish.selectivity.equation"));
    }

    protected void createSelectivityTable() {
        $objectMap.put("selectivityTable", selectivityTable = new JTable());
        
        selectivityTable.setName("selectivityTable");
        selectivityTable.setRowHeight(24);
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidatorUtil.newValidator(Gear.class, "selectivity"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(SwingUtil.boxComponentWithJxLayer($JLabel0), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldSelectivityPopulation), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(selectivityEquation), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(addSelectivityButton), new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane0, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(removeSelectivityButton), new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(selectivityTable));
        
        // apply 11 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        selectivityEquation.setClazz(fr.ifremer.isisfish.equation.SelectivityEquation.class);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createPopulation();
        createValidator();
        createChangeModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("isisfish.selectivity.selectPopulation"));
        createFieldSelectivityPopulation();
        createSelectivityEquation();
        createAddSelectivityButton();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createSelectivityTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = selectivityTable.getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        createRemoveSelectivityButton();
        createSave();
        createCancel();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 11 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 11 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_CHANGED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    changeModel.setChanged(validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_VALID, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    changeModel.setValid(validator.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SELECTIVITY_POPULATION_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldSelectivityPopulation.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTIVITY_EQUATION_ACTIVE, true ,"population") {
        
            @Override
            public void processDataBinding() {
                selectivityEquation.setActive(getPopulation() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTIVITY_EQUATION_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                selectivityEquation.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADD_SELECTIVITY_BUTTON_ENABLED, true ,"population") {
        
            @Override
            public void processDataBinding() {
                addSelectivityButton.setEnabled(getPopulation() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTIVITY_TABLE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                selectivityTable.setEnabled(isActive());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("valid", this);
                }
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    save.setEnabled(changeModel.isValid() && changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("valid", this);
                }
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    cancel.setEnabled(changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
    }

}