package fr.ifremer.isisfish.ui.input;
/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.types.RangeOfValues;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.JAXXComboBox;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RangeOfValuesUI extends InputContentUI<Gear> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_FIELD_GEAR_PARAM_POSSIBLE_VALUE_ENABLED = "fieldGearParamPossibleValue.enabled";
    public static final String BINDING_FIELD_GEAR_PARAM_POSSIBLE_VALUE_TEXT = "fieldGearParamPossibleValue.text";
    public static final String BINDING_FIELD_GEAR_PARAM_TYPE_ENABLED = "fieldGearParamType.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TTU9TQRS9LZQK+IEQCASMIETj19Q9RlFMtaQKoWCI3Tjtm9Ih03njzDx5uDD+BH+C7t2YuHNlXLh24cb4F4xx4dZ4Z1r6qDyDXcxr5t5z7rln7n3zHXJGw9wOjWOiI2l5i5GVW1tbq7UdVrd3mKlrrmyoof3LZCFbheGge28szFfLDl7owAvLYUuFkskD6MUyDBm7J5hpMmYtnOlF1I0pVLrhxVhFep+1KyqN9dXPH9mXwYvXWYBYobo8tjJ7FCrppL8MWR5YGMVKT2lBULmNMjSX26j3hLtbFtSYB7TFnsBzyJdhQFGNZBbO/X/LnsPjY2VhZKEkVWSXQ2kxfbN0zcKVhia8oVmL4ddw0+CmSSJOuEsk66iKrTYeUhExs1lSynMNWOivMSotzKWhkZpbzgy5y6hOIGMLFa+uJDFKBX/GNNY/7x2rYwtcIEm7AXIo82DlMNhD25xDMTG7aBhZWaOSiSQnv7BBa4Ih/WTPg7SzfcxljnYBow3OROD0rlFNWxt7ilk4m4J104l+18LbYeyw412K6V6KtdAYjnW8dRYmeuRusNgWXXqHQsN0Ty0cSZKMZDIzmSrkdITX2Fj18BSvY6g9v5N/za8j9NHfE2Nf3n97V9wf2j6sPZ6aemDncJiUDhXT7lUtnGpPbGS5KNynarEKg4YJXFi/kDMpwiqdMIrDeqcdnDg4uUdNEyly+a8fPk48/twH2SIMiZAGRerySzBomxpdCEUQq5tLXtHx3WN4jjht+NJMutfEPTp5PaCWzta4DNDjGzG6MJPiQldKbfDTr7HK26V9JzKobOqf6YkbuUcwwKXgkvkF7uxm6sIOK8OiIEx2MG0rM+47pTrDO+/PC4dbddcX3XEpjtznspfs/l31sZkjGXB1LM7dERx/APu1E7qUBQAA";
    private static final Log log = LogFactory.getLog(RangeOfValuesUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Gear bean;
    protected JTextField fieldGearParamPossibleValue;
    protected JAXXComboBox fieldGearParamType;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private RangeOfValuesUI $InputContentUI0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    boolean init;
    
    
    protected void $afterCompleteSetup() {
        addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    fieldGearParamPossibleValue.setText("");
                }
                if (evt.getNewValue() != null) {
                    java.util.List<Object> values = new ArrayList<Object>();
                    for (String value : RangeOfValues.getPossibleTypes()) {
                        values.add(value);
                    }
              
                    init = true;
                    jaxx.runtime.SwingUtil.fillComboBox(fieldGearParamType, values, getBean().getPossibleValue() == null ? null : getBean().getPossibleValue().getType(), true);
                    init = false;
                }
            }
        });
    }
    
    /*public void refresh() {
        Gear gear = getSaveVerifier().getEntity(Gear.class);
        
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        setBean(null);
        setBean(gear);
        
        if (getBean() != null) {
            java.util.List<Object> values = new ArrayList<Object>();
            for (String value : RangeOfValues.getPossibleTypes()) {
                values.add(value);
            }
      
            init = true;
            jaxx.runtime.SwingUtil.fillComboBox(fieldGearParamType, values, getBean().getPossibleValue() == null ? null : getBean().getPossibleValue().getType(), true);
            init = false;
        }
    }*/
    
    protected void gearParamChanged() {
        if (fieldGearParamType.getSelectedItem() != null && !init) {
            getBean().setPossibleValue(new RangeOfValues(fieldGearParamType.getSelectedItem().toString().concat("[" + fieldGearParamPossibleValue.getText() + "]")));
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public RangeOfValuesUI() {
        $initialize();
    }

    public RangeOfValuesUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public RangeOfValuesUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public RangeOfValuesUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public RangeOfValuesUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public RangeOfValuesUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public RangeOfValuesUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public RangeOfValuesUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__fieldGearParamType(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        gearParamChanged();
    }

    public void doKeyReleased__on__fieldGearParamPossibleValue(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        gearParamChanged();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Gear getBean() {
        return bean;
    }

    public JTextField getFieldGearParamPossibleValue() {
        return fieldGearParamPossibleValue;
    }

    public JAXXComboBox getFieldGearParamType() {
        return fieldGearParamType;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Gear bean) {
        Gear oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createFieldGearParamPossibleValue() {
        $objectMap.put("fieldGearParamPossibleValue", fieldGearParamPossibleValue = new JTextField());
        
        fieldGearParamPossibleValue.setName("fieldGearParamPossibleValue");
        fieldGearParamPossibleValue.setColumns(15);
        fieldGearParamPossibleValue.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldGearParamPossibleValue"));
    }

    protected void createFieldGearParamType() {
        $objectMap.put("fieldGearParamType", fieldGearParamType = new JAXXComboBox());
        
        fieldGearParamType.setName("fieldGearParamType");
        fieldGearParamType.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldGearParamType"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add(fieldGearParamType, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldGearParamPossibleValue, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        init = false;
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createFieldGearParamType();
        createFieldGearParamPossibleValue();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_GEAR_PARAM_TYPE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldGearParamType.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_GEAR_PARAM_POSSIBLE_VALUE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldGearParamPossibleValue.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_GEAR_PARAM_POSSIBLE_VALUE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null && getBean().getPossibleValue() != null) {
                    SwingUtil.setText(fieldGearParamPossibleValue, getBean().getPossibleValue() == null ? "" : getBean().getPossibleValue().getValues());
                }
            }
        });
    }

}