package fr.ifremer.isisfish.ui.input;
/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.ui.input.model.EffortDescriptionListModel;
import fr.ifremer.isisfish.ui.input.model.MetierListModel;
import fr.ifremer.isisfish.ui.input.renderer.EffortDescriptionListRenderer;
import fr.ifremer.isisfish.ui.input.renderer.MetierListRenderer;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class EffortDescriptionUI extends InputContentUI<SetOfVessels> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_EFFORT_DESCRIPTION_LIST_ENABLED = "fieldEffortDescriptionEffortDescriptionList.enabled";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_METIER_LIST_ENABLED = "fieldEffortDescriptionMetierList.enabled";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVVz08TQRSeVlosPwQhICLECsSoJFtMjBohCKIESBFDhRB7cdqd0iHT2XVmtiwX45/gn6B3LybePBkPnj14Mf4LxnjwanyzbXe7dsXGRg6z5P343ve+mff66itKSIEuHGDXNYTDFa0QY2N5b2+rcECK6i6RRUFtZQlU+4vFUTyPek3fLhWazmd1eqaenlmxKrbFCW/Kns+iHqmOGJFlQpRCk+GMopSZnO+ed21HNFB9UlGoL75/iz83n72MI+TawK4fWkn/LSvopCuL4tRUaAgqVXGGYb4PNATl+8C3X9tWGJbyPq6QJ+gp6s6ipI0FgCk01X7LHoaX79oKDc6sc9tRKxZXEL6zPqfQXEkYtCRIhcBXUlmismw41KA60LhXKlnCx6UW31m3bQ8vqVBXgWCu0OUoBICnihJp5IjaKu0SKQmTQWqqihk1MTBVaDakme8w5CFoYeT0udswNhe3zCNQTwvl1mM3HmBOWBDTPfMQFxiBLsdCNWrRnk9HDvkJ/TMbuaKwGNNAkHYmhB64dPiIn5UuUcLMFqk2CQggslTCjZ0OAWmbzh3zIcYLjlIWb8FYNuGFDIeS73iRYQaToL5VJS3pQWw6nBBq9Ko2jocDZqN7ajE0WpnUx3RwOxJXSUTdZBHzImHNHoHOhS4HxtEIxjGYl1geJYQDZrjNfOsEb4OrNrtjv82uBvS8P0eHP7398ma1MbADUHskMrRp38Ag2cKyidCvWaGB2rQ6irLMJrbn8ygFLxuWlbeMJiKI5epuIAf1vIdg6HRjDcsyQCS6P797P/r44wkUX0U9zMLmKtbx6yilygJUsJjp2reXPEZ9hyfhHNTcFOoDJdk24SYRQA+dWoARwekC5SY8lEUXpJiIkMLnU0h9+DGce73UkCMG9M7+MTyQJPEIJSlnlBNvg9WXU+TG6rUlcUwrWEJRaymmvxN2fWznvPNaVL/dhOuR9SrecB39uenx1v/dahsmUbHM2hPsAKS/dut6zAGtIzBtXoRNtlATNY0V/ArAPiCL0Yjn26DXpYjrzeXmv2J4rI5BmGoLYbtjhOvHaHux/S46Qlj7rxwudaxkewjHcbjSMQeN8Atn49Na0AkAAA==";
    private static final Log log = LogFactory.getLog(EffortDescriptionUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected SetOfVessels bean;
    protected JButton buttonEffortDescriptionAdd;
    protected JButton cancel;
    protected JList fieldEffortDescriptionEffortDescriptionList;
    protected JList fieldEffortDescriptionMetierList;
    protected JButton removeEffortDescriptionButton;
    protected JButton save;
    @Validator( validatorId = "validator")
    protected SwingValidator<SetOfVessels> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private EffortDescriptionUI $InputContentUI0 = this;
    private Table $Table0;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    /**
     * Get input action from context.
     */
    protected InputAction getInputAction() {
        return getContextValue(InputAction.class);
    }
    
    protected void $afterCompleteSetup() {
        addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                MetierListModel metierModel = (MetierListModel)fieldEffortDescriptionMetierList.getModel();
                if (evt.getNewValue() == null) {
                    metierModel.setMetiers(null);
                }
                if (evt.getNewValue() != null) {
                    metierModel.setMetiers(getFisheryRegion().getMetier());
                    setEffortDescriptionEffortDescriptionList();
                }
            }
        });
    }
    
    /*public void refresh() {
        SetOfVessels setOfVessels = getSaveVerifier().getEntity(SetOfVessels.class);
        
        // twice event for jaxx bindings detection
        setBean(null);
        setBean(setOfVessels);
    }*/
    
    protected void onFieldEffortDescriptionMetierListValueChanged() {
        // active le bouton seulement si l'interface est active
        // dans le cas de sensitivity par exemple
        if (isActive()) {
            buttonEffortDescriptionAdd.setEnabled(fieldEffortDescriptionMetierList.getSelectedIndex() != -1);
        }
    }
    
    protected void onFieldEffortDescriptionEffortDescriptionListValueChanged() {
        // active le bouton seulement si l'interface est active
        // dans le cas de sensitivity par exemple
        if (isActive()) {
            removeEffortDescriptionButton.setEnabled(fieldEffortDescriptionEffortDescriptionList.getSelectedIndex() != -1);
        }
    }
    
    protected void setEffortDescriptionEffortDescriptionList() {
        EffortDescriptionListModel model = new EffortDescriptionListModel();
        if (getBean() != null && getBean().getPossibleMetiers() != null) {
            java.util.List<EffortDescription> effortDescriptions = new ArrayList<EffortDescription>(getBean().getPossibleMetiers());
            model.setEffortDescriptions(effortDescriptions);
        }
        fieldEffortDescriptionEffortDescriptionList.setModel(model);
    }
    
    protected void addEffortDescriptions() {
         Object[] selectedValues = (Object[])fieldEffortDescriptionMetierList.getSelectedValues();
         for (Object selectedValue : selectedValues) {
            Metier selectedMetier = (Metier)selectedValue;
            getInputAction().addEffortDescription(getBean(), selectedMetier);
         }
         setEffortDescriptionEffortDescriptionList();
    }
    protected void removeEffortDescriptions() {
         Object[] selectedValues = (Object[])fieldEffortDescriptionEffortDescriptionList.getSelectedValues();
         for (Object selectedValue : selectedValues) {
            EffortDescription selectedEffortDescription = (EffortDescription)selectedValue;
            getInputAction().removeEffortDescription(getBean(), selectedEffortDescription);
         }
         setEffortDescriptionEffortDescriptionList();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EffortDescriptionUI() {
        $initialize();
    }

    public EffortDescriptionUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public EffortDescriptionUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EffortDescriptionUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EffortDescriptionUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EffortDescriptionUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EffortDescriptionUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EffortDescriptionUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__buttonEffortDescriptionAdd(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        addEffortDescriptions();
    }

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__removeEffortDescriptionButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        removeEffortDescriptions();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);
    }

    public void doValueChanged__on__fieldEffortDescriptionEffortDescriptionList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        onFieldEffortDescriptionEffortDescriptionListValueChanged();
    }

    public void doValueChanged__on__fieldEffortDescriptionMetierList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        onFieldEffortDescriptionMetierListValueChanged();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public SetOfVessels getBean() {
        return bean;
    }

    public JButton getButtonEffortDescriptionAdd() {
        return buttonEffortDescriptionAdd;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JList getFieldEffortDescriptionEffortDescriptionList() {
        return fieldEffortDescriptionEffortDescriptionList;
    }

    public JList getFieldEffortDescriptionMetierList() {
        return fieldEffortDescriptionMetierList;
    }

    public JButton getRemoveEffortDescriptionButton() {
        return removeEffortDescriptionButton;
    }

    public JButton getSave() {
        return save;
    }

    public SwingValidator<SetOfVessels> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(SetOfVessels bean) {
        SetOfVessels oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createButtonEffortDescriptionAdd() {
        $objectMap.put("buttonEffortDescriptionAdd", buttonEffortDescriptionAdd = new JButton());
        
        buttonEffortDescriptionAdd.setName("buttonEffortDescriptionAdd");
        buttonEffortDescriptionAdd.setEnabled(false);
        buttonEffortDescriptionAdd.setText(_("isisfish.common.add"));
        buttonEffortDescriptionAdd.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonEffortDescriptionAdd"));
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(_("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createFieldEffortDescriptionEffortDescriptionList() {
        $objectMap.put("fieldEffortDescriptionEffortDescriptionList", fieldEffortDescriptionEffortDescriptionList = new JList());
        
        fieldEffortDescriptionEffortDescriptionList.setName("fieldEffortDescriptionEffortDescriptionList");
        fieldEffortDescriptionEffortDescriptionList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__fieldEffortDescriptionEffortDescriptionList"));
    }

    protected void createFieldEffortDescriptionMetierList() {
        $objectMap.put("fieldEffortDescriptionMetierList", fieldEffortDescriptionMetierList = new JList());
        
        fieldEffortDescriptionMetierList.setName("fieldEffortDescriptionMetierList");
        fieldEffortDescriptionMetierList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__fieldEffortDescriptionMetierList"));
    }

    protected void createRemoveEffortDescriptionButton() {
        $objectMap.put("removeEffortDescriptionButton", removeEffortDescriptionButton = new JButton());
        
        removeEffortDescriptionButton.setName("removeEffortDescriptionButton");
        removeEffortDescriptionButton.setEnabled(false);
        removeEffortDescriptionButton.setText(_("isisfish.common.remove"));
        removeEffortDescriptionButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeEffortDescriptionButton"));
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(_("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidatorUtil.newValidator(SetOfVessels.class, "effortdescription"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(buttonEffortDescriptionAdd), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(removeEffortDescriptionButton), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane1, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 3, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 3, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionMetierList));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionEffortDescriptionList));
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        fieldEffortDescriptionMetierList.setCellRenderer(new MetierListRenderer());
        fieldEffortDescriptionMetierList.setModel(new MetierListModel());
        fieldEffortDescriptionMetierList.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        fieldEffortDescriptionEffortDescriptionList.setCellRenderer(new EffortDescriptionListRenderer());
        fieldEffortDescriptionEffortDescriptionList.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createValidator();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldEffortDescriptionMetierList();
        createButtonEffortDescriptionAdd();
        createRemoveEffortDescriptionButton();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createFieldEffortDescriptionEffortDescriptionList();
        createSave();
        createCancel();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_METIER_LIST_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldEffortDescriptionMetierList.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_EFFORT_DESCRIPTION_LIST_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldEffortDescriptionEffortDescriptionList.setEnabled(isActive());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    save.setEnabled(validator.isValid() && validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    cancel.setEnabled(validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
    }

}