/*
 * #%L
 * 
 * 
 * $Id: RConfigHandler.java 3534 2011-11-21 10:21:00Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/isis-fish/tags/isis-fish-4.1.0.3/src/main/java/fr/ifremer/isisfish/ui/config/RConfigHandler.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.config;

import static org.nuiton.i18n.I18n._;

import java.awt.Color;
import java.io.File;

import javax.swing.JOptionPane;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.j2r.REngine;
import org.nuiton.j2r.RException;
import org.nuiton.j2r.RProxy;

/**
 * Handler for R Configuration UI.
 * 
 * @author chatellier
 * @version $Revision: 3534 $
 * 
 * Last update : $Date: 2011-11-21 11:21:00 +0100 (Mon, 21 Nov 2011) $
 * By : $Author: echatellier $
 */
public class RConfigHandler {

    private static Log log = LogFactory.getLog(RConfigHandler.class);

    /**
     * Initialise l'ui.
     * 
     * @param rconfigUI ui to init
     */
    public void init(RConfigUI rconfigUI) {
        String rHome = System.getenv("R_HOME");
        rconfigUI.getRHomeField().setText(rHome);
        if (StringUtils.isBlank(rHome)) {
            rconfigUI.getRHomeField().setBackground(Color.RED);
        }
        
        String rType = System.getProperty("R.type");
        rconfigUI.getRTypeField().setText(rType);
        if (!"net".equals(rType) && !"jni".equals(rType)) {
            rconfigUI.getRTypeField().setBackground(Color.RED);
        }
        
        // sur windows c'est potentielement ca
        // sur linux, c'est pas possible
        String systemPath = System.getenv("PATH");
        String rBinPath = rHome + File.separator + "bin";
        if (systemPath.contains(rBinPath)) {
            rconfigUI.getSystemPathField().setText(_("isisfish.simulator.configuration.r.systempathok", rBinPath));
        }
        else {
            rconfigUI.getSystemPathField().setBackground(Color.RED);
            rconfigUI.getSystemPathField().setText(_("isisfish.simulator.configuration.r.systempathnok", rBinPath));
        }
        rconfigUI.getSystemPathField().setToolTipText(systemPath);
    }

    /**
     * Test r configuration.
     * 
     * @param rconfigUI
     */
    public void testRCOnfiguration(RConfigUI rconfigUI) {
        REngine engine = null;
        try {
            engine = new RProxy();
            
            boolean error = false;
            try {
                engine.eval("library('lhs')");
            }
            catch (RException ex) {
                if (log.isWarnEnabled()) {
                    log.warn("Can find 'lhs'", ex);
                }
                JOptionPane.showMessageDialog(rconfigUI, _("isisfish.simulator.configuration.r.lhsnotinstalled"),
                        _("isisfish.simulator.configuration.r.title"), JOptionPane.ERROR_MESSAGE);
                error = true;
            }
            try {
                engine.eval("library('sensitivity')");
            }
            catch (RException ex) {
                if (log.isWarnEnabled()) {
                    log.warn("Can find 'sensitivity'", ex);
                }
                JOptionPane.showMessageDialog(rconfigUI, _("isisfish.simulator.configuration.r.sensitivitynotinstalled"),
                        _("isisfish.simulator.configuration.r.title"), JOptionPane.ERROR_MESSAGE);
                error = true;
            }
            
            if (!error) {
                JOptionPane.showMessageDialog(rconfigUI, _("isisfish.simulator.configuration.r.testok"),
                        _("isisfish.simulator.configuration.r.title"), JOptionPane.INFORMATION_MESSAGE);
            }
        }
        catch (RException ex) {
            if (log.isWarnEnabled()) {
                log.warn("Can find call R", ex);
            }
            JOptionPane.showMessageDialog(rconfigUI, _("isisfish.simulator.configuration.r.cantinit", ex.getMessage()),
                    _("isisfish.simulator.configuration.r.title"), JOptionPane.ERROR_MESSAGE);
        }
    }
}
