package fr.ifremer.isisfish.ui;
/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.ui.input.InputAction;
import fr.ifremer.isisfish.ui.input.InputSaveVerifier;
import fr.ifremer.isisfish.ui.input.InputUI;
import fr.ifremer.isisfish.ui.queue.QueueUI;
import fr.ifremer.isisfish.ui.result.ResultUI;
import fr.ifremer.isisfish.ui.script.ScriptUI;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityInputHandler;
import fr.ifremer.isisfish.ui.sensitivity.SensitivitySaveVerifier;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityUI;
import fr.ifremer.isisfish.ui.simulator.SimulAction;
import fr.ifremer.isisfish.ui.simulator.SimulUI;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class WelcomeTabUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1Uy24TMRR1BpI26YNHRSlQpEIjxMopFIREeBQVVaQKUBoqKrLByTiNK2fGtT3tdIP4BD4B9myQ2LFCLFizYIP4BYRYsEVce5JM084AWYwj33POPb72vW++o6yS6NwmCUMsA0+zDsXLd9bXHzY2aVPfpaopmdC+RNEv4yCnjkbc/r7SaLZeNfRSl15a9DvC96i3h12uooLSu5yqNqVao7ODjKZSpVo/XA5FIHuqfVNJqq9+/nBeui9eOwiFAtyNw1Fm/sWKT3K4ihzmanQcMm2TEifeBtiQzNsAv2Nmb5ETpR6QDt1Cz9FQFeUEkSCm0fn/P7LVsPxQaDRcXF4hHuVzULeWxKwlaYfCqphqMdXGAcNPKG/6HfqYNNYqQlhqTqO8Yp2AwyZU/KTxFmK1A1bxMuw1qGtUDTTfZwwxTwR6raJRMSWTBeBKBDOs0Zhs0xnyxRSyBRA4Ka5F0EGBMUU9xTTbZnrXyMylycQwXNtLGZQrFFepCjj4hMpdSNGSFoJ7yP0KNXs1f1WIbg/3kIMK+eKjgAbUCqSVdMsgcBe3nw43VfFaPtBPD7zS6CK7UXGQcMlszCYELqcF5tMCV9ICV3sBic4MmIPmxHFzxt2TqaOsDGBbo6n6wX5ehVDUyVP7OtkI2ujvyYkv77+9W+q1rwO5TyRC90wfaCshfUGlZib1kah3A8146T4R5To0CuUwuuxomk4wVuuGwRzkO2bo2NDxPaLaIJEd+vrh4+Szz4eQs4QK3CfuEjH4CsrrNrywts/dUNxesI5Gd4bhe9R40yjHya4fwHQYv+ESTWYazHPhYm+FUITphCL0nTTyn35N1N4u9AqRAWOnUuFxMbJPUY55nHnUTrLukEqcXCNC0cD142GUNJ4yZi2I7uuYt99rSScd1aSxwkkTnr+nDep6GJilbM2bfzet1hho/QFTFSXtYwYAAA==";
    private static final Log log = LogFactory.getLog(WelcomeTabUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected InputUI inputUI;
    protected SensitivityUI sensitivityUI;
    protected JTabbedPane simulTabs;
    protected SimulUI simulUI;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private WelcomeTabUI $JPanel0 = this;
    private ResultUI $ResultUI0;
    private ScriptUI $ScriptUI0;
    private QueueUI $QueueUI0;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;
    private TabInfo $TabInfo2;
    private TabInfo $TabInfo3;
    private TabInfo $TabInfo4;
    private TabInfo $TabInfo5;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    /** Change tab selection. */
            public void setQueueTabSelection() {
                simulTabs.setSelectedIndex(5);
            }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public WelcomeTabUI() {
        $initialize();
    }

    public WelcomeTabUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public WelcomeTabUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public WelcomeTabUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public WelcomeTabUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public WelcomeTabUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public WelcomeTabUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public WelcomeTabUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public InputUI getInputUI() {
        return inputUI;
    }

    public SensitivityUI getSensitivityUI() {
        return sensitivityUI;
    }

    public JTabbedPane getSimulTabs() {
        return simulTabs;
    }

    public SimulUI getSimulUI() {
        return simulUI;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected ResultUI get$ResultUI0() {
        return $ResultUI0;
    }

    protected ScriptUI get$ScriptUI0() {
        return $ScriptUI0;
    }

    protected QueueUI get$QueueUI0() {
        return $QueueUI0;
    }

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    protected TabInfo get$TabInfo3() {
        return $TabInfo3;
    }

    protected TabInfo get$TabInfo4() {
        return $TabInfo4;
    }

    protected TabInfo get$TabInfo5() {
        return $TabInfo5;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSimulTabs() {
        if (!allComponentsCreated) {
            return;
        }
        simulTabs.add(inputUI);
        simulTabs.add(simulUI);
        simulTabs.add(sensitivityUI);
        simulTabs.add($ResultUI0);
        simulTabs.add($ScriptUI0);
        simulTabs.add($QueueUI0);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener(simulTabs, 0));
        simulTabs.setTitleAt(0, _(""));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener(simulTabs, 1));
        simulTabs.setTitleAt(1, _(""));
        $TabInfo2.addPropertyChangeListener(new TabInfoPropertyChangeListener(simulTabs, 2));
        simulTabs.setTitleAt(2, _(""));
        $TabInfo3.addPropertyChangeListener(new TabInfoPropertyChangeListener(simulTabs, 3));
        simulTabs.setTitleAt(3, _(""));
        $TabInfo4.addPropertyChangeListener(new TabInfoPropertyChangeListener(simulTabs, 4));
        simulTabs.setTitleAt(4, _(""));
        $TabInfo5.addPropertyChangeListener(new TabInfoPropertyChangeListener(simulTabs, 5));
        simulTabs.setTitleAt(5, _(""));
    }

    protected void createInputUI() {
        $objectMap.put("inputUI", inputUI = new InputUI(new JAXXInitialContext().add(getContextValue(WelcomeSaveVerifier.class)).add(new InputAction()).add(new InputSaveVerifier())));
        
        inputUI.setName("inputUI");
    }

    protected void createSensitivityUI() {
        $objectMap.put("sensitivityUI", sensitivityUI = new SensitivityUI(new JAXXInitialContext().add(new InputAction()).add(new SensitivitySaveVerifier()).add(new SimulAction()).add(new SensitivityInputHandler()).add(this)));
        
        sensitivityUI.setName("sensitivityUI");
    }

    protected void createSimulTabs() {
        $objectMap.put("simulTabs", simulTabs = new JTabbedPane());
        
        simulTabs.setName("simulTabs");
    }

    protected void createSimulUI() {
        $objectMap.put("simulUI", simulUI = new SimulUI(new JAXXInitialContext().add(new SimulAction()).add(this)));
        
        simulUI.setName("simulUI");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(simulTabs, BorderLayout.CENTER);
        addChildrenToSimulTabs();
        
        // apply 8 property setters
        simulTabs.setTabPlacement(JTabbedPane.LEFT);
        $TabInfo0.setIcon(new ImageIcon(getClass().getResource("/images/book.gif")));
        $TabInfo1.setIcon(new ImageIcon(getClass().getResource("/images/simulation.gif")));
        $TabInfo2.setIcon(new ImageIcon(getClass().getResource("/images/sensitivities.gif")));
        $TabInfo3.setIcon(new ImageIcon(getClass().getResource("/images/calc.gif")));
        $TabInfo4.setIcon(new ImageIcon(getClass().getResource("/images/bookPage.gif")));
        $TabInfo5.setIcon(new ImageIcon(getClass().getResource("/images/Queue.gif")));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createSimulTabs();
        createInputUI();
        createSimulUI();
        createSensitivityUI();
        // inline creation of $ResultUI0
        $objectMap.put("$ResultUI0", $ResultUI0 = new ResultUI());
        
        $ResultUI0.setName("$ResultUI0");
        // inline creation of $ScriptUI0
        $objectMap.put("$ScriptUI0", $ScriptUI0 = new ScriptUI());
        
        $ScriptUI0.setName("$ScriptUI0");
        // inline creation of $QueueUI0
        $objectMap.put("$QueueUI0", $QueueUI0 = new QueueUI());
        
        $QueueUI0.setName("$QueueUI0");
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(_(""));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(_(""));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new TabInfo());
        
        $TabInfo2.setTitle(_(""));
        // inline creation of $TabInfo3
        $objectMap.put("$TabInfo3", $TabInfo3 = new TabInfo());
        
        $TabInfo3.setTitle(_(""));
        // inline creation of $TabInfo4
        $objectMap.put("$TabInfo4", $TabInfo4 = new TabInfo());
        
        $TabInfo4.setTitle(_(""));
        // inline creation of $TabInfo5
        $objectMap.put("$TabInfo5", $TabInfo5 = new TabInfo());
        
        $TabInfo5.setTitle(_(""));
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        /*public void refresh() {
                    simulUI.refresh();
                    sensitivityUI.refresh();
                }*/;$completeSetup();
    }

}