/*
 * #%L
 * IsisFish
 * 
 * $Id: RuleDiscreteDomainXMLVisitor.java 3393 2011-06-14 17:43:37Z chatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/isis-fish/tags/isis-fish-4.1.0.3/src/main/java/fr/ifremer/isisfish/mexico/xml/RuleDiscreteDomainXMLVisitor.java $
 * %%
 * Copyright (C) 2011 Ifremer, CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.mexico.xml;

import java.util.List;

import fr.ifremer.isisfish.mexico.MexicoHelper;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.simulator.sensitivity.Domain;

/**
 * XML rule domain visitor.
 *
 * @author chatellier
 * @version $Revision: 3393 $
 * 
 * Last update : $Date: 2011-06-14 19:43:37 +0200 (Tue, 14 Jun 2011) $
 * By : $Author: chatellier $
 */
public class RuleDiscreteDomainXMLVisitor extends DiscreteDomainXMLVisitor {

    /**
     * {@inheritDoc}
     */
    @Override
    public void visit(Domain domain, Object label, Object value) {
        List<Rule> rulesList = (List<Rule>)value;
        String rulesAsXml = MexicoHelper.getRulesAsXml(rulesList);

        xmlBuffer.append("<value>");
        xmlBuffer.append(rulesAsXml);
        xmlBuffer.append("</value>");
    }
}
