package fr.ifremer.isisfish.entities;
/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.types.Month;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.persistence.TopiaEntityContextable;

public interface StrategyMonthInfo extends TopiaEntityContextable {

    String PROPERTY_MONTH = "month";

    String PROPERTY_MIN_INACTIVITY_DAYS = "minInactivityDays";

    String PROPERTY_NUMBER_OF_TRIPS = "numberOfTrips";

    String PROPERTY_PROPORTION_METIER = "proportionMetier";

    String PROPERTY_TRIP_TYPE = "tripType";

    String PROPERTY_STRATEGY = "strategy";

    void setMonth(Month month);

    Month getMonth();

    void setMinInactivityDays(double minInactivityDays);

    double getMinInactivityDays();

    void setNumberOfTrips(double numberOfTrips);

    double getNumberOfTrips();

    void setProportionMetier(MatrixND proportionMetier);

    MatrixND getProportionMetier();

    void setTripType(TripType tripType);

    TripType getTripType();

    void setStrategy(Strategy strategy);

    Strategy getStrategy();

    FisheryRegion getFisheryRegion();

    double getProportionMetier(Metier metier);

    void setProportionMetier(Metier metier, double prop);

} //StrategyMonthInfo
