package fr.ifremer.isisfish.entities;
/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import java.util.Collection;
import org.nuiton.topia.persistence.TopiaEntityContextable;

public interface Species extends TopiaEntityContextable {

    String PROPERTY_NAME = "name";

    String PROPERTY_SCIENTIFIC_NAME = "scientificName";

    String PROPERTY_CODE_RUBBIN = "codeRubbin";

    String PROPERTY_CODE_CEE = "codeCEE";

    String PROPERTY_AGE_GROUP_TYPE = "ageGroupType";

    String PROPERTY_COMMENT = "comment";

    String PROPERTY_METIER_SEASON_INFO_TARGET_SPECIES = "metierSeasonInfoTargetSpecies";

    String PROPERTY_POPULATION = "population";

    void setName(String name);

    String getName();

    void setScientificName(String scientificName);

    String getScientificName();

    void setCodeRubbin(String codeRubbin);

    String getCodeRubbin();

    void setCodeCEE(int codeCEE);

    int getCodeCEE();

    void setAgeGroupType(boolean ageGroupType);

    boolean isAgeGroupType();

    boolean getAgeGroupType();

    void setComment(String comment);

    String getComment();

    void addPopulation(Population population);

    void addAllPopulation(Collection<Population> population);

    void setPopulation(Collection<Population> population);

    void removePopulation(Population population);

    void clearPopulation();

    Collection<Population> getPopulation();

    Population getPopulationByTopiaId(String topiaId);

    int sizePopulation();

    boolean isPopulationEmpty();

    FisheryRegion getFisheryRegion();

} //Species
