package fr.ifremer.isisfish.entities;
/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.IsisFishDAOHelper.IsisFishEntityEnum;
import fr.ifremer.isisfish.types.RangeOfValues;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class GearDAOAbstract<E extends Gear> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Gear.class;
    }

    @Override
    public IsisFishEntityEnum getTopiaEntityEnum() {
        return IsisFishEntityEnum.Gear;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Metier> list = getContext()
                                                    .getDAO(Metier.class)
                                                    .findAllByProperties(Metier.PROPERTY_GEAR, entity);
                                            for (Metier item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getGear())) {
                                                    item.setGear(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Gear.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Gear.PROPERTY_NAME, v);
        return result;
    }

    public E findByEffortUnit(String v) throws TopiaException {
        E result = findByProperty(Gear.PROPERTY_EFFORT_UNIT, v);
        return result;
    }

    public List<E> findAllByEffortUnit(String v) throws TopiaException {
        List<E> result = findAllByProperty(Gear.PROPERTY_EFFORT_UNIT, v);
        return result;
    }

    public E findByStandardisationFactor(double v) throws TopiaException {
        E result = findByProperty(Gear.PROPERTY_STANDARDISATION_FACTOR, v);
        return result;
    }

    public List<E> findAllByStandardisationFactor(double v) throws TopiaException {
        List<E> result = findAllByProperty(Gear.PROPERTY_STANDARDISATION_FACTOR, v);
        return result;
    }

    public E findByParameterName(String v) throws TopiaException {
        E result = findByProperty(Gear.PROPERTY_PARAMETER_NAME, v);
        return result;
    }

    public List<E> findAllByParameterName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Gear.PROPERTY_PARAMETER_NAME, v);
        return result;
    }

    public E findByCost(double v) throws TopiaException {
        E result = findByProperty(Gear.PROPERTY_COST, v);
        return result;
    }

    public List<E> findAllByCost(double v) throws TopiaException {
        List<E> result = findAllByProperty(Gear.PROPERTY_COST, v);
        return result;
    }

    public E findByPossibleValue(RangeOfValues v) throws TopiaException {
        E result = findByProperty(Gear.PROPERTY_POSSIBLE_VALUE, v);
        return result;
    }

    public List<E> findAllByPossibleValue(RangeOfValues v) throws TopiaException {
        List<E> result = findAllByProperty(Gear.PROPERTY_POSSIBLE_VALUE, v);
        return result;
    }

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(Gear.PROPERTY_COMMENT, v);
        return result;
    }

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Gear.PROPERTY_COMMENT, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Metier.class) {
            MetierDAO dao = (MetierDAO)
                getContext().getDAO(Metier.class);
            tmp = dao.findAllByGear(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Metier.class, entity);
        if (!list.isEmpty()) {
            result.put(Metier.class, list);
        }

        return result;
    }

} //GearDAOAbstract<E extends Gear>
