package fr.ifremer.isisfish.entities;
/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.types.RangeOfValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class GearAbstract extends TopiaEntityAbstract implements Gear {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : effortUnit
     */
    protected String effortUnit;

    /**
     * Nom de l'attribut en BD : standardisationFactor
     */
    protected double standardisationFactor;

    /**
     * Nom de l'attribut en BD : parameterName
     */
    protected String parameterName;

    /**
     * <p>Co&ucirc;t d'achat de l'engin</p>
     * 
     * Nom de l'attribut en BD : cost
     */
    protected double cost;

    /**
     * Nom de l'attribut en BD : possibleValue
     */
    protected RangeOfValues possibleValue;

    /**
     * Nom de l'attribut en BD : comment
     */
    protected String comment;

    /**
     * Nom de l'attribut en BD : population
     */
    protected Collection<Selectivity> populationSelectivity;

    private static final long serialVersionUID = 3847588526840636258L;

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Gear.class).update(this);
}

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Gear.class).delete(this);
}

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_EFFORT_UNIT, String.class, effortUnit);
        visitor.visit(this, PROPERTY_STANDARDISATION_FACTOR, double.class, standardisationFactor);
        visitor.visit(this, PROPERTY_PARAMETER_NAME, String.class, parameterName);
        visitor.visit(this, PROPERTY_COST, double.class, cost);
        visitor.visit(this, PROPERTY_POSSIBLE_VALUE, RangeOfValues.class, possibleValue);
        visitor.visit(this, PROPERTY_COMMENT, String.class, comment);
        visitor.visit(this, PROPERTY_POPULATION_SELECTIVITY, Collection.class, Selectivity.class, populationSelectivity);
        visitor.end(this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);
        String result = this.name;
        fireOnPostRead(PROPERTY_NAME, name);
        return result;
    }

    @Override
    public void setEffortUnit(String effortUnit) {
        String oldValue = this.effortUnit;
        fireOnPreWrite(PROPERTY_EFFORT_UNIT, oldValue, effortUnit);
        this.effortUnit = effortUnit;
        fireOnPostWrite(PROPERTY_EFFORT_UNIT, oldValue, effortUnit);
    }

    @Override
    public String getEffortUnit() {
        fireOnPreRead(PROPERTY_EFFORT_UNIT, effortUnit);
        String result = this.effortUnit;
        fireOnPostRead(PROPERTY_EFFORT_UNIT, effortUnit);
        return result;
    }

    @Override
    public void setStandardisationFactor(double standardisationFactor) {
        double oldValue = this.standardisationFactor;
        fireOnPreWrite(PROPERTY_STANDARDISATION_FACTOR, oldValue, standardisationFactor);
        this.standardisationFactor = standardisationFactor;
        fireOnPostWrite(PROPERTY_STANDARDISATION_FACTOR, oldValue, standardisationFactor);
    }

    @Override
    public double getStandardisationFactor() {
        fireOnPreRead(PROPERTY_STANDARDISATION_FACTOR, standardisationFactor);
        double result = this.standardisationFactor;
        fireOnPostRead(PROPERTY_STANDARDISATION_FACTOR, standardisationFactor);
        return result;
    }

    @Override
    public void setParameterName(String parameterName) {
        String oldValue = this.parameterName;
        fireOnPreWrite(PROPERTY_PARAMETER_NAME, oldValue, parameterName);
        this.parameterName = parameterName;
        fireOnPostWrite(PROPERTY_PARAMETER_NAME, oldValue, parameterName);
    }

    @Override
    public String getParameterName() {
        fireOnPreRead(PROPERTY_PARAMETER_NAME, parameterName);
        String result = this.parameterName;
        fireOnPostRead(PROPERTY_PARAMETER_NAME, parameterName);
        return result;
    }

    @Override
    public void setCost(double cost) {
        double oldValue = this.cost;
        fireOnPreWrite(PROPERTY_COST, oldValue, cost);
        this.cost = cost;
        fireOnPostWrite(PROPERTY_COST, oldValue, cost);
    }

    @Override
    public double getCost() {
        fireOnPreRead(PROPERTY_COST, cost);
        double result = this.cost;
        fireOnPostRead(PROPERTY_COST, cost);
        return result;
    }

    @Override
    public void setPossibleValue(RangeOfValues possibleValue) {
        RangeOfValues oldValue = this.possibleValue;
        fireOnPreWrite(PROPERTY_POSSIBLE_VALUE, oldValue, possibleValue);
        this.possibleValue = possibleValue;
        fireOnPostWrite(PROPERTY_POSSIBLE_VALUE, oldValue, possibleValue);
    }

    @Override
    public RangeOfValues getPossibleValue() {
        fireOnPreRead(PROPERTY_POSSIBLE_VALUE, possibleValue);
        RangeOfValues result = this.possibleValue;
        fireOnPostRead(PROPERTY_POSSIBLE_VALUE, possibleValue);
        return result;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.comment;
        fireOnPreWrite(PROPERTY_COMMENT, oldValue, comment);
        this.comment = comment;
        fireOnPostWrite(PROPERTY_COMMENT, oldValue, comment);
    }

    @Override
    public String getComment() {
        fireOnPreRead(PROPERTY_COMMENT, comment);
        String result = this.comment;
        fireOnPostRead(PROPERTY_COMMENT, comment);
        return result;
    }

    @Override
    public void addPopulationSelectivity(Selectivity populationSelectivity) {
        fireOnPreWrite(PROPERTY_POPULATION_SELECTIVITY, null, populationSelectivity);
        if (this.populationSelectivity == null) {
            this.populationSelectivity = new ArrayList<Selectivity>();
        }

        this.populationSelectivity.add(populationSelectivity);
        fireOnPostWrite(PROPERTY_POPULATION_SELECTIVITY, this.populationSelectivity.size(), null, populationSelectivity);
    }

    @Override
    public void addAllPopulationSelectivity(Collection<Selectivity> populationSelectivity) {
        if (populationSelectivity == null) {
            return;
        }
        for (Selectivity item : populationSelectivity) {
            addPopulationSelectivity(item);
        }
    }

    @Override
    public void setPopulationSelectivity(Collection<Selectivity> populationSelectivity) {
        // Copy elements to keep data for fire with new reference
        Collection<Selectivity> oldValue = this.populationSelectivity != null ? new ArrayList<Selectivity>(this.populationSelectivity) : null;
        fireOnPreWrite(PROPERTY_POPULATION_SELECTIVITY, oldValue, populationSelectivity);
        this.populationSelectivity = populationSelectivity;
        fireOnPostWrite(PROPERTY_POPULATION_SELECTIVITY, oldValue, populationSelectivity);
    }

    @Override
    public void removePopulationSelectivity(Selectivity populationSelectivity) {
        fireOnPreWrite(PROPERTY_POPULATION_SELECTIVITY, populationSelectivity, null);
        if (this.populationSelectivity == null || !this.populationSelectivity.remove(populationSelectivity)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_POPULATION_SELECTIVITY, this.populationSelectivity.size() + 1, populationSelectivity, null);
    }

    @Override
    public void clearPopulationSelectivity() {
        if (this.populationSelectivity == null) {
            return;
        }
        Collection<Selectivity> oldValue = new ArrayList<Selectivity>(this.populationSelectivity);
        fireOnPreWrite(PROPERTY_POPULATION_SELECTIVITY, oldValue, this.populationSelectivity);
        this.populationSelectivity.clear();
        fireOnPostWrite(PROPERTY_POPULATION_SELECTIVITY, oldValue, this.populationSelectivity);
    }

    @Override
    public Collection<Selectivity> getPopulationSelectivity() {
        return populationSelectivity;
    }

    @Override
    public Selectivity getPopulationSelectivityByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(populationSelectivity, topiaId);
    }

    @Override
    public Selectivity getPopulationSelectivity(Population population) {
        if (population == null || this.populationSelectivity == null) {
            return null;
        }
        for (Selectivity item : this.populationSelectivity) {
            if (population.equals(item.getPopulation())) {
                return item;
            }
        }
        return null;
    }

    @Override
    public int sizePopulationSelectivity() {
        if (populationSelectivity == null) {
            return 0;
        }
        return populationSelectivity.size();
    }

    @Override
    public boolean isPopulationSelectivityEmpty() {
        int size = sizePopulationSelectivity();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        {
            org.nuiton.topia.persistence.TopiaDAO<Selectivity> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(Selectivity.class);
            List<Selectivity> findAllByProperties = dao.findAllByProperties("gear", this);
            if (findAllByProperties != null) {
                tmp.addAll(findAllByProperties);
            }
        }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NAME, this.name).
            append(PROPERTY_EFFORT_UNIT, this.effortUnit).
            append(PROPERTY_STANDARDISATION_FACTOR, this.standardisationFactor).
            append(PROPERTY_PARAMETER_NAME, this.parameterName).
            append(PROPERTY_COST, this.cost).
            append(PROPERTY_POSSIBLE_VALUE, this.possibleValue).
            append(PROPERTY_COMMENT, this.comment).
         toString();
        return result;
    }

} //GearAbstract
