package fr.ifremer.isisfish.entities;
/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class FisheryRegionAbstract extends TopiaEntityAbstract implements FisheryRegion {

    /**
     * <p>Area represente la r&eacute;gion dans lequel on va d&eacute;finir la p&ecirc;cherie. Les objets de la p&ecirc;cherie n'ont plus de lien vers elle, car il n'y en existe qu'une seul dans chaque p&ecirc;cherie.</p>
     * 
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * <p>Area represente la r&eacute;gion dans lequel on va d&eacute;finir la p&ecirc;cherie. Les objets de la p&ecirc;cherie n'ont plus de lien vers elle, car il n'y en existe qu'une seul dans chaque p&ecirc;cherie.</p>
     * 
     * Nom de l'attribut en BD : minLongitude
     */
    protected float minLongitude;

    /**
     * <p>Area represente la r&eacute;gion dans lequel on va d&eacute;finir la p&ecirc;cherie. Les objets de la p&ecirc;cherie n'ont plus de lien vers elle, car il n'y en existe qu'une seul dans chaque p&ecirc;cherie.</p>
     * 
     * Nom de l'attribut en BD : maxLongitude
     */
    protected float maxLongitude;

    /**
     * <p>Area represente la r&eacute;gion dans lequel on va d&eacute;finir la p&ecirc;cherie. Les objets de la p&ecirc;cherie n'ont plus de lien vers elle, car il n'y en existe qu'une seul dans chaque p&ecirc;cherie.</p>
     * 
     * Nom de l'attribut en BD : minLatitude
     */
    protected float minLatitude;

    /**
     * <p>Area represente la r&eacute;gion dans lequel on va d&eacute;finir la p&ecirc;cherie. Les objets de la p&ecirc;cherie n'ont plus de lien vers elle, car il n'y en existe qu'une seul dans chaque p&ecirc;cherie.</p>
     * 
     * Nom de l'attribut en BD : maxLatitude
     */
    protected float maxLatitude;

    /**
     * <p>Area represente la r&eacute;gion dans lequel on va d&eacute;finir la p&ecirc;cherie. Les objets de la p&ecirc;cherie n'ont plus de lien vers elle, car il n'y en existe qu'une seul dans chaque p&ecirc;cherie.</p>
     * 
     * Nom de l'attribut en BD : cellLengthLongitude
     */
    protected float cellLengthLongitude;

    /**
     * <p>Area represente la r&eacute;gion dans lequel on va d&eacute;finir la p&ecirc;cherie. Les objets de la p&ecirc;cherie n'ont plus de lien vers elle, car il n'y en existe qu'une seul dans chaque p&ecirc;cherie.</p>
     * 
     * Nom de l'attribut en BD : cellLengthLatitude
     */
    protected float cellLengthLatitude;

    /**
     * <p>Area represente la r&eacute;gion dans lequel on va d&eacute;finir la p&ecirc;cherie. Les objets de la p&ecirc;cherie n'ont plus de lien vers elle, car il n'y en existe qu'une seul dans chaque p&ecirc;cherie.</p>
     * 
     * Nom de l'attribut en BD : mapFiles
     */
    protected String mapFiles;

    /**
     * <p>Area represente la r&eacute;gion dans lequel on va d&eacute;finir la p&ecirc;cherie. Les objets de la p&ecirc;cherie n'ont plus de lien vers elle, car il n'y en existe qu'une seul dans chaque p&ecirc;cherie.</p>
     * 
     * Nom de l'attribut en BD : comment
     */
    protected String comment;

    private static final long serialVersionUID = 3833461790959876449L;

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(FisheryRegion.class).update(this);
}

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(FisheryRegion.class).delete(this);
}

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_MIN_LONGITUDE, float.class, minLongitude);
        visitor.visit(this, PROPERTY_MAX_LONGITUDE, float.class, maxLongitude);
        visitor.visit(this, PROPERTY_MIN_LATITUDE, float.class, minLatitude);
        visitor.visit(this, PROPERTY_MAX_LATITUDE, float.class, maxLatitude);
        visitor.visit(this, PROPERTY_CELL_LENGTH_LONGITUDE, float.class, cellLengthLongitude);
        visitor.visit(this, PROPERTY_CELL_LENGTH_LATITUDE, float.class, cellLengthLatitude);
        visitor.visit(this, PROPERTY_MAP_FILES, String.class, mapFiles);
        visitor.visit(this, PROPERTY_COMMENT, String.class, comment);
        visitor.end(this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);
        String result = this.name;
        fireOnPostRead(PROPERTY_NAME, name);
        return result;
    }

    @Override
    public void setMinLongitude(float minLongitude) {
        float oldValue = this.minLongitude;
        fireOnPreWrite(PROPERTY_MIN_LONGITUDE, oldValue, minLongitude);
        this.minLongitude = minLongitude;
        fireOnPostWrite(PROPERTY_MIN_LONGITUDE, oldValue, minLongitude);
    }

    @Override
    public float getMinLongitude() {
        fireOnPreRead(PROPERTY_MIN_LONGITUDE, minLongitude);
        float result = this.minLongitude;
        fireOnPostRead(PROPERTY_MIN_LONGITUDE, minLongitude);
        return result;
    }

    @Override
    public void setMaxLongitude(float maxLongitude) {
        float oldValue = this.maxLongitude;
        fireOnPreWrite(PROPERTY_MAX_LONGITUDE, oldValue, maxLongitude);
        this.maxLongitude = maxLongitude;
        fireOnPostWrite(PROPERTY_MAX_LONGITUDE, oldValue, maxLongitude);
    }

    @Override
    public float getMaxLongitude() {
        fireOnPreRead(PROPERTY_MAX_LONGITUDE, maxLongitude);
        float result = this.maxLongitude;
        fireOnPostRead(PROPERTY_MAX_LONGITUDE, maxLongitude);
        return result;
    }

    @Override
    public void setMinLatitude(float minLatitude) {
        float oldValue = this.minLatitude;
        fireOnPreWrite(PROPERTY_MIN_LATITUDE, oldValue, minLatitude);
        this.minLatitude = minLatitude;
        fireOnPostWrite(PROPERTY_MIN_LATITUDE, oldValue, minLatitude);
    }

    @Override
    public float getMinLatitude() {
        fireOnPreRead(PROPERTY_MIN_LATITUDE, minLatitude);
        float result = this.minLatitude;
        fireOnPostRead(PROPERTY_MIN_LATITUDE, minLatitude);
        return result;
    }

    @Override
    public void setMaxLatitude(float maxLatitude) {
        float oldValue = this.maxLatitude;
        fireOnPreWrite(PROPERTY_MAX_LATITUDE, oldValue, maxLatitude);
        this.maxLatitude = maxLatitude;
        fireOnPostWrite(PROPERTY_MAX_LATITUDE, oldValue, maxLatitude);
    }

    @Override
    public float getMaxLatitude() {
        fireOnPreRead(PROPERTY_MAX_LATITUDE, maxLatitude);
        float result = this.maxLatitude;
        fireOnPostRead(PROPERTY_MAX_LATITUDE, maxLatitude);
        return result;
    }

    @Override
    public void setCellLengthLongitude(float cellLengthLongitude) {
        float oldValue = this.cellLengthLongitude;
        fireOnPreWrite(PROPERTY_CELL_LENGTH_LONGITUDE, oldValue, cellLengthLongitude);
        this.cellLengthLongitude = cellLengthLongitude;
        fireOnPostWrite(PROPERTY_CELL_LENGTH_LONGITUDE, oldValue, cellLengthLongitude);
    }

    @Override
    public float getCellLengthLongitude() {
        fireOnPreRead(PROPERTY_CELL_LENGTH_LONGITUDE, cellLengthLongitude);
        float result = this.cellLengthLongitude;
        fireOnPostRead(PROPERTY_CELL_LENGTH_LONGITUDE, cellLengthLongitude);
        return result;
    }

    @Override
    public void setCellLengthLatitude(float cellLengthLatitude) {
        float oldValue = this.cellLengthLatitude;
        fireOnPreWrite(PROPERTY_CELL_LENGTH_LATITUDE, oldValue, cellLengthLatitude);
        this.cellLengthLatitude = cellLengthLatitude;
        fireOnPostWrite(PROPERTY_CELL_LENGTH_LATITUDE, oldValue, cellLengthLatitude);
    }

    @Override
    public float getCellLengthLatitude() {
        fireOnPreRead(PROPERTY_CELL_LENGTH_LATITUDE, cellLengthLatitude);
        float result = this.cellLengthLatitude;
        fireOnPostRead(PROPERTY_CELL_LENGTH_LATITUDE, cellLengthLatitude);
        return result;
    }

    @Override
    public void setMapFiles(String mapFiles) {
        String oldValue = this.mapFiles;
        fireOnPreWrite(PROPERTY_MAP_FILES, oldValue, mapFiles);
        this.mapFiles = mapFiles;
        fireOnPostWrite(PROPERTY_MAP_FILES, oldValue, mapFiles);
    }

    @Override
    public String getMapFiles() {
        fireOnPreRead(PROPERTY_MAP_FILES, mapFiles);
        String result = this.mapFiles;
        fireOnPostRead(PROPERTY_MAP_FILES, mapFiles);
        return result;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.comment;
        fireOnPreWrite(PROPERTY_COMMENT, oldValue, comment);
        this.comment = comment;
        fireOnPostWrite(PROPERTY_COMMENT, oldValue, comment);
    }

    @Override
    public String getComment() {
        fireOnPreRead(PROPERTY_COMMENT, comment);
        String result = this.comment;
        fireOnPostRead(PROPERTY_COMMENT, comment);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NAME, this.name).
            append(PROPERTY_MIN_LONGITUDE, this.minLongitude).
            append(PROPERTY_MAX_LONGITUDE, this.maxLongitude).
            append(PROPERTY_MIN_LATITUDE, this.minLatitude).
            append(PROPERTY_MAX_LATITUDE, this.maxLatitude).
            append(PROPERTY_CELL_LENGTH_LONGITUDE, this.cellLengthLongitude).
            append(PROPERTY_CELL_LENGTH_LATITUDE, this.cellLengthLatitude).
            append(PROPERTY_MAP_FILES, this.mapFiles).
            append(PROPERTY_COMMENT, this.comment).
         toString();
        return result;
    }

} //FisheryRegionAbstract
