package fr.ifremer.isisfish.entities;
/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import java.util.List;
import org.nuiton.topia.persistence.TopiaEntityContextable;

public interface FisheryRegion extends TopiaEntityContextable {

    String PROPERTY_NAME = "name";

    String PROPERTY_MIN_LONGITUDE = "minLongitude";

    String PROPERTY_MAX_LONGITUDE = "maxLongitude";

    String PROPERTY_MIN_LATITUDE = "minLatitude";

    String PROPERTY_MAX_LATITUDE = "maxLatitude";

    String PROPERTY_CELL_LENGTH_LONGITUDE = "cellLengthLongitude";

    String PROPERTY_CELL_LENGTH_LATITUDE = "cellLengthLatitude";

    String PROPERTY_MAP_FILES = "mapFiles";

    String PROPERTY_COMMENT = "comment";

    void setName(String name);

    String getName();

    void setMinLongitude(float minLongitude);

    float getMinLongitude();

    void setMaxLongitude(float maxLongitude);

    float getMaxLongitude();

    void setMinLatitude(float minLatitude);

    float getMinLatitude();

    void setMaxLatitude(float maxLatitude);

    float getMaxLatitude();

    void setCellLengthLongitude(float cellLengthLongitude);

    float getCellLengthLongitude();

    void setCellLengthLatitude(float cellLengthLatitude);

    float getCellLengthLatitude();

    void setMapFiles(String mapFiles);

    String getMapFiles();

    void setComment(String comment);

    String getComment();

    /**
     * <p>Area represente la r&eacute;gion dans lequel on va d&eacute;finir la p&ecirc;cherie. Les objets de la p&ecirc;cherie n'ont plus de lien vers elle, car il n'y en existe qu'une seul dans chaque p&ecirc;cherie.</p>
     * @return 
     */
    List<String> getMapFileList();

    /**
     * <p>Area represente la r&eacute;gion dans lequel on va d&eacute;finir la p&ecirc;cherie. Les objets de la p&ecirc;cherie n'ont plus de lien vers elle, car il n'y en existe qu'une seul dans chaque p&ecirc;cherie.</p>
     * @param v <p>Area represente la r&eacute;gion dans lequel on va d&eacute;finir la p&ecirc;cherie. Les objets de la p&ecirc;cherie n'ont plus de lien vers elle, car il n'y en existe qu'une seul dans chaque p&ecirc;cherie.</p>

     */
    void setMapFileList(List<String> v);

    /**
     * <p>Area represente la r&eacute;gion dans lequel on va d&eacute;finir la p&ecirc;cherie. Les objets de la p&ecirc;cherie n'ont plus de lien vers elle, car il n'y en existe qu'une seul dans chaque p&ecirc;cherie.</p>
     * @return 
     */
    List<String> getMapFilePath();

    /**
     * <p>Area represente la r&eacute;gion dans lequel on va d&eacute;finir la p&ecirc;cherie. Les objets de la p&ecirc;cherie n'ont plus de lien vers elle, car il n'y en existe qu'une seul dans chaque p&ecirc;cherie.</p>
     * @return 
     */
    List<Gear> getGear();

    /**
     * <p>Area represente la r&eacute;gion dans lequel on va d&eacute;finir la p&ecirc;cherie. Les objets de la p&ecirc;cherie n'ont plus de lien vers elle, car il n'y en existe qu'une seul dans chaque p&ecirc;cherie.</p>
     * @return 
     */
    List<Cell> getCell();

    /**
     * <p>Area represente la r&eacute;gion dans lequel on va d&eacute;finir la p&ecirc;cherie. Les objets de la p&ecirc;cherie n'ont plus de lien vers elle, car il n'y en existe qu'une seul dans chaque p&ecirc;cherie.</p>
     * @return 
     */
    List<TripType> getTripType();

    /**
     * <p>Area represente la r&eacute;gion dans lequel on va d&eacute;finir la p&ecirc;cherie. Les objets de la p&ecirc;cherie n'ont plus de lien vers elle, car il n'y en existe qu'une seul dans chaque p&ecirc;cherie.</p>
     * @return 
     */
    List<VesselType> getVesselType();

    /**
     * <p>Area represente la r&eacute;gion dans lequel on va d&eacute;finir la p&ecirc;cherie. Les objets de la p&ecirc;cherie n'ont plus de lien vers elle, car il n'y en existe qu'une seul dans chaque p&ecirc;cherie.</p>
     * @return 
     */
    List<Species> getSpecies();

    /**
     * <p>Area represente la r&eacute;gion dans lequel on va d&eacute;finir la p&ecirc;cherie. Les objets de la p&ecirc;cherie n'ont plus de lien vers elle, car il n'y en existe qu'une seul dans chaque p&ecirc;cherie.</p>
     * @return 
     */
    List<Zone> getZone();

    /**
     * <p>Area represente la r&eacute;gion dans lequel on va d&eacute;finir la p&ecirc;cherie. Les objets de la p&ecirc;cherie n'ont plus de lien vers elle, car il n'y en existe qu'une seul dans chaque p&ecirc;cherie.</p>
     * @return 
     */
    List<Strategy> getStrategy();

    /**
     * <p>Area represente la r&eacute;gion dans lequel on va d&eacute;finir la p&ecirc;cherie. Les objets de la p&ecirc;cherie n'ont plus de lien vers elle, car il n'y en existe qu'une seul dans chaque p&ecirc;cherie.</p>
     * @return 
     */
    List<Port> getPort();

    /**
     * <p>Area represente la r&eacute;gion dans lequel on va d&eacute;finir la p&ecirc;cherie. Les objets de la p&ecirc;cherie n'ont plus de lien vers elle, car il n'y en existe qu'une seul dans chaque p&ecirc;cherie.</p>
     * @return 
     */
    List<Metier> getMetier();

    /**
     * <p>Area represente la r&eacute;gion dans lequel on va d&eacute;finir la p&ecirc;cherie. Les objets de la p&ecirc;cherie n'ont plus de lien vers elle, car il n'y en existe qu'une seul dans chaque p&ecirc;cherie.</p>
     * @return 
     */
    List<SetOfVessels> getSetOfVessels();

} //FisheryRegion
