package fr.ifremer.isisfish.entities;
/*
 * #%L
 * IsisFish
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.IsisFishDAOHelper.IsisFishEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class EquationDAOAbstract<E extends Equation> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Equation.class;
    }

    @Override
    public IsisFishEntityEnum getTopiaEntityEnum() {
        return IsisFishEntityEnum.Equation;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Variable> list = getContext()
                                                    .getDAO(Variable.class)
                                                    .findAllByProperties(Variable.PROPERTY_EQUATION_VALUE, entity);
                                            for (Variable item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getEquationValue())) {
                                                    item.setEquationValue(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Equation.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Equation.PROPERTY_NAME, v);
        return result;
    }

    public E findByContent(String v) throws TopiaException {
        E result = findByProperty(Equation.PROPERTY_CONTENT, v);
        return result;
    }

    public List<E> findAllByContent(String v) throws TopiaException {
        List<E> result = findAllByProperty(Equation.PROPERTY_CONTENT, v);
        return result;
    }

    public E findByCategory(String v) throws TopiaException {
        E result = findByProperty(Equation.PROPERTY_CATEGORY, v);
        return result;
    }

    public List<E> findAllByCategory(String v) throws TopiaException {
        List<E> result = findAllByProperty(Equation.PROPERTY_CATEGORY, v);
        return result;
    }

    public E findByLanguage(String v) throws TopiaException {
        E result = findByProperty(Equation.PROPERTY_LANGUAGE, v);
        return result;
    }

    public List<E> findAllByLanguage(String v) throws TopiaException {
        List<E> result = findAllByProperty(Equation.PROPERTY_LANGUAGE, v);
        return result;
    }

    public E findByJavaInterface(Class v) throws TopiaException {
        E result = findByProperty(Equation.PROPERTY_JAVA_INTERFACE, v);
        return result;
    }

    public List<E> findAllByJavaInterface(Class v) throws TopiaException {
        List<E> result = findAllByProperty(Equation.PROPERTY_JAVA_INTERFACE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == PopulationSeasonInfo.class) {
            PopulationSeasonInfoDAO dao = (PopulationSeasonInfoDAO)
                getContext().getDAO(PopulationSeasonInfo.class);
            tmp = dao.findAllByMigrationEquation(entity);
            result.addAll(tmp);
        }

        if (type == PopulationSeasonInfo.class) {
            PopulationSeasonInfoDAO dao = (PopulationSeasonInfoDAO)
                getContext().getDAO(PopulationSeasonInfo.class);
            tmp = dao.findAllByEmigrationEquation(entity);
            result.addAll(tmp);
        }

        if (type == PopulationSeasonInfo.class) {
            PopulationSeasonInfoDAO dao = (PopulationSeasonInfoDAO)
                getContext().getDAO(PopulationSeasonInfo.class);
            tmp = dao.findAllByImmigrationEquation(entity);
            result.addAll(tmp);
        }

        if (type == Strategy.class) {
            StrategyDAO dao = (StrategyDAO)
                getContext().getDAO(Strategy.class);
            tmp = dao.findAllByInactivityEquation(entity);
            result.addAll(tmp);
        }

        if (type == SetOfVessels.class) {
            SetOfVesselsDAO dao = (SetOfVesselsDAO)
                getContext().getDAO(SetOfVessels.class);
            tmp = dao.findAllByTechnicalEfficiencyEquation(entity);
            result.addAll(tmp);
        }

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllByGrowth(entity);
            result.addAll(tmp);
        }

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllByGrowthReverse(entity);
            result.addAll(tmp);
        }

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllByMeanWeight(entity);
            result.addAll(tmp);
        }

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllByPrice(entity);
            result.addAll(tmp);
        }

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllByNaturalDeathRate(entity);
            result.addAll(tmp);
        }

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllByReproductionEquation(entity);
            result.addAll(tmp);
        }

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllByCapturabilityEquation(entity);
            result.addAll(tmp);
        }

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllByMaturityOgiveEquation(entity);
            result.addAll(tmp);
        }

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllByReproductionRateEquation(entity);
            result.addAll(tmp);
        }

        if (type == Selectivity.class) {
            SelectivityDAO dao = (SelectivityDAO)
                getContext().getDAO(Selectivity.class);
            tmp = dao.findAllByEquation(entity);
            result.addAll(tmp);
        }

        if (type == TargetSpecies.class) {
            TargetSpeciesDAO dao = (TargetSpeciesDAO)
                getContext().getDAO(TargetSpecies.class);
            tmp = dao.findAllByTargetFactorEquation(entity);
            result.addAll(tmp);
        }

        if (type == Variable.class) {
            VariableDAO dao = (VariableDAO)
                getContext().getDAO(Variable.class);
            tmp = dao.findAllByEquationValue(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(7);

        List<? extends TopiaEntity> list;

        list = findUsages(PopulationSeasonInfo.class, entity);
        if (!list.isEmpty()) {
            result.put(PopulationSeasonInfo.class, list);
        }

        list = findUsages(Strategy.class, entity);
        if (!list.isEmpty()) {
            result.put(Strategy.class, list);
        }

        list = findUsages(SetOfVessels.class, entity);
        if (!list.isEmpty()) {
            result.put(SetOfVessels.class, list);
        }

        list = findUsages(Population.class, entity);
        if (!list.isEmpty()) {
            result.put(Population.class, list);
        }

        list = findUsages(Selectivity.class, entity);
        if (!list.isEmpty()) {
            result.put(Selectivity.class, list);
        }

        list = findUsages(TargetSpecies.class, entity);
        if (!list.isEmpty()) {
            result.put(TargetSpecies.class, list);
        }

        list = findUsages(Variable.class, entity);
        if (!list.isEmpty()) {
            result.put(Variable.class, list);
        }

        return result;
    }

} //EquationDAOAbstract<E extends Equation>
