/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.sensitivity;

import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.DiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationContinuousDomain;
import fr.ifremer.isisfish.ui.SimulationUI;
import fr.ifremer.isisfish.ui.input.InputSaveVerifier;
import fr.ifremer.isisfish.ui.simulator.SimulAction;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import static org.nuiton.i18n.I18n._;

public class FactorWizardUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CONTINUE_POSSIBLE = "continuePossible";
    public static final String PROPERTY_CONTINUE_SELECTED = "continueSelected";
    public static final String PROPERTY_EXISTING_VALUE = "existingValue";
    public static final String PROPERTY_FACTOR_PATH = "factorPath";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CONTINUE_RADIO_VISIBLE = "continueRadio.visible";
    public static final String BINDING_REMOVE_VISIBLE = "remove.visible";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWQW8bRRSemNiOk4a2iZoGNaC0mApRsU4qDkCqkDRVSCy3jeq0FFwEs95JPNV4ZpmZTTc9IP4AEifOcOeCxI0T4sCZAxfEX0CIA1fEm1nH67U3mxX2YW3Ne++b7/t25j1/9ycqKomuPsVh6MiAa9olTn3z8eP77lPS1neIakvqayFR9JkooEILzXj9daXRq62GKa/1ymtbousLTvhA9VoDTSt9zIjqEKI1ejlZ0Vaq1uyH10I/kCeofVJpqN/8/VfhK++LbwsIhT6wWwIpy2dVxUomG6hAPY3mYKcjXGOYHwINSfkh8J01a1sMK3UPd8ln6HNUbqCSjyWAaXQtv2SLYetDX6NKtX6HYiYOVzRaPZAOPZCkS+BbUXVAVccJqKMIV1TTI6qPnW3cBrAP6HMsvYe7vm+RShqVO5h7jEiN3s2B0ox/73I/0DtRcQx3oS1ACQ/InlCKuoxodNEY4BhTnNtCMIJ5SnqTMDgmxDPrF+P4LAmpgoTDR5gFZCg4fWA17WHdAaR4l8j6OG++2rRe7nKgjhl9TiSYdt2+3zYYTkGBE9ntjGRmwqya0JUBM6v7GDQD+mLi9KhnQMixMZNZGS6wOMvm8Uo/NFWtN7BLGIDNGW1hDyVaNUlX+7nnIyfMAdumhMFRXEiU7JNQ20CyrOxRkG3u0WIi/QH2qLgdaC14ktPsyeuyGWbxRjLhXId6RtAe5oQNE7eLyfyFHoOoYAvQMeVE9u1wRuywVr1mHqsxrR7KvaDrRsWvJxPgskRywMz5BKdYZZxd1tg1fDS6nHQRuy7xTCSZv9hzRQRqVMZKuoybfRkD7lbrcMIEYwZlZXj3OJSsKsMR7tpecmnknW9Kgk3aZj+71Ma8Hb2Fd5I4Jbj54oikRCYVTl3v3b/9Yx+supZy4E3/jwx+X4rAh3si0ZVEHjRsJ27YcUedaKGiDGAZ3G2N9vgHEIq6++JQdzeANvrvwvxvP/7xw/ZJS78Me19KTR2YSNBqfSl86IbUbH0+6ueBpqx2F/trLVRRtk/ZcbWUQqzZCwM52C/qfKbc2cGqAxDF8u8//bzw6a8voMI2mmYCe1Ff3kUV3ZHggmBe6L+3YRmdezYFzwuGG7weho8FeIlevOVhjZddyj3weD0EE5ZSTOgzcSu//DPf/H7jxIgJIPbSqemxGcWPUIlyBufYTrfe4EqdZjO+IoEn4gGVNrImzPe032uWD+3zwzSlxa7wsD2hT8LAfH1sWZtfn+QH0VSb4TN3K9KwjDVMBTfQZP3/g05quFMmStMxqjkwZtz4QmRAvZEDakoNDM1TvDobxyzzsZiYZZWB8GYuhDBDRT6ELBVnI0AnPaL2L8vYRFoZCLUcREqukF40Pk5BuTm2IW+NjfB2LoSvM1Ssj+1mPoQsFRtjI+yMjVDPhfBlhg9nI8DxJtz8NcvqFo2xpRiE/wCebNEkDA4AAA==";
    private static final Log log = LogFactory.getLog(FactorWizardUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancel;
    protected JTextArea comment;
    protected Boolean continuePossible;
    protected JRadioButton continueRadio;
    protected Boolean continueSelected;
    protected JPanel continuousPanelContainer;
    protected JRadioButton discret;
    protected JTextField discretNumber;
    protected Table discretePanelContainer;
    protected Boolean existingValue;
    protected JTextField factorNameField;
    protected String factorPath;
    protected JAXXButtonGroup factorType;
    protected SensitivityInputHandler handler;
    protected JPanel hidablePanel;
    protected JButton remove;
    protected JButton save;
    protected JTabbedPane tabPane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FactorWizardUI $JDialog0 = this;
    private Table $Table0;
    private Table $Table1;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JButton $JButton0;
    private JLabel $JLabel2;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<JComponent> discretComponents;
    protected ContinuousPanelContainerUI continuousPanel;
    
    
    /*protected void $afterCompleteSetup() {
        addPropertyChangeListener(PROPERTY_CONTINUE_POSSIBLE, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (continuousPanel != null) {
                    continuousPanel.setContinuePossible((Boolean)evt.getNewValue());
                }
            }
        });
        
        addPropertyChangeListener(PROPERTY_CONTINUE_SELECTED, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (continuousPanel != null) {
                    continuousPanel.setContinueSelected((Boolean)evt.getNewValue());
                }
            }
        });
    }*/
    
    protected void $afterCompleteSetup() {
        addPropertyChangeListener(PROPERTY_CONTINUE_SELECTED, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ((Boolean)evt.getNewValue()) {
                    ((CardLayout) hidablePanel.getLayout()).show(hidablePanel, "continuousPanelContainer");
                } else {
                    ((CardLayout) hidablePanel.getLayout()).show(hidablePanel, "discretePanelContainer");
                }
                
                // necessary for validation
                if (continuousPanel != null) {
                    continuousPanel.setContinueSelected((Boolean)evt.getNewValue());
                }
            }
        });
    }
    
    protected SimulAction getSimulAction() {
        return getContextValue(SimulAction.class);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FactorWizardUI(Window param0) {
        super(param0);
        $initialize();
    }

    public FactorWizardUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FactorWizardUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FactorWizardUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FactorWizardUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FactorWizardUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FactorWizardUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FactorWizardUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FactorWizardUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FactorWizardUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FactorWizardUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FactorWizardUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FactorWizardUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FactorWizardUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FactorWizardUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FactorWizardUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FactorWizardUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FactorWizardUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FactorWizardUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FactorWizardUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FactorWizardUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public FactorWizardUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FactorWizardUI() {
        $initialize();
    }

    public FactorWizardUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FactorWizardUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FactorWizardUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FactorWizardUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public FactorWizardUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FactorWizardUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FactorWizardUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FactorWizardUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FactorWizardUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addTabs(this);
    }

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doActionPerformed__on__continueRadio(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setContinueSelected(continueRadio.isSelected());
    }

    public void doActionPerformed__on__discret(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setContinueSelected(continueRadio.isSelected());
    }

    public void doActionPerformed__on__remove(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().remove(this);
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().save(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancel() {
        return cancel;
    }

    public JTextArea getComment() {
        return comment;
    }

    public Boolean getContinuePossible() {
        return continuePossible;
    }

    public JRadioButton getContinueRadio() {
        return continueRadio;
    }

    public Boolean getContinueSelected() {
        return continueSelected;
    }

    public JPanel getContinuousPanelContainer() {
        return continuousPanelContainer;
    }

    public JRadioButton getDiscret() {
        return discret;
    }

    public JTextField getDiscretNumber() {
        return discretNumber;
    }

    public Table getDiscretePanelContainer() {
        return discretePanelContainer;
    }

    public Boolean getExistingValue() {
        return existingValue;
    }

    public JTextField getFactorNameField() {
        return factorNameField;
    }

    public String getFactorPath() {
        return factorPath;
    }

    public JAXXButtonGroup getFactorType() {
        return factorType;
    }

    public SensitivityInputHandler getHandler() {
        return handler;
    }

    public JPanel getHidablePanel() {
        return hidablePanel;
    }

    public JButton getRemove() {
        return remove;
    }

    public JButton getSave() {
        return save;
    }

    public JTabbedPane getTabPane() {
        return tabPane;
    }

    public Boolean isContinuePossible() {
        return continuePossible !=null && continuePossible;
    }

    public Boolean isContinueSelected() {
        return continueSelected !=null && continueSelected;
    }

    public Boolean isExistingValue() {
        return existingValue !=null && existingValue;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setContinuePossible(Boolean continuePossible) {
        Boolean oldValue = this.continuePossible;
        this.continuePossible = continuePossible;
        firePropertyChange(PROPERTY_CONTINUE_POSSIBLE, oldValue, continuePossible);
    }

    public void setContinueSelected(Boolean continueSelected) {
        Boolean oldValue = this.continueSelected;
        this.continueSelected = continueSelected;
        firePropertyChange(PROPERTY_CONTINUE_SELECTED, oldValue, continueSelected);
    }

    public void setExistingValue(Boolean existingValue) {
        Boolean oldValue = this.existingValue;
        this.existingValue = existingValue;
        firePropertyChange(PROPERTY_EXISTING_VALUE, oldValue, existingValue);
    }

    public void setFactorPath(String factorPath) {
        String oldValue = this.factorPath;
        this.factorPath = factorPath;
        firePropertyChange(PROPERTY_FACTOR_PATH, oldValue, factorPath);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToContinueRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = factorType; continueRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(continueRadio); }
    }

    protected void addChildrenToDiscret() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = factorType; discret.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(discret); }
    }

    protected void addChildrenToDiscretePanelContainer() {
        if (!allComponentsCreated) {
            return;
        }
        discretePanelContainer.add($JLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        discretePanelContainer.add(discretNumber, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        discretePanelContainer.add($JButton0, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        discretePanelContainer.add(tabPane, new GridBagConstraints(0, 1, 3, 1, 1.0, 2.0, 11, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToHidablePanel() {
        if (!allComponentsCreated) {
            return;
        }
        hidablePanel.add(discretePanelContainer, "discretePanelContainer");
        hidablePanel.add(continuousPanelContainer, "continuousPanelContainer");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(_("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createComment() {
        $objectMap.put("comment", comment = new JTextArea());
        
        comment.setName("comment");
        comment.setColumns(15);
        comment.setLineWrap(true);
        comment.setWrapStyleWord(true);
    }

    protected void createContinuePossible() {
        $objectMap.put("continuePossible", continuePossible = false);
    }

    protected void createContinueRadio() {
        $objectMap.put("continueRadio", continueRadio = new JRadioButton());
        
        continueRadio.setName("continueRadio");
        continueRadio.setText(_("isisfish.sensitivity.continue"));
        continueRadio.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__continueRadio"));
    }

    protected void createContinueSelected() {
        $objectMap.put("continueSelected", continueSelected = false);
    }

    protected void createContinuousPanelContainer() {
        $objectMap.put("continuousPanelContainer", continuousPanelContainer = new JPanel());
        
        continuousPanelContainer.setName("continuousPanelContainer");
        continuousPanelContainer.setLayout(new BorderLayout());
    }

    protected void createDiscret() {
        $objectMap.put("discret", discret = new JRadioButton());
        
        discret.setName("discret");
        discret.setText(_("isisfish.sensitivity.discret"));
        discret.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__discret"));
    }

    protected void createDiscretNumber() {
        $objectMap.put("discretNumber", discretNumber = new JTextField());
        
        discretNumber.setName("discretNumber");
        discretNumber.setColumns(15);
    }

    protected void createDiscretePanelContainer() {
        $objectMap.put("discretePanelContainer", discretePanelContainer = new Table());
        
        discretePanelContainer.setName("discretePanelContainer");
    }

    protected void createExistingValue() {
        $objectMap.put("existingValue", existingValue = false);
    }

    protected void createFactorNameField() {
        $objectMap.put("factorNameField", factorNameField = new JTextField());
        
        factorNameField.setName("factorNameField");
        factorNameField.setColumns(15);
    }

    protected void createFactorPath() {
        $objectMap.put("factorPath", factorPath = null);
    }

    protected void createFactorType() {
        $objectMap.put("factorType", factorType = new JAXXButtonGroup());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new SensitivityInputHandler());
    }

    protected void createHidablePanel() {
        $objectMap.put("hidablePanel", hidablePanel = new JPanel());
        
        hidablePanel.setName("hidablePanel");
        hidablePanel.setLayout(new CardLayout());
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new JButton());
        
        remove.setName("remove");
        remove.setText(_("isisfish.common.remove"));
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(_("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createTabPane() {
        $objectMap.put("tabPane", tabPane = new JTabbedPane());
        
        tabPane.setName("tabPane");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add($Table0, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(discret, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(continueRadio, new GridBagConstraints(2, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(hidablePanel, new GridBagConstraints(0, 2, 4, 1, 1.0, 3.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 4, 4, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cancel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(remove, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(save, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(factorNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToDiscret();
        addChildrenToContinueRadio();
        addChildrenToHidablePanel();
        addChildrenToDiscretePanelContainer();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(comment);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        setModal(true);
        discret.setSelected(true);
        continueRadio.setSelected(false);
        discretePanelContainer.setBorder(BorderFactory.createTitledBorder(""));
        continuousPanelContainer.setBorder(BorderFactory.createTitledBorder(""));
        // late initializer
        $JDialog0.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JDialog0", $JDialog0);
        createHandler();
        createContinuePossible();
        createContinueSelected();
        createExistingValue();
        createFactorPath();
        discretComponents = new ArrayList<JComponent>();
        continuousPanel = null;
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("isisfish.sensitivity.name"));
        createFactorNameField();
        createDiscret();
        createContinueRadio();
        createHidablePanel();
        createDiscretePanelContainer();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("isisfish.sensitivity.selectDiscretNumber"));
        createDiscretNumber();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("isisfish.sensitivity.validDiscretNumber"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createTabPane();
        createContinuousPanelContainer();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.sensitivity.comment"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createComment();
        createCancel();
        createRemove();
        createSave();
        createFactorType();
        // inline creation of $JDialog0
        setName("$JDialog0");
        $JDialog0.getContentPane().setLayout(new BorderLayout());
        setTitle(_("isisfish.sensitivity.title"));
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CONTINUE_RADIO_VISIBLE, true ,"continuePossible") {
        
            @Override
            public void processDataBinding() {
                continueRadio.setVisible(isContinuePossible());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_VISIBLE, true ,"existingValue") {
        
            @Override
            public void processDataBinding() {
                remove.setVisible(isExistingValue());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getFactorNameField() != null) {
                    $bindingSources.put("getFactorNameField().getDocument()", getFactorNameField().getDocument());
                    getFactorNameField().getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    getFactorNameField().addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.isisfish.ui.sensitivity.FactorWizardUI.this, BINDING_SAVE_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getFactorNameField() != null && getFactorNameField().getText() != null) {
                    save.setEnabled(!getFactorNameField().getText().isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getFactorNameField() != null) {
                    Document $target = (Document) $bindingSources.remove("getFactorNameField().getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    }
                    getFactorNameField().removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.isisfish.ui.sensitivity.FactorWizardUI.this, BINDING_SAVE_ENABLED));
                }
            }
        
            public void $pr$u0(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

}