/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.Zone;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.JAXXComboBox;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;
import org.nuiton.math.matrix.gui.MatrixPanelListener;
import static org.nuiton.i18n.I18n._;

public class PopulationMigrationImmigrationUI extends InputContentUI<Population> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_COEF_NON_VIDE = "coefNonVide";
    public static final String PROPERTY_GPOP_SELECTED = "gPopSelected";
    public static final String PROPERTY_POP_INFO = "popInfo";
    public static final String PROPERTY_ZONE_DEPART_SELECTED = "zoneDepartSelected";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_FIELD_POPULATION_MIGRATION_IMMIGRATION_ARRIVAL_ZONE_CHOOSER_ENABLED = "fieldPopulationMigrationImmigrationArrivalZoneChooser.enabled";
    public static final String BINDING_FIELD_POPULATION_MIGRATION_IMMIGRATION_COEFFICIENT_ENABLED = "fieldPopulationMigrationImmigrationCoefficient.enabled";
    public static final String BINDING_FIELD_POPULATION_MIGRATION_IMMIGRATION_GROUP_CHOOSER_ENABLED = "fieldPopulationMigrationImmigrationGroupChooser.enabled";
    public static final String BINDING_POPULATION_MIGRATION_IMMIGRATION_TABLE_ENABLED = "populationMigrationImmigrationTable.enabled";
    public static final String BINDING_REMOVE_ENABLED = "remove.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVS28TMRB2Qx+0BQotVEUUUWgFSMCmRSAO5dWmFFLSggggRC54s05itLGN7S0LB8RP4CfAnQsSN06IA2cOXBB/ASEOXBFj57HddpuulBy8u56Zb74Zj7+8/4X6lETHn+IwdGTANK0TZ2Xh0aM77lNS1ktElSUVmkvU+PVkUKaEhr32vtJoulQw4dlmeDbH64IzwjZEzxfQkNIvfKJqhGiNjsYjykpli23zfCgC2UJtk0pCffvnd+aN9/pdBqFQALtRKGVqp6iokt4CylBPo1HItI6zPmZVoCEpqwLfvWYv52Ol1nCdPEOv0EAB9QssAUyjE+lLthg2PhQa7Z/JMxHoHGca3B/kZzW6UpEOrUhSJ/BUVFWoqjkBdahxdO5yEfhYU85WaVXal3y93np9kBfCgvdr1OsSzDQ6lQQHuaimRG2AiwIHBBd5VuEazaWMLRKsgAfERCh7qmAvEh/GhkBTD5j+OaanziLnPlCLXEdfQrOWCDRTtwKM5WDkMVzmpLLG2UPqkU2mXpd7LwDD4IeOeg7H5azcxYz4GyqauY9dn0BzJ2Lj0PC2NuN5uB2we2algF3iz24GtrvGabLtm61Q4nudz+Wm5IHI1ThXRGp0LIGEuWQwNi5f5GEcv8Vlznwfj9ucFLlz0LoKLVM7qOOxau6TUC8bhOSM5xMyXkyRcUFKuo79x3CqzZpN8MyWJPaUZs33kbhtF/ZgZMZiXBcDrTmL+02LjjzswWp0lsuqwwIK4U4d65pZJA2dKlyqVftqidzwwEPGE/TD7PN1OxznmxaJjsSOD8TKicQqUpOeEuqTAWzD0JW26ts9MDWUbWKTshlAa/03Pvb908+Pyy05G4HchxJdN6gxyIyQXMCYUZN6pKFlgaZ+dhWL+RIaVPaKWameTCBWbJqBHORrXFsT7tzCqgYQfQM/Pn8Zf/JtF8osoyGfY28ZG/88GtQ1CV3gvheKa9ctoz3Pd8O633CDW0iYORA42X2XPazxlEuZB2d7NYQuTCZ0oU3FHfz6d6z44XqrEz3A7PC27lE3+h6jfsp8yoiV9qZqJ0r5sFAk8Hikzkl63WOeU6IpLFfsupBUaq+GmwXacbmRfQprGDM30ARqNUE3bBHm7WZKTLOdM8tSMsJ01wgnUyHcNkuhG4ROHE53jXCm6yrSIXTicC49wjYc5rquIh1CpyoupJjzYTPdWK5yr/GvuA2ZnaF2InOp64YYhP+tTVxv3woAAA==";
    private static final Log log = LogFactory.getLog(PopulationMigrationImmigrationUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton add;
    protected Population bean;
    protected Boolean coefNonVide;
    protected JAXXComboBox fieldPopulationMigrationImmigrationArrivalZoneChooser;
    protected JTextField fieldPopulationMigrationImmigrationCoefficient;
    protected JAXXComboBox fieldPopulationMigrationImmigrationGroupChooser;
    protected Boolean gPopSelected;
    protected PopulationSeasonInfo popInfo;
    protected MatrixPanelEditor populationMigrationImmigrationTable;
    protected JButton remove;
    protected Boolean zoneDepartSelected;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private PopulationMigrationImmigrationUI $InputContentUI0 = this;
    private Table $Table0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
        addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    populationMigrationImmigrationTable.setMatrix(null);
                }
                if (evt.getNewValue() != null) {
                    refreshPanel();
                }
            }
        });
    }
    
    protected void populationMigrationImmigrationMatrixChanged(MatrixPanelEvent event) {
        if (getPopInfo() != null){
            getPopInfo().setImmigrationMatrix(populationMigrationImmigrationTable.getMatrix().clone());
        }
    }
    
    public void init(PopulationSeasonInfo populationSeasonInfo) {
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        //setPopInfo(null);
        //setPopInfo(populationSeasonInfo);
    
        populationMigrationImmigrationTable.setMatrix(getPopInfo().getImmigrationMatrix().copy());
    }
    
    /*public void refresh(){
        Population population = getVerifier().getEntity(Population.class);
        setBean(population);
    
        refreshPanel();
    }*/
    
    public void refreshPanel(){
        setFieldPopulationMigrationMigrationGroupChooserModel();
        setFieldPopulationMigrationMigrationArrivalZoneChooserModel();
        setAddButton();
    }
    protected void setFieldPopulationMigrationMigrationGroupChooserModel(){
        if (getBean() != null && getBean().getPopulationGroup() != null){
             jaxx.runtime.SwingUtil.fillComboBox(fieldPopulationMigrationImmigrationGroupChooser, getBean().getPopulationGroup(), null, true);
        }
    }
    protected void setFieldPopulationMigrationMigrationArrivalZoneChooserModel(){
        if (getBean() != null && getBean().getPopulationZone() != null){
            jaxx.runtime.SwingUtil.fillComboBox(fieldPopulationMigrationImmigrationArrivalZoneChooser, getBean().getPopulationZone(), null, true);
        }
    }
    protected void add() {
        getContextValue(InputAction.class).addImmigration(getPopInfo(),
                (PopulationGroup) fieldPopulationMigrationImmigrationGroupChooser.getSelectedItem(),
                (Zone) fieldPopulationMigrationImmigrationArrivalZoneChooser.getSelectedItem(),
                Double.parseDouble(fieldPopulationMigrationImmigrationCoefficient.getText()));
        populationMigrationImmigrationTable.setMatrix(getPopInfo().getImmigrationMatrix().clone());
    }
    protected void remove() {
          int row = populationMigrationImmigrationTable.getTable().getSelectedRow();
          if (row != -1) {
              Object group = populationMigrationImmigrationTable.getTable().getValueAt(row, 0);
              Object departure = populationMigrationImmigrationTable.getTable().getValueAt(row, 1);
        
              MatrixND mat = getPopInfo().getImmigrationMatrix().clone();
              mat.setValue(group, departure, 0);
              getPopInfo().setImmigrationMatrix(mat);
              populationMigrationImmigrationTable.setMatrix(getPopInfo().getImmigrationMatrix().copy());
          }
    }
    protected void groupChanged(){
        setGPopSelected(fieldPopulationMigrationImmigrationGroupChooser.getSelectedItem() != null);
        setAddButton();
    }
    protected void coefChanged(){
        setCoefNonVide(!fieldPopulationMigrationImmigrationCoefficient.getText().equals(""));
        setAddButton();
    }
    protected void zoneChanged(){
        setZoneDepartSelected(fieldPopulationMigrationImmigrationArrivalZoneChooser.getSelectedItem() != null);
        setAddButton();
    }
    protected void setAddButton(){
        add.setEnabled(getGPopSelected() && getZoneDepartSelected() && getCoefNonVide());
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PopulationMigrationImmigrationUI() {
        $initialize();
    }

    public PopulationMigrationImmigrationUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public PopulationMigrationImmigrationUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PopulationMigrationImmigrationUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationMigrationImmigrationUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PopulationMigrationImmigrationUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationMigrationImmigrationUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationMigrationImmigrationUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__add(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        add();
    }

    public void doActionPerformed__on__fieldPopulationMigrationImmigrationArrivalZoneChooser(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        zoneChanged();
    }

    public void doActionPerformed__on__fieldPopulationMigrationImmigrationGroupChooser(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        groupChanged();
    }

    public void doActionPerformed__on__remove(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        remove();
    }

    public void doKeyReleased__on__fieldPopulationMigrationImmigrationCoefficient(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        coefChanged();
    }

    public void doMatrixChanged__on__populationMigrationImmigrationTable(MatrixPanelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        populationMigrationImmigrationMatrixChanged(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAdd() {
        return add;
    }

    public Population getBean() {
        return bean;
    }

    public Boolean getCoefNonVide() {
        return coefNonVide;
    }

    public JAXXComboBox getFieldPopulationMigrationImmigrationArrivalZoneChooser() {
        return fieldPopulationMigrationImmigrationArrivalZoneChooser;
    }

    public JTextField getFieldPopulationMigrationImmigrationCoefficient() {
        return fieldPopulationMigrationImmigrationCoefficient;
    }

    public JAXXComboBox getFieldPopulationMigrationImmigrationGroupChooser() {
        return fieldPopulationMigrationImmigrationGroupChooser;
    }

    public Boolean getGPopSelected() {
        return gPopSelected;
    }

    public PopulationSeasonInfo getPopInfo() {
        return popInfo;
    }

    public MatrixPanelEditor getPopulationMigrationImmigrationTable() {
        return populationMigrationImmigrationTable;
    }

    public JButton getRemove() {
        return remove;
    }

    public Boolean getZoneDepartSelected() {
        return zoneDepartSelected;
    }

    public Boolean isCoefNonVide() {
        return coefNonVide !=null && coefNonVide;
    }

    public Boolean isGPopSelected() {
        return gPopSelected !=null && gPopSelected;
    }

    public Boolean isZoneDepartSelected() {
        return zoneDepartSelected !=null && zoneDepartSelected;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Population bean) {
        Population oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setCoefNonVide(Boolean coefNonVide) {
        Boolean oldValue = this.coefNonVide;
        this.coefNonVide = coefNonVide;
        firePropertyChange(PROPERTY_COEF_NON_VIDE, oldValue, coefNonVide);
    }

    public void setGPopSelected(Boolean gPopSelected) {
        Boolean oldValue = this.gPopSelected;
        this.gPopSelected = gPopSelected;
        firePropertyChange(PROPERTY_GPOP_SELECTED, oldValue, gPopSelected);
    }

    public void setPopInfo(PopulationSeasonInfo popInfo) {
        PopulationSeasonInfo oldValue = this.popInfo;
        this.popInfo = popInfo;
        firePropertyChange(PROPERTY_POP_INFO, oldValue, popInfo);
    }

    public void setZoneDepartSelected(Boolean zoneDepartSelected) {
        Boolean oldValue = this.zoneDepartSelected;
        this.zoneDepartSelected = zoneDepartSelected;
        firePropertyChange(PROPERTY_ZONE_DEPART_SELECTED, oldValue, zoneDepartSelected);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void createAdd() {
        $objectMap.put("add", add = new JButton());
        
        add.setName("add");
        add.setEnabled(false);
        add.setText(_("isisfish.common.add"));
        add.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__add"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCoefNonVide() {
        $objectMap.put("coefNonVide", coefNonVide = false);
    }

    protected void createFieldPopulationMigrationImmigrationArrivalZoneChooser() {
        $objectMap.put("fieldPopulationMigrationImmigrationArrivalZoneChooser", fieldPopulationMigrationImmigrationArrivalZoneChooser = new JAXXComboBox());
        
        fieldPopulationMigrationImmigrationArrivalZoneChooser.setName("fieldPopulationMigrationImmigrationArrivalZoneChooser");
        fieldPopulationMigrationImmigrationArrivalZoneChooser.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldPopulationMigrationImmigrationArrivalZoneChooser"));
    }

    protected void createFieldPopulationMigrationImmigrationCoefficient() {
        $objectMap.put("fieldPopulationMigrationImmigrationCoefficient", fieldPopulationMigrationImmigrationCoefficient = new JTextField());
        
        fieldPopulationMigrationImmigrationCoefficient.setName("fieldPopulationMigrationImmigrationCoefficient");
        fieldPopulationMigrationImmigrationCoefficient.setColumns(15);
        fieldPopulationMigrationImmigrationCoefficient.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldPopulationMigrationImmigrationCoefficient"));
    }

    protected void createFieldPopulationMigrationImmigrationGroupChooser() {
        $objectMap.put("fieldPopulationMigrationImmigrationGroupChooser", fieldPopulationMigrationImmigrationGroupChooser = new JAXXComboBox());
        
        fieldPopulationMigrationImmigrationGroupChooser.setName("fieldPopulationMigrationImmigrationGroupChooser");
        fieldPopulationMigrationImmigrationGroupChooser.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldPopulationMigrationImmigrationGroupChooser"));
    }

    protected void createGPopSelected() {
        $objectMap.put("gPopSelected", gPopSelected = false);
    }

    protected void createPopInfo() {
        $objectMap.put("popInfo", popInfo = null);
    }

    protected void createPopulationMigrationImmigrationTable() {
        $objectMap.put("populationMigrationImmigrationTable", populationMigrationImmigrationTable = new MatrixPanelEditor());
        
        populationMigrationImmigrationTable.setName("populationMigrationImmigrationTable");
        populationMigrationImmigrationTable.setLinearModel(true);
        populationMigrationImmigrationTable.addMatrixPanelListener(JAXXUtil.getEventListener(MatrixPanelListener.class, "matrixChanged", this, "doMatrixChanged__on__populationMigrationImmigrationTable"));
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new JButton());
        
        remove.setName("remove");
        remove.setText(_("isisfish.common.remove"));
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    protected void createZoneDepartSelected() {
        $objectMap.put("zoneDepartSelected", zoneDepartSelected = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldPopulationMigrationImmigrationGroupChooser, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldPopulationMigrationImmigrationCoefficient, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldPopulationMigrationImmigrationArrivalZoneChooser, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(2, 1, 2, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(add, new GridBagConstraints(0, 2, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(populationMigrationImmigrationTable, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(remove, new GridBagConstraints(0, 4, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 8 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createPopInfo();
        createGPopSelected();
        createZoneDepartSelected();
        createCoefNonVide();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("isisfish.common.populationGroup"));
        createFieldPopulationMigrationImmigrationGroupChooser();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("isisfish.populationMigrationImmigration.coefficient"));
        createFieldPopulationMigrationImmigrationCoefficient();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.populationMigrationImmigration.arrivalZone"));
        createFieldPopulationMigrationImmigrationArrivalZoneChooser();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        createAdd();
        createPopulationMigrationImmigrationTable();
        createRemove();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 8 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 8 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MIGRATION_IMMIGRATION_GROUP_CHOOSER_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMigrationImmigrationGroupChooser.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MIGRATION_IMMIGRATION_COEFFICIENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMigrationImmigrationCoefficient.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MIGRATION_IMMIGRATION_ARRIVAL_ZONE_CHOOSER_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMigrationImmigrationArrivalZoneChooser.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_MIGRATION_IMMIGRATION_TABLE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                populationMigrationImmigrationTable.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                remove.setEnabled(isActive());
            }
        });
    }

}