/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.Zone;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.JAXXComboBox;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;
import org.nuiton.math.matrix.gui.MatrixPanelListener;
import static org.nuiton.i18n.I18n._;

public class PopulationMigrationEmigrationUI extends InputContentUI<Population> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_COEF_NON_VIDE = "coefNonVide";
    public static final String PROPERTY_GPOP_SELECTED = "gPopSelected";
    public static final String PROPERTY_POP_INFO = "popInfo";
    public static final String PROPERTY_ZONE_DEPART_SELECTED = "zoneDepartSelected";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_FIELD_POPULATION_MIGRATION_EMIGRATION_COEFFICIENT_ENABLED = "fieldPopulationMigrationEmigrationCoefficient.enabled";
    public static final String BINDING_FIELD_POPULATION_MIGRATION_EMIGRATION_DEPARTURE_ZONE_CHOOSER_ENABLED = "fieldPopulationMigrationEmigrationDepartureZoneChooser.enabled";
    public static final String BINDING_FIELD_POPULATION_MIGRATION_EMIGRATION_GROUP_CHOOSER_ENABLED = "fieldPopulationMigrationEmigrationGroupChooser.enabled";
    public static final String BINDING_POPULATION_MIGRATION_EMIGRATION_TABLE_ENABLED = "populationMigrationEmigrationTable.enabled";
    public static final String BINDING_REMOVE_ENABLED = "remove.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVy24TMRR1Qx+UAoUWKiqKaEsFSMCkRQgWLa+mD1JSQAQQIhs8GScxmtjG9rRTFohP4BNgzwaJHSvEgjULNohfQIgFW8S185hOmSaRkoUzmXvvuec+fPLuJ+pTEk09w2HoyIBpWiXO2s3Hj++6z0hRLxFVlFRoLlHt05NCqQIa8prvlUanCjkTnq6HpzO8KjgjbFv0fA7tU3rLJ6pCiNboRDyiqFQ63zTPhyKQDdQmqSTUN79/pV57r96mEAoFsBuBUibbRUWV9OZQinoajUCmDZz2MSsDDUlZGfgeMO8yPlbqDq6S5+glGsihfoElgGk03XnJFsPGh0KjQzNZJgKd4UyD+8PsrEYLJenQkiRVAt+KqhJVFSegDjWOzj0uAh9rytk6LUv7sFxtPD3MCmGx+zXqdQlmGp1JQoNUVFOitqFFgQOCiywrcY3mOozNE6w4MzERyv4y2PPEh60h0NPDpn2OaamzyLkP1CLXkRfQqyUCvdSNAGM5EnkMFTkp3eHsEfXIDlOvy70twDD4oaM2YVrO2j3MiL+topkH2PUJ9PZYbBtq3tZmPMebAXtn1nLYJf7sTmD71jhNNH2dEiW+13Isq5IHIlPhXBGp0ckEDuaKwdK4fJGHcfgGlTnzeypuu9A+dQYaV6JFard0LFbLAxLqFQOQnPBiQsLL7RPW5hhI8gSGWq/ZRM/8l8UOadb8Ph637cEebMxojOxioDVncb9p0YqIHatG57ksOyygEO1Usa6YQ9LQKcONWrePlseyBx4yjt8Pm8837GpcrFskOh6bHiiVEylVJCU9BdQnA3gNK1f4X9zug6kma8d2yJoBtNa/Y6PfPv74sNLQsmHIfTTRdZsUg8YIyQVsGTWph2tCFmjqp9exmC+gQWUvmNXpiQRi+boZyEG+2qU14c4trCoA0Tfw/dPnsadf96DUCtrnc+ytYOOfRYO6IqEL3PdCcf2GZbR/cy+chww3uIOEmYHAYA8ueFjjSZcyD0Z7LYQuTCR0oUnFHfzyZzT//kajEz3AbHxX96gbfU9QP2U+ZcTqel2yE3V8SCgSeDyS5iSx7jHfk6IuK1fteTOp1F4NNwuUY6GWfRJrWDM30ARqNUHLtgjztNohpnmdMcdSMsKprhFOd4Rw2xy5bhBacTjbNcK5rqvoDKEVhwudI+zCYa7rKjpDaFXFpQ72fMhsN5br3Kv9J+5Cpj1UOzJXum6IQfgHiYodH9wKAAA=";
    private static final Log log = LogFactory.getLog(PopulationMigrationEmigrationUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton add;
    protected Population bean;
    protected Boolean coefNonVide;
    protected JTextField fieldPopulationMigrationEmigrationCoefficient;
    protected JAXXComboBox fieldPopulationMigrationEmigrationDepartureZoneChooser;
    protected JAXXComboBox fieldPopulationMigrationEmigrationGroupChooser;
    protected Boolean gPopSelected;
    protected PopulationSeasonInfo popInfo;
    protected MatrixPanelEditor populationMigrationEmigrationTable;
    protected JButton remove;
    protected Boolean zoneDepartSelected;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private PopulationMigrationEmigrationUI $InputContentUI0 = this;
    private Table $Table0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
        addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    populationMigrationEmigrationTable.setMatrix(null);
                }
                if (evt.getNewValue() != null) {
                    refreshPanel();
                }
            }
        });
    }
    
    public void init(PopulationSeasonInfo pi){
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        //setPopInfo(null);
        //setPopInfo(pi);
        populationMigrationEmigrationTable.setMatrix(getPopInfo().getEmigrationMatrix().copy());
    }
    
    /*public void refresh(){
        Population population = getSaveVerifier().getEntity(Population.class);
    
        // setBean(null); useless here
        setBean(population);
    
        refreshPanel();
    }*/
    
    public void refreshPanel() {
        setFieldPopulationMigrationMigrationGroupChooserModel();
        setFieldPopulationMigrationMigrationDepartureZoneChooserModel();
        setAddButton();
    }
        
    protected void populationMigrationEmigrationMatrixChanged(MatrixPanelEvent event) {
        remove.setEnabled(populationMigrationEmigrationTable.getTable().getSelectedRow() != -1);
        if (popInfo != null){
            popInfo.setMigrationMatrix(populationMigrationEmigrationTable.getMatrix().clone());
        }
    }
    
    protected void setFieldPopulationMigrationMigrationGroupChooserModel(){
        if (getBean() != null && getBean().getPopulationGroup() != null){
            jaxx.runtime.SwingUtil.fillComboBox(fieldPopulationMigrationEmigrationGroupChooser,getBean().getPopulationGroup(), null, true);
        }
    }
    protected void setFieldPopulationMigrationMigrationDepartureZoneChooserModel(){
        if (getBean() != null && getBean().getPopulationZone() != null){
            jaxx.runtime.SwingUtil.fillComboBox(fieldPopulationMigrationEmigrationDepartureZoneChooser,getBean().getPopulationZone(), null, true);
        }
    }
    protected void add(){
        getContextValue(InputAction.class).addEmigration(
                getPopInfo(),
                (PopulationGroup) fieldPopulationMigrationEmigrationGroupChooser.getSelectedItem(),
                (Zone) fieldPopulationMigrationEmigrationDepartureZoneChooser.getSelectedItem(),
                Double.parseDouble(fieldPopulationMigrationEmigrationCoefficient.getText()));
         populationMigrationEmigrationTable.setMatrix(getPopInfo().getEmigrationMatrix().clone());
    }
    
    protected void remove() {
        int row = populationMigrationEmigrationTable.getTable().getSelectedRow();
        if (row != -1) {
            Object group = populationMigrationEmigrationTable.getTable().getValueAt(row, 0);
            Object arrival = populationMigrationEmigrationTable.getTable().getValueAt(row, 1);
        
            MatrixND mat = popInfo.getEmigrationMatrix().clone();
            mat.setValue(group, arrival, 0);
            popInfo.setEmigrationMatrix(mat);
            populationMigrationEmigrationTable.setMatrix(getPopInfo().getEmigrationMatrix().copy());
        }
    }
    protected void groupChanged() {
        setGPopSelected(fieldPopulationMigrationEmigrationGroupChooser.getSelectedItem() != null);
        setAddButton();
    }
    protected void coefChanged() {
        setCoefNonVide(!fieldPopulationMigrationEmigrationCoefficient.getText().equals(""));
        setAddButton();
    }
    protected void zoneChanged() {
        setZoneDepartSelected(fieldPopulationMigrationEmigrationDepartureZoneChooser.getSelectedItem() != null);
        setAddButton();
    }
    protected void setAddButton() {
        add.setEnabled(getGPopSelected() && getZoneDepartSelected() && getCoefNonVide());
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PopulationMigrationEmigrationUI() {
        $initialize();
    }

    public PopulationMigrationEmigrationUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public PopulationMigrationEmigrationUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PopulationMigrationEmigrationUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationMigrationEmigrationUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PopulationMigrationEmigrationUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationMigrationEmigrationUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationMigrationEmigrationUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__add(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        add();
    }

    public void doActionPerformed__on__fieldPopulationMigrationEmigrationDepartureZoneChooser(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        zoneChanged();
    }

    public void doActionPerformed__on__fieldPopulationMigrationEmigrationGroupChooser(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        groupChanged();
    }

    public void doActionPerformed__on__remove(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        remove();
    }

    public void doKeyReleased__on__fieldPopulationMigrationEmigrationCoefficient(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        coefChanged();
    }

    public void doMatrixChanged__on__populationMigrationEmigrationTable(MatrixPanelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        populationMigrationEmigrationMatrixChanged(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAdd() {
        return add;
    }

    public Population getBean() {
        return bean;
    }

    public Boolean getCoefNonVide() {
        return coefNonVide;
    }

    public JTextField getFieldPopulationMigrationEmigrationCoefficient() {
        return fieldPopulationMigrationEmigrationCoefficient;
    }

    public JAXXComboBox getFieldPopulationMigrationEmigrationDepartureZoneChooser() {
        return fieldPopulationMigrationEmigrationDepartureZoneChooser;
    }

    public JAXXComboBox getFieldPopulationMigrationEmigrationGroupChooser() {
        return fieldPopulationMigrationEmigrationGroupChooser;
    }

    public Boolean getGPopSelected() {
        return gPopSelected;
    }

    public PopulationSeasonInfo getPopInfo() {
        return popInfo;
    }

    public MatrixPanelEditor getPopulationMigrationEmigrationTable() {
        return populationMigrationEmigrationTable;
    }

    public JButton getRemove() {
        return remove;
    }

    public Boolean getZoneDepartSelected() {
        return zoneDepartSelected;
    }

    public Boolean isCoefNonVide() {
        return coefNonVide !=null && coefNonVide;
    }

    public Boolean isGPopSelected() {
        return gPopSelected !=null && gPopSelected;
    }

    public Boolean isZoneDepartSelected() {
        return zoneDepartSelected !=null && zoneDepartSelected;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Population bean) {
        Population oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setCoefNonVide(Boolean coefNonVide) {
        Boolean oldValue = this.coefNonVide;
        this.coefNonVide = coefNonVide;
        firePropertyChange(PROPERTY_COEF_NON_VIDE, oldValue, coefNonVide);
    }

    public void setGPopSelected(Boolean gPopSelected) {
        Boolean oldValue = this.gPopSelected;
        this.gPopSelected = gPopSelected;
        firePropertyChange(PROPERTY_GPOP_SELECTED, oldValue, gPopSelected);
    }

    public void setPopInfo(PopulationSeasonInfo popInfo) {
        PopulationSeasonInfo oldValue = this.popInfo;
        this.popInfo = popInfo;
        firePropertyChange(PROPERTY_POP_INFO, oldValue, popInfo);
    }

    public void setZoneDepartSelected(Boolean zoneDepartSelected) {
        Boolean oldValue = this.zoneDepartSelected;
        this.zoneDepartSelected = zoneDepartSelected;
        firePropertyChange(PROPERTY_ZONE_DEPART_SELECTED, oldValue, zoneDepartSelected);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void createAdd() {
        $objectMap.put("add", add = new JButton());
        
        add.setName("add");
        add.setEnabled(false);
        add.setText(_("isisfish.common.add"));
        add.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__add"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCoefNonVide() {
        $objectMap.put("coefNonVide", coefNonVide = false);
    }

    protected void createFieldPopulationMigrationEmigrationCoefficient() {
        $objectMap.put("fieldPopulationMigrationEmigrationCoefficient", fieldPopulationMigrationEmigrationCoefficient = new JTextField());
        
        fieldPopulationMigrationEmigrationCoefficient.setName("fieldPopulationMigrationEmigrationCoefficient");
        fieldPopulationMigrationEmigrationCoefficient.setColumns(15);
        fieldPopulationMigrationEmigrationCoefficient.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldPopulationMigrationEmigrationCoefficient"));
    }

    protected void createFieldPopulationMigrationEmigrationDepartureZoneChooser() {
        $objectMap.put("fieldPopulationMigrationEmigrationDepartureZoneChooser", fieldPopulationMigrationEmigrationDepartureZoneChooser = new JAXXComboBox());
        
        fieldPopulationMigrationEmigrationDepartureZoneChooser.setName("fieldPopulationMigrationEmigrationDepartureZoneChooser");
        fieldPopulationMigrationEmigrationDepartureZoneChooser.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldPopulationMigrationEmigrationDepartureZoneChooser"));
    }

    protected void createFieldPopulationMigrationEmigrationGroupChooser() {
        $objectMap.put("fieldPopulationMigrationEmigrationGroupChooser", fieldPopulationMigrationEmigrationGroupChooser = new JAXXComboBox());
        
        fieldPopulationMigrationEmigrationGroupChooser.setName("fieldPopulationMigrationEmigrationGroupChooser");
        fieldPopulationMigrationEmigrationGroupChooser.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldPopulationMigrationEmigrationGroupChooser"));
    }

    protected void createGPopSelected() {
        $objectMap.put("gPopSelected", gPopSelected = false);
    }

    protected void createPopInfo() {
        $objectMap.put("popInfo", popInfo = null);
    }

    protected void createPopulationMigrationEmigrationTable() {
        $objectMap.put("populationMigrationEmigrationTable", populationMigrationEmigrationTable = new MatrixPanelEditor());
        
        populationMigrationEmigrationTable.setName("populationMigrationEmigrationTable");
        populationMigrationEmigrationTable.setLinearModel(true);
        populationMigrationEmigrationTable.addMatrixPanelListener(JAXXUtil.getEventListener(MatrixPanelListener.class, "matrixChanged", this, "doMatrixChanged__on__populationMigrationEmigrationTable"));
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new JButton());
        
        remove.setName("remove");
        remove.setText(_("isisfish.common.remove"));
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    protected void createZoneDepartSelected() {
        $objectMap.put("zoneDepartSelected", zoneDepartSelected = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldPopulationMigrationEmigrationGroupChooser, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldPopulationMigrationEmigrationCoefficient, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldPopulationMigrationEmigrationDepartureZoneChooser, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(2, 1, 2, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(add, new GridBagConstraints(0, 2, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(populationMigrationEmigrationTable, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(remove, new GridBagConstraints(0, 4, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 8 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createPopInfo();
        createGPopSelected();
        createZoneDepartSelected();
        createCoefNonVide();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("isisfish.common.populationGroup"));
        createFieldPopulationMigrationEmigrationGroupChooser();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("isisfish.populationMigrationEmigration.coefficient"));
        createFieldPopulationMigrationEmigrationCoefficient();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.populationMigrationEmigration.departureZone"));
        createFieldPopulationMigrationEmigrationDepartureZoneChooser();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        createAdd();
        createPopulationMigrationEmigrationTable();
        createRemove();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 8 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 8 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MIGRATION_EMIGRATION_GROUP_CHOOSER_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMigrationEmigrationGroupChooser.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MIGRATION_EMIGRATION_COEFFICIENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMigrationEmigrationCoefficient.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MIGRATION_EMIGRATION_DEPARTURE_ZONE_CHOOSER_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMigrationEmigrationDepartureZoneChooser.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_MIGRATION_EMIGRATION_TABLE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                populationMigrationEmigrationTable.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                remove.setEnabled(isActive());
            }
        });
    }

}