/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer, CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.mexico.xml;

import org.nuiton.math.matrix.MatrixND;

import fr.ifremer.isisfish.mexico.MexicoHelper;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.MatrixContinuousDomain;

/**
 * XML domain visitor for Matrix continuous.
 *
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 5 mars 2009 $
 * By : $Author: chatellier $
 */
public class MatrixContinuousDomainXMLVisitor extends ContinuousDomainXMLVisitor {

    /**
     * {@inheritDoc}
     */
    @Override
    protected void appendDomain(ContinuousDomain domain) {

        MatrixContinuousDomain mDomain = (MatrixContinuousDomain)domain;

        // facteur continue pourcentage
        if (domain.isPercentageType()) {
            xmlBuffer.append("<reference coefficient=\"")
                     .append(mDomain.getCoefficient())
                     .append("\">");
            xmlBuffer.append(MexicoHelper.getMatrixAsXML((MatrixND)mDomain.getReferenceValue()));
            xmlBuffer.append("</reference>");
        }
        else {
            // facteur continue min/max
            xmlBuffer.append("<range>");
            xmlBuffer.append("<min>")
                     .append(MexicoHelper.getMatrixAsXML((MatrixND)mDomain.getMinBound()))
                     .append("</min>");
            xmlBuffer.append("<max>")
                     .append(MexicoHelper.getMatrixAsXML((MatrixND)mDomain.getMaxBound()))
                     .append("</max>");
            xmlBuffer.append("</range>");
        }
    }
}
