/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util;

import com.sun.tools.doclets.standard.Standard;
import com.sun.tools.javadoc.Main;
import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.FormuleStorage;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.util.CompileHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;

public class JavadocHelper {
    private static final Log log = LogFactory.getLog(JavadocHelper.class);
    protected static final String JAVADOC_TOOL_NAME = "javadoc";

    public static int generateJavadoc(JavaSourceStorage source, File destDir, boolean force, PrintWriter out) {
        File src = source.getFile();
        File dst = new File(destDir, source.getFQN().replace('.', File.separatorChar) + ".html");
        int result = 0;
        if (force || FileUtil.isNewer((File)src, (File)dst)) {
            result = JavadocHelper.generateJavadoc(source.getRoot(), src, destDir, out);
        }
        return result;
    }

    public static int generateJavadoc(File rootSrc, File dest, PrintWriter out) {
        List javaFiles = FileUtil.getFilteredElements((File)rootSrc, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File f) {
                boolean result = true;
                result &= f.getAbsolutePath().endsWith(".java");
                result &= !f.getAbsolutePath().startsWith(FormuleStorage.getFormuleDirectory().getAbsolutePath());
                return result &= !f.getAbsolutePath().startsWith(SimulationStorage.getSimulationDirectory().getAbsolutePath());
            }
        }, (boolean)true);
        int result = JavadocHelper.generateJavadoc(rootSrc, (Collection<File>)javaFiles, dest, out);
        return result;
    }

    public static int generateJavadoc(File rootSrc, File fileSrc, File dest, PrintWriter out) {
        int result = JavadocHelper.generateJavadoc(rootSrc, Collections.singletonList(fileSrc), dest, out);
        return result;
    }

    public static int generateJavadoc(File rootSrc, Collection<File> filesSrc, File dest, PrintWriter out) {
        int result;
        block2: {
            result = -1;
            try {
                ArrayList<File> classpath = new ArrayList<File>();
                classpath.add(rootSrc.getAbsoluteFile());
                result = JavadocHelper.generateJavadoc(classpath, filesSrc, dest, out);
            }
            catch (Exception eee) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"Javadoc failed", (Throwable)eee);
            }
        }
        return result;
    }

    protected static int generateJavadoc(List<File> classpath, Collection<File> filesSrc, File dest, PrintWriter out) {
        int result;
        block3: {
            result = 0;
            dest.mkdirs();
            try {
                String classpathAsString = CompileHelper.getClassPathAsString(classpath);
                ArrayList<String> args = new ArrayList<String>();
                args.add("-classpath");
                args.add(classpathAsString);
                args.add("-d");
                args.add(dest.getAbsolutePath());
                args.add("-link");
                args.add("http://java.sun.com/javase/6/docs/api/");
                args.add("-link");
                args.add(IsisFish.config.getJavadocURL());
                args.add("-author");
                args.add("-version");
                for (File srcFile : filesSrc) {
                    args.add(srcFile.getAbsolutePath());
                }
                result = Main.execute((String)JAVADOC_TOOL_NAME, (PrintWriter)out, (PrintWriter)out, (PrintWriter)out, (String)Standard.class.getName(), (String[])args.toArray(new String[0]));
            }
            catch (Exception eee) {
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)"Can't generate javadoc", (Throwable)eee);
            }
        }
        return result;
    }
}

