/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.sensitivity;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.DiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationDiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.MatrixContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.RuleDiscreteDomain;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.RangeOfValues;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.types.TimeUnit;
import fr.ifremer.isisfish.ui.SimulationUI;
import fr.ifremer.isisfish.ui.input.InputAction;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.input.InputHandler;
import fr.ifremer.isisfish.ui.input.InputOneEquationUI;
import fr.ifremer.isisfish.ui.input.tree.FisheryDataProvider;
import fr.ifremer.isisfish.ui.input.tree.FisheryTreeHelper;
import fr.ifremer.isisfish.ui.input.tree.FisheryTreeNode;
import fr.ifremer.isisfish.ui.input.tree.FisheryTreeRenderer;
import fr.ifremer.isisfish.ui.sensitivity.ContinuousPanelContainerUI;
import fr.ifremer.isisfish.ui.sensitivity.DefaultContinuousPanelUI;
import fr.ifremer.isisfish.ui.sensitivity.EquationContinuousPanelUI;
import fr.ifremer.isisfish.ui.sensitivity.FactorWizardUI;
import fr.ifremer.isisfish.ui.sensitivity.MatrixContinuousPanelUI;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityTabUI;
import fr.ifremer.isisfish.ui.simulator.RuleChooser;
import fr.ifremer.isisfish.ui.simulator.SimulAction;
import fr.ifremer.isisfish.ui.widget.editor.MonthComponent;
import fr.ifremer.isisfish.ui.widget.editor.StepComponent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityContextable;

public class SensitivityInputHandler
extends InputHandler {
    private static Log log = LogFactory.getLog(SensitivityInputHandler.class);

    public void loadFisheryRegionTree(SensitivityTabUI sensitivityTabUI) {
        FisheryRegion fisheryRegion = sensitivityTabUI.getFisheryRegion();
        if (fisheryRegion == null) {
            sensitivityTabUI.getCardlayoutPrincipal().show(sensitivityTabUI.getInputPanePrincipal(), "none");
            DefaultTreeModel model = new DefaultTreeModel(null);
            sensitivityTabUI.getFisheryRegionTree().setModel(model);
        } else {
            FisheryTreeHelper treeHelper = new FisheryTreeHelper();
            FisheryDataProvider dataProvider = new FisheryDataProvider(fisheryRegion);
            treeHelper.setDataProvider(dataProvider);
            TreeModel model = treeHelper.createTreeModel(fisheryRegion);
            sensitivityTabUI.getFisheryRegionTree().setModel(model);
            sensitivityTabUI.getFisheryRegionTree().setCellRenderer(new FisheryTreeRenderer(dataProvider));
            treeHelper.setUI(sensitivityTabUI.getFisheryRegionTree(), true, false, null);
            sensitivityTabUI.setContextValue(fisheryRegion);
            sensitivityTabUI.setContextValue(treeHelper);
            sensitivityTabUI.setContextValue(model);
            sensitivityTabUI.setContextValue(fisheryRegion.getTopiaContext());
            sensitivityTabUI.getCardlayoutPrincipal().show(sensitivityTabUI.getInputPanePrincipal(), "normale");
        }
    }

    public void nodeSelectionChanged(SensitivityTabUI sensitivityTabUI, TreeSelectionEvent event) {
        Object lastTreePath;
        TreePath newTreePath = event.getNewLeadSelectionPath();
        if (newTreePath != null && (lastTreePath = newTreePath.getLastPathComponent()) instanceof FisheryTreeNode) {
            FisheryTreeNode isisTreeNode = (FisheryTreeNode)((Object)lastTreePath);
            Class internalClass = isisTreeNode.getInternalClass();
            TopiaEntityContextable topiaEntity = null;
            String topiaId = isisTreeNode.getId();
            try {
                if (isisTreeNode.isStaticNode()) {
                    FisheryRegion fisheryRegion = sensitivityTabUI.getContextValue(FisheryRegion.class);
                    TopiaContext topiaContext = fisheryRegion.getTopiaContext();
                    topiaEntity = (TopiaEntityContextable)topiaContext.findByTopiaId(topiaId);
                }
                InputContentUI<?> inputContentUI = this.getUIInstanceForBeanClass(internalClass, sensitivityTabUI);
                inputContentUI.getSaveVerifier().reset();
                if (topiaEntity != null) {
                    inputContentUI.getSaveVerifier().addCurrentEntity(topiaEntity);
                    inputContentUI.getSaveVerifier().setInputContentUI(inputContentUI);
                }
                inputContentUI.setBean(topiaEntity);
                inputContentUI.setActive(topiaEntity != null);
                inputContentUI.setLayer(true);
                inputContentUI.setSensitivity(true);
                sensitivityTabUI.getCardlayoutPrincipal().show(sensitivityTabUI.getInputPanePrincipal(), "normale");
                sensitivityTabUI.getInputPane().removeAll();
                sensitivityTabUI.getInputPane().add(inputContentUI, "Center");
                sensitivityTabUI.getInputPane().repaint();
                sensitivityTabUI.getInputPane().validate();
            }
            catch (Exception ex) {
                throw new IsisFishRuntimeException("Can't display bean " + topiaId, ex);
            }
        }
    }

    public void addNewFactorGroup(SensitivityTabUI sensitivityTabUI, boolean continuous) {
        String factorName = JOptionPane.showInputDialog(sensitivityTabUI, I18n._((String)"isisfish.sensitivity.newfactorname", (Object[])new Object[0]), I18n._((String)"isisfish.sensitivity.title", (Object[])new Object[0]), 3);
        if (StringUtils.isNotBlank((CharSequence)factorName)) {
            FactorGroup rootFactorGroup = sensitivityTabUI.getSimulAction().getFactorGroup();
            FactorGroup factorGroup = new FactorGroup(factorName, continuous);
            rootFactorGroup.addFactor(factorGroup);
            sensitivityTabUI.setFactorModel();
        }
    }

    public void moveFactor(SensitivityTabUI sensitivityTabUI, FactorGroup selectedFactorGroup, List<Factor> movedFactors) {
        try {
            selectedFactorGroup.addAllFactors(movedFactors);
            FactorGroup rootFactorGroup = sensitivityTabUI.getSimulAction().getFactorGroup();
            if (!rootFactorGroup.equals(selectedFactorGroup)) {
                rootFactorGroup.removeAll(movedFactors);
            }
            for (int index = 0; index < rootFactorGroup.size(); ++index) {
                FactorGroup factorGroup;
                Factor factor = rootFactorGroup.get(index);
                if (!(factor instanceof FactorGroup) || (factorGroup = (FactorGroup)factor).equals(selectedFactorGroup)) continue;
                factorGroup.removeAll(movedFactors);
            }
            sensitivityTabUI.setFactorModel();
        }
        catch (IllegalArgumentException ex) {
            JOptionPane.showMessageDialog(sensitivityTabUI, I18n._((String)"isisfish.sensitivity.moveillegal", (Object[])new Object[0]), I18n._((String)"isisfish.sensitivity.title", (Object[])new Object[0]), 0);
        }
    }

    public void factorsTreeMouseClicked(final SensitivityTabUI sensitivityTabUI, MouseEvent e) {
        if (e.getButton() == 3) {
            JPopupMenu menu = new JPopupMenu();
            JMenuItem menuItemDelete = new JMenuItem(I18n._((String)"isisfish.common.delete", (Object[])new Object[0]));
            menuItemDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SensitivityInputHandler.this.deleteSelectedFactors(sensitivityTabUI);
                }
            });
            menu.add(menuItemDelete);
            menu.show(e.getComponent(), e.getX(), e.getY());
        } else if (e.getButton() == 1 && e.getClickCount() == 2) {
            this.factorSelected(sensitivityTabUI);
        }
    }

    protected void factorSelected(SensitivityTabUI sensitivityTabUI) {
        Object[] pathWay;
        Object selectedObject;
        TreePath selectedPath = sensitivityTabUI.getFactorsTree().getSelectionPath();
        if (selectedPath != null && (selectedObject = (pathWay = selectedPath.getPath())[pathWay.length - 1]) != null && !(selectedObject instanceof FactorGroup)) {
            Factor selectedFactor = (Factor)selectedObject;
            FactorWizardUI factorWizardUI = new FactorWizardUI((JAXXContext)sensitivityTabUI);
            SensitivityInputHandler handler = factorWizardUI.getHandler();
            handler.initExistingFactor(factorWizardUI, selectedFactor);
            factorWizardUI.pack();
            factorWizardUI.setLocationRelativeTo(sensitivityTabUI);
            factorWizardUI.setVisible(true);
        }
    }

    protected void deleteSelectedFactors(SensitivityTabUI sensitivityTabUI) {
        Object[] selectedPaths = sensitivityTabUI.getFactorsTree().getSelectionPaths();
        if (!ArrayUtils.isEmpty((Object[])selectedPaths)) {
            for (Object selectedPath : selectedPaths) {
                Object selectedObject;
                Object[] pathWay = ((TreePath)selectedPath).getPath();
                if (pathWay.length < 2 || (selectedObject = pathWay[pathWay.length - 1]) == null || !(selectedObject instanceof Factor)) continue;
                Factor selectedFactor = (Factor)selectedObject;
                FactorGroup selectedFactorGroup = (FactorGroup)pathWay[pathWay.length - 2];
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting factor " + selectedFactor.getName()));
                }
                selectedFactorGroup.remove(selectedFactor);
                sensitivityTabUI.setFactorModel();
            }
        }
    }

    public void initNewFactor(FactorWizardUI factorWizardUI, TopiaEntityContextable bean, String property) {
        String beanProperty = StringUtils.uncapitalize((String)property);
        String path = bean.getTopiaId() + "#" + beanProperty;
        factorWizardUI.setFactorPath(path);
        factorWizardUI.getFactorNameField().setText(bean.toString() + "." + beanProperty);
        Object valueForPath = this.getPropertyValue(bean, beanProperty);
        boolean continuePossible = this.canBeContinue(valueForPath);
        boolean continueSelected = this.isContinue(valueForPath);
        if (continuePossible) {
            factorWizardUI.continuousPanel = this.getContinuousPanel(valueForPath, bean, property);
            factorWizardUI.getContinuousPanelContainer().add((Component)factorWizardUI.continuousPanel, "Center");
        }
        factorWizardUI.setContinuePossible(continuePossible);
        factorWizardUI.setContinueSelected(continueSelected);
        factorWizardUI.getContinueRadio().setSelected(continueSelected);
    }

    public void initNewFactorWithValue(FactorWizardUI factorWizardUI, Object value) {
        boolean continuePossible = this.canBeContinue(value);
        boolean continueSelected = this.isContinue(value);
        if (continuePossible) {
            factorWizardUI.continuousPanel = this.getContinuousPanel(value, null, null);
            factorWizardUI.getContinuousPanelContainer().add((Component)factorWizardUI.continuousPanel, "Center");
        }
        factorWizardUI.setContinuePossible(continuePossible);
        factorWizardUI.setContinueSelected(continueSelected);
        factorWizardUI.getContinueRadio().setSelected(continueSelected);
    }

    public void initExistingFactor(FactorWizardUI factorWizardUI, Factor factor) {
        factorWizardUI.setExistingValue(true);
        String factorPath = factor.getPath();
        Domain domain = factor.getDomain();
        String factorName = factor.getName();
        factorWizardUI.setFactorPath(factorPath);
        factorWizardUI.getComment().setText(factor.getComment());
        if (domain instanceof EquationContinuousDomain) {
            EquationContinuousDomain equationDomain = (EquationContinuousDomain)domain;
            String suffix = equationDomain.getVariableName();
            factorName = StringUtils.removeEnd((String)factorName, (String)("." + suffix));
            factorName = StringUtils.removeEnd((String)factorName, (String)("_" + suffix));
        }
        if (domain instanceof ContinuousDomain) {
            ContinuousDomain cDomain = (ContinuousDomain)domain;
            TopiaContext topiaContext = factorWizardUI.getContextValue(TopiaContext.class);
            factorWizardUI.continuousPanel = this.getContinuousPanelWithValue(factor, cDomain, topiaContext);
            factorWizardUI.getContinuousPanelContainer().add((Component)factorWizardUI.continuousPanel, "Center");
            factorWizardUI.getContinueRadio().setSelected(true);
            factorWizardUI.setContinueSelected(true);
            factorWizardUI.setContinuePossible(true);
        } else {
            DiscreteDomain dDomain = (DiscreteDomain)domain;
            int nb = dDomain.getValues().size();
            factorWizardUI.getDiscretNumber().setText(String.valueOf(nb));
            factorWizardUI.discretComponents.clear();
            factorWizardUI.getTabPane().removeAll();
            SortedMap<Object, Object> values = dDomain.getValues();
            int i = 0;
            for (Object o : values.values()) {
                ++i;
                JComponent c = null;
                if (o != null) {
                    c = this.getEditorWithValue(factorWizardUI, factor, dDomain, o);
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)"Null value in factor");
                }
                factorWizardUI.discretComponents.add(c);
                JScrollPane js = new JScrollPane(c);
                String tabName = I18n._((String)"isisfish.sensitivity.discretevaluelabel", (Object[])new Object[]{i});
                factorWizardUI.getTabPane().addTab(tabName, js);
            }
            if (factorPath.indexOf(35) != -1) {
                try {
                    String topiaId = factorPath.substring(0, factorPath.lastIndexOf(35));
                    String property = factorPath.substring(factorPath.lastIndexOf(35) + 1);
                    TopiaContext topiaContext = factorWizardUI.getContextValue(TopiaContext.class);
                    TopiaEntityContextable entity = (TopiaEntityContextable)topiaContext.findByTopiaId(topiaId);
                    String getter = "get" + StringUtils.capitalize((String)property);
                    Method m = entity.getClass().getMethod(getter, new Class[0]);
                    Object valueForPath = m.invoke((Object)entity, new Object[0]);
                    boolean continuePossible = this.canBeContinue(valueForPath);
                    factorWizardUI.setContinuePossible(continuePossible);
                    if (continuePossible) {
                        factorWizardUI.continuousPanel = this.getContinuousPanel(valueForPath, entity, property);
                        factorWizardUI.getContinuousPanelContainer().add((Component)factorWizardUI.continuousPanel, "Center");
                    }
                }
                catch (Exception ex) {
                    throw new IsisFishRuntimeException("Can't get factor path database value", ex);
                }
            }
        }
        factorWizardUI.getFactorNameField().setText(factorName);
    }

    public void addTabs(FactorWizardUI factorWizardUI) {
        String discreteNumber = factorWizardUI.getDiscretNumber().getText();
        int nbTab = Integer.parseInt(discreteNumber);
        factorWizardUI.discretComponents.clear();
        factorWizardUI.getTabPane().removeAll();
        for (int i = 1; i <= nbTab; ++i) {
            JComponent c = this.getNewDiscreteComponent(factorWizardUI);
            factorWizardUI.discretComponents.add(c);
            String tabName = I18n._((String)"isisfish.sensitivity.discretevaluelabel", (Object[])new Object[]{i});
            factorWizardUI.getTabPane().addTab(tabName, c);
        }
        factorWizardUI.pack();
    }

    protected Class<?> getPropertyClass(String factorPath, TopiaContext context) {
        Class<?> result;
        block4: {
            result = null;
            if (factorPath.indexOf(35) != -1) {
                String topiaId = factorPath.substring(0, factorPath.lastIndexOf(35));
                String property = factorPath.substring(factorPath.lastIndexOf(35) + 1);
                try {
                    TopiaEntity entity = context.findByTopiaId(topiaId);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Factor path " + factorPath + " denoted entity " + entity));
                    }
                    String getter = "get" + StringUtils.capitalize((String)property);
                    Method method = entity.getClass().getMethod(getter, new Class[0]);
                    result = method.getReturnType();
                }
                catch (Exception ex) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)("Can't find entity for " + topiaId), (Throwable)ex);
                }
            }
        }
        return result;
    }

    protected Object getPropertyValue(Object entity, String fieldName) {
        Object result;
        block2: {
            result = null;
            try {
                String getMethod = "get" + StringUtils.capitalize((String)fieldName);
                Method m = entity.getClass().getMethod(getMethod, new Class[0]);
                result = m.invoke(entity, new Object[0]);
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't get entity value", (Throwable)ex);
            }
        }
        return result;
    }

    public boolean canBeFactor(Class type) {
        boolean result = false;
        if (TopiaEntity.class.isAssignableFrom(type)) {
            result = true;
        } else if (Double.TYPE.isAssignableFrom(type)) {
            result = true;
        } else if (Number.class.isAssignableFrom(type)) {
            result = true;
        } else if (TimeStep.class.isAssignableFrom(type)) {
            result = true;
        } else if (Month.class.isAssignableFrom(type)) {
            result = true;
        }
        return result;
    }

    public boolean canBeContinue(Object value) {
        boolean result = false;
        if (value instanceof Double) {
            result = true;
        } else if (value instanceof Long) {
            result = true;
        } else if (value instanceof Equation) {
            result = true;
        } else if (value instanceof MatrixND) {
            result = true;
        } else if (value instanceof RangeOfValues) {
            RangeOfValues rangeOfValues = (RangeOfValues)value;
            if (rangeOfValues.getType().equals("Float")) {
                result = true;
            }
        } else if (value instanceof TimeUnit) {
            result = true;
        } else if (value instanceof String) {
            result = true;
        }
        return result;
    }

    public boolean isContinue(Object value) {
        String textValue;
        RangeOfValues range;
        boolean result = false;
        if (value instanceof RangeOfValues && (range = (RangeOfValues)value).getType().equals("Float") && (textValue = range.getValues()).matches("^\\ *[0-9]*\\ *\\-\\ *[0-9]*\\ *$")) {
            result = true;
        }
        return result;
    }

    public ContinuousPanelContainerUI getContinuousPanel(Object value, TopiaEntityContextable bean, String property) {
        ContinuousPanelContainerUI result;
        if (value instanceof RangeOfValues) {
            int first;
            RangeOfValues rangeOfValues = (RangeOfValues)value;
            DefaultContinuousPanelUI ui = new DefaultContinuousPanelUI();
            String values = rangeOfValues.getValues();
            String min = "0";
            String max = "0";
            if (values.matches("^\\ *[0-9]*\\ *\\-\\ *[0-9]*\\ *$") && (first = values.indexOf("-")) != -1) {
                min = values.substring(0, first);
                max = values.substring(first + 1);
            }
            ui.init(min, max, min, null);
            result = ui;
        } else if (value instanceof Equation) {
            Equation equation = (Equation)value;
            EquationContinuousPanelUI ui = new EquationContinuousPanelUI((JAXXContext)new JAXXInitialContext().add((Object)new InputAction()));
            ui.setSelectedEquation(equation);
            ui.setText(I18n._((String)"isisfish.common.equation", (Object[])new Object[0]));
            ui.setFormuleCategory(equation.getCategory());
            ui.setClazz(equation.getClass());
            ui.setBeanProperty(property);
            ui.setBean(bean);
            result = ui;
        } else if (value instanceof MatrixND) {
            MatrixND matrix = (MatrixND)value;
            MatrixContinuousPanelUI matrixPanel = new MatrixContinuousPanelUI();
            matrixPanel.init(matrix.clone(), matrix.clone(), matrix.clone(), null);
            result = matrixPanel;
        } else if (value instanceof TimeUnit) {
            TimeUnit timeUnit = (TimeUnit)value;
            DefaultContinuousPanelUI ui = new DefaultContinuousPanelUI();
            ui.init(String.valueOf(timeUnit.getTime()), String.valueOf(timeUnit.getTime()), String.valueOf(timeUnit.getTime()), null);
            result = ui;
        } else {
            DefaultContinuousPanelUI ui = new DefaultContinuousPanelUI();
            ui.init(String.valueOf(value), String.valueOf(value), String.valueOf(value), null);
            result = ui;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Component for " + value + " (" + bean + ", " + property + ")"));
            log.debug((Object)(" > " + result));
        }
        return result;
    }

    public ContinuousPanelContainerUI getContinuousPanelWithValue(Factor factor, ContinuousDomain domain, TopiaContext topiaContext) {
        ContinuousPanelContainerUI result = null;
        if (domain instanceof EquationContinuousDomain) {
            String factorPath = factor.getPath();
            if (factor.getPath().indexOf(35) != -1) {
                String topiaId = factorPath.substring(0, factorPath.lastIndexOf(35));
                String property = factorPath.substring(factorPath.lastIndexOf(35) + 1);
                try {
                    TopiaEntityContextable entity = (TopiaEntityContextable)topiaContext.findByTopiaId(topiaId);
                    String getter = "get" + StringUtils.capitalize((String)property);
                    Method m = entity.getClass().getMethod(getter, new Class[0]);
                    Equation value = (Equation)m.invoke((Object)entity, new Object[0]);
                    EquationContinuousPanelUI ui = new EquationContinuousPanelUI((JAXXContext)new JAXXInitialContext().add((Object)new InputAction()));
                    ui.setText(value.getContent());
                    ui.setFormuleCategory(value.getCategory());
                    ui.setText(I18n._((String)"isisfish.common.equation", (Object[])new Object[0]));
                    ui.setClazz(value.getClass());
                    ui.setBeanProperty(property);
                    ui.setBean(entity);
                    EquationContinuousDomain equationDomain = (EquationContinuousDomain)domain;
                    ui.addDomain(equationDomain);
                    result = ui;
                }
                catch (Exception ex) {
                    throw new IsisFishRuntimeException("Can't restore initial factor database property", ex);
                }
            }
        } else if (domain instanceof MatrixContinuousDomain) {
            MatrixContinuousPanelUI continuousPanel = new MatrixContinuousPanelUI();
            if (domain.isPercentageType()) {
                MatrixND matrix = (MatrixND)domain.getReferenceValue();
                continuousPanel.initExisting(matrix.clone(), matrix.clone(), matrix.clone(), String.valueOf(domain.getCoefficient() * 100.0));
            } else {
                MatrixND matrixMin = (MatrixND)domain.getMinBound();
                MatrixND matrixMax = (MatrixND)domain.getMaxBound();
                continuousPanel.initExisting(matrixMin.clone(), matrixMax.clone(), matrixMin.clone(), "");
            }
            result = continuousPanel;
        } else {
            DefaultContinuousPanelUI continuousPanel = new DefaultContinuousPanelUI();
            if (domain.isPercentageType()) {
                continuousPanel.initExisting(String.valueOf(domain.getReferenceValue()), String.valueOf(domain.getReferenceValue()), String.valueOf(domain.getReferenceValue()), String.valueOf(domain.getCoefficient() * 100.0));
            } else {
                continuousPanel.initExisting(String.valueOf(domain.getMinBound()), String.valueOf(domain.getMaxBound()), String.valueOf(domain.getMinBound()), "");
            }
            result = continuousPanel;
        }
        return result;
    }

    protected JComponent getEditorWithValue(FactorWizardUI factorWizardUI, Factor factor, Domain domain, Object value) {
        Object result = null;
        if (Double.class.isAssignableFrom(value.getClass())) {
            result = new JTextField();
            ((JTextComponent)result).setText(String.valueOf(value));
        } else if (Double.TYPE.isAssignableFrom(value.getClass())) {
            result = new JTextField();
            ((JTextComponent)result).setText(String.valueOf(value));
        } else if (MatrixND.class.isAssignableFrom(value.getClass())) {
            result = new MatrixPanelEditor();
            ((MatrixPanelEditor)result).setMatrix((MatrixND)value);
        } else if (domain instanceof RuleDiscreteDomain) {
            result = new RuleChooser((JAXXContext)factorWizardUI);
            ((RuleChooser)((Object)result)).setRulesList((List)value);
        } else if (domain instanceof EquationDiscreteDomain) {
            String factorPath = factor.getPath();
            if (factor.getPath().indexOf(35) != -1) {
                String topiaId = factorPath.substring(0, factorPath.lastIndexOf(35));
                String property = factorPath.substring(factorPath.lastIndexOf(35) + 1);
                try {
                    TopiaContext topiaContext = factorWizardUI.getContextValue(TopiaContext.class);
                    TopiaEntityContextable entity = (TopiaEntityContextable)topiaContext.findByTopiaId(topiaId);
                    String getter = "get" + StringUtils.capitalize((String)property);
                    Method m = entity.getClass().getMethod(getter, new Class[0]);
                    Equation equation = (Equation)m.invoke((Object)entity, new Object[0]);
                    InputOneEquationUI ui = new InputOneEquationUI((JAXXContext)factorWizardUI);
                    ui.setAutoSaveModification(false);
                    ui.setFormuleCategory(equation.getCategory());
                    ui.setText(I18n._((String)"isisfish.common.equation", (Object[])new Object[0]));
                    ui.setClazz(value.getClass());
                    ui.setBeanProperty(property);
                    ui.setBean(entity);
                    ui.getEditor().setText((String)value);
                    ui.setActive(true);
                    result = ui;
                }
                catch (Exception ex) {
                    throw new IsisFishRuntimeException("Can't restore initial factor database property", ex);
                }
            }
        } else if (value instanceof TimeUnit) {
            result = new JTextField();
            ((JTextComponent)result).setText(String.valueOf(((TimeUnit)value).getTime()));
        } else {
            if (value instanceof TopiaEntity) {
                RegionStorage regionStorage = factorWizardUI.getContextValue(RegionStorage.class);
                TopiaContext context = null;
                try {
                    context = regionStorage.getStorage().beginTransaction();
                    List list = context.find("from " + value.getClass().getName(), new Object[0]);
                    JComboBox<Object> c = new JComboBox<Object>(list.toArray());
                    c.setSelectedItem(value);
                    result = c;
                }
                catch (TopiaException ex) {
                    throw new IsisFishRuntimeException("Can't get entity list", ex);
                }
                finally {
                    if (context != null) {
                        try {
                            context.closeContext();
                        }
                        catch (TopiaException ex) {
                            throw new IsisFishRuntimeException("Can't get entity list", ex);
                        }
                    }
                }
            }
            if (value instanceof TimeStep) {
                TimeStep timeStep = (TimeStep)value;
                result = new StepComponent(timeStep.getMonth().getMonthNumber(), timeStep.getYear());
            } else if (value instanceof Month) {
                Month month = (Month)value;
                result = MonthComponent.createMounthCombo(month.getMonthNumber());
            } else if (value instanceof String) {
                result = new JTextField();
                ((JTextField)result).setText(String.valueOf(value));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Editor for value " + value + " is " + result));
        }
        return result;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public JComponent getNewDiscreteComponent(FactorWizardUI factorWizardUI) {
        result /* !! */  = null;
        factorPath = factorWizardUI.getFactorPath();
        if (factorPath.indexOf(35) != -1) {
            topiaId = factorPath.substring(0, factorPath.lastIndexOf(35));
            property = factorPath.substring(factorPath.lastIndexOf(35) + 1);
            topiaContext = factorWizardUI.getContextValue(TopiaContext.class);
            try {
                entity = (TopiaEntityContextable)topiaContext.findByTopiaId(topiaId);
                getter = "get" + StringUtils.capitalize((String)property);
                m = entity.getClass().getMethod(getter, new Class[0]);
                value = m.invoke((Object)entity, new Object[0]);
                if (value instanceof Number) {
                    result /* !! */  = new JTextField(String.valueOf(value));
                }
                if (value instanceof MatrixND) {
                    result /* !! */  = new MatrixPanelEditor();
                    matrix = ((MatrixND)value).copy();
                    ((MatrixPanelEditor)result /* !! */ ).setMatrix(matrix);
                }
                if (value instanceof RangeOfValues) {
                    rangeOfValues = (RangeOfValues)value;
                    result /* !! */  = new JTextField(rangeOfValues.getValues());
                }
                if (value instanceof TimeUnit) {
                    timeUnit = (TimeUnit)value;
                    result /* !! */  = new JTextField(String.valueOf(timeUnit.getTime()));
                }
                if (!(value instanceof Equation)) ** GOTO lbl71
                equation = (Equation)value;
                ui = new InputOneEquationUI((JAXXContext)factorWizardUI);
                ui.setAutoSaveModification(false);
                ui.setText(equation.getContent());
                ui.setFormuleCategory(equation.getCategory());
                ui.setText(I18n._((String)"isisfish.common.equation", (Object[])new Object[0]));
                ui.setClazz(value.getClass());
                ui.setBeanProperty(property);
                ui.setBean(entity);
                ui.setActive(true);
                result /* !! */  = ui;
            }
            catch (Exception ex) {
                throw new IsisFishRuntimeException("Can't restore intial factor database property", ex);
            }
        } else if (factorPath.equals("parameters.rules")) {
            result /* !! */  = new RuleChooser((JAXXContext)factorWizardUI);
        } else if (factorPath.startsWith("parameters.population.")) {
            currentPanel = (MatrixContinuousPanelUI)factorWizardUI.continuousPanel;
            matrix = currentPanel.getReferenceValuePanel().getMatrix().copy();
            result /* !! */  = new MatrixPanelEditor();
            ((MatrixPanelEditor)result /* !! */ ).setMatrix(matrix);
        } else if (factorPath.startsWith("parameters.rule.")) {
            pattern = Pattern.compile("^parameters\\.rule\\.\\d+\\.parameter\\.\\w+\\.(.+)$");
            matcher = pattern.matcher(factorPath);
            if (matcher.matches()) {
                className = matcher.group(1);
                try {
                    if (SensitivityInputHandler.log.isDebugEnabled()) {
                        SensitivityInputHandler.log.debug((Object)("Looking for a component for class : " + className));
                    }
                    type = Class.forName(className);
                    result /* !! */  = this.getRuleDiscreteComponent(factorWizardUI, type);
                }
                catch (ClassNotFoundException ex) {
                    if (SensitivityInputHandler.log.isWarnEnabled()) {
                        SensitivityInputHandler.log.warn((Object)"Can't find class for rule parameter", (Throwable)ex);
                    }
                }
            } else {
                result /* !! */  = new JTextField();
            }
        } else if (SensitivityInputHandler.log.isWarnEnabled()) {
            SensitivityInputHandler.log.warn((Object)("Can't find component for path " + factorPath));
        }
lbl71:
        // 14 sources

        if (SensitivityInputHandler.log.isDebugEnabled()) {
            SensitivityInputHandler.log.debug((Object)("Component for path " + factorPath + " is " + (Object)result /* !! */ ));
        }
        if (!(result /* !! */  instanceof MatrixPanelEditor)) {
            result /* !! */  = new JScrollPane((Component)result /* !! */ );
        }
        return result /* !! */ ;
    }

    protected JComponent getRuleDiscreteComponent(FactorWizardUI factorWizardUI, Class type) {
        JComponent result = null;
        if (TopiaEntity.class.isAssignableFrom(type)) {
            RegionStorage regionStorage = factorWizardUI.getContextValue(RegionStorage.class);
            TopiaContext context = null;
            try {
                context = regionStorage.getStorage().beginTransaction();
                List list = context.find("from " + type.getName(), new Object[0]);
                JComboBox<Object> c = new JComboBox<Object>(list.toArray());
                result = c;
            }
            catch (TopiaException ex) {
                throw new IsisFishRuntimeException("Can't get entity list", ex);
            }
            finally {
                if (context != null) {
                    try {
                        context.closeContext();
                    }
                    catch (TopiaException ex) {
                        throw new IsisFishRuntimeException("Can't get entity list", ex);
                    }
                }
            }
        }
        result = TimeStep.class.isAssignableFrom(type) ? new StepComponent(0, 0) : (Month.class.isAssignableFrom(type) ? MonthComponent.createMounthCombo(0) : new JTextField());
        return result;
    }

    public void save(FactorWizardUI factorWizardUI) {
        boolean factorValid = true;
        ContinuousPanelContainerUI continuousPanel = factorWizardUI.continuousPanel;
        if (continuousPanel != null) {
            factorValid = continuousPanel.isFactorValid();
        }
        if (!factorValid) {
            JOptionPane.showMessageDialog(factorWizardUI, I18n._((String)"isisfish.sensitivity.factor.notvalid", (Object[])new Object[0]), I18n._((String)"isisfish.sensitivity.title", (Object[])new Object[0]), 0);
            return;
        }
        if (factorWizardUI.getContinueRadio().isSelected()) {
            this.saveContinue(factorWizardUI.getFactorNameField().getText(), factorWizardUI.getComment().getText(), factorWizardUI.getFactorPath(), factorWizardUI.continuousPanel, factorWizardUI.getSimulAction(), factorWizardUI.isExistingValue());
        } else {
            this.saveDiscret(factorWizardUI.getFactorNameField().getText(), factorWizardUI.getComment().getText(), factorWizardUI.getFactorPath(), factorWizardUI.discretComponents, factorWizardUI.getSimulAction(), factorWizardUI.isExistingValue());
        }
        factorWizardUI.getContextValue(SimulationUI.class, "SimulationUI").refreshFactorTree();
        factorWizardUI.dispose();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void saveContinue(String name, String comment, String path, ContinuousPanelContainerUI panel, SimulAction action, boolean exist) {
        if (panel instanceof MatrixContinuousPanelUI) {
            MatrixContinuousPanelUI matrixPanel = (MatrixContinuousPanelUI)panel;
            if (matrixPanel.isPercentageTypeFactor().booleanValue()) {
                MatrixND referenceValue = matrixPanel.getReferenceValuePanel().getMatrix();
                Double coefficient = Double.valueOf(matrixPanel.getCoefficientField().getText()) / 100.0;
                action.addContinuousMatrixFactor(name, comment, path, referenceValue, coefficient, exist);
                return;
            } else {
                MatrixND minBound = matrixPanel.getMinValuePanel().getMatrix();
                MatrixND maxBound = matrixPanel.getMaxValuePanel().getMatrix();
                action.addContinuousMatrixFactor(name, comment, path, minBound, maxBound, exist);
            }
            return;
        } else if (panel instanceof EquationContinuousPanelUI) {
            try {
                EquationContinuousPanelUI equationPanel = (EquationContinuousPanelUI)panel;
                TopiaEntityContextable bean = equationPanel.getBean();
                TopiaContext topiaContext = bean.getTopiaContext();
                String property = equationPanel.getBeanProperty();
                property = StringUtils.capitalize((String)property) + "Content";
                Method m = bean.getClass().getMethod("set" + property, String.class);
                m.invoke((Object)bean, equationPanel.getEditor().getEditor().getText());
                bean.update();
                topiaContext.commitTransaction();
                List<EquationContinuousDomain> domains = equationPanel.getDomains();
                for (EquationContinuousDomain domain : domains) {
                    action.addContinuousEquationFactor(name, comment, path, domain, exist);
                }
                return;
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) return;
                log.error((Object)"Can't call method : ", (Throwable)ex);
                return;
            }
        } else {
            if (!(panel instanceof DefaultContinuousPanelUI)) return;
            DefaultContinuousPanelUI defaultPanel = (DefaultContinuousPanelUI)panel;
            if (defaultPanel.isPercentageTypeFactor().booleanValue()) {
                Double referenceValue = Double.valueOf(defaultPanel.getReferenceValueField().getText());
                Double coefficient = Double.valueOf(defaultPanel.getCoefficientField().getText()) / 100.0;
                action.addContinuousPercentageFactor(name, comment, path, referenceValue, coefficient, exist);
                return;
            } else {
                double minBound = Double.parseDouble(defaultPanel.getContinueMin().getText());
                double maxBound = Double.parseDouble(defaultPanel.getContinueMax().getText());
                action.addContinuousFactor(name, comment, path, minBound, maxBound, exist);
            }
        }
    }

    protected void saveDiscret(String name, String comment, String path, List<JComponent> components, SimulAction action, boolean exist) {
        ArrayList<Object> values = new ArrayList<Object>();
        boolean ruleFactor = false;
        boolean equationFactor = false;
        for (JComponent component : components) {
            Object result = null;
            if (component instanceof JTextComponent) {
                result = ((JTextComponent)component).getText();
            } else if (component instanceof MatrixPanelEditor) {
                result = ((MatrixPanelEditor)component).getMatrix();
            } else if (component instanceof InputOneEquationUI) {
                result = ((InputOneEquationUI)component).getEditor().getText();
                equationFactor = true;
            } else if (component instanceof RuleChooser) {
                result = ((RuleChooser)((Object)component)).getRulesList();
                ruleFactor = true;
            } else if (component instanceof StepComponent) {
                result = new TimeStep(((StepComponent)component).getSelectedValue());
            } else if (component instanceof MonthComponent) {
                result = new Month(((MonthComponent)component).getSelectedValue());
            } else if (component instanceof JComboBox) {
                result = ((JComboBox)component).getSelectedItem();
            }
            values.add(result);
        }
        if (ruleFactor) {
            action.addDiscreteRuleFactor(name, comment, path, values, exist);
        } else if (equationFactor) {
            action.addDiscreteEquationFactor(name, comment, path, values, exist);
        } else {
            action.addDiscreteFactor(name, comment, path, values, exist);
        }
    }

    protected Object getComponentValue(JComponent component) {
        Object result = null;
        if (component instanceof JTextComponent) {
            result = ((JTextComponent)component).getText();
        } else if (component instanceof MatrixPanelEditor) {
            result = ((MatrixPanelEditor)component).getMatrix();
        } else if (component instanceof InputOneEquationUI) {
            result = ((InputOneEquationUI)component).getEditor().getText();
        } else if (component instanceof RuleChooser) {
            result = ((RuleChooser)((Object)component)).getRulesList();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Value for component : " + component.getClass().getSimpleName() + " is " + result));
        }
        return result;
    }

    public void remove(FactorWizardUI factorWizardUI) {
        factorWizardUI.getSimulAction().removeFactor(factorWizardUI.getFactorPath());
        factorWizardUI.getContextValue(SimulationUI.class, "SimulationUI").refreshFactorTree();
        factorWizardUI.dispose();
    }
}

