/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.models.simulationplan;

import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.SimulationPlanStorage;
import fr.ifremer.isisfish.simulator.SimulationPlan;
import fr.ifremer.isisfish.ui.util.TooltipHelper;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import org.nuiton.i18n.I18n;

public class SimulationPlanComboRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -4070846632975105788L;
    protected Map<String, SimulationPlan> simulationPlanCache = new HashMap<String, SimulationPlan>();

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel c = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        String simulationPlanName = (String)value;
        c.setText(simulationPlanName);
        try {
            SimulationPlan plan = this.simulationPlanCache.get(simulationPlanName);
            if (plan == null) {
                SimulationPlanStorage storage = SimulationPlanStorage.getSimulationPlan(simulationPlanName, new CodeSourceStorage.Location[0]);
                plan = storage.getNewSimulationPlanInstance();
                this.simulationPlanCache.put(simulationPlanName, plan);
            }
            c.setToolTipText(plan.getDescription());
        }
        catch (Exception e) {
            String errorTooltip = TooltipHelper.getErrorTooltip(I18n._((String)"isisfish.error.compile.fileerror", (Object[])new Object[]{simulationPlanName}));
            c.setToolTipText(errorTooltip);
        }
        return c;
    }
}

