/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.equation.PopulationGrowth;
import fr.ifremer.isisfish.equation.PopulationGrowthReverse;
import fr.ifremer.isisfish.ui.input.InputAction;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.input.InputOneEquationUI;
import fr.ifremer.isisfish.ui.input.InputUI;
import fr.ifremer.isisfish.ui.input.WizardGroupCreationUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.JTextComponent;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class PopulationBasicsUI
extends InputContentUI<Population>
implements JAXXValidator {
    public static final String PROPERTY_BEAN = "bean";
    public static final String BINDING_BUTTON_POPULATION_BASICS_CREATE_CLASSES_ENABLED = "buttonPopulationBasicsCreateClasses.enabled";
    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CREATE_ENABLED = "create.enabled";
    public static final String BINDING_DELETE_ENABLED = "delete.enabled";
    public static final String BINDING_FIELD_POPULATION_BASICS_COMMENT_ENABLED = "fieldPopulationBasicsComment.enabled";
    public static final String BINDING_FIELD_POPULATION_BASICS_COMMENT_TEXT = "fieldPopulationBasicsComment.text";
    public static final String BINDING_FIELD_POPULATION_BASICS_GEOGRAPHIC_ID_ENABLED = "fieldPopulationBasicsGeographicID.enabled";
    public static final String BINDING_FIELD_POPULATION_BASICS_GEOGRAPHIC_ID_TEXT = "fieldPopulationBasicsGeographicID.text";
    public static final String BINDING_FIELD_POPULATION_BASICS_NAME_ENABLED = "fieldPopulationBasicsName.enabled";
    public static final String BINDING_FIELD_POPULATION_BASICS_NAME_TEXT = "fieldPopulationBasicsName.text";
    public static final String BINDING_FIELD_POPULATION_BASICS_NB_CLASSES_ENABLED = "fieldPopulationBasicsNbClasses.enabled";
    public static final String BINDING_FIELD_POPULATION_BASICS_NB_CLASSES_TEXT = "fieldPopulationBasicsNbClasses.text";
    public static final String BINDING_FIELD_POPULATION_BASICS_PLUS_GROUP_ENABLED = "fieldPopulationBasicsPlusGroup.enabled";
    public static final String BINDING_FIELD_POPULATION_BASICS_PLUS_GROUP_SELECTED = "fieldPopulationBasicsPlusGroup.selected";
    public static final String BINDING_GROWTH_EQUATION_ACTIVE = "growthEquation.active";
    public static final String BINDING_GROWTH_EQUATION_BEAN = "growthEquation.bean";
    public static final String BINDING_GROWTH_REVERSE_EQUATION_ACTIVE = "growthReverseEquation.active";
    public static final String BINDING_GROWTH_REVERSE_EQUATION_BEAN = "growthReverseEquation.bean";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";
    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";
    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWXz28bRRTHJyZ26qa/aJQ0pWmVkKAKFdb9hRCkKkncJnUwNDQJBHyg492JPWW9s52ZTTY9IP4E/gS4c0GCCxwQAglx5MAF8S8gxIEr4s2uvc46681Ik8M62ffeZ77vzcx7zld/oaLgaO4JDkOLB56kHWKtL+/sPGw+Iba8R4TNqS8ZR/HPSAEVGmjcSd4LieYbdRVe6YZXqqzjM494h6IX6+ikkAcuEW1CpESX0xG2EJXNxLwY+gHvURNRWdQv/vm78Lnz2ZcFhEIf1F2CVGaPi+pnMlpHBepIdB5W2sMVF3stkMGp1wK9p9W7qouFeBd3yFP0KRqro5KPOcAkelE/5YgRxYe+ROcWap4fyCrzJLhv165LVNnlFt3lpEPgU1CxS0XbCqhFlaO1wfzAxZIybwULaovtmu9HuJJEo02CPYmuZgGATiUl4hCgH1jewy51MMiU6FqqYInBEvtQCGtTPd/vvTy8NHMOoHSqSmHXd30De8Tt+4wtbOGmSyDF6dQasXdkU57nBwNuqD8vqMfkoOlmYppOTCcW1uu4Sdzrg3Kit8rphcT34i4lrjNYU7XDEk2lgrdIKFeVcxrQWyzSeCVtm8uErxHW4thvU7t2TznOZQNvZgCvZKttRkeKiAzafDOQknmDIVVOsCTdMIkmUpmuRCE6K2+4gVjjLIBzPJlCVNvE/mSFhWnIGam2bLlF6sRryfbg9iQH4FBEi7N92b7/NIhWPe5uRFfpoUd6/tu1NG4yxj0ie4SLxEsZX8vehFsZm3B6YX3T5sx11emGM3YhlUTflI6aySwg9IlO1D8mj5y1ZdgiFfvm4JG/Nfw23E5MS/2LKfBepOUV9VhJ3pds7NnxdThiiU5HlsUhLklbOLqUusvQuq1+6+731pEGKvLAVadtunG02z8CU9znpwf6vAJG1v+mJn7//s9vVnvN/VVYezLT9dBsgqbrc+YTrlqfRGfjzh5I6lbewf5iA5UFpGTHg2smQ9hm1wziYL3nVbilwq0HWLQBURz748efph7/9hwqrKKTLsPOKlb+NVSWbQ5VYK4T+m8tRYpO7Z+A5zmlDfaMeGrPYN6cuQPNFM82qefA9t8NoQozGVVIpDTLv/w7sfn1Uq8SI6Ds4lD3fjWKH6ES9VzqkWjQdWdY5mAb9wUJHNafVVnTa0R9Xva7Df696LmdleqohAMN1/1OvPosljBVoTMRyFUFfRgloX5raDLV6w/UYyebMKtF+NiYkKdhXl/DYxNCnoaXjOugR8jTcNW4DscToGUTh8reBBnCedk4Fz1CXj3NNVwzrqceIU+DpbMjcWsljhHnuFx0lIxLxtwt6qu5aoRKyjKEcENDTBm+gzwgtNXOk6IDKsGgofFsH1Ld2zq9Wf3PYMg4pRgb8Zw9yMlKh1W0XfzsmaGgs7uMd+CbQBW+x7QYN9N03AnUI3ybk9LrWoTvjAk/5GShR/jZWMOvxhry9kKPkNfZ3jDWoEfI03DXeMroEfI03Deugx4hT8OasQY9Qp6GmrEGPUKehreNNSjC/92efuvcEwAA";
    private static final Log log = LogFactory.getLog(PopulationBasicsUI.class);
    private static final long serialVersionUID = 1L;
    private boolean allComponentsCreated;
    protected Population bean;
    protected JButton buttonPopulationBasicsCreateClasses;
    protected JButton cancel;
    protected JButton create;
    protected JButton delete;
    protected JTextArea fieldPopulationBasicsComment;
    protected JTextField fieldPopulationBasicsGeographicID;
    @ValidatorField(validatorId="validator", propertyName="name", editorName="fieldPopulationBasicsName")
    protected JTextField fieldPopulationBasicsName;
    protected JTextField fieldPopulationBasicsNbClasses;
    protected JCheckBox fieldPopulationBasicsPlusGroup;
    protected InputOneEquationUI growthEquation;
    protected InputOneEquationUI growthReverseEquation;
    protected JButton save;
    protected JTable tableAgeLength;
    @Validator(validatorId="validator")
    protected SwingValidator<Population> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    private PopulationBasicsUI $InputContentUI0 = this;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JScrollPane $JScrollPane0;
    private Table $Table3;
    private Table $Table4;

    protected void $afterCompleteSetup() {
        this.addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    PopulationBasicsUI.this.fieldPopulationBasicsName.setText("");
                    PopulationBasicsUI.this.fieldPopulationBasicsGeographicID.setText("");
                    PopulationBasicsUI.this.fieldPopulationBasicsNbClasses.setText("");
                    PopulationBasicsUI.this.fieldPopulationBasicsComment.setText("");
                    PopulationBasicsUI.this.tableAgeLength.setModel(new DefaultTableModel());
                }
                if (evt.getNewValue() != null) {
                    PopulationBasicsUI.this.setTableAgeLengthModel();
                }
            }
        });
    }

    public void refresh() {
        Population population = this.getSaveVerifier().getEntity(Population.class);
        this.setBean((Population)null);
        this.setBean(population);
        if (this.getBean() != null) {
            this.setTableAgeLengthModel();
        }
    }

    protected void createGroups() {
        int response = JOptionPane.showConfirmDialog(this, I18n._((String)"isisfish.populationBasics.confirmCreateGroups", (Object[])new Object[0]), I18n._((String)"isisfish.common.confirm", (Object[])new Object[0]), 0, 2);
        if (response == 0) {
            JFrame wizardFrame = new JFrame();
            wizardFrame.setLayout(new BorderLayout());
            WizardGroupCreationUI wizard = new WizardGroupCreationUI((JAXXContext)this);
            wizard.init(this);
            wizardFrame.add((Component)wizard, "Center");
            wizardFrame.setTitle(I18n._((String)"isisfish.wizardGroupCreation.title", (Object[])new Object[0]));
            Species species = this.getBean().getSpecies();
            wizard.setAgeType(species.getAgeGroupType());
            if (wizard.isAgeType()) {
                wizard.setCard("singleGroupAge");
            } else {
                wizard.setCard("beginGroupLength");
            }
            wizardFrame.pack();
            wizardFrame.setLocationRelativeTo(this);
            wizardFrame.setVisible(true);
        }
    }

    protected void setTableAgeLengthModel() {
        List<PopulationGroup> popGroup = this.getBean().getPopulationGroup();
        if (popGroup != null) {
            DefaultTableModel model = new DefaultTableModel(2, popGroup.size() + 1);
            model.setValueAt("Age", 0, 0);
            model.setValueAt("Lengths", 1, 0);
            int cnt = 1;
            for (PopulationGroup pg : popGroup) {
                model.setValueAt(pg.getAge(), 0, cnt);
                model.setValueAt(pg.getLength(), 1, cnt);
                ++cnt;
            }
            this.tableAgeLength.setModel(model);
        }
    }

    protected void create() {
        InputUI inputUI = this.getContextValue(InputUI.class, "parent");
        Species species = inputUI.getHandler().findSpecies(inputUI);
        Population population = this.getContextValue(InputAction.class).createPopulation(this.getTopiaContext(), species);
        inputUI.getHandler().insertTreeNode(inputUI, Population.class, population);
        this.setInfoText(I18n._((String)"isisfish.message.creation.finished", (Object[])new Object[0]));
    }

    public PopulationBasicsUI(LayoutManager param0, boolean param1) {
        super(param0, param1);
        this.$initialize();
    }

    public PopulationBasicsUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0, param1, param2);
        this.$initialize();
    }

    public PopulationBasicsUI(LayoutManager param0) {
        super(param0);
        this.$initialize();
    }

    public PopulationBasicsUI(JAXXContext param0, LayoutManager param1) {
        super(param0, param1);
        this.$initialize();
    }

    public PopulationBasicsUI(boolean param0) {
        super(param0);
        this.$initialize();
    }

    public PopulationBasicsUI(JAXXContext param0, boolean param1) {
        super(param0, param1);
        this.$initialize();
    }

    public PopulationBasicsUI() {
        this.$initialize();
    }

    public PopulationBasicsUI(JAXXContext param0) {
        super(param0);
        this.$initialize();
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator)(this.validatorIds.contains(validatorId) ? this.getObjectById(validatorId) : null);
    }

    public List<String> getValidatorIds() {
        return this.validatorIds;
    }

    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields((JAXXValidator)this);
    }

    public void doActionPerformed__on__buttonPopulationBasicsCreateClasses(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.createGroups();
    }

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__create(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.create();
    }

    public void doActionPerformed__on__delete(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.getSaveVerifier().delete();
    }

    public void doActionPerformed__on__fieldPopulationBasicsPlusGroup(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.getBean().setPlusGroup(this.fieldPopulationBasicsPlusGroup.isSelected());
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.getSaveVerifier().save();
        this.validator.setChanged(false);
    }

    public void doKeyReleased__on__fieldPopulationBasicsComment(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.getBean().setComment(this.fieldPopulationBasicsComment.getText());
    }

    public void doKeyReleased__on__fieldPopulationBasicsGeographicID(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.getBean().setGeographicId(this.fieldPopulationBasicsGeographicID.getText());
    }

    public void doKeyReleased__on__fieldPopulationBasicsName(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.getBean().setName(this.fieldPopulationBasicsName.getText());
    }

    @Override
    public Population getBean() {
        return this.bean;
    }

    public JButton getButtonPopulationBasicsCreateClasses() {
        return this.buttonPopulationBasicsCreateClasses;
    }

    public JButton getCancel() {
        return this.cancel;
    }

    public JButton getCreate() {
        return this.create;
    }

    public JButton getDelete() {
        return this.delete;
    }

    public JTextArea getFieldPopulationBasicsComment() {
        return this.fieldPopulationBasicsComment;
    }

    public JTextField getFieldPopulationBasicsGeographicID() {
        return this.fieldPopulationBasicsGeographicID;
    }

    public JTextField getFieldPopulationBasicsName() {
        return this.fieldPopulationBasicsName;
    }

    public JTextField getFieldPopulationBasicsNbClasses() {
        return this.fieldPopulationBasicsNbClasses;
    }

    public JCheckBox getFieldPopulationBasicsPlusGroup() {
        return this.fieldPopulationBasicsPlusGroup;
    }

    public InputOneEquationUI getGrowthEquation() {
        return this.growthEquation;
    }

    public InputOneEquationUI getGrowthReverseEquation() {
        return this.growthReverseEquation;
    }

    public JButton getSave() {
        return this.save;
    }

    public JTable getTableAgeLength() {
        return this.tableAgeLength;
    }

    public SwingValidator<Population> getValidator() {
        return this.validator;
    }

    @Override
    public void setBean(Population bean) {
        Population oldValue = this.bean;
        this.bean = bean;
        this.firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    protected Table get$Table0() {
        return this.$Table0;
    }

    protected Table get$Table1() {
        return this.$Table1;
    }

    protected Table get$Table2() {
        return this.$Table2;
    }

    protected JLabel get$JLabel0() {
        return this.$JLabel0;
    }

    protected JLabel get$JLabel1() {
        return this.$JLabel1;
    }

    protected JLabel get$JLabel2() {
        return this.$JLabel2;
    }

    protected JLabel get$JLabel3() {
        return this.$JLabel3;
    }

    protected JScrollPane get$JScrollPane0() {
        return this.$JScrollPane0;
    }

    protected Table get$Table3() {
        return this.$Table3;
    }

    protected Table get$Table4() {
        return this.$Table4;
    }

    protected void addChildrenToBody() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.body.add((Component)this.$Table0);
    }

    protected void addChildrenToValidator() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.validator.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        this.bean = null;
        this.$objectMap.put(PROPERTY_BEAN, null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        this.body.setName("body");
    }

    protected void createButtonPopulationBasicsCreateClasses() {
        this.buttonPopulationBasicsCreateClasses = new JButton();
        this.$objectMap.put("buttonPopulationBasicsCreateClasses", this.buttonPopulationBasicsCreateClasses);
        this.buttonPopulationBasicsCreateClasses.setName("buttonPopulationBasicsCreateClasses");
        this.buttonPopulationBasicsCreateClasses.setText(I18n._((String)"isisfish.populationBasics.recreateClasses", (Object[])new Object[0]));
        this.buttonPopulationBasicsCreateClasses.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__buttonPopulationBasicsCreateClasses"));
    }

    protected void createCancel() {
        this.cancel = new JButton();
        this.$objectMap.put("cancel", this.cancel);
        this.cancel.setName("cancel");
        this.cancel.setText(I18n._((String)"isisfish.common.cancel", (Object[])new Object[0]));
        this.cancel.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__cancel"));
    }

    protected void createCreate() {
        this.create = new JButton();
        this.$objectMap.put("create", this.create);
        this.create.setName("create");
        this.create.setText(I18n._((String)"isisfish.common.new", (Object[])new Object[0]));
        this.create.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__create"));
    }

    protected void createDelete() {
        this.delete = new JButton();
        this.$objectMap.put("delete", this.delete);
        this.delete.setName("delete");
        this.delete.setText(I18n._((String)"isisfish.common.remove", (Object[])new Object[0]));
        this.delete.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__delete"));
    }

    protected void createFieldPopulationBasicsComment() {
        this.fieldPopulationBasicsComment = new JTextArea();
        this.$objectMap.put("fieldPopulationBasicsComment", this.fieldPopulationBasicsComment);
        this.fieldPopulationBasicsComment.setName("fieldPopulationBasicsComment");
        this.fieldPopulationBasicsComment.setColumns(15);
        this.fieldPopulationBasicsComment.setLineWrap(true);
        this.fieldPopulationBasicsComment.setWrapStyleWord(true);
        this.fieldPopulationBasicsComment.addKeyListener((KeyListener)JAXXUtil.getEventListener(KeyListener.class, (String)"keyReleased", (Object)this, (String)"doKeyReleased__on__fieldPopulationBasicsComment"));
    }

    protected void createFieldPopulationBasicsGeographicID() {
        this.fieldPopulationBasicsGeographicID = new JTextField();
        this.$objectMap.put("fieldPopulationBasicsGeographicID", this.fieldPopulationBasicsGeographicID);
        this.fieldPopulationBasicsGeographicID.setName("fieldPopulationBasicsGeographicID");
        this.fieldPopulationBasicsGeographicID.setColumns(15);
        this.fieldPopulationBasicsGeographicID.addKeyListener((KeyListener)JAXXUtil.getEventListener(KeyListener.class, (String)"keyReleased", (Object)this, (String)"doKeyReleased__on__fieldPopulationBasicsGeographicID"));
    }

    protected void createFieldPopulationBasicsName() {
        this.fieldPopulationBasicsName = new JTextField();
        this.$objectMap.put("fieldPopulationBasicsName", this.fieldPopulationBasicsName);
        this.fieldPopulationBasicsName.setName("fieldPopulationBasicsName");
        this.fieldPopulationBasicsName.setColumns(15);
        this.fieldPopulationBasicsName.addKeyListener((KeyListener)JAXXUtil.getEventListener(KeyListener.class, (String)"keyReleased", (Object)this, (String)"doKeyReleased__on__fieldPopulationBasicsName"));
    }

    protected void createFieldPopulationBasicsNbClasses() {
        this.fieldPopulationBasicsNbClasses = new JTextField();
        this.$objectMap.put("fieldPopulationBasicsNbClasses", this.fieldPopulationBasicsNbClasses);
        this.fieldPopulationBasicsNbClasses.setName("fieldPopulationBasicsNbClasses");
        this.fieldPopulationBasicsNbClasses.setColumns(15);
        this.fieldPopulationBasicsNbClasses.setEditable(false);
    }

    protected void createFieldPopulationBasicsPlusGroup() {
        this.fieldPopulationBasicsPlusGroup = new JCheckBox();
        this.$objectMap.put("fieldPopulationBasicsPlusGroup", this.fieldPopulationBasicsPlusGroup);
        this.fieldPopulationBasicsPlusGroup.setName("fieldPopulationBasicsPlusGroup");
        this.fieldPopulationBasicsPlusGroup.setText(I18n._((String)"isisfish.populationBasics.plusGroup", (Object[])new Object[0]));
        this.fieldPopulationBasicsPlusGroup.setToolTipText(I18n._((String)"isisfish.populationBasics.plusGroupTip", (Object[])new Object[0]));
        this.fieldPopulationBasicsPlusGroup.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__fieldPopulationBasicsPlusGroup"));
        this.fieldPopulationBasicsPlusGroup.putClientProperty("sensitivityBean", Population.class);
        this.fieldPopulationBasicsPlusGroup.putClientProperty("sensitivityMethod", "PlusGroup");
    }

    protected void createGrowthEquation() {
        this.growthEquation = new InputOneEquationUI((JAXXContext)this);
        this.$objectMap.put("growthEquation", this.growthEquation);
        this.growthEquation.setName("growthEquation");
        this.growthEquation.setBeanProperty("growth");
        this.growthEquation.setFormuleCategory("Growth");
        this.growthEquation.setText(I18n._((String)"isisfish.populationBasics.growth", (Object[])new Object[0]));
        this.growthEquation.putClientProperty("sensitivityBean", Population.class);
        this.growthEquation.putClientProperty("sensitivityMethod", "Growth");
    }

    protected void createGrowthReverseEquation() {
        this.growthReverseEquation = new InputOneEquationUI((JAXXContext)this);
        this.$objectMap.put("growthReverseEquation", this.growthReverseEquation);
        this.growthReverseEquation.setName("growthReverseEquation");
        this.growthReverseEquation.setBeanProperty("GrowthReverse");
        this.growthReverseEquation.setFormuleCategory("GrowthReverse");
        this.growthReverseEquation.setText(I18n._((String)"isisfish.populationBasics.growthReverse", (Object[])new Object[0]));
        this.growthReverseEquation.putClientProperty("sensitivityBean", Population.class);
        this.growthReverseEquation.putClientProperty("sensitivityMethod", "GrowthReverse");
    }

    protected void createSave() {
        this.save = new JButton();
        this.$objectMap.put("save", this.save);
        this.save.setName("save");
        this.save.setText(I18n._((String)"isisfish.common.save", (Object[])new Object[0]));
        this.save.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__save"));
    }

    protected void createTableAgeLength() {
        this.tableAgeLength = new JTable();
        this.$objectMap.put("tableAgeLength", this.tableAgeLength);
        this.tableAgeLength.setName("tableAgeLength");
        this.tableAgeLength.setEnabled(false);
        this.tableAgeLength.setRowHeight(24);
    }

    protected void createValidator() {
        this.validator = SwingValidatorUtil.newValidator(Population.class, (String)"basics");
        this.$objectMap.put("validator", this.validator);
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.addChildrenToValidator();
        this.addChildrenToBody();
        this.$Table0.add((Component)this.$Table1, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.$Table3, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.$Table2, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)this.$JLabel0, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)SwingUtil.boxComponentWithJxLayer((JComponent)this.fieldPopulationBasicsName)), (Object)new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)this.$JLabel1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.fieldPopulationBasicsGeographicID), (Object)new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)this.$JLabel2, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.fieldPopulationBasicsNbClasses), (Object)new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.buttonPopulationBasicsCreateClasses), (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.fieldPopulationBasicsPlusGroup), (Object)new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.tableAgeLength), (Object)new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.growthEquation), (Object)new GridBagConstraints(0, 5, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.growthReverseEquation), (Object)new GridBagConstraints(0, 6, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)this.$JLabel3, (Object)new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)this.$JScrollPane0, (Object)new GridBagConstraints(1, 7, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.$JScrollPane0.getViewport().add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.fieldPopulationBasicsComment));
        this.$Table3.add((Component)this.$Table4, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table4.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.save), (Object)new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table4.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.cancel), (Object)new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table4.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.create), (Object)new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table4.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.delete), (Object)new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        JAXXUtil.applyDataBinding((JAXXObject)this, this.$bindings.keySet());
        this.growthEquation.setClazz(PopulationGrowth.class);
        this.growthReverseEquation.setClazz(PopulationGrowthReverse.class);
        this.validatorIds = SwingValidatorUtil.detectValidators((JAXXValidator)this);
        SwingValidatorUtil.installUI((JAXXValidator)this);
        this.$afterCompleteSetup();
    }

    private void $initialize() {
        if (this.allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.$objectMap.put("$InputContentUI0", this.$InputContentUI0);
        this.createBean();
        this.createValidator();
        this.$Table0 = new Table();
        this.$objectMap.put("$Table0", this.$Table0);
        this.$Table0.setName("$Table0");
        this.$Table1 = new Table();
        this.$objectMap.put("$Table1", this.$Table1);
        this.$Table1.setName("$Table1");
        this.$Table2 = new Table();
        this.$objectMap.put("$Table2", this.$Table2);
        this.$Table2.setName("$Table2");
        this.$JLabel0 = new JLabel();
        this.$objectMap.put("$JLabel0", this.$JLabel0);
        this.$JLabel0.setName("$JLabel0");
        this.$JLabel0.setText(I18n._((String)"isisfish.populationBasics.name", (Object[])new Object[0]));
        this.createFieldPopulationBasicsName();
        this.$JLabel1 = new JLabel();
        this.$objectMap.put("$JLabel1", this.$JLabel1);
        this.$JLabel1.setName("$JLabel1");
        this.$JLabel1.setText(I18n._((String)"isisfish.populationBasics.geographicID", (Object[])new Object[0]));
        this.createFieldPopulationBasicsGeographicID();
        this.$JLabel2 = new JLabel();
        this.$objectMap.put("$JLabel2", this.$JLabel2);
        this.$JLabel2.setName("$JLabel2");
        this.$JLabel2.setText(I18n._((String)"isisfish.populationBasics.numberGroup", (Object[])new Object[0]));
        this.createFieldPopulationBasicsNbClasses();
        this.createButtonPopulationBasicsCreateClasses();
        this.createFieldPopulationBasicsPlusGroup();
        this.createTableAgeLength();
        this.createGrowthEquation();
        this.createGrowthReverseEquation();
        this.$JLabel3 = new JLabel();
        this.$objectMap.put("$JLabel3", this.$JLabel3);
        this.$JLabel3.setName("$JLabel3");
        this.$JLabel3.setText(I18n._((String)"isisfish.population.comments", (Object[])new Object[0]));
        this.$JScrollPane0 = new JScrollPane();
        this.$objectMap.put("$JScrollPane0", this.$JScrollPane0);
        this.$JScrollPane0.setName("$JScrollPane0");
        this.createFieldPopulationBasicsComment();
        this.$Table3 = new Table();
        this.$objectMap.put("$Table3", this.$Table3);
        this.$Table3.setName("$Table3");
        this.$Table4 = new Table();
        this.$objectMap.put("$Table4", this.$Table4);
        this.$Table4.setName("$Table4");
        this.createSave();
        this.createCancel();
        this.createCreate();
        this.createDelete();
        this.setName("$InputContentUI0");
        this.$registerDefaultBindings();
        this.$completeSetup();
    }

    private void $registerDefaultBindings() {
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true, new String[]{PROPERTY_BEAN}){

            public void processDataBinding() {
                PopulationBasicsUI.this.validator.setBean((Object)PopulationBasicsUI.this.getBean());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true, new String[]{"active"}){

            public void processDataBinding() {
                PopulationBasicsUI.this.$JLabel0.setEnabled(PopulationBasicsUI.this.isActive());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_BASICS_NAME_ENABLED, true, new String[]{"active"}){

            public void processDataBinding() {
                PopulationBasicsUI.this.fieldPopulationBasicsName.setEnabled(PopulationBasicsUI.this.isActive());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_BASICS_NAME_TEXT, true, new String[]{PROPERTY_BEAN}){

            public void processDataBinding() {
                if (PopulationBasicsUI.this.getBean() != null) {
                    SwingUtil.setText((JTextComponent)PopulationBasicsUI.this.fieldPopulationBasicsName, (String)PopulationBasicsUI.this.getBean().getName());
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true, new String[]{"active"}){

            public void processDataBinding() {
                PopulationBasicsUI.this.$JLabel1.setEnabled(PopulationBasicsUI.this.isActive());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_BASICS_GEOGRAPHIC_ID_ENABLED, true, new String[]{"active"}){

            public void processDataBinding() {
                PopulationBasicsUI.this.fieldPopulationBasicsGeographicID.setEnabled(PopulationBasicsUI.this.isActive());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_BASICS_GEOGRAPHIC_ID_TEXT, true, new String[]{PROPERTY_BEAN}){

            public void processDataBinding() {
                if (PopulationBasicsUI.this.getBean() != null) {
                    SwingUtil.setText((JTextComponent)PopulationBasicsUI.this.fieldPopulationBasicsGeographicID, (String)SwingUtil.getStringValue((Object)PopulationBasicsUI.this.getBean().getGeographicId()));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true, new String[]{"active"}){

            public void processDataBinding() {
                PopulationBasicsUI.this.$JLabel2.setEnabled(PopulationBasicsUI.this.isActive());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_BASICS_NB_CLASSES_ENABLED, true, new String[]{"active"}){

            public void processDataBinding() {
                PopulationBasicsUI.this.fieldPopulationBasicsNbClasses.setEnabled(PopulationBasicsUI.this.isActive());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_BASICS_NB_CLASSES_TEXT, true, new String[]{PROPERTY_BEAN}){

            public void processDataBinding() {
                if (PopulationBasicsUI.this.getBean() != null) {
                    SwingUtil.setText((JTextComponent)PopulationBasicsUI.this.fieldPopulationBasicsNbClasses, (String)String.valueOf(PopulationBasicsUI.this.getBean() == null ? "" : Integer.valueOf(PopulationBasicsUI.this.getBean().sizePopulationGroup())));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_BUTTON_POPULATION_BASICS_CREATE_CLASSES_ENABLED, true, new String[]{"active"}){

            public void processDataBinding() {
                PopulationBasicsUI.this.buttonPopulationBasicsCreateClasses.setEnabled(PopulationBasicsUI.this.isActive());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_BASICS_PLUS_GROUP_ENABLED, true, new String[]{"active"}){

            public void processDataBinding() {
                PopulationBasicsUI.this.fieldPopulationBasicsPlusGroup.setEnabled(PopulationBasicsUI.this.isActive());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_BASICS_PLUS_GROUP_SELECTED, true, new String[]{PROPERTY_BEAN}){

            public void processDataBinding() {
                if (PopulationBasicsUI.this.getBean() != null) {
                    PopulationBasicsUI.this.fieldPopulationBasicsPlusGroup.setSelected(PopulationBasicsUI.this.getBean().getPlusGroup());
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_GROWTH_EQUATION_ACTIVE, true, new String[]{"active"}){

            public void processDataBinding() {
                PopulationBasicsUI.this.growthEquation.setActive(PopulationBasicsUI.this.isActive());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_GROWTH_EQUATION_BEAN, true, new String[]{PROPERTY_BEAN}){

            public void processDataBinding() {
                PopulationBasicsUI.this.growthEquation.setBean(PopulationBasicsUI.this.getBean());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_GROWTH_REVERSE_EQUATION_ACTIVE, true, new String[]{"active"}){

            public void processDataBinding() {
                PopulationBasicsUI.this.growthReverseEquation.setActive(PopulationBasicsUI.this.isActive());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_GROWTH_REVERSE_EQUATION_BEAN, true, new String[]{PROPERTY_BEAN}){

            public void processDataBinding() {
                PopulationBasicsUI.this.growthReverseEquation.setBean(PopulationBasicsUI.this.getBean());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_$JLABEL3_ENABLED, true, new String[]{"active"}){

            public void processDataBinding() {
                PopulationBasicsUI.this.$JLabel3.setEnabled(PopulationBasicsUI.this.isActive());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_BASICS_COMMENT_ENABLED, true, new String[]{"active"}){

            public void processDataBinding() {
                PopulationBasicsUI.this.fieldPopulationBasicsComment.setEnabled(PopulationBasicsUI.this.isActive());
            }
        });
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_BASICS_COMMENT_TEXT, true, new String[]{PROPERTY_BEAN}){

            public void processDataBinding() {
                if (PopulationBasicsUI.this.getBean() != null) {
                    SwingUtil.setText((JTextComponent)PopulationBasicsUI.this.fieldPopulationBasicsComment, (String)SwingUtil.getStringValue((Object)PopulationBasicsUI.this.getBean().getComment()));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true){

            public void applyDataBinding() {
                if (PopulationBasicsUI.this.validator != null) {
                    PopulationBasicsUI.this.validator.addPropertyChangeListener("valid", (PropertyChangeListener)((Object)this));
                }
                if (PopulationBasicsUI.this.validator != null) {
                    PopulationBasicsUI.this.validator.addPropertyChangeListener("changed", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (PopulationBasicsUI.this.validator != null) {
                    PopulationBasicsUI.this.save.setEnabled(PopulationBasicsUI.this.validator.isValid() && PopulationBasicsUI.this.validator.isChanged());
                }
            }

            public void removeDataBinding() {
                if (PopulationBasicsUI.this.validator != null) {
                    PopulationBasicsUI.this.validator.removePropertyChangeListener("valid", (PropertyChangeListener)((Object)this));
                }
                if (PopulationBasicsUI.this.validator != null) {
                    PopulationBasicsUI.this.validator.removePropertyChangeListener("changed", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true){

            public void applyDataBinding() {
                if (PopulationBasicsUI.this.validator != null) {
                    PopulationBasicsUI.this.validator.addPropertyChangeListener("changed", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (PopulationBasicsUI.this.validator != null) {
                    PopulationBasicsUI.this.cancel.setEnabled(PopulationBasicsUI.this.validator.isChanged());
                }
            }

            public void removeDataBinding() {
                if (PopulationBasicsUI.this.validator != null) {
                    PopulationBasicsUI.this.validator.removePropertyChangeListener("changed", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_CREATE_ENABLED, true){

            public void applyDataBinding() {
                if (PopulationBasicsUI.this.validator != null) {
                    PopulationBasicsUI.this.validator.addPropertyChangeListener("changed", (PropertyChangeListener)((Object)this));
                }
            }

            public void processDataBinding() {
                if (PopulationBasicsUI.this.validator != null) {
                    PopulationBasicsUI.this.create.setEnabled(!PopulationBasicsUI.this.validator.isChanged());
                }
            }

            public void removeDataBinding() {
                if (PopulationBasicsUI.this.validator != null) {
                    PopulationBasicsUI.this.validator.removePropertyChangeListener("changed", (PropertyChangeListener)((Object)this));
                }
            }
        });
        this.registerDataBinding((JAXXBinding)new DefaultJAXXBinding(this, BINDING_DELETE_ENABLED, true, true){

            public void applyDataBinding() {
                if (PopulationBasicsUI.this.validator != null) {
                    PopulationBasicsUI.this.validator.addPropertyChangeListener("changed", (PropertyChangeListener)((Object)this));
                }
                PopulationBasicsUI.this.addPropertyChangeListener(PopulationBasicsUI.PROPERTY_BEAN, (PropertyChangeListener)((Object)this));
            }

            public void processDataBinding() {
                if (PopulationBasicsUI.this.validator != null) {
                    PopulationBasicsUI.this.delete.setEnabled(!PopulationBasicsUI.this.validator.isChanged() && PopulationBasicsUI.this.getBean() != null);
                }
            }

            public void removeDataBinding() {
                if (PopulationBasicsUI.this.validator != null) {
                    PopulationBasicsUI.this.validator.removePropertyChangeListener("changed", (PropertyChangeListener)((Object)this));
                }
                PopulationBasicsUI.this.removePropertyChangeListener(PopulationBasicsUI.PROPERTY_BEAN, (PropertyChangeListener)((Object)this));
            }
        });
    }
}

