/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.types.hibernate;

import fr.ifremer.isisfish.util.ConverterUtil;
import fr.ifremer.isisfish.util.TopiaEntityConverter;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.jdbc.NonContextualLobCreator;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixHelper;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.StringUtil;

public class MatrixType
implements CompositeUserType {
    private static final Log log = LogFactory.getLog(MatrixType.class);
    private static final Type[] hibernateTypes = new Type[]{StandardBasicTypes.STRING, StandardBasicTypes.STRING, StandardBasicTypes.CLOB, StandardBasicTypes.CLOB, StandardBasicTypes.CLOB};
    private static final String[] propertyNames = new String[]{"name", "dim", "dimNames", "semantics", "data"};

    public boolean isMutable() {
        return true;
    }

    private String getDimToString(int[] dimArray) {
        String result = "[";
        String sep = "";
        for (int i = 0; i < dimArray.length; ++i) {
            result = result + sep + dimArray[i];
            sep = ", ";
        }
        result = result + "]";
        return result;
    }

    private int[] getDimFromString(String str) {
        if ((str = str.trim()).startsWith("[") && str.endsWith("]")) {
            str = str.substring(1, str.length() - 1);
        }
        String[] dimAsString = StringUtil.split((String)str, (String)",");
        int[] result = new int[dimAsString.length];
        int i = 0;
        for (String dim : dimAsString) {
            int val = Integer.parseInt(dim.trim());
            result[i++] = val;
        }
        return result;
    }

    private String getDimNamesToString(String[] dimNamesArray) {
        String result = "[";
        String sep = "";
        for (int i = 0; i < dimNamesArray.length; ++i) {
            result = result + sep + '\"' + dimNamesArray[i] + '\"';
            sep = ", ";
        }
        result = result + "]";
        return result;
    }

    private String[] getDimNamesFromString(String str) {
        if ((str = str.trim()).startsWith("[") && str.endsWith("]")) {
            str = str.substring(1, str.length() - 1);
        }
        String[] result = StringUtil.split((String)str, (String)",");
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].trim();
            if (!result[i].startsWith("\"") || !result[i].endsWith("\"")) continue;
            result[i] = result[i].substring(1, result[i].length() - 1);
        }
        return result;
    }

    private String getSemanticsToString(List[] semanticsArray) {
        StringBuffer result = new StringBuffer("[");
        for (int i = 0; i < semanticsArray.length; ++i) {
            result.append("[");
            List semantics = semanticsArray[i];
            Iterator it = semantics.iterator();
            while (it.hasNext()) {
                this.appendString(result, it.next());
                if (!it.hasNext()) continue;
                result.append(", ");
            }
            result.append("]");
            if (i + 1 >= semanticsArray.length) continue;
            result.append(", ");
        }
        return result.append("]").toString();
    }

    private List[] getSemanticsFromString(String name, String str, SessionImplementor session) {
        if ((str = str.trim()).startsWith("[") && str.endsWith("]")) {
            str = str.substring(1, str.length() - 1);
        }
        String[] sems = StringUtil.split((String)str, (String)",");
        List[] result = new List[sems.length];
        for (int i = 0; i < sems.length; ++i) {
            result[i] = this.splitObjects(name, sems[i], session);
        }
        return result;
    }

    private List splitObjects(String name, String str, SessionImplementor session) {
        String[] elems;
        LinkedList<Object> result = new LinkedList<Object>();
        if ((str = str.trim()).startsWith("[") && str.endsWith("]")) {
            str = str.substring(1, str.length() - 1);
        }
        for (String elem : elems = StringUtil.split((String)str, (String)",")) {
            Object o;
            block6: {
                elem = elem.trim();
                int openbrace = elem.indexOf(40);
                String objectType = elem.substring(0, openbrace);
                String objectString = elem.substring(openbrace + 1, elem.length() - 1);
                if ("null".equals(objectType)) {
                    result.add(null);
                    continue;
                }
                ConvertUtilsBean converter = this.getConverter(session);
                try {
                    o = converter.convert(objectString, Class.forName(objectType));
                }
                catch (Exception eee) {
                    o = objectType + "(" + objectString + ")";
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Continuing but can't convert object in matrix " + name + " from String: '" + o + "'"));
                    }
                    if (!log.isDebugEnabled()) break block6;
                    log.debug((Object)("Continuing can't convert object in matrix " + name + " from String: '" + o + "'"), (Throwable)eee);
                }
            }
            result.add(o);
        }
        return result;
    }

    private StringBuffer appendString(StringBuffer buffer, Object o) {
        if (o == null) {
            buffer.append("null()");
        } else {
            String qualifiedName = o.getClass().getName();
            if (o instanceof TopiaEntity) {
                qualifiedName = TopiaEntity.class.getName();
            }
            buffer.append(qualifiedName).append("(");
            ConvertUtilsBean converter = this.getConverter(null);
            buffer.append(converter.convert(o));
            buffer.append(")");
        }
        return buffer;
    }

    private ConvertUtilsBean getConverter(SessionImplementor session) {
        ConvertUtilsBean cub = ConverterUtil.getConverter(null);
        if (session != null) {
            cub.register((Converter)new TopiaEntityConverter(session), TopiaEntity.class);
        }
        return cub;
    }

    public Class returnedClass() {
        return MatrixND.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x != null && y != null) {
            return x.equals(y);
        }
        return false;
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object deepCopy(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        return MatrixFactory.getInstance().create((MatrixND)value);
    }

    public String[] getPropertyNames() {
        return propertyNames;
    }

    public Type[] getPropertyTypes() {
        return hibernateTypes;
    }

    public Object getPropertyValue(Object component, int property) throws HibernateException {
        MatrixND matrix = (MatrixND)component;
        switch (property) {
            case 0: {
                return matrix.getName();
            }
            case 1: {
                return matrix.getDim();
            }
            case 2: {
                return matrix.getDimensionNames();
            }
            case 3: {
                return matrix.getSemantics();
            }
            case 4: {
                return matrix.toList();
            }
        }
        throw new HibernateException("Property index invalid : " + property);
    }

    public void setPropertyValue(Object component, int property, Object value) throws HibernateException {
        MatrixND matrix = (MatrixND)component;
        switch (property) {
            case 0: {
                matrix.setName((String)value);
                break;
            }
            case 1: {
                throw new HibernateException("Modification of the dimension forbidden");
            }
            case 2: {
                matrix.setDimensionNames((String[])value);
                break;
            }
            case 3: {
                int index = 0;
                for (List semantics : (List[])value) {
                    matrix.setSemantic(index, semantics);
                    ++index;
                }
                break;
            }
            case 4: {
                matrix.fromList((List)value);
                break;
            }
            default: {
                throw new HibernateException("Property index invalid : " + property);
            }
        }
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        MatrixND matrix = null;
        String nameAsString = rs.getString(names[0]);
        String dimAsString = rs.getString(names[1]);
        String dimNamesAsString = rs.getString(names[2]);
        String semanticsAsString = rs.getString(names[3]);
        String datasAsString = rs.getString(names[4]);
        if (nameAsString == null && dimAsString == null && dimNamesAsString == null && semanticsAsString == null) {
            matrix = null;
        } else {
            String name = nameAsString;
            int[] dim = this.getDimFromString(dimAsString);
            String[] dimNames = this.getDimNamesFromString(dimNamesAsString);
            List[] semantics = this.getSemanticsFromString(name, semanticsAsString, session);
            List datas = MatrixHelper.convertStringToList((String)datasAsString);
            matrix = MatrixFactory.getInstance().create(name, dim);
            matrix.setDimensionNames(dimNames);
            for (int i = 0; i < semantics.length; ++i) {
                matrix.setSemantic(i, semantics[i]);
            }
            matrix.fromList(datas);
            session.getPersistenceContext();
        }
        return matrix;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            st.setString(index, null);
            st.setString(index + 1, null);
            st.setString(index + 2, null);
            st.setString(index + 3, null);
            st.setClob(index + 4, NonContextualLobCreator.INSTANCE.createClob(""));
        } else {
            MatrixND matrix = MatrixFactory.getInstance().create((MatrixND)value);
            st.setString(index, matrix.getName());
            st.setString(index + 1, this.getDimToString(matrix.getDim()));
            st.setString(index + 2, this.getDimNamesToString(matrix.getDimensionNames()));
            st.setString(index + 3, this.getSemanticsToString(matrix.getSemantics()));
            st.setClob(index + 4, NonContextualLobCreator.INSTANCE.createClob(matrix.toList().toString()));
        }
    }

    public Serializable disassemble(Object value, SessionImplementor session) throws HibernateException {
        MatrixND matrix = (MatrixND)value;
        return new Serializable[]{matrix.getName(), this.getDimToString(matrix.getDim()), this.getDimNamesToString(matrix.getDimensionNames()), this.getSemanticsToString(matrix.getSemantics()), matrix.toList().toString()};
    }

    public Object assemble(Serializable cached, SessionImplementor session, Object owner) throws HibernateException {
        Serializable[] o = (Serializable[])cached;
        String name = (String)((Object)o[0]);
        int[] dim = this.getDimFromString((String)((Object)o[1]));
        String[] dimNames = this.getDimNamesFromString((String)((Object)o[2]));
        List[] semantics = this.getSemanticsFromString(name, (String)((Object)o[3]), session);
        List datas = MatrixHelper.convertStringToList((String)((String)((Object)o[4])));
        MatrixND matrix = MatrixFactory.getInstance().create(name, dim);
        matrix.setDimensionNames(dimNames);
        for (int i = 0; i < semantics.length; ++i) {
            matrix.setSemantic(i, semantics[i]);
        }
        matrix.fromList(datas);
        return matrix;
    }

    public Object replace(Object original, Object target, SessionImplementor session, Object owner) throws HibernateException {
        return this.assemble(this.disassemble(original, session), session, owner);
    }
}

