/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.IsisConfig;
import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.datastore.SensitivityAnalysisStorage;
import fr.ifremer.isisfish.datastore.SensitivityExportStorage;
import fr.ifremer.isisfish.datastore.SimulationPlanStorage;
import fr.ifremer.isisfish.datastore.StorageHelper;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationDAO;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.StrategyDAO;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.export.ExportHelper;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.rule.RuleHelper;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.SimulationPlan;
import fr.ifremer.isisfish.simulator.SimulationPlanIndependent;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityAnalysis;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixHelper;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.SortedProperties;
import org.nuiton.util.StringUtil;

public class SimulationParameterImpl
implements SimulationParameter {
    private static Log log = LogFactory.getLog(SimulationParameterImpl.class);
    protected Properties propertiesParameters;
    protected String isisFishVersion;
    protected String description;
    protected String regionName;
    protected Integer numberOfYear;
    protected String simulatorName;
    protected Boolean useOptimization;
    protected Boolean useStatistic;
    protected List<Strategy> strategies;
    protected List<Population> populations;
    protected Map<Population, MatrixND> numbers;
    protected List<Rule> rules;
    protected List<String> extraRules;
    protected List<SimulationPlan> simulationPlans;
    protected List<String> exportNames;
    protected Boolean usePreScript;
    protected String preScript;
    protected Boolean useSimulationPlan;
    protected Integer simulationPlanNumber;
    protected List<SensitivityExport> sensitivityExports;
    protected Integer numberOfSensitivitySimulation;
    protected SensitivityAnalysis sensitivityAnalysis;
    protected Collection<String> resultEnabled;
    protected Map<String, String> tagValue;
    protected Boolean onlyExport;
    protected String simulLogLevel;
    protected String scriptLogLevel;
    protected String libLogLevel;
    protected transient RegionStorage region;

    @Override
    public List<String> check() {
        ArrayList<String> result = new ArrayList<String>();
        return result;
    }

    @Override
    public String getIsisFishVersion() {
        if (this.isisFishVersion == null) {
            this.isisFishVersion = this.propertiesParameters != null ? this.propertiesParameters.getProperty("isisFishVersion", "") : IsisConfig.getVersion();
        }
        return this.isisFishVersion;
    }

    @Override
    public void setIsisFishVersion(String isisFishVersion) {
        this.isisFishVersion = isisFishVersion;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.description = this.propertiesParameters != null ? this.propertiesParameters.getProperty("description", "") : "";
        }
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public RegionStorage getRegion() {
        if (this.region == null || !this.region.getName().equals(this.getRegionName())) {
            this.region = RegionStorage.getRegion(this.getRegionName());
        } else if (log.isDebugEnabled()) {
            log.debug((Object)I18n._((String)"Region %s already inited", (Object[])new Object[]{this.getRegionName()}));
        }
        return this.region;
    }

    @Override
    public MatrixND getNumberOf(Population pop) {
        MatrixND result;
        if (this.numbers == null) {
            this.numbers = new LinkedHashMap<Population, MatrixND>();
        }
        if ((result = this.numbers.get(pop)) == null) {
            List<PopulationGroup> groups = pop.getPopulationGroup();
            List<Zone> zones = pop.getPopulationZone();
            if (groups.size() == 0) {
                groups.add((PopulationGroup)((Object)"No group"));
            }
            if (zones.size() == 0) {
                zones.add((Zone)((Object)"No zone"));
            }
            List[] semantics = new List[]{groups, zones};
            result = MatrixFactory.getInstance().create(semantics);
            this.numbers.put(pop, result);
        }
        return result;
    }

    @Override
    public List<String> getExtraRules() {
        if (this.extraRules == null) {
            this.extraRules = new ArrayList<String>();
        }
        return this.extraRules;
    }

    @Override
    public void addExtraRules(String ... extraRules) {
        this.getExtraRules().addAll(Arrays.asList(extraRules));
    }

    @Override
    public List<Population> getPopulations() {
        block11: {
            if (this.populations == null) {
                this.populations = new ArrayList<Population>();
                if (this.propertiesParameters != null) {
                    try {
                        String[] populationList;
                        boolean mustClose = false;
                        TopiaContext tx = SimulationContext.get().getDB();
                        if (tx == null) {
                            tx = this.getRegion().getStorage().beginTransaction();
                            mustClose = true;
                        }
                        PopulationDAO populationDAO = IsisFishDAOHelper.getPopulationDAO(tx);
                        for (String name : populationList = this.propertiesParameters.getProperty("populations", "").split(",")) {
                            if (name == null || "".equals(name)) continue;
                            try {
                                Object population = populationDAO.findByName(name);
                                this.populations.add((Population)population);
                                String numberAsString = this.propertiesParameters.getProperty("population." + name + ".number");
                                List number = MatrixHelper.convertStringToList((String)numberAsString);
                                MatrixND mat = this.getNumberOf((Population)population);
                                mat.fromList(number);
                            }
                            catch (TopiaException eee) {
                                if (!log.isWarnEnabled()) continue;
                                log.warn((Object)("Can't find population: " + name), (Throwable)eee);
                            }
                        }
                        if (mustClose) {
                            tx.closeContext();
                        }
                        break block11;
                    }
                    catch (TopiaException eee1) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)"Can't get PopulationDAO", (Throwable)eee1);
                        }
                        break block11;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No last read properties, skip population reloading");
                }
            }
        }
        return this.populations;
    }

    @Override
    public void setPopulations(List<Population> populations) {
        this.populations = populations;
    }

    @Override
    public List<Strategy> getStrategies() {
        block11: {
            if (this.strategies == null) {
                this.strategies = new ArrayList<Strategy>();
                if (this.propertiesParameters != null) {
                    this.strategies = new ArrayList<Strategy>();
                    try {
                        String[] strategyList;
                        boolean mustClose = false;
                        TopiaContext tx = SimulationContext.get().getDB();
                        if (tx == null) {
                            tx = this.getRegion().getStorage().beginTransaction();
                            mustClose = true;
                        }
                        StrategyDAO strategyDAO = IsisFishDAOHelper.getStrategyDAO(tx);
                        for (String name : strategyList = this.propertiesParameters.getProperty("strategies", "").split(",")) {
                            if (name == null || "".equals(name)) continue;
                            try {
                                Object str = strategyDAO.findByName(name);
                                this.strategies.add((Strategy)str);
                            }
                            catch (TopiaException eee) {
                                if (!log.isWarnEnabled()) continue;
                                log.warn((Object)("Can't find strategy: " + name), (Throwable)eee);
                            }
                        }
                        if (mustClose) {
                            tx.closeContext();
                        }
                        break block11;
                    }
                    catch (TopiaException eee1) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)"Can't get StrategyDAO", (Throwable)eee1);
                        }
                        break block11;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No last read properties, skip strategies reloading");
                }
            }
        }
        return this.strategies;
    }

    @Override
    public void setStrategies(List<Strategy> strategies) {
        this.strategies = strategies;
    }

    @Override
    public void addSimulationPlan(SimulationPlan plan) {
        this.getSimulationPlans().add(plan);
    }

    @Override
    public boolean removeSimulationPlan(SimulationPlan plan) {
        return this.getSimulationPlans().remove(plan);
    }

    @Override
    public List<SimulationPlan> getSimulationPlans() {
        if (this.simulationPlans == null) {
            this.simulationPlans = new ArrayList<SimulationPlan>();
            if (this.propertiesParameters != null) {
                String[] planList = this.propertiesParameters.getProperty("plans", "").split(",");
                int planIndex = 0;
                for (String name : planList) {
                    if (name == null || "".equals(name)) continue;
                    try {
                        SimulationPlanStorage planStorage = SimulationPlanStorage.getSimulationPlan(name, new CodeSourceStorage.Location[0]);
                        if (planStorage == null) continue;
                        SimulationPlan plan = planStorage.getNewSimulationPlanInstance();
                        StorageHelper.populateStorageParams(planIndex++, this.getRegion().getStorage(), plan, this.propertiesParameters, "plan");
                        this.simulationPlans.add(plan);
                    }
                    catch (IsisFishException eee) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)("Can't find plan: " + name), (Throwable)eee);
                    }
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"No last read properties, skip plans reloading");
            }
        }
        return this.simulationPlans;
    }

    @Override
    public void setSimulationPlans(List<SimulationPlan> plans) {
        this.simulationPlans = plans;
    }

    @Override
    public boolean isIndependentPlan() {
        boolean result = true;
        for (SimulationPlan plan : this.getSimulationPlans()) {
            if (plan instanceof SimulationPlanIndependent) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public void clearPlans() {
        if (this.simulationPlans != null) {
            this.simulationPlans.clear();
        }
    }

    @Override
    public void addRule(Rule rule) {
        this.getRules().add(rule);
    }

    @Override
    public boolean removeRule(Rule rule) {
        return this.getRules().remove(rule);
    }

    @Override
    public List<Rule> getRules() {
        block11: {
            if (this.rules == null) {
                this.rules = new ArrayList<Rule>();
                if (this.propertiesParameters != null) {
                    try {
                        boolean mustClose = false;
                        TopiaContext tx = SimulationContext.get().getDB();
                        if (tx == null) {
                            tx = this.getRegion().getStorage().beginTransaction();
                            mustClose = true;
                        }
                        String[] ruleList = this.propertiesParameters.getProperty("rules", "").split(",");
                        int ruleIndex = 0;
                        for (String name : ruleList) {
                            if (name == null || "".equals(name)) continue;
                            try {
                                Rule rule = RuleStorage.getRule(name, new CodeSourceStorage.Location[0]).getNewRuleInstance();
                                RuleHelper.populateRule(ruleIndex++, tx, rule, this.propertiesParameters);
                                this.rules.add(rule);
                            }
                            catch (IsisFishException eee) {
                                if (!log.isWarnEnabled()) continue;
                                log.warn((Object)("Can't find rule: " + name), (Throwable)eee);
                            }
                        }
                        if (mustClose) {
                            tx.closeContext();
                        }
                        break block11;
                    }
                    catch (TopiaException eee1) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)"Can't get TopiaContext", (Throwable)eee1);
                        }
                        break block11;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No last read properties, skip rule reloading");
                }
            }
        }
        return this.rules;
    }

    @Override
    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    @Override
    public void clearRules() {
        if (this.rules != null) {
            this.rules.clear();
        }
    }

    @Override
    public boolean getUseOptimization() {
        if (this.useOptimization == null) {
            this.useOptimization = this.propertiesParameters != null ? Boolean.valueOf(this.propertiesParameters.getProperty("useOptimization", "true")) : Boolean.TRUE;
        }
        return this.useOptimization;
    }

    @Override
    public void setUseOptimization(boolean useOptimization) {
        this.useOptimization = useOptimization;
    }

    @Override
    public boolean getUseStatistic() {
        if (this.useStatistic == null) {
            this.useStatistic = this.propertiesParameters != null ? Boolean.valueOf(this.propertiesParameters.getProperty("useStatistic", "false")) : Boolean.FALSE;
        }
        return this.useStatistic;
    }

    @Override
    public void setUseStatistic(boolean useStatistic) {
        this.useStatistic = useStatistic;
    }

    @Override
    public List<String> getExportNames() {
        if (this.exportNames == null) {
            this.exportNames = new ArrayList<String>();
            if (this.propertiesParameters != null) {
                String[] exportList;
                for (String name : exportList = this.propertiesParameters.getProperty("exports", "").split(",")) {
                    if (name == null || "".equals(name)) continue;
                    this.exportNames.add(name);
                }
            }
        }
        return this.exportNames;
    }

    @Override
    public void setExportNames(List<String> exportNames) {
        this.exportNames = exportNames;
    }

    @Override
    public int getNumberOfSensitivitySimulation() {
        if (this.numberOfSensitivitySimulation == null) {
            this.numberOfSensitivitySimulation = this.propertiesParameters != null ? Integer.valueOf(this.propertiesParameters.getProperty("numberOfSensitivitySimulation", "-1")) : Integer.valueOf(-1);
        }
        return this.numberOfSensitivitySimulation;
    }

    @Override
    public void setNumberOfSensitivitySimulation(int numberOfSensitivitySimulation) {
        this.numberOfSensitivitySimulation = numberOfSensitivitySimulation;
    }

    @Override
    public SensitivityAnalysis getSensitivityAnalysis() {
        block3: {
            String analysisName;
            if (this.sensitivityAnalysis == null && this.propertiesParameters != null && !StringUtils.isEmpty((CharSequence)(analysisName = this.propertiesParameters.getProperty("sensitivityanalysis")))) {
                try {
                    SensitivityAnalysisStorage sensitivityStorage = SensitivityAnalysisStorage.getSensitivityAnalysis(analysisName, new CodeSourceStorage.Location[0]);
                    this.sensitivityAnalysis = sensitivityStorage.getNewSensitivityAnalysisInstance();
                    StorageHelper.populateStorageParams(0, this.getRegion().getStorage(), this.sensitivityAnalysis, this.propertiesParameters, "sensitivity");
                }
                catch (IsisFishException eee) {
                    this.sensitivityAnalysis = null;
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)("Can't find sensitivity: " + this.sensitivityAnalysis), (Throwable)eee);
                }
            }
        }
        return this.sensitivityAnalysis;
    }

    @Override
    public void setSensitivityAnalysis(SensitivityAnalysis sensitivityAnalysis) {
        this.sensitivityAnalysis = sensitivityAnalysis;
    }

    @Override
    public List<SensitivityExport> getSensitivityExport() {
        block11: {
            if (this.sensitivityExports == null) {
                this.sensitivityExports = new ArrayList<SensitivityExport>();
                if (this.propertiesParameters != null) {
                    try {
                        boolean mustClose = false;
                        TopiaContext tx = SimulationContext.get().getDbResult();
                        if (tx == null) {
                            tx = this.getRegion().getStorage().beginTransaction();
                            mustClose = true;
                        }
                        String[] sensitivityExportList = this.propertiesParameters.getProperty("sensitivityexports", "").split(",");
                        int sensitivityExportIndex = 0;
                        for (String name : sensitivityExportList) {
                            try {
                                if (StringUtils.isEmpty((CharSequence)name)) continue;
                                SensitivityExport sensitivityExport = SensitivityExportStorage.getSensitivityExport(name, new CodeSourceStorage.Location[0]).getNewSensitivityExportInstance();
                                ExportHelper.populateSensitivityExport(sensitivityExportIndex++, tx, sensitivityExport, this.propertiesParameters);
                                this.sensitivityExports.add(sensitivityExport);
                            }
                            catch (IsisFishException eee) {
                                if (!log.isWarnEnabled()) continue;
                                log.warn((Object)("Can't find SensitivityExport: " + name), (Throwable)eee);
                            }
                        }
                        if (mustClose) {
                            tx.closeContext();
                        }
                        break block11;
                    }
                    catch (TopiaException eee1) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)"Can't get TopiaContext", (Throwable)eee1);
                        }
                        break block11;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No last read properties, skip sensitivity exports reloading");
                }
            }
        }
        return this.sensitivityExports;
    }

    @Override
    public void setSensitivityExport(List<SensitivityExport> sensitivityExport) {
        this.sensitivityExports = sensitivityExport;
    }

    @Override
    public boolean getUseSimulationPlan() {
        if (this.useSimulationPlan == null) {
            this.useSimulationPlan = this.propertiesParameters != null ? Boolean.valueOf(this.propertiesParameters.getProperty("useSimulationPlan", "false")) : Boolean.FALSE;
        }
        return this.useSimulationPlan;
    }

    @Override
    public void setUseSimulationPlan(boolean useSimulationPlan) {
        this.useSimulationPlan = useSimulationPlan;
    }

    @Override
    public int getSimulationPlanNumber() {
        if (this.simulationPlanNumber == null) {
            this.simulationPlanNumber = this.propertiesParameters != null ? Integer.valueOf(this.propertiesParameters.getProperty("simulationPlanNumber", "-1")) : Integer.valueOf(-1);
        }
        return this.simulationPlanNumber;
    }

    @Override
    public void setSimulationPlanNumber(int simulationPlanNumber) {
        this.simulationPlanNumber = simulationPlanNumber;
    }

    @Override
    public int getNumberOfYear() {
        if (this.numberOfYear == null) {
            this.numberOfYear = this.propertiesParameters != null ? Integer.valueOf(this.propertiesParameters.getProperty("numberOfYear", "1")) : Integer.valueOf(1);
        }
        return this.numberOfYear;
    }

    @Override
    public void setNumberOfYear(int numberOfYear) {
        this.numberOfYear = numberOfYear;
    }

    @Override
    public boolean getUsePreScript() {
        if (this.usePreScript == null) {
            this.usePreScript = this.propertiesParameters != null ? Boolean.valueOf(this.propertiesParameters.getProperty("usePreScript", "false")) : Boolean.FALSE;
        }
        return this.usePreScript;
    }

    @Override
    public void setUsePreScript(boolean usePreScript) {
        this.usePreScript = usePreScript;
    }

    @Override
    public String getPreScript() {
        if (this.preScript == null) {
            this.preScript = this.propertiesParameters != null ? this.propertiesParameters.getProperty("preScript", "") : "";
        }
        return this.preScript;
    }

    @Override
    public void setPreScript(String preScript) {
        this.preScript = preScript;
    }

    @Override
    public String getRegionName() {
        if (this.regionName == null) {
            this.regionName = this.propertiesParameters != null ? this.propertiesParameters.getProperty("regionName", "") : "";
        }
        return this.regionName;
    }

    @Override
    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    @Override
    public String getSimulatorName() {
        if (this.simulatorName == null) {
            this.simulatorName = this.propertiesParameters != null ? this.propertiesParameters.getProperty("simulatorName", "DefaultSimulator.java") : "DefaultSimulator.java";
        }
        return this.simulatorName;
    }

    @Override
    public void setSimulatorName(String simulatorName) {
        this.simulatorName = simulatorName;
    }

    @Override
    public Collection<String> getResultEnabled() {
        if (this.resultEnabled == null) {
            this.resultEnabled = new LinkedList<String>();
            if (this.propertiesParameters != null) {
                String[] resultList;
                for (String name : resultList = this.propertiesParameters.getProperty("resultNames", "").split(",")) {
                    if (name == null || "".equals(name)) continue;
                    this.resultEnabled.add(name);
                }
            }
        }
        return this.resultEnabled;
    }

    @Override
    public void setResultEnabled(Collection<String> resultEnabled) {
        this.resultEnabled = resultEnabled;
    }

    @Override
    public Map<String, String> getTagValue() {
        if (this.tagValue == null) {
            this.tagValue = new LinkedHashMap<String, String>();
            if (this.propertiesParameters != null) {
                for (Object k : this.propertiesParameters.keySet()) {
                    if (!k.toString().startsWith("tagValue.")) continue;
                    String key = k.toString().substring("tagValue.".length());
                    String value = this.propertiesParameters.getProperty(k.toString());
                    this.getTagValue().put(key, value);
                }
            }
        }
        return this.tagValue;
    }

    @Override
    public void setTagValue(Map<String, String> tagValue) {
        this.tagValue = tagValue;
    }

    @Override
    public String getSimulLogLevel() {
        if (this.simulLogLevel == null) {
            this.simulLogLevel = this.propertiesParameters != null ? this.propertiesParameters.getProperty("simulLogLevel", "info") : "info";
        }
        return this.simulLogLevel;
    }

    @Override
    public void setSimulLogLevel(String logLevel) {
        if (log.isDebugEnabled()) {
            log.debug((Object)I18n._((String)"isisfish.params.changeLogLev", (Object[])new Object[]{this.simulLogLevel, logLevel}));
        }
        this.simulLogLevel = logLevel;
    }

    @Override
    public String getScriptLogLevel() {
        if (this.scriptLogLevel == null) {
            this.scriptLogLevel = this.propertiesParameters != null ? this.propertiesParameters.getProperty("scriptLogLevel", "info") : "info";
        }
        return this.scriptLogLevel;
    }

    @Override
    public void setScriptLogLevel(String logLevel) {
        if (log.isDebugEnabled()) {
            log.debug((Object)I18n._((String)"isisfish.params.changeLogLev", (Object[])new Object[]{this.scriptLogLevel, logLevel}));
        }
        this.scriptLogLevel = logLevel;
    }

    @Override
    public String getLibLogLevel() {
        if (this.libLogLevel == null) {
            this.libLogLevel = this.propertiesParameters != null ? this.propertiesParameters.getProperty("libLogLevel", "error") : "error";
        }
        return this.libLogLevel;
    }

    @Override
    public void setLibLogLevel(String logLevel) {
        if (log.isDebugEnabled()) {
            log.debug((Object)I18n._((String)"isisfish.params.changeLogLev", (Object[])new Object[]{this.libLogLevel, logLevel}));
        }
        this.libLogLevel = logLevel;
    }

    @Override
    public boolean isSimulErrorLevel() {
        return "error".equals(this.getSimulLogLevel());
    }

    @Override
    public boolean isSimulWarnLevel() {
        return "warn".equals(this.getSimulLogLevel());
    }

    @Override
    public boolean isSimulInfoLevel() {
        return "info".equals(this.getSimulLogLevel());
    }

    @Override
    public boolean isSimulDebugLevel() {
        return "debug".equals(this.getSimulLogLevel());
    }

    @Override
    public boolean isScriptErrorLevel() {
        return "error".equals(this.getScriptLogLevel());
    }

    @Override
    public boolean isScriptWarnLevel() {
        return "warn".equals(this.getScriptLogLevel());
    }

    @Override
    public boolean isScriptInfoLevel() {
        return "info".equals(this.getScriptLogLevel());
    }

    @Override
    public boolean isScriptDebugLevel() {
        return "debug".equals(this.getScriptLogLevel());
    }

    @Override
    public boolean isLibErrorLevel() {
        return "error".equals(this.getLibLogLevel());
    }

    @Override
    public boolean isLibWarnLevel() {
        return "warn".equals(this.getLibLogLevel());
    }

    @Override
    public boolean isLibInfoLevel() {
        return "info".equals(this.getLibLogLevel());
    }

    @Override
    public boolean isLibDebugLevel() {
        return "debug".equals(this.getLibLogLevel());
    }

    @Override
    public void setProperty(String key, String value) {
        this.propertiesParameters.setProperty(key, value);
    }

    @Override
    public SimulationParameter copy() {
        SimulationParameterImpl result = new SimulationParameterImpl();
        if (this.propertiesParameters != null) {
            result.propertiesParameters = new SortedProperties();
            result.propertiesParameters.putAll((Map<?, ?>)this.propertiesParameters);
        }
        result.isisFishVersion = this.getIsisFishVersion();
        result.description = this.getDescription();
        result.regionName = this.getRegionName();
        result.numberOfYear = this.getNumberOfYear();
        result.simulatorName = this.getSimulatorName();
        result.useOptimization = this.getUseOptimization();
        result.useStatistic = this.getUseStatistic();
        result.usePreScript = this.getUsePreScript();
        result.preScript = this.getPreScript();
        result.useSimulationPlan = this.getUseSimulationPlan();
        result.simulationPlanNumber = this.getSimulationPlanNumber();
        if (this.exportNames != null) {
            result.exportNames = new LinkedList<String>(this.exportNames);
        }
        if (this.strategies != null) {
            result.strategies = new LinkedList<Strategy>(this.strategies);
        }
        if (this.populations != null) {
            result.populations = new LinkedList<Population>(this.populations);
        }
        if (this.rules != null) {
            result.rules = new LinkedList<Rule>(this.rules);
        }
        if (this.simulationPlans != null) {
            result.simulationPlans = new LinkedList<SimulationPlan>(this.simulationPlans);
        }
        if (this.resultEnabled != null) {
            result.resultEnabled = new LinkedList<String>(this.resultEnabled);
        }
        if (this.numbers != null) {
            result.numbers = new HashMap<Population, MatrixND>(this.numbers);
        }
        if (this.tagValue != null) {
            result.tagValue = new HashMap<String, String>(this.tagValue);
        }
        result.simulLogLevel = this.getSimulLogLevel();
        result.scriptLogLevel = this.getScriptLogLevel();
        result.libLogLevel = this.getLibLogLevel();
        result.numberOfSensitivitySimulation = this.getNumberOfSensitivitySimulation();
        if (this.sensitivityExports != null) {
            result.sensitivityExports = new LinkedList<SensitivityExport>(this.sensitivityExports);
        }
        result.sensitivityAnalysis = this.sensitivityAnalysis;
        return result;
    }

    @Override
    public SimulationParameter deepCopy() {
        Properties props = this.toProperties();
        SimulationParameterImpl newInstance = new SimulationParameterImpl();
        newInstance.fromProperties(props);
        return newInstance;
    }

    @Override
    public String toString() {
        String param;
        String name;
        StringBuffer result = new StringBuffer();
        result.append(I18n._((String)"isisfish.params.toString.simulation.done", (Object[])new Object[]{this.getIsisFishVersion()})).append('\n');
        result.append("--------------------\n");
        result.append(this.getDescription()).append('\n');
        result.append("--------------------\n");
        if (this.getUseSimulationPlan()) {
            result.append(I18n._((String)"isisfish.params.toString.plan.number", (Object[])new Object[]{this.getSimulationPlanNumber()}));
        }
        RegionStorage region = this.getRegion();
        result.append(I18n._((String)"isisfish.params.toString.fishery", (Object[])new Object[]{region.getName()}));
        result.append(I18n._((String)"isisfish.params.toString.number.years", (Object[])new Object[]{this.getNumberOfYear()}));
        List<Strategy> strs = this.getStrategies();
        result.append(I18n._((String)"isisfish.params.toString.strategies", (Object[])new Object[0]));
        String sep = "";
        for (Strategy str : strs) {
            result.append(sep).append(str.getName());
            sep = ",";
        }
        result.append("\n\n");
        result.append(I18n._((String)"isisfish.params.toString.populations", (Object[])new Object[0]));
        sep = "";
        for (Population pop : this.getPopulations()) {
            result.append(sep).append(pop.getName());
            sep = ",";
        }
        result.append("\n\n");
        for (Rule rule : this.getRules()) {
            block9: {
                name = RuleStorage.getName(rule);
                param = "";
                try {
                    param = RuleStorage.getParamAsString(rule);
                }
                catch (IsisFishException eee) {
                    if (!log.isWarnEnabled()) break block9;
                    log.warn((Object)("Can't convert rule parameter to string for " + name), (Throwable)eee);
                }
            }
            result.append(I18n._((String)"isisfish.params.toString.rule", (Object[])new Object[]{name}));
            result.append('\n');
            result.append(param);
            result.append("\n");
        }
        result.append("\n\n");
        for (SimulationPlan plan : this.getSimulationPlans()) {
            block10: {
                name = RuleStorage.getName(plan);
                param = "";
                try {
                    param = SimulationPlanStorage.getParamAsString(plan);
                }
                catch (IsisFishException eee) {
                    if (!log.isWarnEnabled()) break block10;
                    log.warn((Object)("Can't convert plan parameter to string for " + name), (Throwable)eee);
                }
            }
            result.append(I18n._((String)"isisfish.params.toString.plan", (Object[])new Object[]{name}));
            result.append('\n');
            result.append(param);
            result.append('\n');
        }
        result.append('\n');
        result.append(I18n._((String)"isisfish.params.toString.script.presimulation", (Object[])new Object[0])).append(":\n");
        result.append(this.getPreScript());
        result.append('\n');
        result.append(I18n._((String)"isisfish.params.toString.simul.logger.level", (Object[])new Object[]{this.simulLogLevel}));
        result.append('\n');
        result.append(I18n._((String)"isisfish.params.toString.script.logger.level", (Object[])new Object[]{this.scriptLogLevel}));
        result.append('\n');
        result.append(I18n._((String)"isisfish.params.toString.lib.logger.level", (Object[])new Object[]{this.libLogLevel}));
        result.append('\n');
        return result.toString();
    }

    @Override
    public Properties toProperties() {
        SortedProperties result = new SortedProperties();
        result.setProperty("isisFishVersion", this.getIsisFishVersion());
        result.setProperty("description", this.getDescription());
        result.setProperty("regionName", this.getRegionName());
        result.setProperty("numberOfYear", String.valueOf(this.getNumberOfYear()));
        result.setProperty("simulatorName", this.getSimulatorName());
        result.setProperty("useOptimization", String.valueOf(this.getUseOptimization()));
        result.setProperty("useStatistic", String.valueOf(this.getUseStatistic()));
        if (this.strategies != null) {
            String strategyList = "";
            for (Strategy str : this.getStrategies()) {
                strategyList = strategyList + str.getName() + ",";
            }
            result.setProperty("strategies", StringUtil.substring((String)strategyList, (int)0, (int)-1));
        } else if (this.propertiesParameters != null && this.propertiesParameters.containsKey("strategies")) {
            result.setProperty("strategies", this.propertiesParameters.getProperty("strategies"));
        }
        if (this.populations != null) {
            String populationList = "";
            for (Population pop : this.getPopulations()) {
                populationList = populationList + pop.getName() + ",";
                MatrixND matrixND = this.getNumberOf(pop);
                String numberAsString = String.valueOf(matrixND.toList());
                result.setProperty("population." + pop.getName() + ".number", numberAsString);
            }
            result.setProperty("populations", StringUtil.substring((String)populationList, (int)0, (int)-1));
        } else if (this.propertiesParameters != null && this.propertiesParameters.containsKey("populations")) {
            result.setProperty("populations", this.propertiesParameters.getProperty("populations"));
            for (String key : this.propertiesParameters.stringPropertyNames()) {
                if (!key.startsWith("population.")) continue;
                result.setProperty(key, this.propertiesParameters.getProperty(key));
            }
        }
        if (this.rules != null) {
            String ruleList = "";
            int ruleIndex = 0;
            for (Rule rule : this.getRules()) {
                ruleList = ruleList + RuleStorage.getName(rule) + ",";
                Properties ruleProp = RuleHelper.getRuleAsProperties(ruleIndex++, this.getRegion().getStorage(), rule);
                result.putAll((Map<?, ?>)ruleProp);
            }
            result.setProperty("rules", ruleList);
        } else if (this.propertiesParameters != null && this.propertiesParameters.containsKey("rules")) {
            result.setProperty("rules", this.propertiesParameters.getProperty("rules"));
            for (String key : this.propertiesParameters.stringPropertyNames()) {
                if (!key.startsWith("rule.")) continue;
                result.setProperty(key, this.propertiesParameters.getProperty(key));
            }
        }
        if (this.simulationPlans != null) {
            String planList = "";
            int planIndex = 0;
            for (SimulationPlan simulationPlan : this.getSimulationPlans()) {
                planList = planList + SimulationPlanStorage.getName(simulationPlan) + ",";
                Properties planProp = StorageHelper.getParamsAsProperties(planIndex++, this.getRegion().getStorage(), simulationPlan, "plan");
                result.putAll((Map<?, ?>)planProp);
            }
            result.setProperty("plans", planList);
        } else if (this.propertiesParameters != null && this.propertiesParameters.containsKey("plans")) {
            result.setProperty("plans", this.propertiesParameters.getProperty("plans"));
            for (String key : this.propertiesParameters.stringPropertyNames()) {
                if (!key.startsWith("plan.")) continue;
                result.setProperty(key, this.propertiesParameters.getProperty(key));
            }
        }
        String exportList = "";
        for (String export : this.getExportNames()) {
            exportList = exportList + export + ",";
        }
        result.setProperty("exports", exportList);
        result.setProperty("numberOfSensitivitySimulation", String.valueOf(this.getNumberOfSensitivitySimulation()));
        if (this.sensitivityAnalysis != null) {
            String analysisName = SensitivityAnalysisStorage.getName(this.getSensitivityAnalysis());
            result.setProperty("sensitivityanalysis", analysisName);
            Properties analysisParams = StorageHelper.getParamsAsProperties(0, this.getRegion().getStorage(), this.getSensitivityAnalysis(), "sensitivity");
            result.putAll((Map<?, ?>)analysisParams);
        } else if (this.propertiesParameters != null && this.propertiesParameters.containsKey("sensitivityanalysis")) {
            result.setProperty("sensitivityanalysis", this.propertiesParameters.getProperty("sensitivityanalysis"));
            for (String key : this.propertiesParameters.stringPropertyNames()) {
                if (!key.startsWith("sensitivity.")) continue;
                result.setProperty(key, this.propertiesParameters.getProperty(key));
            }
        }
        if (this.sensitivityExports != null) {
            String sensitivityExportList = "";
            int sensitivityExportIndex = 0;
            for (SensitivityExport sensitivityExport : this.getSensitivityExport()) {
                sensitivityExportList = sensitivityExportList + SensitivityExportStorage.getName(sensitivityExport) + ",";
                Properties exportProp = ExportHelper.getSensitivityExportAsProperties(sensitivityExportIndex++, this.getRegion().getStorage(), sensitivityExport);
                result.putAll((Map<?, ?>)exportProp);
            }
            result.setProperty("sensitivityexports", sensitivityExportList);
        } else if (this.propertiesParameters != null && this.propertiesParameters.containsKey("sensitivityexports")) {
            result.setProperty("sensitivityexports", this.propertiesParameters.getProperty("sensitivityexports"));
            for (String key : this.propertiesParameters.stringPropertyNames()) {
                if (!key.startsWith("sensitivityexport.")) continue;
                result.setProperty(key, this.propertiesParameters.getProperty(key));
            }
        }
        result.setProperty("usePreScript", String.valueOf(this.getUsePreScript()));
        result.setProperty("preScript", this.getPreScript());
        result.setProperty("useSimulationPlan", String.valueOf(this.getUseSimulationPlan()));
        result.setProperty("simulationPlanNumber", String.valueOf(this.getSimulationPlanNumber()));
        String resultList = "";
        for (String string : this.getResultEnabled()) {
            resultList = resultList + string + ",";
        }
        result.setProperty("resultNames", resultList);
        for (Map.Entry entry : this.getTagValue().entrySet()) {
            result.setProperty("tagValue." + (String)entry.getKey(), (String)entry.getValue());
        }
        result.setProperty("simulLogLevel", this.getSimulLogLevel());
        result.setProperty("scriptLogLevel", this.getScriptLogLevel());
        result.setProperty("libLogLevel", this.getLibLogLevel());
        return result;
    }

    @Override
    public void fromProperties(Properties props) {
        this.propertiesParameters = props;
    }

    @Override
    public void reloadContextParameters() throws TopiaException {
        boolean mustClose = false;
        TopiaContext tx = SimulationContext.get().getDB();
        if (tx == null) {
            tx = this.getRegion().getStorage().beginTransaction();
            mustClose = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Reloading rules");
        }
        for (Rule rule : this.getRules()) {
            try {
                for (Field field : rule.getClass().getFields()) {
                    TopiaEntity entity;
                    if (!Modifier.isPublic(field.getModifiers()) || !TopiaEntity.class.isAssignableFrom(field.getType()) || (entity = (TopiaEntity)field.get(rule)) == null) continue;
                    TopiaEntity newEntity = tx.findByTopiaId(entity.getTopiaId());
                    field.set(rule, newEntity);
                }
            }
            catch (IllegalArgumentException e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Can't refresh rule field", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Can't access rule field", (Throwable)e);
            }
        }
        if (mustClose) {
            tx.commitTransaction();
            tx.closeContext();
        }
    }
}

