/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.logging.console;

import fr.ifremer.isisfish.ui.logging.console.LogMailUI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.FileUtil;
import org.nuiton.util.ZipUtil;
import org.nuiton.widget.StatusBar;

public class LogMail
extends LogMailUI {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(LogMail.class);
    protected File simulationFile;
    protected File logFile;
    protected String smtpServer;
    protected String to;
    protected String from;
    protected StatusBar statusBar;

    public LogMail(final StatusBar statusBar, String from, File logFile, File simulationFile, final String smtpServer) {
        this.setTitle(I18n._((String)"isisfish.log.mail.send.title", (Object[])new Object[]{simulationFile.getName()}));
        this.from = from;
        this.logFile = logFile;
        this.simulationFile = simulationFile;
        this.smtpServer = smtpServer;
        this.statusBar = statusBar;
        this.sendMail.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    LogMail.this.sendMail(LogMail.this.mailTo.getText(), LogMail.this.content.getText(), LogMail.this.sendAll.isSelected());
                    statusBar.setStatus(I18n._((String)"isisfish.log.mail.send", (Object[])new Object[]{LogMail.this.to}));
                }
                catch (Exception eee) {
                    statusBar.setStatus(I18n._((String)"isisfish.log.mail.failed", (Object[])new Object[]{smtpServer}));
                }
                finally {
                    LogMail.this.dispose();
                }
            }
        });
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void sendMail(String to, String text, boolean selected) throws IOException, MessagingException {
        Properties props = System.getProperties();
        props.put("mail.smtp.host", this.smtpServer);
        Session session = Session.getDefaultInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(this.from));
        msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to, (boolean)false));
        MimeMultipart bodyMime = new MimeMultipart("mixed");
        MimeBodyPart attPart = new MimeBodyPart();
        String subject = I18n._((String)"isisfish.log.simulation.name", (Object[])new Object[]{this.simulationFile.getName()});
        msg.setSubject(subject);
        File tmpDirectory = null;
        if (!selected) {
            File zipFile = this.logFile;
            final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
            BufferedWriter zipWriter = new BufferedWriter(new OutputStreamWriter(zipOutputStream));
            zipOutputStream.putNextEntry(new ZipEntry(zipFile.getName()));
            String content = FileUtil.readAsString((File)zipFile);
            zipWriter.write(content);
            zipWriter.flush();
            zipOutputStream.closeEntry();
            zipWriter.close();
            attPart.setDataHandler(new DataHandler(new DataSource(){

                public String getContentType() {
                    return "application/zip";
                }

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                }

                public String getName() {
                    return LogMail.this.simulationFile.getName() + ".zip";
                }

                public OutputStream getOutputStream() throws IOException {
                    return null;
                }
            }));
        } else {
            File root = this.simulationFile;
            tmpDirectory = FileUtil.createTempDirectory((String)"isis-simultation-", (String)"-sendLog");
            final File zipFile = new File(tmpDirectory, root.getName() + ".zip");
            ZipUtil.compress((File)zipFile, (File)root, null);
            attPart.setDataHandler(new DataHandler(new DataSource(){

                public String getContentType() {
                    return "application/zip";
                }

                public InputStream getInputStream() throws IOException {
                    return new BufferedInputStream(new FileInputStream(zipFile));
                }

                public String getName() {
                    return LogMail.this.simulationFile.getName() + ".zip";
                }

                public OutputStream getOutputStream() throws IOException {
                    return null;
                }
            }));
        }
        String attachmentName = this.simulationFile.getName() + ".zip";
        attPart.setFileName(attachmentName);
        attPart.setDisposition("attachment");
        bodyMime.addBodyPart((BodyPart)attPart);
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setText(text);
        bodyMime.addBodyPart((BodyPart)bodyPart);
        msg.setContent((Multipart)bodyMime);
        msg.setHeader("X-Mailer", "Code Lutin Java Mailer");
        msg.setSentDate(new Date());
        Transport.send((Message)msg);
        if (tmpDirectory != null && !FileUtil.deleteRecursively((File)tmpDirectory)) {
            log.warn((Object)I18n._((String)"isisfish.error.remove.directory", (Object[])new Object[]{tmpDirectory}));
        }
    }
}

