/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.logging;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.logging.ThreadFilter;
import fr.ifremer.isisfish.logging.console.LogConsole;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.Filter;
import org.nuiton.i18n.I18n;

public class SimulationLoggerUtil {
    private static Log log = LogFactory.getLog(SimulationLoggerUtil.class);
    private static Map<String, Level> simulLevelKeeper = null;
    private static Map<String, Level> scriptLevelKeeper = null;
    private static Map<String, Level> libLevelKeeper = null;
    public static final String LOG_PATTERN = "%p|%d{ABSOLUTE}|%F|%L|%M|%m%n";
    private static final String[] simulLoggerToChange = new String[]{"fr.ifremer.isisfish"};
    private static final String[] scriptLoggerToChange = new String[]{"exports", "formules", "rules", "scripts", "simulators", "sensitivityexports"};
    private static final String[] libLoggerToChange = new String[]{"org.nuiton"};

    public static void addSimulationAppender(String filename, String appenderId, String simulLogLevel, String scriptLogLevel, String libLogLevel, String threadName) throws IsisFishException {
        PatternLayout layout = new PatternLayout();
        layout.setConversionPattern(LOG_PATTERN);
        ThreadFilter filter = new ThreadFilter(threadName);
        simulLevelKeeper = SimulationLoggerUtil.prepareLogger(simulLogLevel, simulLoggerToChange);
        scriptLevelKeeper = SimulationLoggerUtil.prepareLogger(scriptLogLevel, scriptLoggerToChange);
        libLevelKeeper = SimulationLoggerUtil.prepareLogger(libLogLevel, libLoggerToChange);
        try {
            FileAppender appender = new FileAppender((Layout)layout, filename, false);
            appender.setName(appenderId);
            appender.addFilter((Filter)filter);
            Logger.getRootLogger().addAppender((Appender)appender);
            if (log.isDebugEnabled()) {
                log.debug((Object)I18n._((String)"isisfish.log.addAppender", (Object[])new Object[]{appenderId}));
            }
        }
        catch (IOException ex) {
            log.error((Object)I18n._((String)"isisfish.error.log.createAppender", (Object[])new Object[]{appenderId, ex.getMessage()}));
            throw new IsisFishException("Can't add appender", ex);
        }
    }

    public static void removeSimulationAppender(String appenderId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)I18n._((String)"isisfish.log.removeAppender", (Object[])new Object[]{appenderId}));
        }
        SimulationLoggerUtil.removeAppender(null, appenderId);
        SimulationLoggerUtil.retablishLogger(simulLevelKeeper);
        simulLevelKeeper = null;
        SimulationLoggerUtil.retablishLogger(scriptLevelKeeper);
        scriptLevelKeeper = null;
        SimulationLoggerUtil.retablishLogger(libLevelKeeper);
        libLevelKeeper = null;
    }

    public static void showSimulationLogConsole(String simulationName) throws IllegalArgumentException, IOException {
        SimulationStorage storage = SimulationStorage.getSimulation(simulationName);
        File logFile = new File(storage.getSimulationLogFile());
        String smtpServer = IsisFish.config.getSmtpServer();
        String defaultFrom = IsisFish.config.getUserMail();
        String title = I18n._((String)"isisfish.simulation.log.console.title", (Object[])new Object[]{simulationName});
        LogConsole.newConsole(logFile, smtpServer, defaultFrom, null, title);
        if (log.isInfoEnabled()) {
            log.info((Object)I18n._((String)"isisfish.simulation.log.showConsole", (Object[])new Object[]{simulationName}));
        }
    }

    static Map<String, Level> prepareLogger(String logLevel, String[] categoriesToChange) {
        HashMap<String, Level> result = new HashMap<String, Level>();
        Level level = Level.toLevel((String)logLevel);
        Enumeration enumeration = Logger.getRootLogger().getLoggerRepository().getCurrentLoggers();
        block0: while (enumeration.hasMoreElements()) {
            Object o = enumeration.nextElement();
            if (!(o instanceof Logger)) continue;
            Logger logger = (Logger)o;
            String loggerName = logger.getName();
            for (String category : categoriesToChange) {
                if (!loggerName.startsWith(category)) continue;
                result.put(logger.getName(), logger.getLevel());
                if (log.isDebugEnabled()) {
                    log.debug((Object)I18n._((String)"isisfish.log.swapLogLevel", (Object[])new Object[]{loggerName, logger.getLevel(), logLevel}));
                }
                logger.setLevel(level);
                continue block0;
            }
        }
        return result;
    }

    static void retablishLogger(Map<String, Level> levelKeeper) {
        Logger rootLogger = Logger.getRootLogger();
        for (Map.Entry<String, Level> entry : levelKeeper.entrySet()) {
            Logger logger = rootLogger.getLoggerRepository().getLogger(entry.getKey());
            if (logger == null) continue;
            Level oldLevel = entry.getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)I18n._((String)"isisfish.log.restoreLogLevel", (Object[])new Object[]{logger.getName(), logger.getLevel(), oldLevel}));
            }
            logger.setLevel(oldLevel);
        }
        levelKeeper.clear();
    }

    static void removeAppender(String category, String name) {
        Logger logger;
        Logger logger2 = logger = category == null ? Logger.getRootLogger() : Logger.getLogger((String)category);
        if (logger == null) {
            Logger.getRootLogger().warn((Object)I18n._((String)"isisfish.error.log.closeAppender", (Object[])new Object[]{name, category}));
            return;
        }
        Appender app = logger.getAppender(name);
        if (app == null) {
            logger.warn((Object)I18n._((String)"isisfish.error.log.foundAppender", (Object[])new Object[]{name, category}));
            return;
        }
        logger.info((Object)I18n._((String)"isisfish.log.closeAppender", (Object[])new Object[]{name, category}));
        app.close();
        logger.removeAppender(app);
    }
}

