/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.sensitivity;

import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import fr.ifremer.isisfish.ui.NavigationUI;
import fr.ifremer.isisfish.ui.WelcomePanelUI;
import fr.ifremer.isisfish.ui.input.InputAction;
import fr.ifremer.isisfish.ui.input.InputSaveVerifier;
import fr.ifremer.isisfish.ui.sensitivity.model.FactorTree;
import fr.ifremer.isisfish.ui.sensitivity.model.FactorTreeCellRenderer;
import fr.ifremer.isisfish.ui.sensitivity.model.FactorTreeModel;
import fr.ifremer.isisfish.ui.simulator.SimulAction;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class SensitivityTabUI extends NavigationUI {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_FISHERY_REGION = "fisheryRegion";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz28bRRSemDipkzSA3aYJhJJSS6AirSkFhEgVWhKixLihsl2oMEiMd8f2VOOdZWY22XBAiAsXDvwJcOeCxI0T4sCZAxfEv4AQB66IN7P2rrfZrhfZh931+/HN9968+ea7P1FRCnTlAQ4CS/iuokNi1W/fv/9u9wGx1R6RtqCe4gKFv7kCKnTQshPZpUJXOw2dXhul13b50OMucSeytxtoSapTRuSAEKXQM8kMW8paK3JvB54vxqgRqTTUb/7+q/C18/m3BYQCD9hdgFK2pmXFlcw3UIE6CpVhpWNcY9jtAw1B3T7wPa9tuwxLeYSH5BP0GVpsoAUPCwBT6Ln8JRsMkx94Cq1Wj/Ax7WNFuXvv8CWFbvSERXuCDAm8JZU9KgeWTy1JXEkVPabq1GrF323cvXfoeQZwQaHFAXYdRoRCb/w/nEPX89VBmBzDnddZRJw2SR/4KXQtDRTKBBAirf3J4BhkpVpveYyqu9glUOCabmRgyRPoqxV7dHApyjlXrWsjg/hyIt5YdVA5Ff+6tl3Qj4txEeC3BWdsROBSkkDk0uHrUdazidLbgpAWYXAE4M8d7hAGzZjEURBg7ZEe9pk6Gxw348kzsGBLENI2HfxUvKlV2GWmqa8nhjlMML4k91K1/pavFHchpZIAD8067OrZaNO8F5LORPNMwGYyYLmHbX3uw1LyTO9Qd8TaN2njYl+M8Co2Fg7Dp9xXd+Ho2dTDbFSFhU+UtQvuhnHHTS1TPb2aYZSiPZeSczKeqeuR70bkm3fhuD48aw3cDWft1ShuKWan0OWU3YjpvRzzK0X8JpcW6OkEAKieFateLEtzHVQUPphh/ztnhbIJrlAi1x+SSA1ovP+uVX778Y8f9se6uAFrX0wNnZB10CtPcA+0hOqlHw9F0VeU1e5gb7uDStLMuNH8zRRirZEbyMF6ZsgtnW4dYDkAiOLi7z/9vPbxr4+hwj5aYhw74UwcopIaCOgCZ07gvXnLMFo5OQfPJzQ34OLAJDlENLhthBM27iZ1GXXJFlYg2F1fkZ0AOrKZ0pGIVrf0yz+V1ve3xl2ZA5YbjwyPO1P8AC2Eq5n7YnQVpN4Py54kvsNjyU+7BOb0u+KNxmXPPA/Syi7DjLa5bw/eDjxQ6vG5fyfw9athStBfR7kRl7mgIN+miTNCLYxPxepNByu81aWuAwdiJx1xbSqiNtczOG3kQmjOjPD+TAggoHLyJtBhH6WDXc4BVjTamQFyJc+mC87Ve6DO2fOTB2o1UdysxFYitCY/mZHZPLXDkX4En+fzNEpxztrUa5NAZdCZDqXNX2aQuZYL4asMDtMRoL02YaxJXBBOIjLYWLnYyJkRgox68iF8MTPChxlVvDIzwms5dqUyAA3+FO4wzG4z2neHoMcZZb2eZ/ZV9sBOx5hW2A4g/AdsZMMOKw4AAA==";
    private static final Log log = LogFactory.getLog(SensitivityTabUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected CardLayout2 cardlayout;
    protected CardLayout cardlayoutPrincipal;
    protected FactorTree factorsTree;
    protected FisheryRegion fisheryRegion;
    protected JTree fisheryRegionTree;
    protected DefaultTreeSelectionModel fisheryRegionTreeSelectionModel;
    protected SensitivityInputHandler handler;
    protected JPanel inputPane;
    protected JPanel inputPanePrincipal;
    protected JLabel none;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SensitivityTabUI $NavigationUI0 = this;
    private JSplitPane $JSplitPane0;
    private JPanel $JPanel0;
    private JSplitPane $JSplitPane1;
    private JScrollPane $JScrollPane0;
    private Table $Table0;
    private JButton $JButton0;
    private JButton $JButton1;
    private JScrollPane $JScrollPane1;
    private JPanel $JPanel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected InputAction getInputAction() {
        return getContextValue(InputAction.class);
    }
    
    protected SimulAction getSimulAction() {
        return getContextValue(SimulAction.class);
    }
    
    protected InputSaveVerifier getVerifier() {
        return getContextValue(InputSaveVerifier.class);
    }
    
    protected RegionStorage getRegionStorage() {
        return getContextValue(RegionStorage.class);
    }
    
    public void setTreeModel() {
        if (getFisheryRegion() != null) {
            getCardlayoutPrincipal().show(inputPanePrincipal,"normale");
            String regionName = getFisheryRegion().getName();
            setContextValue(getFisheryRegion());
            getHandler().loadFisheryRegionTree(this);
        }
    }
    protected void setInfoText(String s) {
        WelcomePanelUI root = getParentContainer(WelcomePanelUI.class);
        root.setStatusMessage(s);
    }
    protected void regionNull() {
        getCardlayoutPrincipal().show(inputPanePrincipal,"none");
        DefaultTreeModel model = new DefaultTreeModel(null);
        fisheryRegionTree.setModel(model);
    }
    public void setFactorModel() {
        FactorGroup factorGroup = getSimulAction().getFactorGroup();
        FactorTreeModel model = new FactorTreeModel(factorGroup);
        factorsTree.setModel(model);
        getParentContainer(SensitivityUI.class).getSensitivityChooserUI().setFactorCardinalityTableModel();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SensitivityTabUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SensitivityTabUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SensitivityTabUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SensitivityTabUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SensitivityTabUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SensitivityTabUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SensitivityTabUI() {
        $initialize();
    }

    public SensitivityTabUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addNewFactorGroup(this, false);
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addNewFactorGroup(this, true);
    }

    public void doMouseClicked__on__factorsTree(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().factorsTreeMouseClicked(this, event);
    }

    public void doValueChanged__on__fisheryRegionTree(TreeSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().nodeSelectionChanged(this, event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public CardLayout2 getCardlayout() {
        return cardlayout;
    }

    public CardLayout getCardlayoutPrincipal() {
        return cardlayoutPrincipal;
    }

    public FactorTree getFactorsTree() {
        return factorsTree;
    }

    public FisheryRegion getFisheryRegion() {
        return fisheryRegion;
    }

    public JTree getFisheryRegionTree() {
        return fisheryRegionTree;
    }

    public DefaultTreeSelectionModel getFisheryRegionTreeSelectionModel() {
        return fisheryRegionTreeSelectionModel;
    }

    public SensitivityInputHandler getHandler() {
        return handler;
    }

    public JPanel getInputPane() {
        return inputPane;
    }

    public JPanel getInputPanePrincipal() {
        return inputPanePrincipal;
    }

    public JLabel getNone() {
        return none;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setFisheryRegion(FisheryRegion fisheryRegion) {
        FisheryRegion oldValue = this.fisheryRegion;
        this.fisheryRegion = fisheryRegion;
        firePropertyChange(PROPERTY_FISHERY_REGION, oldValue, fisheryRegion);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JSplitPane get$JSplitPane1() {
        return $JSplitPane1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToInputPanePrincipal() {
        if (!allComponentsCreated) {
            return;
        }
        inputPanePrincipal.add($JPanel1, "none");
        inputPanePrincipal.add(inputPane, "normale");
    }

    protected void createCardlayout() {
        $objectMap.put("cardlayout", cardlayout = new CardLayout2());
    }

    protected void createCardlayoutPrincipal() {
        $objectMap.put("cardlayoutPrincipal", cardlayoutPrincipal = new CardLayout());
    }

    protected void createFactorsTree() {
        $objectMap.put("factorsTree", factorsTree = new FactorTree(this));
        
        factorsTree.setName("factorsTree");
        factorsTree.setRootVisible(true);
        factorsTree.setSelectionRow(0);
        factorsTree.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__factorsTree"));
    }

    protected void createFisheryRegion() {
        $objectMap.put("fisheryRegion", fisheryRegion = null);
    }

    protected void createFisheryRegionTree() {
        $objectMap.put("fisheryRegionTree", fisheryRegionTree = new JTree());
        
        fisheryRegionTree.setName("fisheryRegionTree");
        fisheryRegionTree.setRootVisible(true);
        fisheryRegionTree.setSelectionRow(0);
        fisheryRegionTree.addTreeSelectionListener(JAXXUtil.getEventListener(TreeSelectionListener.class, "valueChanged", this, "doValueChanged__on__fisheryRegionTree"));
    }

    protected void createFisheryRegionTreeSelectionModel() {
        $objectMap.put("fisheryRegionTreeSelectionModel", fisheryRegionTreeSelectionModel = new DefaultTreeSelectionModel());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new SensitivityInputHandler());
    }

    protected void createInputPane() {
        $objectMap.put("inputPane", inputPane = new JPanel());
        
        inputPane.setName("inputPane");
        inputPane.setLayout(getCardlayout());
    }

    protected void createInputPanePrincipal() {
        $objectMap.put("inputPanePrincipal", inputPanePrincipal = new JPanel());
        
        inputPanePrincipal.setName("inputPanePrincipal");
        inputPanePrincipal.setLayout(getCardlayoutPrincipal());
    }

    protected void createNone() {
        $objectMap.put("none", none = new JLabel());
        
        none.setName("none");
        none.setHorizontalAlignment(0);
        none.setText(_("isisfish.input.selectRegion"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $NavigationUI0
        add($JSplitPane0, BorderLayout.CENTER);
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($JPanel0, JSplitPane.LEFT);
        $JSplitPane0.add(inputPanePrincipal, JSplitPane.RIGHT);
        // inline complete setup of $JPanel0
        $JPanel0.add($JSplitPane1, BorderLayout.CENTER);
        // inline complete setup of $JSplitPane1
        $JSplitPane1.add($JScrollPane0, JSplitPane.LEFT);
        $JSplitPane1.add($Table0, JSplitPane.RIGHT);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fisheryRegionTree);
        // inline complete setup of $Table0
        $Table0.add($JButton0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane1, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(factorsTree);
        addChildrenToInputPanePrincipal();
        // inline complete setup of $JPanel1
        $JPanel1.add(none, BorderLayout.CENTER);
        
        // apply 11 property setters
        fisheryRegionTreeSelectionModel.setSelectionMode(javax.swing.tree.TreeSelectionModel.SINGLE_TREE_SELECTION);
        fisheryRegionTree.setModel(new DefaultTreeModel(null));
        fisheryRegionTree.setSelectionModel(getFisheryRegionTreeSelectionModel());
        $JButton0.setIcon(SwingUtil.createImageIcon("factors/dgroup.png"));
        $JButton1.setIcon(SwingUtil.createImageIcon("factors/cgroup.png"));
        factorsTree.setCellRenderer(new FactorTreeCellRenderer());
        factorsTree.setModel(new FactorTreeModel(getSimulAction().getFactorGroup()));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$NavigationUI0", $NavigationUI0);
        createHandler();
        createFisheryRegion();
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setDividerLocation(200);
        $JSplitPane0.setOneTouchExpandable(true);
        $JSplitPane0.setOrientation(1);
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JSplitPane1
        $objectMap.put("$JSplitPane1", $JSplitPane1 = new JSplitPane());
        
        $JSplitPane1.setName("$JSplitPane1");
        $JSplitPane1.setDividerLocation(400);
        $JSplitPane1.setOneTouchExpandable(true);
        $JSplitPane1.setOrientation(0);
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFisheryRegionTreeSelectionModel();
        createFisheryRegionTree();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(_("isisfish.sensitivity.newfactordgroup.tip"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setToolTipText(_("isisfish.sensitivity.newfactorcgroup.tip"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createFactorsTree();
        createCardlayoutPrincipal();
        createInputPanePrincipal();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createNone();
        createCardlayout();
        createInputPane();
        // inline creation of $NavigationUI0
        setName("$NavigationUI0");
        
        $completeSetup();
    }

}