/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.StrategyMonthInfo;
import fr.ifremer.isisfish.entities.TripType;
import fr.ifremer.isisfish.ui.input.model.TripTypeComboModel;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class StrategyOneMonthInfoUI extends InputContentUI<Strategy> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_STRATEGIE_MONTH_TEXT = "strategieMonthText";
    public static final String PROPERTY_STRATEGY_MONTH_INFO = "strategyMonthInfo";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_FIELD_STRATEGY_MONTH_INFO_MIN_INACTIVITY_DAYS_ENABLED = "fieldStrategyMonthInfoMinInactivityDays.enabled";
    public static final String BINDING_FIELD_STRATEGY_MONTH_INFO_MIN_INACTIVITY_DAYS_TEXT = "fieldStrategyMonthInfoMinInactivityDays.text";
    public static final String BINDING_FIELD_STRATEGY_MONTH_INFO_TRIP_TYPE_ENABLED = "fieldStrategyMonthInfoTripType.enabled";
    public static final String BINDING_NUMBER_OF_TRIPS_ENABLED = "numberOfTrips.enabled";
    public static final String BINDING_NUMBER_OF_TRIPS_TEXT = "numberOfTrips.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWUz08TQRTHp5XyG+VHIBhBEeuPi1uUqDEQRUsaS4oYKQmxF2e703bIdnacmYXtxfgn+Cfo3YuJN0/Gg2cPXoz/gjEevBrf7La7FJbSSA+723nvfefz3sx7736ilBTo4g72PEO4TNE6MdYebG9vmDukrFaJLAvKlSNQ8EskUbKEhqxwXSp0qVTQ4ZlmeCbr1LnDCNsXvVRAg1I1bCJrhCiFZtsjylJmNkPzksdd0VINoeJU3/z+lXxtvXqbRMjjQDcMqcwdFxVl0lNASWopNA477eKMjVkVMARlVeAd0WtZG0v5GNfJC/QS9RVQL8cCxBSa7z5lX8OP97hCo+k8467KOkyB+1Z+QaHFijBoRZA6gbekskJlzXCpQbWjAUBYkWpjg5F1CKrlWcXZynPuS/YCvAwcaGAuEg/wRjW8oRMygoQi/x6TYKbQ5bhNgYgqSmS4aRQ21tymEUIoZHSlEQbsZ3CsBqBrSs+QewBorD3BjNiRT1+6iE2bQH2m20408PZt2nMyDOhPrxWwSeyFg8L+qnaaDn3PVyixrUOERTi6YoMThSbbFOB4Teeh47WLtDa8of/PtttGmFs3idioaEkZ49AKvhljuxpPt05ZnuGyortUNVZxA1pvqg1Tn31OhzblBDrXVjpoMyNqs6gPEiWUEi4sQ61LhzvzKZiCnpw+0JNa0Lf+nZr49vHHh1yrEUdg78lY131zBBqEC4cToa+LQmeCLnQVtTPrmC+V0IAkNgwhf8jMxIBtNs0AB/uN+XdehxuPsKyBRKrv+6fPU8+/nkLJHBq0HWzlsPbPowFVE1AFx7Y8fn/FJxre64fnqGaDy0eYvmAwG04vW1jhOZMyC2p8z4MqzMRUIUQxB778mdh8v9KqRALIzh7pHlUj9Qz1UmZTRvyh1Jw3sUNoiEviWk40V+ImTUK/Z3iznzL+czEu1aEK3K/re4RWazA4xpcDiDmsYG6YriKQso694+eiv+52Ld2j4EJq6+3/1dDLtzooXOiCoh8mtkUEESfSOY5kviuFrH4cUdHuFDoxpLtnOJFCJ4YrJ65DdwqdGK6duA5a4R+UGqXFGwkAAA==";
    private static final Log log = LogFactory.getLog(StrategyOneMonthInfoUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Strategy bean;
    protected JTextField fieldStrategyMonthInfoMinInactivityDays;
    protected JComboBox fieldStrategyMonthInfoTripType;
    protected JLabel numberOfTrips;
    protected String strategieMonthText;
    protected StrategyMonthInfo strategyMonthInfo;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private StrategyOneMonthInfoUI $InputContentUI0 = this;
    private Table $Table0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected boolean init;
    
    
    protected void $afterCompleteSetup() {
        addPropertyChangeListener(PROPERTY_STRATEGY_MONTH_INFO, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
    
                }
                if (evt.getNewValue() != null) {
                    init = true;
                    refresh();
                    init = false;
                }
            }
        });
    }
    
    public void refresh() {
        if (getStrategyMonthInfo() != null) {
            numberOfTrips.putClientProperty("sensitivityBeanID", getStrategyMonthInfo().getTopiaId());
            fieldStrategyMonthInfoMinInactivityDays.putClientProperty("sensitivityBeanID", getStrategyMonthInfo().getTopiaId());
    
            TripTypeComboModel model = new TripTypeComboModel(getFisheryRegion().getTripType());
            fieldStrategyMonthInfoTripType.setModel(model);
            fieldStrategyMonthInfoTripType.setSelectedItem(getStrategyMonthInfo().getTripType());
        }
        else {
            // don't put in addPropertyChangeListener
            // if called after, remove content :(
            numberOfTrips.setText("");
            fieldStrategyMonthInfoMinInactivityDays.setText("");
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public StrategyOneMonthInfoUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public StrategyOneMonthInfoUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public StrategyOneMonthInfoUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public StrategyOneMonthInfoUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public StrategyOneMonthInfoUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public StrategyOneMonthInfoUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public StrategyOneMonthInfoUI() {
        $initialize();
    }

    public StrategyOneMonthInfoUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__fieldStrategyMonthInfoTripType(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getStrategyMonthInfo().setTripType((TripType)fieldStrategyMonthInfoTripType.getSelectedItem());
    }

    public void doKeyReleased__on__fieldStrategyMonthInfoMinInactivityDays(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getStrategyMonthInfo().setMinInactivityDays(Double.parseDouble(fieldStrategyMonthInfoMinInactivityDays.getText()));
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Strategy getBean() {
        return bean;
    }

    public JTextField getFieldStrategyMonthInfoMinInactivityDays() {
        return fieldStrategyMonthInfoMinInactivityDays;
    }

    public JComboBox getFieldStrategyMonthInfoTripType() {
        return fieldStrategyMonthInfoTripType;
    }

    public JLabel getNumberOfTrips() {
        return numberOfTrips;
    }

    public String getStrategieMonthText() {
        return strategieMonthText;
    }

    public StrategyMonthInfo getStrategyMonthInfo() {
        return strategyMonthInfo;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Strategy bean) {
        Strategy oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setStrategieMonthText(String strategieMonthText) {
        String oldValue = this.strategieMonthText;
        this.strategieMonthText = strategieMonthText;
        firePropertyChange(PROPERTY_STRATEGIE_MONTH_TEXT, oldValue, strategieMonthText);
    }

    public void setStrategyMonthInfo(StrategyMonthInfo strategyMonthInfo) {
        StrategyMonthInfo oldValue = this.strategyMonthInfo;
        this.strategyMonthInfo = strategyMonthInfo;
        firePropertyChange(PROPERTY_STRATEGY_MONTH_INFO, oldValue, strategyMonthInfo);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createFieldStrategyMonthInfoMinInactivityDays() {
        $objectMap.put("fieldStrategyMonthInfoMinInactivityDays", fieldStrategyMonthInfoMinInactivityDays = new JTextField());
        
        fieldStrategyMonthInfoMinInactivityDays.setName("fieldStrategyMonthInfoMinInactivityDays");
        fieldStrategyMonthInfoMinInactivityDays.setColumns(15);
        fieldStrategyMonthInfoMinInactivityDays.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldStrategyMonthInfoMinInactivityDays"));
        fieldStrategyMonthInfoMinInactivityDays.putClientProperty("sensitivityBean", fr.ifremer.isisfish.entities.StrategyMonthInfoImpl.class);
        fieldStrategyMonthInfoMinInactivityDays.putClientProperty("sensitivityMethod", "MinInactivityDays");
    }

    protected void createFieldStrategyMonthInfoTripType() {
        $objectMap.put("fieldStrategyMonthInfoTripType", fieldStrategyMonthInfoTripType = new JComboBox());
        
        fieldStrategyMonthInfoTripType.setName("fieldStrategyMonthInfoTripType");
        fieldStrategyMonthInfoTripType.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldStrategyMonthInfoTripType"));
    }

    protected void createNumberOfTrips() {
        $objectMap.put("numberOfTrips", numberOfTrips = new JLabel());
        
        numberOfTrips.setName("numberOfTrips");
        numberOfTrips.putClientProperty("sensitivityBean", fr.ifremer.isisfish.entities.StrategyMonthInfoImpl.class);
        numberOfTrips.putClientProperty("sensitivityMethod", "NumberOfTrips");
    }

    protected void createStrategieMonthText() {
        $objectMap.put("strategieMonthText", strategieMonthText = null);
    }

    protected void createStrategyMonthInfo() {
        $objectMap.put("strategyMonthInfo", strategyMonthInfo = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldStrategyMonthInfoTripType), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(numberOfTrips), new GridBagConstraints(1, 2, 1, 1, 0.5, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 3, 1, 1, 0.5, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldStrategyMonthInfoMinInactivityDays), new GridBagConstraints(1, 3, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 9 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        fieldStrategyMonthInfoTripType.setRenderer(new fr.ifremer.isisfish.ui.input.renderer.TripTypeListRenderer(true));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createStrategieMonthText();
        createBean();
        createStrategyMonthInfo();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        if ($JLabel0.getFont() != null) {
            $JLabel0.setFont($JLabel0.getFont().deriveFont($JLabel0.getFont().getStyle() | Font.BOLD));
        }
        createFieldStrategyMonthInfoTripType();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("isisfish.strategyMonthInfo.numberOfTrips"));
        createNumberOfTrips();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.strategyMonthInfo.minInactivityDays"));
        createFieldStrategyMonthInfoMinInactivityDays();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 9 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 9 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TEXT, true ,"strategieMonthText") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setText(_(getStrategieMonthText()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_STRATEGY_MONTH_INFO_TRIP_TYPE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldStrategyMonthInfoTripType.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_NUMBER_OF_TRIPS_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                numberOfTrips.setEnabled(isActive());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NUMBER_OF_TRIPS_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("strategyMonthInfo", this);
                if (getStrategyMonthInfo() != null) {
                    getStrategyMonthInfo().addPropertyChangeListener("numberOfTrips", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getStrategyMonthInfo() != null) {
                    numberOfTrips.setText(_(String.valueOf(getStrategyMonthInfo().getNumberOfTrips())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("strategyMonthInfo", this);
                if (getStrategyMonthInfo() != null) {
                    getStrategyMonthInfo().removePropertyChangeListener("numberOfTrips", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_STRATEGY_MONTH_INFO_MIN_INACTIVITY_DAYS_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldStrategyMonthInfoMinInactivityDays.setEnabled(isActive());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_STRATEGY_MONTH_INFO_MIN_INACTIVITY_DAYS_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("strategyMonthInfo", this);
                if (getStrategyMonthInfo() != null) {
                    getStrategyMonthInfo().addPropertyChangeListener("minInactivityDays", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getStrategyMonthInfo() != null) {
                    SwingUtil.setText(fieldStrategyMonthInfoMinInactivityDays, String.valueOf(getStrategyMonthInfo().getMinInactivityDays()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("strategyMonthInfo", this);
                if (getStrategyMonthInfo() != null) {
                    getStrategyMonthInfo().removePropertyChangeListener("minInactivityDays", this);
                }
            }
        });
    }

}